/*
 * Decompiled with CFR 0.152.
 */
package com.mobandme.android.bind.binder;

import android.view.View;
import android.widget.CheckBox;
import android.widget.ProgressBar;
import android.widget.RadioButton;
import android.widget.RatingBar;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.ToggleButton;
import com.mobandme.android.bind.binder.DataBinder;
import com.mobandme.android.bind.compiler.Compiler;
import com.mobandme.android.bind.parser.ParserFactory;

public class GenericDataBinder
extends DataBinder {
    @Override
    public void onBind(Compiler.Mapping mapping, Object object, View view, int direction) {
        Object value = this.getValue(mapping, object, view, direction);
        Object parsedValue = this.parseValue(mapping, value, direction);
        if (direction == 1) {
            this.setViewValue(mapping, view, parsedValue);
        } else {
            this.setValue(mapping, object, parsedValue);
        }
    }

    private Object parseValue(Compiler.Mapping mapping, Object value, int direction) {
        return ParserFactory.getParser(mapping).parse(mapping, value, direction);
    }

    private void setValue(Compiler.Mapping mapping, Object object, Object value) {
        try {
            if (mapping.getSetter() != null) {
                mapping.getSetter().invoke(object, value);
            } else {
                mapping.getField().set(object, value);
            }
        }
        catch (Exception error) {
            throw new RuntimeException(error);
        }
    }

    private void setViewValue(Compiler.Mapping mapping, View view, Object value) {
        if (view instanceof CheckBox) {
            this.setViewValue((CheckBox)view, (boolean)((Boolean)value));
        } else if (view instanceof SeekBar) {
            this.setViewValue((SeekBar)view, (int)((Integer)value));
        } else if (view instanceof ProgressBar) {
            this.setViewValue((ProgressBar)view, (int)((Integer)value));
        } else if (view instanceof RatingBar) {
            this.setViewValue((RatingBar)view, ((Float)value).floatValue());
        } else if (view instanceof RadioButton) {
            this.setViewValue((RadioButton)view, (boolean)((Boolean)value));
        } else if (view instanceof ToggleButton) {
            this.setViewValue((ToggleButton)view, (boolean)((Boolean)value));
        } else if (view instanceof TextView) {
            this.setViewValue((TextView)view, (String)value);
        }
    }

    private void setViewValue(TextView view, String value) {
        view.setText((CharSequence)value);
    }

    private void setViewValue(CheckBox view, boolean value) {
        view.setChecked(value);
    }

    private void setViewValue(SeekBar view, int value) {
        view.setProgress(value);
    }

    private void setViewValue(ProgressBar view, int value) {
        view.setProgress(value);
    }

    private void setViewValue(RatingBar view, float value) {
        view.setRating(value);
    }

    private void setViewValue(RadioButton view, boolean value) {
        view.setChecked(value);
    }

    private void setViewValue(ToggleButton view, boolean value) {
        view.setChecked(value);
    }

    private Object getValue(Compiler.Mapping mapping, Object object, View view, int direction) {
        Object result = null;
        try {
            result = direction == 1 ? (mapping.getGetter() != null ? mapping.getGetter().invoke(object, (Object[])null) : mapping.getField().get(object)) : this.getViewValue(view);
        }
        catch (Exception error) {
            String fieldName = mapping.getField().getName();
            throw new RuntimeException(String.format("Error getting value of field %s.", fieldName), error);
        }
        return result;
    }

    private Object getViewValue(View view) {
        if (view instanceof TextView) {
            return this.getViewValue((TextView)view);
        }
        if (view instanceof CheckBox) {
            return this.getViewValue((CheckBox)view);
        }
        if (view instanceof SeekBar) {
            return this.getViewValue((SeekBar)view);
        }
        if (view instanceof ProgressBar) {
            return this.getViewValue((ProgressBar)view);
        }
        if (view instanceof RatingBar) {
            return this.getViewValue((RatingBar)view);
        }
        if (view instanceof RadioButton) {
            return this.getViewValue((RadioButton)view);
        }
        if (view instanceof ToggleButton) {
            return this.getViewValue((ToggleButton)view);
        }
        return null;
    }

    private Object getViewValue(TextView view) {
        return view.getText();
    }

    private Object getViewValue(CheckBox view) {
        return view.isChecked();
    }

    private Object getViewValue(SeekBar view) {
        return view.getProgress();
    }

    private Object getViewValue(ProgressBar view) {
        return view.getProgress();
    }

    private Object getViewValue(RatingBar view) {
        return Float.valueOf(view.getRating());
    }

    private Object getViewValue(RadioButton view) {
        return view.isChecked();
    }

    private Object getViewValue(ToggleButton view) {
        return view.isChecked();
    }
}

