/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.util.MPLog;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class MPDbAdapter {
    private static final String LOGTAG = "MixpanelAPI.Database";
    private static final Map<Context, MPDbAdapter> sInstances = new HashMap<Context, MPDbAdapter>();
    public static final String KEY_DATA = "data";
    public static final String KEY_CREATED_AT = "created_at";
    public static final String KEY_AUTOMATIC_DATA = "automatic_data";
    public static final String KEY_TOKEN = "token";
    public static final int ID_COLUMN_INDEX = 0;
    public static final int DATA_COLUMN_INDEX = 1;
    public static final int CREATED_AT_COLUMN_INDEX = 2;
    public static final int AUTOMATIC_DATA_COLUMN_INDEX = 3;
    public static final int TOKEN_COLUMN_INDEX = 4;
    public static final int DB_UPDATE_ERROR = -1;
    public static final int DB_OUT_OF_MEMORY_ERROR = -2;
    public static final int DB_UNDEFINED_CODE = -3;
    private static final String DATABASE_NAME = "mixpanel";
    private static final int MIN_DB_VERSION = 4;
    private static final int DATABASE_VERSION = 7;
    private static final int MAX_DB_VERSION = 7;
    private static final String CREATE_EVENTS_TABLE = "CREATE TABLE " + Table.EVENTS.getName() + " (_id INTEGER PRIMARY KEY AUTOINCREMENT, " + "data" + " STRING NOT NULL, " + "created_at" + " INTEGER NOT NULL, " + "automatic_data" + " INTEGER DEFAULT 0, " + "token" + " STRING NOT NULL DEFAULT '')";
    private static final String CREATE_PEOPLE_TABLE = "CREATE TABLE " + Table.PEOPLE.getName() + " (_id INTEGER PRIMARY KEY AUTOINCREMENT, " + "data" + " STRING NOT NULL, " + "created_at" + " INTEGER NOT NULL, " + "automatic_data" + " INTEGER DEFAULT 0, " + "token" + " STRING NOT NULL DEFAULT '')";
    private static final String CREATE_GROUPS_TABLE = "CREATE TABLE " + Table.GROUPS.getName() + " (_id INTEGER PRIMARY KEY AUTOINCREMENT, " + "data" + " STRING NOT NULL, " + "created_at" + " INTEGER NOT NULL, " + "automatic_data" + " INTEGER DEFAULT 0, " + "token" + " STRING NOT NULL DEFAULT '')";
    private static final String CREATE_ANONYMOUS_PEOPLE_TABLE = "CREATE TABLE " + Table.ANONYMOUS_PEOPLE.getName() + " (_id INTEGER PRIMARY KEY AUTOINCREMENT, " + "data" + " STRING NOT NULL, " + "created_at" + " INTEGER NOT NULL, " + "automatic_data" + " INTEGER DEFAULT 0, " + "token" + " STRING NOT NULL DEFAULT '')";
    private static final String EVENTS_TIME_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON " + Table.EVENTS.getName() + " (" + "created_at" + ");";
    private static final String PEOPLE_TIME_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON " + Table.PEOPLE.getName() + " (" + "created_at" + ");";
    private static final String GROUPS_TIME_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON " + Table.GROUPS.getName() + " (" + "created_at" + ");";
    private static final String ANONYMOUS_PEOPLE_TIME_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON " + Table.ANONYMOUS_PEOPLE.getName() + " (" + "created_at" + ");";
    private final MPDatabaseHelper mDb;

    public MPDbAdapter(Context context) {
        this(context, DATABASE_NAME);
    }

    public MPDbAdapter(Context context, String dbName) {
        this.mDb = new MPDatabaseHelper(context, dbName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MPDbAdapter getInstance(Context context) {
        Map<Context, MPDbAdapter> map = sInstances;
        synchronized (map) {
            MPDbAdapter ret;
            Context appContext = context.getApplicationContext();
            if (!sInstances.containsKey(appContext)) {
                ret = new MPDbAdapter(appContext);
                sInstances.put(appContext, ret);
            } else {
                ret = sInstances.get(appContext);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addJSON(JSONObject j, String token, Table table, boolean isAutomaticRecord) {
        if (!this.belowMemThreshold()) {
            MPLog.e(LOGTAG, "There is not enough space left on the device to store Mixpanel data, so data was discarded");
            return -2;
        }
        String tableName = table.getName();
        Cursor c = null;
        int count = -1;
        try {
            SQLiteDatabase db = this.mDb.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(KEY_DATA, j.toString());
            cv.put(KEY_CREATED_AT, Long.valueOf(System.currentTimeMillis()));
            cv.put(KEY_AUTOMATIC_DATA, Boolean.valueOf(isAutomaticRecord));
            cv.put(KEY_TOKEN, token);
            db.insert(tableName, null, cv);
            c = db.rawQuery("SELECT COUNT(*) FROM " + tableName + " WHERE token='" + token + "'", null);
            c.moveToFirst();
            count = c.getInt(0);
        }
        catch (SQLiteException e) {
            MPLog.e(LOGTAG, "Could not add Mixpanel data to table");
            if (c != null) {
                c.close();
                c = null;
            }
            this.mDb.deleteDatabase();
        }
        catch (OutOfMemoryError e) {
            MPLog.e(LOGTAG, "Out of memory when adding Mixpanel data to table");
        }
        finally {
            if (c != null) {
                c.close();
            }
            this.mDb.close();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int pushAnonymousUpdatesToPeopleDb(String token, String distinctId) {
        if (!this.belowMemThreshold()) {
            MPLog.e(LOGTAG, "There is not enough space left on the device to store Mixpanel data, so data was discarded");
            return -2;
        }
        Cursor selectCursor = null;
        int count = -1;
        try {
            SQLiteDatabase db = this.mDb.getWritableDatabase();
            StringBuffer allAnonymousQuery = new StringBuffer("SELECT * FROM " + Table.ANONYMOUS_PEOPLE.getName() + " WHERE " + KEY_TOKEN + " = '" + token + "'");
            selectCursor = db.rawQuery(allAnonymousQuery.toString(), null);
            db.beginTransaction();
            try {
                while (selectCursor.moveToNext()) {
                    try {
                        ContentValues values = new ContentValues();
                        int createdAtColumnIndex = selectCursor.getColumnIndex(KEY_CREATED_AT) >= 0 ? selectCursor.getColumnIndex(KEY_CREATED_AT) : 2;
                        values.put(KEY_CREATED_AT, Long.valueOf(selectCursor.getLong(createdAtColumnIndex)));
                        int automaticDataColumnIndex = selectCursor.getColumnIndex(KEY_AUTOMATIC_DATA) >= 0 ? selectCursor.getColumnIndex(KEY_AUTOMATIC_DATA) : 3;
                        values.put(KEY_AUTOMATIC_DATA, Integer.valueOf(selectCursor.getInt(automaticDataColumnIndex)));
                        int tokenColumnIndex = selectCursor.getColumnIndex(KEY_TOKEN) >= 0 ? selectCursor.getColumnIndex(KEY_TOKEN) : 4;
                        values.put(KEY_TOKEN, selectCursor.getString(tokenColumnIndex));
                        int dataColumnIndex = selectCursor.getColumnIndex(KEY_DATA) >= 0 ? selectCursor.getColumnIndex(KEY_DATA) : 1;
                        JSONObject updatedData = new JSONObject(selectCursor.getString(dataColumnIndex));
                        updatedData.put("$distinct_id", (Object)distinctId);
                        values.put(KEY_DATA, updatedData.toString());
                        db.insert(Table.PEOPLE.getName(), null, values);
                        int idColumnIndex = selectCursor.getColumnIndex("_id") >= 0 ? selectCursor.getColumnIndex("_id") : 0;
                        int rowId = selectCursor.getInt(idColumnIndex);
                        db.delete(Table.ANONYMOUS_PEOPLE.getName(), "_id = " + rowId, null);
                        ++count;
                    }
                    catch (JSONException jSONException) {}
                }
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
        }
        catch (SQLiteException e) {
            MPLog.e(LOGTAG, "Could not push anonymous updates records from " + Table.ANONYMOUS_PEOPLE.getName() + ". Re-initializing database.", e);
            if (selectCursor != null) {
                selectCursor.close();
                selectCursor = null;
            }
            this.mDb.deleteDatabase();
        }
        finally {
            if (selectCursor != null) {
                selectCursor.close();
            }
            this.mDb.close();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int rewriteEventDataWithProperties(Map<String, String> properties, String token) {
        if (!this.belowMemThreshold()) {
            MPLog.e(LOGTAG, "There is not enough space left on the device to store Mixpanel data, so data was discarded");
            return -2;
        }
        Cursor selectCursor = null;
        int count = 0;
        try {
            SQLiteDatabase db = this.mDb.getWritableDatabase();
            StringBuffer allAnonymousQuery = new StringBuffer("SELECT * FROM " + Table.EVENTS.getName() + " WHERE " + KEY_TOKEN + " = '" + token + "'");
            selectCursor = db.rawQuery(allAnonymousQuery.toString(), null);
            db.beginTransaction();
            try {
                while (selectCursor.moveToNext()) {
                    try {
                        ContentValues values = new ContentValues();
                        int dataColumnIndex = selectCursor.getColumnIndex(KEY_DATA) >= 0 ? selectCursor.getColumnIndex(KEY_DATA) : 1;
                        JSONObject updatedData = new JSONObject(selectCursor.getString(dataColumnIndex));
                        JSONObject existingProps = updatedData.getJSONObject("properties");
                        for (Map.Entry<String, String> entry : properties.entrySet()) {
                            String key = entry.getKey();
                            String value = entry.getValue();
                            existingProps.put(key, (Object)value);
                        }
                        updatedData.put("properties", (Object)existingProps);
                        values.put(KEY_DATA, updatedData.toString());
                        int idColumnIndex = selectCursor.getColumnIndex("_id") >= 0 ? selectCursor.getColumnIndex("_id") : 0;
                        int rowId = selectCursor.getInt(idColumnIndex);
                        db.update(Table.EVENTS.getName(), values, "_id = " + rowId, null);
                        ++count;
                    }
                    catch (JSONException jSONException) {}
                }
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
        }
        catch (SQLiteException e) {
            MPLog.e(LOGTAG, "Could not re-write events history. Re-initializing database.", e);
            if (selectCursor != null) {
                selectCursor.close();
                selectCursor = null;
            }
            this.mDb.deleteDatabase();
        }
        finally {
            if (selectCursor != null) {
                selectCursor.close();
            }
            this.mDb.close();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupEvents(String last_id, Table table, String token, boolean includeAutomaticEvents) {
        String tableName = table.getName();
        try {
            SQLiteDatabase db = this.mDb.getWritableDatabase();
            StringBuffer deleteQuery = new StringBuffer("_id <= " + last_id + " AND " + KEY_TOKEN + " = '" + token + "'");
            if (!includeAutomaticEvents) {
                deleteQuery.append(" AND automatic_data=0");
            }
            db.delete(tableName, deleteQuery.toString(), null);
        }
        catch (SQLiteException e) {
            MPLog.e(LOGTAG, "Could not clean sent Mixpanel records from " + tableName + ". Re-initializing database.", e);
            this.mDb.deleteDatabase();
        }
        catch (Exception e) {
            MPLog.e(LOGTAG, "Unknown exception. Could not clean sent Mixpanel records from " + tableName + ".Re-initializing database.", e);
            this.mDb.deleteDatabase();
        }
        finally {
            this.mDb.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupEvents(long time, Table table) {
        String tableName = table.getName();
        try {
            SQLiteDatabase db = this.mDb.getWritableDatabase();
            db.delete(tableName, "created_at <= " + time, null);
        }
        catch (SQLiteException e) {
            MPLog.e(LOGTAG, "Could not clean timed-out Mixpanel records from " + tableName + ". Re-initializing database.", e);
            this.mDb.deleteDatabase();
        }
        finally {
            this.mDb.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupAllEvents(Table table, String token) {
        String tableName = table.getName();
        try {
            SQLiteDatabase db = this.mDb.getWritableDatabase();
            db.delete(tableName, "token = '" + token + "'", null);
        }
        catch (SQLiteException e) {
            MPLog.e(LOGTAG, "Could not clean timed-out Mixpanel records from " + tableName + ". Re-initializing database.", e);
            this.mDb.deleteDatabase();
        }
        finally {
            this.mDb.close();
        }
    }

    public synchronized void cleanupAutomaticEvents(String token) {
        this.cleanupAutomaticEvents(Table.EVENTS, token);
        this.cleanupAutomaticEvents(Table.PEOPLE, token);
        this.cleanupAutomaticEvents(Table.GROUPS, token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupAutomaticEvents(Table table, String token) {
        String tableName = table.getName();
        try {
            SQLiteDatabase db = this.mDb.getWritableDatabase();
            db.delete(tableName, "automatic_data = 1 AND token = '" + token + "'", null);
        }
        catch (SQLiteException e) {
            MPLog.e(LOGTAG, "Could not clean automatic Mixpanel records from " + tableName + ". Re-initializing database.", e);
            this.mDb.deleteDatabase();
        }
        finally {
            this.mDb.close();
        }
    }

    public void deleteDB() {
        this.mDb.deleteDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] generateDataString(Table table, String token, boolean includeAutomaticEvents) {
        Cursor c = null;
        Cursor queueCountCursor = null;
        String data = null;
        String last_id = null;
        String queueCount = null;
        String tableName = table.getName();
        SQLiteDatabase db = this.mDb.getReadableDatabase();
        try {
            StringBuffer rawDataQuery = new StringBuffer("SELECT * FROM " + tableName + " WHERE " + KEY_TOKEN + " = '" + token + "' ");
            StringBuffer queueCountQuery = new StringBuffer("SELECT COUNT(*) FROM " + tableName + " WHERE " + KEY_TOKEN + " = '" + token + "' ");
            if (!includeAutomaticEvents) {
                rawDataQuery.append("AND automatic_data = 0 ");
                queueCountQuery.append(" AND automatic_data = 0");
            }
            rawDataQuery.append("ORDER BY created_at ASC LIMIT 50");
            c = db.rawQuery(rawDataQuery.toString(), null);
            queueCountCursor = db.rawQuery(queueCountQuery.toString(), null);
            queueCountCursor.moveToFirst();
            queueCount = String.valueOf(queueCountCursor.getInt(0));
            JSONArray arr = new JSONArray();
            while (c.moveToNext()) {
                if (c.isLast()) {
                    int idColumnIndex = c.getColumnIndex("_id") >= 0 ? c.getColumnIndex("_id") : 0;
                    last_id = c.getString(idColumnIndex);
                }
                try {
                    int dataColumnIndex = c.getColumnIndex(KEY_DATA) >= 0 ? c.getColumnIndex(KEY_DATA) : 1;
                    JSONObject j = new JSONObject(c.getString(dataColumnIndex));
                    arr.put((Object)j);
                }
                catch (JSONException jSONException) {}
            }
            if (arr.length() > 0) {
                data = arr.toString();
            }
        }
        catch (SQLiteException e) {
            MPLog.e(LOGTAG, "Could not pull records for Mixpanel out of database " + tableName + ". Waiting to send.", e);
            last_id = null;
            data = null;
        }
        finally {
            this.mDb.close();
            if (c != null) {
                c.close();
            }
            if (queueCountCursor != null) {
                queueCountCursor.close();
            }
        }
        if (last_id != null && data != null) {
            String[] ret = new String[]{last_id, data, queueCount};
            return ret;
        }
        return null;
    }

    public File getDatabaseFile() {
        return this.mDb.mDatabaseFile;
    }

    protected boolean belowMemThreshold() {
        return this.mDb.belowMemThreshold();
    }

    private static class MPDatabaseHelper
    extends SQLiteOpenHelper {
        private final File mDatabaseFile;
        private final MPConfig mConfig;
        private final Context mContext;

        MPDatabaseHelper(Context context, String dbName) {
            super(context, dbName, null, 7);
            this.mDatabaseFile = context.getDatabasePath(dbName);
            this.mConfig = MPConfig.getInstance(context);
            this.mContext = context;
        }

        public void deleteDatabase() {
            this.close();
            this.mDatabaseFile.delete();
        }

        public void onCreate(SQLiteDatabase db) {
            MPLog.v(MPDbAdapter.LOGTAG, "Creating a new Mixpanel events DB");
            db.execSQL(CREATE_EVENTS_TABLE);
            db.execSQL(CREATE_PEOPLE_TABLE);
            db.execSQL(CREATE_GROUPS_TABLE);
            db.execSQL(CREATE_ANONYMOUS_PEOPLE_TABLE);
            db.execSQL(EVENTS_TIME_INDEX);
            db.execSQL(PEOPLE_TIME_INDEX);
            db.execSQL(GROUPS_TIME_INDEX);
            db.execSQL(ANONYMOUS_PEOPLE_TIME_INDEX);
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            MPLog.v(MPDbAdapter.LOGTAG, "Upgrading app, replacing Mixpanel events DB");
            if (oldVersion >= 4 && newVersion <= 7) {
                if (oldVersion == 4) {
                    this.migrateTableFrom4To5(db);
                    this.migrateTableFrom5To6(db);
                    this.migrateTableFrom6To7(db);
                }
                if (oldVersion == 5) {
                    this.migrateTableFrom5To6(db);
                    this.migrateTableFrom6To7(db);
                }
                if (oldVersion == 6) {
                    this.migrateTableFrom6To7(db);
                }
            } else {
                db.execSQL("DROP TABLE IF EXISTS " + Table.EVENTS.getName());
                db.execSQL("DROP TABLE IF EXISTS " + Table.PEOPLE.getName());
                db.execSQL("DROP TABLE IF EXISTS " + Table.GROUPS.getName());
                db.execSQL("DROP TABLE IF EXISTS " + Table.ANONYMOUS_PEOPLE.getName());
                db.execSQL(CREATE_EVENTS_TABLE);
                db.execSQL(CREATE_PEOPLE_TABLE);
                db.execSQL(CREATE_GROUPS_TABLE);
                db.execSQL(CREATE_ANONYMOUS_PEOPLE_TABLE);
                db.execSQL(EVENTS_TIME_INDEX);
                db.execSQL(PEOPLE_TIME_INDEX);
                db.execSQL(GROUPS_TIME_INDEX);
                db.execSQL(ANONYMOUS_PEOPLE_TIME_INDEX);
            }
        }

        public boolean belowMemThreshold() {
            if (this.mDatabaseFile.exists()) {
                return Math.max(this.mDatabaseFile.getUsableSpace(), (long)this.mConfig.getMinimumDatabaseLimit()) >= this.mDatabaseFile.length();
            }
            return true;
        }

        private void migrateTableFrom4To5(SQLiteDatabase db) {
            db.execSQL("ALTER TABLE " + Table.EVENTS.getName() + " ADD COLUMN " + MPDbAdapter.KEY_AUTOMATIC_DATA + " INTEGER DEFAULT 0");
            db.execSQL("ALTER TABLE " + Table.PEOPLE.getName() + " ADD COLUMN " + MPDbAdapter.KEY_AUTOMATIC_DATA + " INTEGER DEFAULT 0");
            db.execSQL("ALTER TABLE " + Table.EVENTS.getName() + " ADD COLUMN " + MPDbAdapter.KEY_TOKEN + " STRING NOT NULL DEFAULT ''");
            db.execSQL("ALTER TABLE " + Table.PEOPLE.getName() + " ADD COLUMN " + MPDbAdapter.KEY_TOKEN + " STRING NOT NULL DEFAULT ''");
            Cursor eventsCursor = db.rawQuery("SELECT * FROM " + Table.EVENTS.getName(), null);
            while (eventsCursor.moveToNext()) {
                int rowId = 0;
                try {
                    int dataColumnIndex = eventsCursor.getColumnIndex(MPDbAdapter.KEY_DATA) >= 0 ? eventsCursor.getColumnIndex(MPDbAdapter.KEY_DATA) : 1;
                    JSONObject j = new JSONObject(eventsCursor.getString(dataColumnIndex));
                    String token = j.getJSONObject("properties").getString(MPDbAdapter.KEY_TOKEN);
                    int idColumnIndex = eventsCursor.getColumnIndex("_id") >= 0 ? eventsCursor.getColumnIndex("_id") : 0;
                    rowId = eventsCursor.getInt(idColumnIndex);
                    db.execSQL("UPDATE " + Table.EVENTS.getName() + " SET " + MPDbAdapter.KEY_TOKEN + " = '" + token + "' WHERE _id = " + rowId);
                }
                catch (JSONException e) {
                    db.delete(Table.EVENTS.getName(), "_id = " + rowId, null);
                }
            }
            Cursor peopleCursor = db.rawQuery("SELECT * FROM " + Table.PEOPLE.getName(), null);
            while (peopleCursor.moveToNext()) {
                int rowId = 0;
                try {
                    int dataColumnIndex = peopleCursor.getColumnIndex(MPDbAdapter.KEY_DATA) >= 0 ? peopleCursor.getColumnIndex(MPDbAdapter.KEY_DATA) : 1;
                    JSONObject j = new JSONObject(peopleCursor.getString(dataColumnIndex));
                    String token = j.getString("$token");
                    int idColumnIndex = peopleCursor.getColumnIndex("_id") >= 0 ? peopleCursor.getColumnIndex("_id") : 0;
                    rowId = peopleCursor.getInt(idColumnIndex);
                    db.execSQL("UPDATE " + Table.PEOPLE.getName() + " SET " + MPDbAdapter.KEY_TOKEN + " = '" + token + "' WHERE _id = " + rowId);
                }
                catch (JSONException e) {
                    db.delete(Table.PEOPLE.getName(), "_id = " + rowId, null);
                }
            }
        }

        private void migrateTableFrom5To6(SQLiteDatabase db) {
            db.execSQL(CREATE_GROUPS_TABLE);
            db.execSQL(GROUPS_TIME_INDEX);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void migrateTableFrom6To7(SQLiteDatabase db) {
            db.execSQL(CREATE_ANONYMOUS_PEOPLE_TABLE);
            db.execSQL(ANONYMOUS_PEOPLE_TIME_INDEX);
            File prefsDir = new File(this.mContext.getApplicationInfo().dataDir, "shared_prefs");
            if (prefsDir.exists() && prefsDir.isDirectory()) {
                String[] storedPrefsFiles;
                for (String storedPrefFile : storedPrefsFiles = prefsDir.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith("com.mixpanel.android.mpmetrics.MixpanelAPI_");
                    }
                })) {
                    String storedPrefName = storedPrefFile.split("\\.xml")[0];
                    SharedPreferences s = this.mContext.getSharedPreferences(storedPrefName, 0);
                    String waitingPeopleUpdates = s.getString("waiting_array", null);
                    if (waitingPeopleUpdates == null) continue;
                    try {
                        JSONArray waitingObjects = new JSONArray(waitingPeopleUpdates);
                        db.beginTransaction();
                        try {
                            for (int i = 0; i < waitingObjects.length(); ++i) {
                                try {
                                    JSONObject j = waitingObjects.getJSONObject(i);
                                    String token = j.getString("$token");
                                    ContentValues cv = new ContentValues();
                                    cv.put(MPDbAdapter.KEY_DATA, j.toString());
                                    cv.put(MPDbAdapter.KEY_CREATED_AT, Long.valueOf(System.currentTimeMillis()));
                                    cv.put(MPDbAdapter.KEY_AUTOMATIC_DATA, Boolean.valueOf(false));
                                    cv.put(MPDbAdapter.KEY_TOKEN, token);
                                    db.insert(Table.ANONYMOUS_PEOPLE.getName(), null, cv);
                                    continue;
                                }
                                catch (JSONException jSONException) {
                                    // empty catch block
                                }
                            }
                            db.setTransactionSuccessful();
                        }
                        finally {
                            db.endTransaction();
                        }
                    }
                    catch (JSONException waitingObjects) {
                        // empty catch block
                    }
                    SharedPreferences.Editor e = s.edit();
                    e.remove("waiting_array");
                    e.apply();
                }
            }
        }
    }

    public static enum Table {
        EVENTS("events"),
        PEOPLE("people"),
        ANONYMOUS_PEOPLE("anonymous_people"),
        GROUPS("groups");

        private final String mTableName;

        private Table(String name) {
            this.mTableName = name;
        }

        public String getName() {
            return this.mTableName;
        }
    }
}

