/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.viewcrawler;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Base64OutputStream;
import android.util.DisplayMetrics;
import android.util.JsonWriter;
import android.util.LruCache;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.ResourceIds;
import com.mixpanel.android.util.MPLog;
import com.mixpanel.android.viewcrawler.PropertyDescription;
import com.mixpanel.android.viewcrawler.UIThreadSet;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;
import org.json.JSONObject;

@TargetApi(value=16)
class ViewSnapshot {
    private final MPConfig mConfig;
    private final RootViewFinder mRootViewFinder;
    private final List<PropertyDescription> mProperties;
    private final ClassNameCache mClassnameCache;
    private final Handler mMainThreadHandler;
    private final ResourceIds mResourceIds;
    private static final int MAX_CLASS_NAME_CACHE_SIZE = 255;
    private static final String LOGTAG = "MixpanelAPI.Snapshot";
    private static transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - void declaration
     */
    public ViewSnapshot(Context context, List<PropertyDescription> list, ResourceIds resourceIds) {
        void resourceIds2;
        void properties;
        void context2;
        boolean[] blArray = ViewSnapshot.$jacocoInit();
        blArray[0] = true;
        this.mConfig = MPConfig.getInstance((Context)context2);
        this.mProperties = properties;
        this.mResourceIds = resourceIds2;
        blArray[1] = true;
        this.mMainThreadHandler = new Handler(Looper.getMainLooper());
        blArray[2] = true;
        this.mRootViewFinder = new RootViewFinder();
        blArray[3] = true;
        this.mClassnameCache = new ClassNameCache(255);
        blArray[4] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void snapshots(UIThreadSet<Activity> uIThreadSet, OutputStream outputStream) throws IOException {
        void i;
        List infoList;
        void writer;
        void out;
        void infoFuture;
        void liveActivities;
        boolean[] blArray = ViewSnapshot.$jacocoInit();
        this.mRootViewFinder.findInActivities((UIThreadSet<Activity>)liveActivities);
        blArray[5] = true;
        FutureTask<List<RootViewInfo>> futureTask = new FutureTask<List<RootViewInfo>>(this.mRootViewFinder);
        blArray[6] = true;
        this.mMainThreadHandler.post((Runnable)infoFuture);
        blArray[7] = true;
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)out);
        blArray[8] = true;
        List list = Collections.emptyList();
        blArray[9] = true;
        writer.write("[");
        try {
            blArray[10] = true;
            infoList = (List)infoFuture.get(1L, TimeUnit.SECONDS);
            blArray[11] = true;
        }
        catch (InterruptedException interruptedException) {
            void e;
            blArray[12] = true;
            MPLog.d(LOGTAG, "Screenshot interrupted, no screenshot will be sent.", (Throwable)e);
            blArray[13] = true;
        }
        catch (TimeoutException e) {
            blArray[14] = true;
            MPLog.i(LOGTAG, "Screenshot took more than 1 second to be scheduled and executed. No screenshot will be sent.", e);
            blArray[15] = true;
        }
        catch (ExecutionException e) {
            blArray[16] = true;
            MPLog.e(LOGTAG, "Exception thrown during screenshot attempt", e);
            blArray[17] = true;
        }
        int infoCount = infoList.size();
        boolean bl = false;
        blArray[18] = true;
        while (i < infoCount) {
            void j;
            void info;
            if (i <= 0) {
                blArray[19] = true;
            } else {
                blArray[20] = true;
                writer.write(",");
                blArray[21] = true;
            }
            RootViewInfo rootViewInfo = (RootViewInfo)infoList.get((int)i);
            blArray[22] = true;
            writer.write("{");
            blArray[23] = true;
            writer.write("\"activity\":");
            blArray[24] = true;
            writer.write(JSONObject.quote((String)info.activityName));
            blArray[25] = true;
            writer.write(",");
            blArray[26] = true;
            writer.write("\"scale\":");
            blArray[27] = true;
            writer.write(String.format("%s", Float.valueOf(info.scale)));
            blArray[28] = true;
            writer.write(",");
            blArray[29] = true;
            writer.write("\"serialized_objects\":");
            blArray[30] = true;
            JsonWriter jsonWriter = new JsonWriter((Writer)writer);
            blArray[31] = true;
            j.beginObject();
            blArray[32] = true;
            j.name("rootObject").value((long)info.rootView.hashCode());
            blArray[33] = true;
            j.name("objects");
            blArray[34] = true;
            this.snapshotViewHierarchy((JsonWriter)j, info.rootView);
            blArray[35] = true;
            j.endObject();
            blArray[36] = true;
            j.flush();
            blArray[37] = true;
            writer.write(",");
            blArray[38] = true;
            writer.write("\"screenshot\":");
            blArray[39] = true;
            writer.flush();
            blArray[40] = true;
            info.screenshot.writeBitmapJSON(Bitmap.CompressFormat.PNG, 100, (OutputStream)out);
            blArray[41] = true;
            writer.write("}");
            ++i;
            blArray[42] = true;
        }
        writer.write("]");
        blArray[43] = true;
        writer.flush();
        blArray[44] = true;
    }

    List<PropertyDescription> getProperties() {
        boolean[] blArray = ViewSnapshot.$jacocoInit();
        blArray[45] = true;
        return this.mProperties;
    }

    /*
     * WARNING - void declaration
     */
    void snapshotViewHierarchy(JsonWriter jsonWriter, View view) throws IOException {
        void rootView;
        void j;
        boolean[] blArray = ViewSnapshot.$jacocoInit();
        j.beginArray();
        blArray[46] = true;
        this.snapshotView((JsonWriter)j, (View)rootView);
        blArray[47] = true;
        j.endArray();
        blArray[48] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void snapshotView(JsonWriter jsonWriter, View view) throws IOException {
        ViewGroup group;
        ViewGroup relativeLayoutParams;
        void j;
        void view2;
        block31: {
            String viewIdName;
            boolean[] blArray = ViewSnapshot.$jacocoInit();
            if (view2.getVisibility() != 4) {
                blArray[49] = true;
            } else if (!this.mConfig.getIgnoreInvisibleViewsEditor()) {
                blArray[50] = true;
            } else {
                blArray[51] = true;
                return;
            }
            int viewId = view2.getId();
            if (-1 == viewId) {
                viewIdName = null;
                blArray[52] = true;
            } else {
                viewIdName = this.mResourceIds.nameForId(viewId);
                blArray[53] = true;
            }
            j.beginObject();
            blArray[54] = true;
            j.name("hashCode").value((long)view2.hashCode());
            blArray[55] = true;
            j.name("id").value((long)viewId);
            blArray[56] = true;
            j.name("mp_id_name").value(viewIdName);
            blArray[57] = true;
            CharSequence description = view2.getContentDescription();
            if (null == description) {
                blArray[58] = true;
                j.name("contentDescription").nullValue();
                blArray[59] = true;
            } else {
                j.name("contentDescription").value(description.toString());
                blArray[60] = true;
            }
            Object tag = view2.getTag();
            if (null == tag) {
                blArray[61] = true;
                j.name("tag").nullValue();
                blArray[62] = true;
            } else if (!(tag instanceof CharSequence)) {
                blArray[63] = true;
            } else {
                blArray[64] = true;
                j.name("tag").value(tag.toString());
                blArray[65] = true;
            }
            j.name("top").value((long)view2.getTop());
            blArray[66] = true;
            j.name("left").value((long)view2.getLeft());
            blArray[67] = true;
            j.name("width").value((long)view2.getWidth());
            blArray[68] = true;
            j.name("height").value((long)view2.getHeight());
            blArray[69] = true;
            j.name("scrollX").value((long)view2.getScrollX());
            blArray[70] = true;
            j.name("scrollY").value((long)view2.getScrollY());
            blArray[71] = true;
            j.name("visibility").value((long)view2.getVisibility());
            float translationX = 0.0f;
            float translationY = 0.0f;
            if (Build.VERSION.SDK_INT < 11) {
                blArray[72] = true;
            } else {
                blArray[73] = true;
                translationX = view2.getTranslationX();
                blArray[74] = true;
                translationY = view2.getTranslationY();
                blArray[75] = true;
            }
            j.name("translationX").value((double)translationX);
            blArray[76] = true;
            j.name("translationY").value((double)translationY);
            blArray[77] = true;
            j.name("classes");
            blArray[78] = true;
            j.beginArray();
            blArray[79] = true;
            Class<?> clazz = view2.getClass();
            blArray[80] = true;
            while (true) {
                Class klass;
                j.value((String)this.mClassnameCache.get(klass));
                blArray[81] = true;
                klass = klass.getSuperclass();
                if (klass == Object.class) {
                    blArray[82] = true;
                    break block31;
                }
                if (klass == null) break;
                blArray[83] = true;
            }
            blArray[84] = true;
        }
        j.endArray();
        blArray[85] = true;
        this.addProperties((JsonWriter)j, (View)view2);
        blArray[86] = true;
        ViewGroup.LayoutParams layoutParams = view2.getLayoutParams();
        if (!(layoutParams instanceof RelativeLayout.LayoutParams)) {
            blArray[87] = true;
        } else {
            void rules;
            RelativeLayout.LayoutParams layoutParams2 = (RelativeLayout.LayoutParams)layoutParams;
            blArray[88] = true;
            int[] nArray = relativeLayoutParams.getRules();
            blArray[89] = true;
            j.name("layoutRules");
            blArray[90] = true;
            j.beginArray();
            void var14_16 = rules;
            int n = ((void)var14_16).length;
            blArray[91] = true;
            for (int i = 0; i < n; ++i) {
                void rule;
                void var17_23 = var14_16[i];
                blArray[92] = true;
                j.value((long)rule);
                blArray[93] = true;
            }
            j.endArray();
            blArray[94] = true;
        }
        j.name("subviews");
        blArray[95] = true;
        j.beginArray();
        if (!(view2 instanceof ViewGroup)) {
            blArray[96] = true;
        } else {
            relativeLayoutParams = (ViewGroup)view2;
            blArray[97] = true;
            int childCount = group.getChildCount();
            boolean bl = false;
            blArray[98] = true;
            while (true) {
                void i;
                if (i >= childCount) {
                    blArray[99] = true;
                    break;
                }
                blArray[100] = true;
                View child = group.getChildAt((int)i);
                if (null == child) {
                    blArray[101] = true;
                } else {
                    blArray[102] = true;
                    j.value((long)child.hashCode());
                    blArray[103] = true;
                }
                ++i;
                blArray[104] = true;
            }
        }
        j.endArray();
        blArray[105] = true;
        j.endObject();
        if (!(view2 instanceof ViewGroup)) {
            blArray[106] = true;
        } else {
            group = (ViewGroup)view2;
            blArray[107] = true;
            int childCount = group.getChildCount();
            int i = 0;
            blArray[108] = true;
            while (true) {
                if (i >= childCount) {
                    blArray[109] = true;
                    break;
                }
                blArray[110] = true;
                View child = group.getChildAt(i);
                if (null == child) {
                    blArray[111] = true;
                } else {
                    blArray[112] = true;
                    this.snapshotView((JsonWriter)j, child);
                    blArray[113] = true;
                }
                ++i;
                blArray[114] = true;
            }
        }
        blArray[115] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void addProperties(JsonWriter jsonWriter, View view) throws IOException {
        void v;
        boolean[] blArray = ViewSnapshot.$jacocoInit();
        Class<?> clazz = v.getClass();
        blArray[116] = true;
        Iterator<PropertyDescription> iterator = this.mProperties.iterator();
        blArray[117] = true;
        while (iterator.hasNext()) {
            void viewClass;
            void desc;
            PropertyDescription propertyDescription = iterator.next();
            blArray[118] = true;
            if (!desc.targetClass.isAssignableFrom((Class<?>)viewClass)) {
                blArray[119] = true;
            } else if (null == desc.accessor) {
                blArray[120] = true;
            } else {
                void j;
                blArray[121] = true;
                Object value = desc.accessor.applyMethod((View)v);
                if (null == value) {
                    blArray[122] = true;
                } else if (value instanceof Number) {
                    blArray[123] = true;
                    j.name(desc.name).value((Number)value);
                    blArray[124] = true;
                } else if (value instanceof Boolean) {
                    blArray[125] = true;
                    j.name(desc.name).value(((Boolean)value).booleanValue());
                    blArray[126] = true;
                } else if (value instanceof ColorStateList) {
                    blArray[127] = true;
                    j.name(desc.name).value((Number)((ColorStateList)value).getDefaultColor());
                    blArray[128] = true;
                } else if (value instanceof Drawable) {
                    void bounds;
                    Class klass;
                    void drawable;
                    Drawable drawable2 = (Drawable)value;
                    blArray[129] = true;
                    Rect rect = drawable.getBounds();
                    blArray[130] = true;
                    j.name(desc.name);
                    blArray[131] = true;
                    j.beginObject();
                    blArray[132] = true;
                    j.name("classes");
                    blArray[133] = true;
                    j.beginArray();
                    blArray[134] = true;
                    Class<?> clazz2 = drawable.getClass();
                    blArray[135] = true;
                    while (klass != Object.class) {
                        blArray[136] = true;
                        j.value(klass.getCanonicalName());
                        blArray[137] = true;
                        klass = klass.getSuperclass();
                        blArray[138] = true;
                    }
                    j.endArray();
                    blArray[139] = true;
                    j.name("dimensions");
                    blArray[140] = true;
                    j.beginObject();
                    blArray[141] = true;
                    j.name("left").value((long)bounds.left);
                    blArray[142] = true;
                    j.name("right").value((long)bounds.right);
                    blArray[143] = true;
                    j.name("top").value((long)bounds.top);
                    blArray[144] = true;
                    j.name("bottom").value((long)bounds.bottom);
                    blArray[145] = true;
                    j.endObject();
                    if (!(drawable instanceof ColorDrawable)) {
                        blArray[146] = true;
                    } else {
                        void colorDrawable;
                        ColorDrawable colorDrawable2 = (ColorDrawable)drawable;
                        blArray[147] = true;
                        j.name("color").value((long)colorDrawable.getColor());
                        blArray[148] = true;
                    }
                    j.endObject();
                    blArray[149] = true;
                } else {
                    j.name(desc.name).value(value.toString());
                    blArray[150] = true;
                }
            }
            blArray[151] = true;
        }
        blArray[152] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)2022858564063361411L, (String)"com/mixpanel/android/viewcrawler/ViewSnapshot", (int)153);
        }
        return blArray;
    }

    private static class RootViewInfo {
        public final String activityName;
        public final View rootView;
        public CachedBitmap screenshot;
        public float scale;
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        public RootViewInfo(String string, View view) {
            void rootView;
            void activityName;
            boolean[] blArray = RootViewInfo.$jacocoInit();
            this.activityName = activityName;
            this.rootView = rootView;
            this.screenshot = null;
            this.scale = 1.0f;
            blArray[0] = true;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)-8501860321873361339L, (String)"com/mixpanel/android/viewcrawler/ViewSnapshot$RootViewInfo", (int)1);
            }
            return blArray;
        }
    }

    private static class CachedBitmap {
        private Bitmap mCached;
        private final Paint mPaint;
        private static transient /* synthetic */ boolean[] $jacocoData;

        public CachedBitmap() {
            boolean[] blArray = CachedBitmap.$jacocoInit();
            blArray[0] = true;
            this.mPaint = new Paint(2);
            this.mCached = null;
            blArray[1] = true;
        }

        /*
         * Unable to fully structure code
         */
        public synchronized void recreate(int var1_1, int var2_2, int var3_3, Bitmap var4_4) {
            block9: {
                block8: {
                    var5_5 = CachedBitmap.$jacocoInit();
                    if (null != this.mCached) break block8;
                    var5_5[2] = true;
                    ** GOTO lbl15
                }
                if (this.mCached.getWidth() == width) break block9;
                var5_5[3] = true;
                ** GOTO lbl15
            }
            if (this.mCached.getHeight() == height) {
                var5_5[4] = true;
            } else {
                try {
                    var5_5[5] = true;
lbl15:
                    // 3 sources

                    this.mCached = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
                    var5_5[6] = true;
                }
                catch (OutOfMemoryError e) {
                    this.mCached = null;
                    var5_5[7] = true;
                }
                if (null == this.mCached) {
                    var5_5[8] = true;
                } else {
                    var5_5[9] = true;
                    this.mCached.setDensity((int)destDensity);
                    var5_5[10] = true;
                }
            }
            if (null == this.mCached) {
                var5_5[11] = true;
            } else {
                var5_5[12] = true;
                e = new Canvas(this.mCached);
                var5_5[13] = true;
                scaledCanvas.drawBitmap((Bitmap)source, 0.0f, 0.0f, this.mPaint);
                var5_5[14] = true;
            }
            var5_5[15] = true;
        }

        /*
         * Unable to fully structure code
         */
        public synchronized void writeBitmapJSON(Bitmap.CompressFormat var1_1, int var2_2, OutputStream var3_3) throws IOException {
            block3: {
                block2: {
                    var4_4 = CachedBitmap.$jacocoInit();
                    if (null != this.mCached) break block2;
                    var4_4[16] = true;
                    ** GOTO lbl12
                }
                if (this.mCached.getWidth() != 0) break block3;
                var4_4[17] = true;
                ** GOTO lbl12
            }
            if (this.mCached.getHeight() == 0) {
                var4_4[18] = true;
lbl12:
                // 3 sources

                out.write("null".getBytes());
                var4_4[19] = true;
            } else {
                out.write(34);
                var4_4[20] = true;
                var5_5 = new Base64OutputStream((OutputStream)out, 2);
                var4_4[21] = true;
                this.mCached.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)imageOut);
                var4_4[22] = true;
                imageOut.flush();
                var4_4[23] = true;
                out.write(34);
                var4_4[24] = true;
            }
            var4_4[25] = true;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)6679331713237672512L, (String)"com/mixpanel/android/viewcrawler/ViewSnapshot$CachedBitmap", (int)26);
            }
            return blArray;
        }
    }

    private static class RootViewFinder
    implements Callable<List<RootViewInfo>> {
        private UIThreadSet<Activity> mLiveActivities;
        private final List<RootViewInfo> mRootViews;
        private final DisplayMetrics mDisplayMetrics;
        private final CachedBitmap mCachedBitmap;
        private final int mClientDensity = 160;
        private static transient /* synthetic */ boolean[] $jacocoData;

        public RootViewFinder() {
            boolean[] blArray = RootViewFinder.$jacocoInit();
            this.mClientDensity = 160;
            blArray[0] = true;
            this.mDisplayMetrics = new DisplayMetrics();
            blArray[1] = true;
            this.mRootViews = new ArrayList<RootViewInfo>();
            blArray[2] = true;
            this.mCachedBitmap = new CachedBitmap();
            blArray[3] = true;
        }

        /*
         * WARNING - void declaration
         */
        public void findInActivities(UIThreadSet<Activity> uIThreadSet) {
            void liveActivities;
            boolean[] blArray = RootViewFinder.$jacocoInit();
            this.mLiveActivities = liveActivities;
            blArray[4] = true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<RootViewInfo> call() throws Exception {
            void i;
            RootViewInfo activityName;
            void liveActivities;
            boolean[] blArray = RootViewFinder.$jacocoInit();
            this.mRootViews.clear();
            blArray[5] = true;
            Set<Activity> set = this.mLiveActivities.getAll();
            blArray[6] = true;
            Iterator iterator = liveActivities.iterator();
            blArray[7] = true;
            while (iterator.hasNext()) {
                void info;
                void rootView;
                void a;
                Activity activity = (Activity)iterator.next();
                blArray[8] = true;
                String string = a.getClass().getCanonicalName();
                blArray[9] = true;
                View view = a.getWindow().getDecorView().getRootView();
                blArray[10] = true;
                a.getWindowManager().getDefaultDisplay().getMetrics(this.mDisplayMetrics);
                blArray[11] = true;
                RootViewInfo rootViewInfo = new RootViewInfo((String)((Object)activityName), (View)rootView);
                blArray[12] = true;
                this.mRootViews.add((RootViewInfo)info);
                blArray[13] = true;
            }
            int viewCount = this.mRootViews.size();
            boolean a = false;
            blArray[14] = true;
            while (i < viewCount) {
                void info;
                blArray[15] = true;
                activityName = this.mRootViews.get((int)i);
                blArray[16] = true;
                this.takeScreenshot((RootViewInfo)info);
                ++i;
                blArray[17] = true;
            }
            blArray[18] = true;
            return this.mRootViews;
        }

        /*
         * WARNING - void declaration
         */
        private void takeScreenshot(RootViewInfo rootViewInfo) {
            Boolean originalCacheState;
            Bitmap rawBitmap;
            View rootView;
            block25: {
                void info;
                boolean[] blArray = RootViewFinder.$jacocoInit();
                rootView = info.rootView;
                Object var4_4 = null;
                try {
                    void createSnapshot;
                    blArray[19] = true;
                    Method method = View.class.getDeclaredMethod("createSnapshot", Bitmap.Config.class, Integer.TYPE, Boolean.TYPE);
                    blArray[20] = true;
                    createSnapshot.setAccessible(true);
                    blArray[21] = true;
                    rawBitmap = (Bitmap)createSnapshot.invoke((Object)rootView, Bitmap.Config.RGB_565, -1, false);
                }
                catch (NoSuchMethodException createSnapshot) {
                    void e;
                    blArray[23] = true;
                    MPLog.v(ViewSnapshot.LOGTAG, "Can't call createSnapshot, will use drawCache", (Throwable)e);
                    blArray[24] = true;
                }
                catch (IllegalArgumentException e) {
                    blArray[25] = true;
                    MPLog.d(ViewSnapshot.LOGTAG, "Can't call createSnapshot with arguments", e);
                    blArray[26] = true;
                }
                catch (InvocationTargetException e) {
                    blArray[27] = true;
                    MPLog.e(ViewSnapshot.LOGTAG, "Exception when calling createSnapshot", e);
                    blArray[28] = true;
                }
                catch (IllegalAccessException e) {
                    blArray[29] = true;
                    MPLog.e(ViewSnapshot.LOGTAG, "Can't access createSnapshot, using drawCache", e);
                    blArray[30] = true;
                }
                catch (ClassCastException e) {
                    blArray[31] = true;
                    MPLog.e(ViewSnapshot.LOGTAG, "createSnapshot didn't return a bitmap?", e);
                    blArray[32] = true;
                }
                blArray[22] = true;
                Object e = null;
                try {
                    blArray[33] = true;
                    if (null != rawBitmap) {
                        blArray[34] = true;
                        break block25;
                    }
                    blArray[35] = true;
                    originalCacheState = rootView.isDrawingCacheEnabled();
                    blArray[36] = true;
                    rootView.setDrawingCacheEnabled(true);
                    blArray[37] = true;
                    rootView.buildDrawingCache(true);
                    blArray[38] = true;
                    rawBitmap = rootView.getDrawingCache();
                    blArray[39] = true;
                }
                catch (RuntimeException runtimeException) {
                    void e2;
                    blArray[41] = true;
                    MPLog.v(ViewSnapshot.LOGTAG, "Can't take a bitmap snapshot of view " + rootView + ", skipping for now.", (Throwable)e2);
                    blArray[42] = true;
                }
            }
            blArray[40] = true;
            float scale = 1.0f;
            if (null == rawBitmap) {
                blArray[43] = true;
            } else {
                void destWidth;
                void rawHeight;
                void rawWidth;
                blArray[44] = true;
                int rawDensity = rawBitmap.getDensity();
                if (rawDensity == 0) {
                    blArray[45] = true;
                } else {
                    scale = 160.0f / (float)rawDensity;
                    blArray[46] = true;
                }
                int n = rawBitmap.getWidth();
                blArray[47] = true;
                int n2 = rawBitmap.getHeight();
                blArray[48] = true;
                int n3 = (int)((double)((float)rawBitmap.getWidth() * scale) + 0.5);
                blArray[49] = true;
                int destHeight = (int)((double)((float)rawBitmap.getHeight() * scale) + 0.5);
                if (rawWidth <= 0) {
                    blArray[50] = true;
                } else if (rawHeight <= 0) {
                    blArray[51] = true;
                } else if (destWidth <= 0) {
                    blArray[52] = true;
                } else if (destHeight <= 0) {
                    blArray[53] = true;
                } else {
                    blArray[54] = true;
                    this.mCachedBitmap.recreate((int)destWidth, destHeight, 160, rawBitmap);
                    blArray[55] = true;
                }
            }
            if (null == originalCacheState) {
                blArray[56] = true;
            } else if (originalCacheState.booleanValue()) {
                blArray[57] = true;
            } else {
                blArray[58] = true;
                rootView.setDrawingCacheEnabled(false);
                blArray[59] = true;
            }
            info.scale = scale;
            info.screenshot = this.mCachedBitmap;
            blArray[60] = true;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)-7910417609876405553L, (String)"com/mixpanel/android/viewcrawler/ViewSnapshot$RootViewFinder", (int)62);
            }
            return blArray;
        }
    }

    private static class ClassNameCache
    extends LruCache<Class<?>, String> {
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        public ClassNameCache(int n) {
            void maxSize;
            boolean[] blArray = ClassNameCache.$jacocoInit();
            super((int)maxSize);
            blArray[0] = true;
        }

        /*
         * WARNING - void declaration
         */
        protected String create(Class<?> clazz) {
            void klass;
            boolean[] blArray = ClassNameCache.$jacocoInit();
            blArray[1] = true;
            return klass.getCanonicalName();
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)-30426219143745067L, (String)"com/mixpanel/android/viewcrawler/ViewSnapshot$ClassNameCache", (int)3);
            }
            return blArray;
        }
    }
}

