/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.Parcelable;
import com.mixpanel.android.mpmetrics.AnalyticsMessages;
import com.mixpanel.android.mpmetrics.BadDecideObjectException;
import com.mixpanel.android.mpmetrics.DisplayTrigger;
import com.mixpanel.android.util.JSONUtils;
import com.mixpanel.android.util.MPLog;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class InAppNotification
implements Parcelable {
    private static final String LOGTAG = "MixpanelAPI.InAppNotif";
    private static final Pattern FILE_EXTENSION_PATTERN;
    protected final JSONObject mDescription;
    protected final JSONObject mExtras;
    protected final int mId;
    protected final int mMessageId;
    private final int mBackgroundColor;
    private final String mBody;
    private final int mBodyColor;
    private final String mImageUrl;
    private final List<DisplayTrigger> mDisplayTriggers;
    private Bitmap mImage;
    private static transient /* synthetic */ boolean[] $jacocoData;

    public InAppNotification() {
        boolean[] blArray = InAppNotification.$jacocoInit();
        this.mDescription = null;
        this.mExtras = null;
        this.mId = 0;
        this.mMessageId = 0;
        this.mBackgroundColor = 0;
        this.mBody = null;
        this.mBodyColor = 0;
        this.mImageUrl = null;
        this.mDisplayTriggers = null;
        blArray[0] = true;
    }

    /*
     * WARNING - void declaration
     */
    public InAppNotification(Parcel parcel) {
        JSONObject tempExtras;
        JSONObject tempDescription;
        void in;
        boolean[] blArray = InAppNotification.$jacocoInit();
        blArray[1] = true;
        JSONObject jSONObject = new JSONObject();
        blArray[2] = true;
        JSONObject jSONObject2 = new JSONObject();
        try {
            blArray[3] = true;
            tempDescription = new JSONObject(in.readString());
            blArray[4] = true;
            tempExtras = new JSONObject(in.readString());
            blArray[5] = true;
        }
        catch (JSONException jSONException) {
            blArray[6] = true;
            MPLog.e(LOGTAG, "Error reading JSON when creating InAppNotification from Parcel");
            blArray[7] = true;
        }
        this.mDescription = tempDescription;
        this.mExtras = tempExtras;
        blArray[8] = true;
        this.mId = in.readInt();
        blArray[9] = true;
        this.mMessageId = in.readInt();
        blArray[10] = true;
        this.mBackgroundColor = in.readInt();
        blArray[11] = true;
        this.mBody = in.readString();
        blArray[12] = true;
        this.mBodyColor = in.readInt();
        blArray[13] = true;
        this.mImageUrl = in.readString();
        blArray[14] = true;
        this.mImage = (Bitmap)in.readParcelable(Bitmap.class.getClassLoader());
        blArray[15] = true;
        this.mDisplayTriggers = new ArrayList<DisplayTrigger>();
        blArray[16] = true;
        in.readList(this.mDisplayTriggers, null);
        blArray[17] = true;
    }

    /*
     * WARNING - void declaration
     */
    InAppNotification(JSONObject jSONObject) throws BadDecideObjectException {
        boolean[] blArray = InAppNotification.$jacocoInit();
        blArray[18] = true;
        this.mDisplayTriggers = new ArrayList<DisplayTrigger>();
        try {
            void description;
            blArray[19] = true;
            this.mDescription = description;
            blArray[20] = true;
            this.mExtras = description.getJSONObject("extras");
            blArray[21] = true;
            this.mId = description.getInt("id");
            blArray[22] = true;
            this.mMessageId = description.getInt("message_id");
            blArray[23] = true;
            this.mBackgroundColor = description.getInt("bg_color");
            blArray[24] = true;
            this.mBody = JSONUtils.optionalStringKey((JSONObject)description, "body");
            blArray[25] = true;
            this.mBodyColor = description.optInt("body_color");
            blArray[26] = true;
            this.mImageUrl = description.getString("image_url");
            blArray[27] = true;
            this.mImage = Bitmap.createBitmap((int)500, (int)500, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            blArray[28] = true;
            JSONArray jSONArray = description.optJSONArray("display_triggers");
            blArray[29] = true;
            boolean bl = false;
            blArray[30] = true;
            while (true) {
                void i;
                void tempDisplayTriggers;
                if (null == tempDisplayTriggers) {
                    blArray[31] = true;
                    break;
                }
                if (i >= tempDisplayTriggers.length()) {
                    blArray[32] = true;
                    break;
                }
                blArray[33] = true;
                this.mDisplayTriggers.add(new DisplayTrigger(tempDisplayTriggers.getJSONObject((int)i)));
                ++i;
                blArray[34] = true;
            }
        }
        catch (JSONException i) {
            void e;
            blArray[35] = true;
            blArray[36] = true;
            throw new BadDecideObjectException("Notification JSON was unexpected or bad", (Throwable)e);
        }
        blArray[37] = true;
    }

    String toJSON() {
        boolean[] blArray = InAppNotification.$jacocoInit();
        blArray[38] = true;
        return this.mDescription.toString();
    }

    /*
     * WARNING - void declaration
     */
    JSONObject getCampaignProperties() {
        void ret;
        boolean[] blArray = InAppNotification.$jacocoInit();
        JSONObject jSONObject = new JSONObject();
        try {
            blArray[39] = true;
            ret.put("campaign_id", this.getId());
            blArray[40] = true;
            ret.put("message_id", this.getMessageId());
            blArray[41] = true;
            ret.put("message_type", (Object)"inapp");
            blArray[42] = true;
            ret.put("message_subtype", (Object)this.getType().toString());
            blArray[43] = true;
        }
        catch (JSONException jSONException) {
            void e;
            blArray[44] = true;
            MPLog.e(LOGTAG, "Impossible JSON Exception", (Throwable)e);
            blArray[45] = true;
        }
        blArray[46] = true;
        return ret;
    }

    public int getId() {
        boolean[] blArray = InAppNotification.$jacocoInit();
        blArray[47] = true;
        return this.mId;
    }

    public int getMessageId() {
        boolean[] blArray = InAppNotification.$jacocoInit();
        blArray[48] = true;
        return this.mMessageId;
    }

    public abstract Type getType();

    public int getBackgroundColor() {
        boolean[] blArray = InAppNotification.$jacocoInit();
        blArray[49] = true;
        return this.mBackgroundColor;
    }

    public boolean hasBody() {
        boolean bl;
        boolean[] blArray = InAppNotification.$jacocoInit();
        if (this.mBody != null) {
            bl = blArray[50] = true;
        } else {
            bl = false;
            blArray[51] = true;
        }
        blArray[52] = true;
        return bl;
    }

    public String getBody() {
        boolean[] blArray = InAppNotification.$jacocoInit();
        blArray[53] = true;
        return this.mBody;
    }

    public int getBodyColor() {
        boolean[] blArray = InAppNotification.$jacocoInit();
        blArray[54] = true;
        return this.mBodyColor;
    }

    public String getImageUrl() {
        boolean[] blArray = InAppNotification.$jacocoInit();
        blArray[55] = true;
        return this.mImageUrl;
    }

    public String getImage2xUrl() {
        boolean[] blArray = InAppNotification.$jacocoInit();
        blArray[56] = true;
        return InAppNotification.sizeSuffixUrl(this.mImageUrl, "@2x");
    }

    public String getImage4xUrl() {
        boolean[] blArray = InAppNotification.$jacocoInit();
        blArray[57] = true;
        return InAppNotification.sizeSuffixUrl(this.mImageUrl, "@4x");
    }

    /*
     * WARNING - void declaration
     */
    void setImage(Bitmap bitmap) {
        void image;
        boolean[] blArray = InAppNotification.$jacocoInit();
        this.mImage = image;
        blArray[58] = true;
    }

    public Bitmap getImage() {
        boolean[] blArray = InAppNotification.$jacocoInit();
        blArray[59] = true;
        return this.mImage;
    }

    /*
     * Unable to fully structure code
     */
    public boolean isEventTriggered() {
        block2: {
            var1_1 = InAppNotification.$jacocoInit();
            if (null != this.mDisplayTriggers) break block2;
            var1_1[60] = true;
            ** GOTO lbl10
        }
        if (!this.mDisplayTriggers.isEmpty()) {
            v0 = var1_1[62] = true;
        } else {
            var1_1[61] = true;
lbl10:
            // 2 sources

            v0 = false;
            var1_1[63] = true;
        }
        var1_1[64] = true;
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    public boolean matchesEventDescription(AnalyticsMessages.EventDescription eventDescription) {
        boolean[] blArray = InAppNotification.$jacocoInit();
        if (!this.isEventTriggered()) {
            blArray[65] = true;
        } else {
            blArray[66] = true;
            Iterator<DisplayTrigger> iterator = this.mDisplayTriggers.iterator();
            blArray[67] = true;
            while (true) {
                void eventDescription2;
                void trigger;
                if (!iterator.hasNext()) {
                    blArray[68] = true;
                    break;
                }
                DisplayTrigger displayTrigger = iterator.next();
                blArray[69] = true;
                if (trigger.matchesEventDescription((AnalyticsMessages.EventDescription)eventDescription2)) {
                    blArray[70] = true;
                    return true;
                }
                blArray[71] = true;
            }
        }
        blArray[72] = true;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    static String sizeSuffixUrl(String string, String string2) {
        void matcher;
        String url;
        boolean[] blArray = InAppNotification.$jacocoInit();
        Matcher matcher2 = FILE_EXTENSION_PATTERN.matcher(url);
        blArray[73] = true;
        if (matcher.find()) {
            void sizeSuffix;
            blArray[74] = true;
            blArray[75] = true;
            return matcher.replaceFirst((String)sizeSuffix + "$1");
        }
        blArray[76] = true;
        return url;
    }

    protected JSONObject getExtras() {
        boolean[] blArray = InAppNotification.$jacocoInit();
        blArray[77] = true;
        return this.mExtras;
    }

    public int describeContents() {
        boolean[] blArray = InAppNotification.$jacocoInit();
        blArray[78] = true;
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(Parcel parcel, int n) {
        void flags;
        void dest;
        boolean[] blArray = InAppNotification.$jacocoInit();
        dest.writeString(this.mDescription.toString());
        blArray[79] = true;
        dest.writeString(this.mExtras.toString());
        blArray[80] = true;
        dest.writeInt(this.mId);
        blArray[81] = true;
        dest.writeInt(this.mMessageId);
        blArray[82] = true;
        dest.writeInt(this.mBackgroundColor);
        blArray[83] = true;
        dest.writeString(this.mBody);
        blArray[84] = true;
        dest.writeInt(this.mBodyColor);
        blArray[85] = true;
        dest.writeString(this.mImageUrl);
        blArray[86] = true;
        dest.writeParcelable((Parcelable)this.mImage, (int)flags);
        blArray[87] = true;
        dest.writeList(this.mDisplayTriggers);
        blArray[88] = true;
    }

    public String toString() {
        boolean[] blArray = InAppNotification.$jacocoInit();
        blArray[89] = true;
        return this.mDescription.toString();
    }

    static {
        boolean[] blArray = InAppNotification.$jacocoInit();
        FILE_EXTENSION_PATTERN = Pattern.compile("(\\.[^./]+$)");
        blArray[90] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)1609980781796944763L, (String)"com/mixpanel/android/mpmetrics/InAppNotification", (int)91);
        }
        return blArray;
    }

    public static class Type
    extends Enum<Type> {
        public static final /* enum */ Type UNKNOWN;
        public static final /* enum */ Type MINI;
        public static final /* enum */ Type TAKEOVER;
        private static final /* synthetic */ Type[] $VALUES;
        private static transient /* synthetic */ boolean[] $jacocoData;

        public static Type[] values() {
            boolean[] blArray = Type.$jacocoInit();
            blArray[0] = true;
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string) {
            String name;
            boolean[] blArray = Type.$jacocoInit();
            blArray[1] = true;
            return Enum.valueOf(Type.class, name);
        }

        private Type() {
            boolean[] blArray = Type.$jacocoInit();
            blArray[2] = true;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ Type(String string, int n, com.mixpanel.android.mpmetrics.InAppNotification$1 var3_3) {
            void x1;
            void x0;
            boolean[] blArray = Type.$jacocoInit();
            this();
            blArray[3] = true;
        }

        static {
            boolean[] blArray = Type.$jacocoInit();
            UNKNOWN = new Type(){
                private static transient /* synthetic */ boolean[] $jacocoData;
                {
                    boolean[] blArray = 1.$jacocoInit();
                    blArray[0] = true;
                }

                public String toString() {
                    boolean[] blArray = 1.$jacocoInit();
                    blArray[1] = true;
                    return "*unknown_type*";
                }

                private static /* synthetic */ boolean[] $jacocoInit() {
                    boolean[] blArray = $jacocoData;
                    if ($jacocoData == null) {
                        blArray = $jacocoData = Offline.getProbes((long)1169760555595178239L, (String)"com/mixpanel/android/mpmetrics/InAppNotification$Type$1", (int)2);
                    }
                    return blArray;
                }
            };
            blArray[4] = true;
            MINI = new Type(){
                private static transient /* synthetic */ boolean[] $jacocoData;
                {
                    boolean[] blArray = 2.$jacocoInit();
                    blArray[0] = true;
                }

                public String toString() {
                    boolean[] blArray = 2.$jacocoInit();
                    blArray[1] = true;
                    return "mini";
                }

                private static /* synthetic */ boolean[] $jacocoInit() {
                    boolean[] blArray = $jacocoData;
                    if ($jacocoData == null) {
                        blArray = $jacocoData = Offline.getProbes((long)-669569810520987639L, (String)"com/mixpanel/android/mpmetrics/InAppNotification$Type$2", (int)2);
                    }
                    return blArray;
                }
            };
            blArray[5] = true;
            TAKEOVER = new Type(){
                private static transient /* synthetic */ boolean[] $jacocoData;
                {
                    boolean[] blArray = 3.$jacocoInit();
                    blArray[0] = true;
                }

                public String toString() {
                    boolean[] blArray = 3.$jacocoInit();
                    blArray[1] = true;
                    return "takeover";
                }

                private static /* synthetic */ boolean[] $jacocoInit() {
                    boolean[] blArray = $jacocoData;
                    if ($jacocoData == null) {
                        blArray = $jacocoData = Offline.getProbes((long)5948624406094839674L, (String)"com/mixpanel/android/mpmetrics/InAppNotification$Type$3", (int)2);
                    }
                    return blArray;
                }
            };
            $VALUES = new Type[]{UNKNOWN, MINI, TAKEOVER};
            blArray[6] = true;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)4123434257504424355L, (String)"com/mixpanel/android/mpmetrics/InAppNotification$Type", (int)7);
            }
            return blArray;
        }
    }
}

