/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.viewcrawler;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.mixpanel.android.util.MPLog;
import com.mixpanel.android.viewcrawler.Caller;
import com.mixpanel.android.viewcrawler.Pathfinder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;

@TargetApi(value=16)
abstract class ViewVisitor
implements Pathfinder.Accumulator {
    private final List<Pathfinder.PathElement> mPath;
    private final Pathfinder mPathfinder;
    private static final String LOGTAG = "MixpanelAPI.ViewVisitor";
    private static transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - void declaration
     */
    public void visit(View view) {
        void rootView;
        boolean[] blArray = ViewVisitor.$jacocoInit();
        this.mPathfinder.findTargetsInRoot((View)rootView, this.mPath, this);
        blArray[0] = true;
    }

    public abstract void cleanup();

    /*
     * WARNING - void declaration
     */
    protected ViewVisitor(List<Pathfinder.PathElement> list) {
        void path;
        boolean[] blArray = ViewVisitor.$jacocoInit();
        this.mPath = path;
        blArray[1] = true;
        this.mPathfinder = new Pathfinder();
        blArray[2] = true;
    }

    protected List<Pathfinder.PathElement> getPath() {
        boolean[] blArray = ViewVisitor.$jacocoInit();
        blArray[3] = true;
        return this.mPath;
    }

    protected Pathfinder getPathfinder() {
        boolean[] blArray = ViewVisitor.$jacocoInit();
        blArray[4] = true;
        return this.mPathfinder;
    }

    protected abstract String name();

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)5548953334207749958L, (String)"com/mixpanel/android/viewcrawler/ViewVisitor", (int)5);
        }
        return blArray;
    }

    private static abstract class EventTriggeringVisitor
    extends ViewVisitor {
        private final OnEventListener mListener;
        private final String mEventName;
        private final boolean mDebounce;
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        public EventTriggeringVisitor(List<Pathfinder.PathElement> list, String string, OnEventListener onEventListener, boolean bl) {
            void debounce;
            void eventName;
            void listener;
            void path;
            boolean[] blArray = EventTriggeringVisitor.$jacocoInit();
            super((List<Pathfinder.PathElement>)path);
            this.mListener = listener;
            this.mEventName = eventName;
            this.mDebounce = debounce;
            blArray[0] = true;
        }

        /*
         * WARNING - void declaration
         */
        protected void fireEvent(View view) {
            void found;
            boolean[] blArray = EventTriggeringVisitor.$jacocoInit();
            this.mListener.OnEvent((View)found, this.mEventName, this.mDebounce);
            blArray[1] = true;
        }

        protected String getEventName() {
            boolean[] blArray = EventTriggeringVisitor.$jacocoInit();
            blArray[2] = true;
            return this.mEventName;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)5444773078576480835L, (String)"com/mixpanel/android/viewcrawler/ViewVisitor$EventTriggeringVisitor", (int)3);
            }
            return blArray;
        }
    }

    public static class ViewDetectorVisitor
    extends EventTriggeringVisitor {
        private boolean mSeen;
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        public ViewDetectorVisitor(List<Pathfinder.PathElement> list, String string, OnEventListener onEventListener) {
            void listener;
            void eventName;
            void path;
            boolean[] blArray = ViewDetectorVisitor.$jacocoInit();
            super((List<Pathfinder.PathElement>)path, (String)eventName, (OnEventListener)listener, false);
            this.mSeen = false;
            blArray[0] = true;
        }

        @Override
        public void cleanup() {
            boolean[] blArray = ViewDetectorVisitor.$jacocoInit();
            blArray[1] = true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void accumulate(View view) {
            boolean bl;
            void found;
            boolean[] blArray = ViewDetectorVisitor.$jacocoInit();
            if (found == null) {
                blArray[2] = true;
            } else if (this.mSeen) {
                blArray[3] = true;
            } else {
                blArray[4] = true;
                this.fireEvent((View)found);
                blArray[5] = true;
            }
            if (found != null) {
                bl = blArray[6] = true;
            } else {
                bl = false;
                blArray[7] = true;
            }
            this.mSeen = bl;
            blArray[8] = true;
        }

        @Override
        protected String name() {
            boolean[] blArray = ViewDetectorVisitor.$jacocoInit();
            blArray[9] = true;
            return this.getEventName() + " when Detected";
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)4654505699593970251L, (String)"com/mixpanel/android/viewcrawler/ViewVisitor$ViewDetectorVisitor", (int)11);
            }
            return blArray;
        }
    }

    public static class AddTextChangeListener
    extends EventTriggeringVisitor {
        private final Map<TextView, TextWatcher> mWatching;
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        public AddTextChangeListener(List<Pathfinder.PathElement> list, String string, OnEventListener onEventListener) {
            void listener;
            void eventName;
            void path;
            boolean[] blArray = AddTextChangeListener.$jacocoInit();
            super((List<Pathfinder.PathElement>)path, (String)eventName, (OnEventListener)listener, true);
            blArray[0] = true;
            this.mWatching = new HashMap<TextView, TextWatcher>();
            blArray[1] = true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void cleanup() {
            boolean[] blArray = AddTextChangeListener.$jacocoInit();
            Iterator<Map.Entry<TextView, TextWatcher>> iterator = this.mWatching.entrySet().iterator();
            blArray[2] = true;
            while (iterator.hasNext()) {
                void watcher;
                void v;
                void entry;
                Map.Entry<TextView, TextWatcher> entry2 = iterator.next();
                blArray[3] = true;
                TextView textView = (TextView)entry.getKey();
                blArray[4] = true;
                TextWatcher textWatcher = (TextWatcher)entry.getValue();
                blArray[5] = true;
                v.removeTextChangedListener((TextWatcher)watcher);
                blArray[6] = true;
            }
            this.mWatching.clear();
            blArray[7] = true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void accumulate(View view) {
            void found;
            boolean[] blArray = AddTextChangeListener.$jacocoInit();
            if (!(found instanceof TextView)) {
                blArray[8] = true;
            } else {
                void watcher;
                void foundTextView;
                TextView textView = (TextView)found;
                blArray[9] = true;
                TrackingTextWatcher trackingTextWatcher = new TrackingTextWatcher(this, (View)foundTextView);
                blArray[10] = true;
                TextWatcher oldWatcher = this.mWatching.get(foundTextView);
                if (null == oldWatcher) {
                    blArray[11] = true;
                } else {
                    blArray[12] = true;
                    foundTextView.removeTextChangedListener(oldWatcher);
                    blArray[13] = true;
                }
                foundTextView.addTextChangedListener((TextWatcher)watcher);
                blArray[14] = true;
                this.mWatching.put((TextView)foundTextView, (TextWatcher)watcher);
                blArray[15] = true;
            }
            blArray[16] = true;
        }

        @Override
        protected String name() {
            boolean[] blArray = AddTextChangeListener.$jacocoInit();
            blArray[17] = true;
            return this.getEventName() + " on Text Change";
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)-3777877858520348998L, (String)"com/mixpanel/android/viewcrawler/ViewVisitor$AddTextChangeListener", (int)19);
            }
            return blArray;
        }

        private class TrackingTextWatcher
        implements TextWatcher {
            private final View mBoundTo;
            final /* synthetic */ AddTextChangeListener this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;

            /*
             * WARNING - void declaration
             */
            public TrackingTextWatcher(AddTextChangeListener addTextChangeListener, View view) {
                void boundTo;
                boolean[] blArray = TrackingTextWatcher.$jacocoInit();
                this.this$0 = addTextChangeListener;
                this.mBoundTo = boundTo;
                blArray[0] = true;
            }

            public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                boolean[] blArray = TrackingTextWatcher.$jacocoInit();
                blArray[1] = true;
            }

            public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                boolean[] blArray = TrackingTextWatcher.$jacocoInit();
                blArray[2] = true;
            }

            public void afterTextChanged(Editable editable) {
                boolean[] blArray = TrackingTextWatcher.$jacocoInit();
                this.this$0.fireEvent(this.mBoundTo);
                blArray[3] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)-5283807155030952472L, (String)"com/mixpanel/android/viewcrawler/ViewVisitor$AddTextChangeListener$TrackingTextWatcher", (int)4);
                }
                return blArray;
            }
        }
    }

    public static class AddAccessibilityEventVisitor
    extends EventTriggeringVisitor {
        private final int mEventType;
        private final WeakHashMap<View, TrackingAccessibilityDelegate> mWatching;
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        public AddAccessibilityEventVisitor(List<Pathfinder.PathElement> list, int n, String string, OnEventListener onEventListener) {
            void accessibilityEventType;
            void listener;
            void eventName;
            void path;
            boolean[] blArray = AddAccessibilityEventVisitor.$jacocoInit();
            super((List<Pathfinder.PathElement>)path, (String)eventName, (OnEventListener)listener, false);
            this.mEventType = accessibilityEventType;
            blArray[0] = true;
            this.mWatching = new WeakHashMap();
            blArray[1] = true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void cleanup() {
            boolean[] blArray = AddAccessibilityEventVisitor.$jacocoInit();
            Iterator<Map.Entry<View, TrackingAccessibilityDelegate>> iterator = this.mWatching.entrySet().iterator();
            blArray[2] = true;
            while (iterator.hasNext()) {
                void toCleanup;
                void v;
                void entry;
                Map.Entry<View, TrackingAccessibilityDelegate> entry2 = iterator.next();
                blArray[3] = true;
                View view = (View)entry.getKey();
                blArray[4] = true;
                TrackingAccessibilityDelegate trackingAccessibilityDelegate = (TrackingAccessibilityDelegate)((Object)entry.getValue());
                blArray[5] = true;
                View.AccessibilityDelegate currentViewDelegate = this.getOldDelegate((View)v);
                if (currentViewDelegate == toCleanup) {
                    blArray[6] = true;
                    v.setAccessibilityDelegate(toCleanup.getRealDelegate());
                    blArray[7] = true;
                } else if (!(currentViewDelegate instanceof TrackingAccessibilityDelegate)) {
                    blArray[8] = true;
                } else {
                    void newChain;
                    TrackingAccessibilityDelegate trackingAccessibilityDelegate2 = (TrackingAccessibilityDelegate)currentViewDelegate;
                    blArray[9] = true;
                    newChain.removeFromDelegateChain((TrackingAccessibilityDelegate)toCleanup);
                    blArray[10] = true;
                }
                blArray[11] = true;
            }
            this.mWatching.clear();
            blArray[12] = true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void accumulate(View view) {
            void newDelegate;
            TrackingAccessibilityDelegate currentTracker;
            void found;
            boolean[] blArray = AddAccessibilityEventVisitor.$jacocoInit();
            View.AccessibilityDelegate realDelegate = this.getOldDelegate((View)found);
            if (!(realDelegate instanceof TrackingAccessibilityDelegate)) {
                blArray[13] = true;
            } else {
                TrackingAccessibilityDelegate trackingAccessibilityDelegate = (TrackingAccessibilityDelegate)realDelegate;
                blArray[14] = true;
                if (!currentTracker.willFireEvent(this.getEventName())) {
                    blArray[15] = true;
                } else {
                    blArray[16] = true;
                    return;
                }
            }
            currentTracker = new TrackingAccessibilityDelegate(this, realDelegate);
            blArray[17] = true;
            found.setAccessibilityDelegate((View.AccessibilityDelegate)newDelegate);
            blArray[18] = true;
            this.mWatching.put((View)found, (TrackingAccessibilityDelegate)newDelegate);
            blArray[19] = true;
        }

        @Override
        protected String name() {
            boolean[] blArray = AddAccessibilityEventVisitor.$jacocoInit();
            blArray[20] = true;
            return this.getEventName() + " event when (" + this.mEventType + ")";
        }

        /*
         * WARNING - void declaration
         */
        private View.AccessibilityDelegate getOldDelegate(View view) {
            View.AccessibilityDelegate ret;
            boolean[] blArray = AddAccessibilityEventVisitor.$jacocoInit();
            Object var3_3 = null;
            try {
                void m;
                void klass;
                void v;
                blArray[21] = true;
                Class<?> clazz = v.getClass();
                blArray[22] = true;
                Method method = klass.getMethod("getAccessibilityDelegate", new Class[0]);
                blArray[23] = true;
                ret = (View.AccessibilityDelegate)m.invoke((Object)v, new Object[0]);
                blArray[24] = true;
            }
            catch (NoSuchMethodException klass) {
                blArray[25] = true;
            }
            catch (IllegalAccessException klass) {
                blArray[26] = true;
            }
            catch (InvocationTargetException klass) {
                void e;
                blArray[27] = true;
                MPLog.w(ViewVisitor.LOGTAG, "getAccessibilityDelegate threw an exception when called.", (Throwable)e);
                blArray[28] = true;
            }
            blArray[29] = true;
            return ret;
        }

        static /* synthetic */ int access$100(AddAccessibilityEventVisitor addAccessibilityEventVisitor) {
            AddAccessibilityEventVisitor x0;
            boolean[] blArray = AddAccessibilityEventVisitor.$jacocoInit();
            blArray[31] = true;
            return x0.mEventType;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)-4712240937825846811L, (String)"com/mixpanel/android/viewcrawler/ViewVisitor$AddAccessibilityEventVisitor", (int)32);
            }
            return blArray;
        }

        private class TrackingAccessibilityDelegate
        extends View.AccessibilityDelegate {
            private View.AccessibilityDelegate mRealDelegate;
            final /* synthetic */ AddAccessibilityEventVisitor this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;

            /*
             * WARNING - void declaration
             */
            public TrackingAccessibilityDelegate(AddAccessibilityEventVisitor addAccessibilityEventVisitor, View.AccessibilityDelegate accessibilityDelegate) {
                void realDelegate;
                boolean[] blArray = TrackingAccessibilityDelegate.$jacocoInit();
                this.this$0 = addAccessibilityEventVisitor;
                this.mRealDelegate = realDelegate;
                blArray[0] = true;
            }

            public View.AccessibilityDelegate getRealDelegate() {
                boolean[] blArray = TrackingAccessibilityDelegate.$jacocoInit();
                blArray[1] = true;
                return this.mRealDelegate;
            }

            /*
             * WARNING - void declaration
             */
            public boolean willFireEvent(String string) {
                void eventName;
                boolean[] blArray = TrackingAccessibilityDelegate.$jacocoInit();
                if (this.this$0.getEventName().equals(eventName)) {
                    blArray[2] = true;
                    return true;
                }
                if (this.mRealDelegate instanceof TrackingAccessibilityDelegate) {
                    blArray[3] = true;
                    blArray[4] = true;
                    return ((TrackingAccessibilityDelegate)this.mRealDelegate).willFireEvent((String)eventName);
                }
                blArray[5] = true;
                return false;
            }

            /*
             * WARNING - void declaration
             */
            public void removeFromDelegateChain(TrackingAccessibilityDelegate trackingAccessibilityDelegate) {
                void other;
                boolean[] blArray = TrackingAccessibilityDelegate.$jacocoInit();
                if (this.mRealDelegate == other) {
                    blArray[6] = true;
                    this.mRealDelegate = other.getRealDelegate();
                    blArray[7] = true;
                } else if (!(this.mRealDelegate instanceof TrackingAccessibilityDelegate)) {
                    blArray[8] = true;
                } else {
                    void child;
                    TrackingAccessibilityDelegate trackingAccessibilityDelegate2 = (TrackingAccessibilityDelegate)this.mRealDelegate;
                    blArray[9] = true;
                    child.removeFromDelegateChain((TrackingAccessibilityDelegate)other);
                    blArray[10] = true;
                }
                blArray[11] = true;
            }

            /*
             * WARNING - void declaration
             */
            public void sendAccessibilityEvent(View view, int n) {
                void host;
                void eventType;
                boolean[] blArray = TrackingAccessibilityDelegate.$jacocoInit();
                if (eventType != AddAccessibilityEventVisitor.access$100(this.this$0)) {
                    blArray[12] = true;
                } else {
                    blArray[13] = true;
                    this.this$0.fireEvent((View)host);
                    blArray[14] = true;
                }
                if (null == this.mRealDelegate) {
                    blArray[15] = true;
                } else {
                    blArray[16] = true;
                    this.mRealDelegate.sendAccessibilityEvent((View)host, (int)eventType);
                    blArray[17] = true;
                }
                blArray[18] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)5522447795369290599L, (String)"com/mixpanel/android/viewcrawler/ViewVisitor$AddAccessibilityEventVisitor$TrackingAccessibilityDelegate", (int)19);
                }
                return blArray;
            }
        }
    }

    public static class LayoutRule {
        public final int viewId;
        public final int verb;
        public final int anchor;
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        public LayoutRule(int n, int n2, int n3) {
            void a;
            void v;
            void vi;
            boolean[] blArray = LayoutRule.$jacocoInit();
            this.viewId = vi;
            this.verb = v;
            this.anchor = a;
            blArray[0] = true;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)-3177179798417286067L, (String)"com/mixpanel/android/viewcrawler/ViewVisitor$LayoutRule", (int)1);
            }
            return blArray;
        }
    }

    public static class LayoutUpdateVisitor
    extends ViewVisitor {
        private final WeakHashMap<View, int[]> mOriginalValues;
        private final List<LayoutRule> mArgs;
        private final String mName;
        private static final Set<Integer> mHorizontalRules;
        private static final Set<Integer> mVerticalRules;
        private boolean mAlive;
        private final OnLayoutErrorListener mOnLayoutErrorListener;
        private final CycleDetector mCycleDetector;
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        public LayoutUpdateVisitor(List<Pathfinder.PathElement> list, List<LayoutRule> list2, String string, OnLayoutErrorListener onLayoutErrorListener) {
            void onLayoutErrorListener2;
            void name;
            void args;
            void path;
            boolean[] blArray = LayoutUpdateVisitor.$jacocoInit();
            super((List<Pathfinder.PathElement>)path);
            blArray[0] = true;
            this.mOriginalValues = new WeakHashMap();
            this.mArgs = args;
            this.mName = name;
            this.mAlive = true;
            this.mOnLayoutErrorListener = onLayoutErrorListener2;
            blArray[1] = true;
            this.mCycleDetector = new CycleDetector(null);
            blArray[2] = true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void cleanup() {
            boolean[] blArray = LayoutUpdateVisitor.$jacocoInit();
            Iterator<Map.Entry<View, int[]>> iterator = this.mOriginalValues.entrySet().iterator();
            blArray[3] = true;
            while (iterator.hasNext()) {
                void originalValue;
                void i;
                void changedView;
                void original;
                Map.Entry<View, int[]> entry = iterator.next();
                blArray[4] = true;
                View view = (View)original.getKey();
                blArray[5] = true;
                int[] nArray = (int[])original.getValue();
                blArray[6] = true;
                RelativeLayout.LayoutParams originalParams = (RelativeLayout.LayoutParams)changedView.getLayoutParams();
                boolean bl = false;
                blArray[7] = true;
                while (i < ((void)originalValue).length) {
                    blArray[8] = true;
                    originalParams.addRule((int)i, (int)originalValue[i]);
                    ++i;
                    blArray[9] = true;
                }
                changedView.setLayoutParams((ViewGroup.LayoutParams)originalParams);
                blArray[10] = true;
            }
            this.mAlive = false;
            blArray[11] = true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visit(View view) {
            boolean[] blArray = LayoutUpdateVisitor.$jacocoInit();
            if (!this.mAlive) {
                blArray[12] = true;
            } else {
                void rootView;
                blArray[13] = true;
                this.getPathfinder().findTargetsInRoot((View)rootView, this.getPath(), this);
                blArray[14] = true;
            }
            blArray[15] = true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void accumulate(View view) {
            void i;
            void idToChild;
            void i2;
            void parent;
            void found;
            boolean[] blArray = LayoutUpdateVisitor.$jacocoInit();
            ViewGroup viewGroup = (ViewGroup)found;
            blArray[16] = true;
            SparseArray sparseArray = new SparseArray();
            blArray[17] = true;
            int count = parent.getChildCount();
            boolean bl = false;
            blArray[18] = true;
            while (i2 < count) {
                void child;
                blArray[19] = true;
                View view2 = parent.getChildAt((int)i2);
                blArray[20] = true;
                int childId = child.getId();
                if (childId <= 0) {
                    blArray[21] = true;
                } else {
                    blArray[22] = true;
                    idToChild.put(childId, (Object)child);
                    blArray[23] = true;
                }
                ++i2;
                blArray[24] = true;
            }
            int size = this.mArgs.size();
            boolean child = false;
            blArray[25] = true;
            while (i < size) {
                void layoutRule;
                blArray[26] = true;
                LayoutRule childId = this.mArgs.get((int)i);
                blArray[27] = true;
                View currentChild = (View)idToChild.get(layoutRule.viewId);
                if (null == currentChild) {
                    blArray[28] = true;
                } else {
                    void currentParams;
                    RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)currentChild.getLayoutParams();
                    blArray[29] = true;
                    int[] currentRules = (int[])currentParams.getRules().clone();
                    if (currentRules[layoutRule.verb] == layoutRule.anchor) {
                        blArray[30] = true;
                    } else {
                        Set<Integer> rules;
                        if (this.mOriginalValues.containsKey(currentChild)) {
                            blArray[31] = true;
                        } else {
                            this.mOriginalValues.put(currentChild, currentRules);
                            blArray[32] = true;
                        }
                        currentParams.addRule(layoutRule.verb, layoutRule.anchor);
                        blArray[33] = true;
                        if (mHorizontalRules.contains(layoutRule.verb)) {
                            rules = mHorizontalRules;
                            blArray[34] = true;
                        } else if (mVerticalRules.contains(layoutRule.verb)) {
                            rules = mVerticalRules;
                            blArray[35] = true;
                        } else {
                            rules = null;
                            blArray[36] = true;
                        }
                        if (rules == null) {
                            blArray[37] = true;
                        } else if (this.verifyLayout(rules, (SparseArray<View>)idToChild)) {
                            blArray[38] = true;
                        } else {
                            blArray[39] = true;
                            this.cleanup();
                            blArray[40] = true;
                            this.mOnLayoutErrorListener.onLayoutError(new LayoutErrorMessage("circular_dependency", this.mName));
                            blArray[41] = true;
                            return;
                        }
                        currentChild.setLayoutParams((ViewGroup.LayoutParams)currentParams);
                        blArray[42] = true;
                    }
                }
                ++i;
                blArray[43] = true;
            }
            blArray[44] = true;
        }

        /*
         * WARNING - void declaration
         */
        private boolean verifyLayout(Set<Integer> set, SparseArray<View> sparseArray) {
            void dependencyGraph;
            void i;
            void idToChild;
            boolean[] blArray = LayoutUpdateVisitor.$jacocoInit();
            TreeMap treeMap = new TreeMap(new Comparator<View>(this){
                final /* synthetic */ LayoutUpdateVisitor this$0;
                private static transient /* synthetic */ boolean[] $jacocoData;
                {
                    void this$0;
                    boolean[] blArray = 1.$jacocoInit();
                    this.this$0 = this$0;
                    blArray[0] = true;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public int compare(View view, View view2) {
                    void rhs;
                    void lhs;
                    boolean[] blArray = 1.$jacocoInit();
                    if (lhs == rhs) {
                        blArray[1] = true;
                        return 0;
                    }
                    if (null == lhs) {
                        blArray[2] = true;
                        return -1;
                    }
                    if (null == rhs) {
                        blArray[3] = true;
                        return 1;
                    }
                    blArray[4] = true;
                    return rhs.hashCode() - lhs.hashCode();
                }

                private static /* synthetic */ boolean[] $jacocoInit() {
                    boolean[] blArray = $jacocoData;
                    if ($jacocoData == null) {
                        blArray = $jacocoData = Offline.getProbes((long)-137476546486653534L, (String)"com/mixpanel/android/viewcrawler/ViewVisitor$LayoutUpdateVisitor$1", (int)6);
                    }
                    return blArray;
                }
            });
            blArray[45] = true;
            int size = idToChild.size();
            boolean bl = false;
            blArray[46] = true;
            while (i < size) {
                void dependencies;
                void rules;
                void childLayoutParams;
                void child;
                blArray[47] = true;
                View view = (View)idToChild.valueAt((int)i);
                blArray[48] = true;
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)child.getLayoutParams();
                blArray[49] = true;
                int[] nArray = childLayoutParams.getRules();
                blArray[50] = true;
                ArrayList arrayList = new ArrayList();
                blArray[51] = true;
                Iterator iterator = rules.iterator();
                blArray[52] = true;
                while (iterator.hasNext()) {
                    void dependencyId;
                    void layoutRules;
                    int rule = (Integer)iterator.next();
                    void var13_13 = layoutRules[rule];
                    blArray[53] = true;
                    if (dependencyId <= 0) {
                        blArray[54] = true;
                    } else if (dependencyId == child.getId()) {
                        blArray[55] = true;
                    } else {
                        blArray[56] = true;
                        dependencies.add(idToChild.get((int)dependencyId));
                        blArray[57] = true;
                    }
                    blArray[58] = true;
                }
                dependencyGraph.put(child, dependencies);
                ++i;
                blArray[59] = true;
            }
            blArray[60] = true;
            return this.mCycleDetector.hasCycle((TreeMap<View, List<View>>)dependencyGraph);
        }

        @Override
        protected String name() {
            boolean[] blArray = LayoutUpdateVisitor.$jacocoInit();
            blArray[61] = true;
            return "Layout Update";
        }

        static {
            boolean[] blArray = LayoutUpdateVisitor.$jacocoInit();
            Integer[] integerArray = new Integer[4];
            blArray[62] = true;
            integerArray[0] = 0;
            integerArray[1] = 1;
            blArray[63] = true;
            integerArray[2] = 5;
            integerArray[3] = 7;
            blArray[64] = true;
            mHorizontalRules = new HashSet<Integer>(Arrays.asList(integerArray));
            Integer[] integerArray2 = new Integer[5];
            blArray[65] = true;
            integerArray2[0] = 2;
            integerArray2[1] = 3;
            blArray[66] = true;
            integerArray2[2] = 4;
            integerArray2[3] = 6;
            blArray[67] = true;
            integerArray2[4] = 8;
            blArray[68] = true;
            mVerticalRules = new HashSet<Integer>(Arrays.asList(integerArray2));
            blArray[69] = true;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)1853295360930417071L, (String)"com/mixpanel/android/viewcrawler/ViewVisitor$LayoutUpdateVisitor", (int)70);
            }
            return blArray;
        }
    }

    private static class CycleDetector {
        private static transient /* synthetic */ boolean[] $jacocoData;

        private CycleDetector() {
            boolean[] blArray = CycleDetector.$jacocoInit();
            blArray[0] = true;
        }

        /*
         * WARNING - void declaration
         */
        public boolean hasCycle(TreeMap<View, List<View>> treeMap) {
            void dependencyGraph;
            boolean[] blArray = CycleDetector.$jacocoInit();
            ArrayList arrayList = new ArrayList();
            blArray[1] = true;
            while (!dependencyGraph.isEmpty()) {
                void dfsStack;
                void currentNode;
                blArray[2] = true;
                View view = (View)dependencyGraph.firstKey();
                blArray[3] = true;
                if (!this.detectSubgraphCycle((TreeMap<View, List<View>>)dependencyGraph, (View)currentNode, (List<View>)dfsStack)) {
                    blArray[4] = true;
                    return false;
                }
                blArray[5] = true;
            }
            blArray[6] = true;
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private boolean detectSubgraphCycle(TreeMap<View, List<View>> treeMap, View view, List<View> list) {
            void dependencyGraph;
            void currentNode;
            void dfsStack;
            boolean[] blArray = CycleDetector.$jacocoInit();
            if (dfsStack.contains(currentNode)) {
                blArray[7] = true;
                return false;
            }
            if (!dependencyGraph.containsKey(currentNode)) {
                blArray[8] = true;
            } else {
                void i;
                void dependencies;
                blArray[9] = true;
                List list2 = (List)dependencyGraph.remove(currentNode);
                blArray[10] = true;
                dfsStack.add(currentNode);
                blArray[11] = true;
                int size = dependencies.size();
                boolean bl = false;
                blArray[12] = true;
                while (i < size) {
                    blArray[13] = true;
                    if (!this.detectSubgraphCycle((TreeMap<View, List<View>>)dependencyGraph, (View)dependencies.get((int)i), (List<View>)dfsStack)) {
                        blArray[14] = true;
                        return false;
                    }
                    ++i;
                    blArray[15] = true;
                }
                dfsStack.remove(currentNode);
                blArray[16] = true;
            }
            blArray[17] = true;
            return true;
        }

        /* synthetic */ CycleDetector(1 var1_1) {
            boolean[] blArray = CycleDetector.$jacocoInit();
            this();
            blArray[18] = true;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)2764622419091550710L, (String)"com/mixpanel/android/viewcrawler/ViewVisitor$CycleDetector", (int)19);
            }
            return blArray;
        }
    }

    public static class PropertySetVisitor
    extends ViewVisitor {
        private final Caller mMutator;
        private final Caller mAccessor;
        private final WeakHashMap<View, Object> mOriginalValues;
        private final Object[] mOriginalValueHolder;
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        public PropertySetVisitor(List<Pathfinder.PathElement> list, Caller caller, Caller caller2) {
            void accessor;
            void mutator;
            void path;
            boolean[] blArray = PropertySetVisitor.$jacocoInit();
            super((List<Pathfinder.PathElement>)path);
            this.mMutator = mutator;
            this.mAccessor = accessor;
            this.mOriginalValueHolder = new Object[1];
            blArray[0] = true;
            this.mOriginalValues = new WeakHashMap();
            blArray[1] = true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void cleanup() {
            boolean[] blArray = PropertySetVisitor.$jacocoInit();
            Iterator<Map.Entry<View, Object>> iterator = this.mOriginalValues.entrySet().iterator();
            blArray[2] = true;
            while (iterator.hasNext()) {
                void original;
                Map.Entry<View, Object> entry = iterator.next();
                blArray[3] = true;
                View view = (View)original.getKey();
                blArray[4] = true;
                Object originalValue = original.getValue();
                if (null == originalValue) {
                    blArray[5] = true;
                } else {
                    void changedView;
                    this.mOriginalValueHolder[0] = originalValue;
                    blArray[6] = true;
                    this.mMutator.applyMethodWithArguments((View)changedView, this.mOriginalValueHolder);
                    blArray[7] = true;
                }
                blArray[8] = true;
            }
            blArray[9] = true;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void accumulate(View var1_1) {
            block19: {
                block22: {
                    block26: {
                        block24: {
                            block25: {
                                block23: {
                                    block21: {
                                        block20: {
                                            block18: {
                                                var2_2 = PropertySetVisitor.$jacocoInit();
                                                if (null != this.mAccessor) break block18;
                                                var2_2[10] = true;
                                                break block19;
                                            }
                                            var2_2[11] = true;
                                            setArgs = this.mMutator.getArgs();
                                            if (1 == setArgs.length) break block20;
                                            var2_2[12] = true;
                                            break block19;
                                        }
                                        var4_4 = setArgs[0];
                                        var2_2[13] = true;
                                        currentValue = this.mAccessor.applyMethod((View)found);
                                        if (desiredValue == currentValue) {
                                            var2_2[14] = true;
                                            return;
                                        }
                                        if (null != desiredValue) break block21;
                                        var2_2[15] = true;
                                        break block22;
                                    }
                                    if (desiredValue instanceof Bitmap) break block23;
                                    var2_2[16] = true;
                                    break block24;
                                }
                                if (!(currentValue instanceof Bitmap)) break block25;
                                desiredBitmap = (Bitmap)desiredValue;
                                var7_8 = (Bitmap)currentValue;
                                var2_2[18] = true;
                                if (desiredBitmap.sameAs((Bitmap)currentBitmap)) {
                                    var2_2[19] = true;
                                    return;
                                }
                                var2_2[20] = true;
                                break block22;
                            }
                            var2_2[17] = true;
                        }
                        if (desiredValue instanceof BitmapDrawable) break block26;
                        var2_2[21] = true;
                        ** GOTO lbl59
                    }
                    if (currentValue instanceof BitmapDrawable) {
                        var2_2[23] = true;
                        desiredBitmap = ((BitmapDrawable)desiredValue).getBitmap();
                        var2_2[24] = true;
                        currentBitmap = ((BitmapDrawable)currentValue).getBitmap();
                        var2_2[25] = true;
                        if (desiredBitmap == null) {
                            var2_2[26] = true;
                        } else if (!desiredBitmap.sameAs(currentBitmap)) {
                            var2_2[27] = true;
                        } else {
                            var2_2[28] = true;
                            return;
                        }
                        var2_2[29] = true;
                    } else {
                        var2_2[22] = true;
lbl59:
                        // 2 sources

                        if (!desiredValue.equals(currentValue)) {
                            var2_2[30] = true;
                        } else {
                            var2_2[31] = true;
                            return;
                        }
                    }
                }
                if (currentValue instanceof Bitmap) {
                    var2_2[32] = true;
                } else if (currentValue instanceof BitmapDrawable) {
                    var2_2[33] = true;
                } else {
                    var2_2[34] = true;
                    if (this.mOriginalValues.containsKey(found)) {
                        var2_2[35] = true;
                    } else {
                        this.mOriginalValueHolder[0] = currentValue;
                        var2_2[36] = true;
                        if (this.mMutator.argsAreApplicable(this.mOriginalValueHolder)) {
                            var2_2[37] = true;
                            this.mOriginalValues.put((View)found, currentValue);
                            var2_2[38] = true;
                        } else {
                            this.mOriginalValues.put((View)found, null);
                            var2_2[39] = true;
                        }
                    }
                }
            }
            this.mMutator.applyMethod((View)found);
            var2_2[40] = true;
        }

        @Override
        protected String name() {
            boolean[] blArray = PropertySetVisitor.$jacocoInit();
            blArray[41] = true;
            return "Property Mutator";
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)-1171834043099475145L, (String)"com/mixpanel/android/viewcrawler/ViewVisitor$PropertySetVisitor", (int)43);
            }
            return blArray;
        }
    }

    public static class LayoutErrorMessage {
        private final String mErrorType;
        private final String mName;
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        public LayoutErrorMessage(String string, String string2) {
            void name;
            void errorType;
            boolean[] blArray = LayoutErrorMessage.$jacocoInit();
            this.mErrorType = errorType;
            this.mName = name;
            blArray[0] = true;
        }

        public String getErrorType() {
            boolean[] blArray = LayoutErrorMessage.$jacocoInit();
            blArray[1] = true;
            return this.mErrorType;
        }

        public String getName() {
            boolean[] blArray = LayoutErrorMessage.$jacocoInit();
            blArray[2] = true;
            return this.mName;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)1507602786880724020L, (String)"com/mixpanel/android/viewcrawler/ViewVisitor$LayoutErrorMessage", (int)3);
            }
            return blArray;
        }
    }

    public static interface OnLayoutErrorListener {
        public void onLayoutError(LayoutErrorMessage var1);
    }

    public static interface OnEventListener {
        public void OnEvent(View var1, String var2, boolean var3);
    }
}

