/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Base64;
import android.util.LruCache;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.util.HttpService;
import com.mixpanel.android.util.MPLog;
import com.mixpanel.android.util.RemoteService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLSocketFactory;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;

public class ImageStore {
    private final File mDirectory;
    private final RemoteService mPoster;
    private final MessageDigest mDigest;
    private final MPConfig mConfig;
    private static LruCache<String, Bitmap> sMemoryCache;
    private static final String DEFAULT_DIRECTORY_PREFIX = "MixpanelAPI.Images.";
    private static final int MAX_BITMAP_SIZE = 10000000;
    private static final String FILE_PREFIX = "MP_IMG_";
    private static final String LOGTAG = "MixpanelAPI.ImageStore";
    private static transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - void declaration
     */
    public ImageStore(Context context, String string) {
        void moduleName;
        void context2;
        boolean[] blArray = ImageStore.$jacocoInit();
        this((Context)context2, DEFAULT_DIRECTORY_PREFIX + (String)moduleName, new HttpService());
        blArray[0] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ImageStore(Context context, String string, RemoteService remoteService) {
        MessageDigest useDigest;
        void poster;
        void directoryName;
        void context2;
        boolean[] blArray = ImageStore.$jacocoInit();
        blArray[1] = true;
        this.mDirectory = context2.getDir((String)directoryName, 0);
        this.mPoster = poster;
        blArray[2] = true;
        this.mConfig = MPConfig.getInstance((Context)context2);
        try {
            blArray[3] = true;
            useDigest = MessageDigest.getInstance("SHA1");
            blArray[4] = true;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            blArray[5] = true;
            MPLog.w(LOGTAG, "Images won't be stored because this platform doesn't supply a SHA1 hash function");
            useDigest = null;
            blArray[6] = true;
        }
        this.mDigest = useDigest;
        if (sMemoryCache != null) {
            blArray[7] = true;
        } else {
            Class<ImageStore> clazz = ImageStore.class;
            // MONITORENTER : com.mixpanel.android.util.ImageStore.class
            try {
                blArray[8] = true;
                if (sMemoryCache != null) {
                    blArray[9] = true;
                } else {
                    void cacheSize;
                    void maxMemory;
                    blArray[10] = true;
                    int n = (int)(Runtime.getRuntime().maxMemory() / 1024L);
                    blArray[11] = true;
                    void var8_9 = maxMemory / this.mConfig.getImageCacheMaxMemoryFactor();
                    blArray[12] = true;
                    sMemoryCache = new LruCache<String, Bitmap>(this, (int)cacheSize){
                        final /* synthetic */ ImageStore this$0;
                        private static transient /* synthetic */ boolean[] $jacocoData;
                        {
                            void arg0;
                            void this$0;
                            boolean[] blArray = 1.$jacocoInit();
                            this.this$0 = this$0;
                            super((int)arg0);
                            blArray[0] = true;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        protected int sizeOf(String string, Bitmap bitmap) {
                            void bitmap2;
                            boolean[] blArray = 1.$jacocoInit();
                            blArray[1] = true;
                            return bitmap2.getRowBytes() * bitmap2.getHeight() / 1024;
                        }

                        private static /* synthetic */ boolean[] $jacocoInit() {
                            boolean[] blArray = $jacocoData;
                            if ($jacocoData == null) {
                                blArray = $jacocoData = Offline.getProbes((long)3844611644421457713L, (String)"com/mixpanel/android/util/ImageStore$1", (int)3);
                            }
                            return blArray;
                        }
                    };
                    blArray[13] = true;
                }
                // MONITOREXIT : clazz
                blArray[14] = true;
            }
            catch (Throwable throwable) {
                // MONITOREXIT : clazz
                blArray[15] = true;
                throw throwable;
            }
        }
        blArray[16] = true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File getImageFile(String var1_1) throws CantGetImageException {
        block23: {
            block24: {
                var2_2 = ImageStore.$jacocoInit();
                file = this.storedFile((String)url);
                var4_4 = null;
                var2_2[17] = true;
                if (file != null) break block24;
                var2_2[18] = true;
                ** GOTO lbl14
            }
            if (file.exists()) {
                var2_2[19] = true;
            } else {
                try {
                    var2_2[20] = true;
lbl14:
                    // 2 sources

                    var5_5 = this.mConfig.getSSLSocketFactory();
                    var2_2[21] = true;
                    bytes = this.mPoster.performRequest((String)url, null, (SSLSocketFactory)factory);
                }
                catch (IOException factory) {
                    var2_2[22] = true;
                    var2_2[23] = true;
                    throw new CantGetImageException("Can't download bitmap", (Throwable)e);
                }
                catch (RemoteService.ServiceUnavailableException e) {
                    var2_2[24] = true;
                    var2_2[25] = true;
                    throw new CantGetImageException("Couldn't download image due to service availability", e);
                }
                if (null == bytes) {
                    var2_2[26] = true;
                } else if (null == file) {
                    var2_2[27] = true;
                } else if (bytes.length >= 10000000) {
                    var2_2[28] = true;
                } else {
                    block22: {
                        e = null;
                        try {
                            var2_2[29] = true;
                            out = new FileOutputStream(file);
                            var2_2[30] = true;
                            out.write(bytes);
                            if (null != out) break block22;
                            var2_2[31] = true;
                            break block23;
                        }
                        catch (FileNotFoundException e) {
                            try {
                                var2_2[36] = true;
                                var2_2[37] = true;
                                throw new CantGetImageException("It appears that ImageStore is misconfigured, or disk storage is unavailable- can't write to bitmap directory", e);
                                catch (IOException e) {
                                    var2_2[38] = true;
                                    var2_2[39] = true;
                                    throw new CantGetImageException("Can't store bitmap", e);
                                }
                            }
                            catch (Throwable var7_11) {
                                if (null == out) {
                                    var2_2[40] = true;
                                } else {
                                    try {
                                        var2_2[41] = true;
                                        out.close();
                                        var2_2[42] = true;
                                    }
                                    catch (IOException var8_12) {
                                        var2_2[43] = true;
                                        MPLog.w("MixpanelAPI.ImageStore", "Problem closing output file", (Throwable)e);
                                        var2_2[44] = true;
                                    }
                                }
                                var2_2[45] = true;
                                throw var7_11;
                            }
                        }
                    }
                    try {
                        var2_2[32] = true;
                        out.close();
                        var2_2[33] = true;
                    }
                    catch (IOException var6_8) {
                        var2_2[34] = true;
                        MPLog.w("MixpanelAPI.ImageStore", "Problem closing output file", (Throwable)e);
                        var2_2[35] = true;
                    }
                }
            }
        }
        var2_2[46] = true;
        return file;
    }

    /*
     * WARNING - void declaration
     */
    public Bitmap getImage(String string) throws CantGetImageException {
        void url;
        boolean[] blArray = ImageStore.$jacocoInit();
        Bitmap cachedBitmap = ImageStore.getBitmapFromMemCache((String)url);
        if (cachedBitmap != null) {
            blArray[47] = true;
        } else {
            void imageFile;
            blArray[48] = true;
            File file = this.getImageFile((String)url);
            blArray[49] = true;
            cachedBitmap = ImageStore.decodeImage((File)imageFile);
            blArray[50] = true;
            ImageStore.addBitmapToMemoryCache((String)url, cachedBitmap);
            blArray[51] = true;
        }
        blArray[52] = true;
        return cachedBitmap;
    }

    /*
     * WARNING - void declaration
     */
    private static Bitmap decodeImage(File file) throws CantGetImageException {
        void imageSize;
        File file2;
        boolean[] blArray = ImageStore.$jacocoInit();
        BitmapFactory.Options option = new BitmapFactory.Options();
        option.inJustDecodeBounds = true;
        blArray[53] = true;
        BitmapFactory.decodeFile((String)file2.getAbsolutePath(), (BitmapFactory.Options)option);
        float f = (float)option.outHeight * (float)option.outWidth * 4.0f;
        blArray[54] = true;
        if (imageSize > ImageStore.getAvailableMemory()) {
            blArray[55] = true;
            blArray[56] = true;
            throw new CantGetImageException("Do not have enough memory for the image");
        }
        Bitmap bitmap = BitmapFactory.decodeFile((String)file2.getAbsolutePath());
        if (null == bitmap) {
            blArray[57] = true;
            boolean bl = file2.delete();
            blArray[58] = true;
            blArray[59] = true;
            throw new CantGetImageException("Bitmap on disk can't be opened or was corrupt");
        }
        blArray[60] = true;
        return bitmap;
    }

    /*
     * WARNING - void declaration
     */
    private static float getAvailableMemory() {
        void used;
        void runtime;
        boolean[] blArray = ImageStore.$jacocoInit();
        Runtime runtime2 = Runtime.getRuntime();
        blArray[61] = true;
        float f = runtime.totalMemory() - runtime.freeMemory();
        blArray[62] = true;
        blArray[63] = true;
        return (float)runtime.maxMemory() - used;
    }

    /*
     * WARNING - void declaration
     */
    public void clearStorage() {
        void i;
        boolean[] blArray = ImageStore.$jacocoInit();
        File[] files = this.mDirectory.listFiles();
        int length = files.length;
        boolean bl = false;
        blArray[64] = true;
        while (i < length) {
            void filename;
            void file;
            File file2 = files[i];
            blArray[65] = true;
            String string = file.getName();
            blArray[66] = true;
            if (!filename.startsWith(FILE_PREFIX)) {
                blArray[67] = true;
            } else {
                blArray[68] = true;
                boolean bl2 = file.delete();
                blArray[69] = true;
            }
            ++i;
            blArray[70] = true;
        }
        ImageStore.clearMemCache();
        blArray[71] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void deleteStorage(String string) {
        void url;
        boolean[] blArray = ImageStore.$jacocoInit();
        File file = this.storedFile((String)url);
        if (null == file) {
            blArray[72] = true;
        } else {
            blArray[73] = true;
            boolean bl = file.delete();
            blArray[74] = true;
            ImageStore.removeBitmapFromMemCache((String)url);
            blArray[75] = true;
        }
        blArray[76] = true;
    }

    /*
     * WARNING - void declaration
     */
    private File storedFile(String string) {
        void safeName;
        void hashed;
        void url;
        boolean[] blArray = ImageStore.$jacocoInit();
        if (null == this.mDigest) {
            blArray[77] = true;
            return null;
        }
        byte[] byArray = this.mDigest.digest(url.getBytes());
        blArray[78] = true;
        String string2 = FILE_PREFIX + Base64.encodeToString((byte[])hashed, (int)10);
        blArray[79] = true;
        blArray[80] = true;
        return new File(this.mDirectory, (String)safeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void addBitmapToMemoryCache(String string, Bitmap bitmap) {
        String key;
        boolean[] blArray = ImageStore.$jacocoInit();
        if (ImageStore.getBitmapFromMemCache(key) != null) {
            blArray[81] = true;
        } else {
            LruCache<String, Bitmap> lruCache = sMemoryCache;
            synchronized (lruCache) {
                try {
                    void bitmap2;
                    blArray[82] = true;
                    sMemoryCache.put((Object)key, (Object)bitmap2);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
                    blArray[83] = true;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2, 3] lbl15 : MonitorExitStatement: MONITOREXIT : var3_3
                    blArray[84] = true;
                    throw throwable;
                }
            }
        }
        blArray[85] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getBitmapFromMemCache(String string) {
        boolean[] blArray = ImageStore.$jacocoInit();
        LruCache<String, Bitmap> lruCache = sMemoryCache;
        synchronized (lruCache) {
            try {
                String key;
                blArray[86] = true;
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
                blArray[87] = true;
                return (Bitmap)sMemoryCache.get((Object)key);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                blArray[88] = true;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeBitmapFromMemCache(String string) {
        boolean[] blArray = ImageStore.$jacocoInit();
        LruCache<String, Bitmap> lruCache = sMemoryCache;
        synchronized (lruCache) {
            try {
                String key;
                blArray[89] = true;
                sMemoryCache.remove((Object)key);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                blArray[90] = true;
                throw throwable;
            }
        }
        blArray[91] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearMemCache() {
        boolean[] blArray = ImageStore.$jacocoInit();
        LruCache<String, Bitmap> lruCache = sMemoryCache;
        synchronized (lruCache) {
            try {
                blArray[92] = true;
                sMemoryCache.evictAll();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                blArray[93] = true;
                throw throwable;
            }
        }
        blArray[94] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)5719652480881017728L, (String)"com/mixpanel/android/util/ImageStore", (int)95);
        }
        return blArray;
    }

    public static class CantGetImageException
    extends Exception {
        private static transient /* synthetic */ boolean[] $jacocoData;

        /*
         * WARNING - void declaration
         */
        public CantGetImageException(String string) {
            void message;
            boolean[] blArray = CantGetImageException.$jacocoInit();
            super((String)message);
            blArray[0] = true;
        }

        /*
         * WARNING - void declaration
         */
        public CantGetImageException(String string, Throwable throwable) {
            void cause;
            void message;
            boolean[] blArray = CantGetImageException.$jacocoInit();
            super((String)message, (Throwable)cause);
            blArray[1] = true;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)6731001981486835494L, (String)"com/mixpanel/android/util/ImageStore$CantGetImageException", (int)2);
            }
            return blArray;
        }
    }
}

