/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.mixpanel.android.mpmetrics.SystemInformation;
import com.mixpanel.android.util.MPLog;
import com.mixpanel.android.util.OfflineMode;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public class MPConfig {
    public static final String VERSION = "5.8.5";
    public static boolean DEBUG = false;
    public static final int UI_FEATURES_MIN_API = 16;
    static final String REFERRER_PREFS_NAME = "com.mixpanel.android.mpmetrics.ReferralInfo";
    static final int MAX_NOTIFICATION_CACHE_COUNT = 2;
    static final int MAX_EVENT_TRIGGERED_NOTIFICATION_CACHE_COUNT = 2;
    private final int mBulkUploadLimit;
    private final int mFlushInterval;
    private final boolean mFlushOnBackground;
    private final long mDataExpiration;
    private final int mMinimumDatabaseLimit;
    private final boolean mTestMode;
    private final boolean mDisableGestureBindingUI;
    private final boolean mDisableEmulatorBindingUI;
    private final boolean mDisableAppOpenEvent;
    private final boolean mDisableViewCrawler;
    private final boolean mDisableExceptionHandler;
    private final String[] mDisableViewCrawlerForProjects;
    private String mEventsEndpoint;
    private String mPeopleEndpoint;
    private String mGroupsEndpoint;
    private String mDecideEndpoint;
    private final boolean mAutoShowMixpanelUpdates;
    private final String mEditorUrl;
    private final String mResourcePackageName;
    private final boolean mDisableDecideChecker;
    private final int mImageCacheMaxMemoryFactor;
    private final boolean mIgnoreInvisibleViewsEditor;
    private final int mNotificationDefaults;
    private final int mMinSessionDuration;
    private final int mSessionTimeoutDuration;
    private final boolean mUseIpAddressForGeolocation;
    private final int mNotificationChannelImportance;
    private final String mNotificationChannelId;
    private final String mNotificationChannelName;
    private SSLSocketFactory mSSLSocketFactory;
    private OfflineMode mOfflineMode;
    private static MPConfig sInstance;
    private static final Object sInstanceLock;
    private static final String LOGTAG = "MixpanelAPI.Conf";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MPConfig getInstance(Context context) {
        Object object = sInstanceLock;
        synchronized (object) {
            if (null == sInstance) {
                Context appContext = context.getApplicationContext();
                sInstance = MPConfig.readConfig(appContext);
            }
        }
        return sInstance;
    }

    public synchronized void setSSLSocketFactory(SSLSocketFactory factory) {
        this.mSSLSocketFactory = factory;
    }

    public synchronized void setOfflineMode(OfflineMode offlineMode) {
        this.mOfflineMode = offlineMode;
    }

    MPConfig(Bundle metaData, Context context) {
        long dataExpirationLong;
        block20: {
            SSLSocketFactory foundSSLFactory;
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, null, null);
                foundSSLFactory = sslContext.getSocketFactory();
            }
            catch (GeneralSecurityException e) {
                MPLog.i(LOGTAG, "System has no SSL support. Built-in events editor will not be available", e);
                foundSSLFactory = null;
            }
            this.mSSLSocketFactory = foundSSLFactory;
            DEBUG = metaData.getBoolean("com.mixpanel.android.MPConfig.EnableDebugLogging", false);
            if (DEBUG) {
                MPLog.setLevel(2);
            }
            if (metaData.containsKey("com.mixpanel.android.MPConfig.DebugFlushInterval")) {
                MPLog.w(LOGTAG, "We do not support com.mixpanel.android.MPConfig.DebugFlushInterval anymore. There will only be one flush interval. Please, update your AndroidManifest.xml.");
            }
            this.mBulkUploadLimit = metaData.getInt("com.mixpanel.android.MPConfig.BulkUploadLimit", 40);
            this.mFlushInterval = metaData.getInt("com.mixpanel.android.MPConfig.FlushInterval", 60000);
            this.mFlushOnBackground = metaData.getBoolean("com.mixpanel.android.MPConfig.FlushOnBackground", true);
            this.mMinimumDatabaseLimit = metaData.getInt("com.mixpanel.android.MPConfig.MinimumDatabaseLimit", 0x1400000);
            this.mResourcePackageName = metaData.getString("com.mixpanel.android.MPConfig.ResourcePackageName");
            this.mDisableGestureBindingUI = metaData.getBoolean("com.mixpanel.android.MPConfig.DisableGestureBindingUI", false);
            this.mDisableEmulatorBindingUI = metaData.getBoolean("com.mixpanel.android.MPConfig.DisableEmulatorBindingUI", false);
            this.mDisableAppOpenEvent = metaData.getBoolean("com.mixpanel.android.MPConfig.DisableAppOpenEvent", true);
            this.mDisableViewCrawler = metaData.getBoolean("com.mixpanel.android.MPConfig.DisableViewCrawler", false);
            this.mDisableDecideChecker = metaData.getBoolean("com.mixpanel.android.MPConfig.DisableDecideChecker", false);
            this.mDisableExceptionHandler = metaData.getBoolean("com.mixpanel.android.MPConfig.DisableExceptionHandler", false);
            this.mImageCacheMaxMemoryFactor = metaData.getInt("com.mixpanel.android.MPConfig.ImageCacheMaxMemoryFactor", 10);
            this.mIgnoreInvisibleViewsEditor = metaData.getBoolean("com.mixpanel.android.MPConfig.IgnoreInvisibleViewsVisualEditor", false);
            this.mAutoShowMixpanelUpdates = metaData.getBoolean("com.mixpanel.android.MPConfig.AutoShowMixpanelUpdates", true);
            this.mNotificationDefaults = metaData.getInt("com.mixpanel.android.MPConfig.NotificationDefaults", 0);
            this.mMinSessionDuration = metaData.getInt("com.mixpanel.android.MPConfig.MinimumSessionDuration", 10000);
            this.mSessionTimeoutDuration = metaData.getInt("com.mixpanel.android.MPConfig.SessionTimeoutDuration", Integer.MAX_VALUE);
            this.mUseIpAddressForGeolocation = metaData.getBoolean("com.mixpanel.android.MPConfig.UseIpAddressForGeolocation", true);
            this.mTestMode = metaData.getBoolean("com.mixpanel.android.MPConfig.TestMode", false);
            this.mNotificationChannelImportance = metaData.getInt("com.mixpanel.android.MPConfig.NotificationChannelImportance", 3);
            Object dataExpirationMetaData = metaData.get("com.mixpanel.android.MPConfig.DataExpiration");
            dataExpirationLong = 432000000L;
            if (dataExpirationMetaData != null) {
                try {
                    if (dataExpirationMetaData instanceof Integer) {
                        dataExpirationLong = ((Integer)dataExpirationMetaData).intValue();
                        break block20;
                    }
                    if (dataExpirationMetaData instanceof Float) {
                        dataExpirationLong = (long)((Float)dataExpirationMetaData).floatValue();
                        break block20;
                    }
                    throw new NumberFormatException(dataExpirationMetaData.toString() + " is not a number.");
                }
                catch (Exception e) {
                    MPLog.e(LOGTAG, "Error parsing com.mixpanel.android.MPConfig.DataExpiration meta-data value", e);
                }
            }
        }
        this.mDataExpiration = dataExpirationLong;
        String notificationChannelId = metaData.getString("com.mixpanel.android.MPConfig.NotificationChannelId");
        if (notificationChannelId == null) {
            notificationChannelId = "mp";
        }
        this.mNotificationChannelId = notificationChannelId;
        String notificationChannelName = metaData.getString("com.mixpanel.android.MPConfig.NotificationChannelName");
        if (notificationChannelName == null) {
            notificationChannelName = SystemInformation.getInstance(context).getAppName();
        }
        this.mNotificationChannelName = notificationChannelName;
        String eventsEndpoint = metaData.getString("com.mixpanel.android.MPConfig.EventsEndpoint");
        if (eventsEndpoint != null) {
            this.setEventsEndpoint(eventsEndpoint);
        } else {
            this.setMixpanelEventsEndpoint();
        }
        String peopleEndpoint = metaData.getString("com.mixpanel.android.MPConfig.PeopleEndpoint");
        if (peopleEndpoint != null) {
            this.setPeopleEndpoint(peopleEndpoint);
        } else {
            this.setMixpanelPeopleEndpoint();
        }
        String groupsEndpoint = metaData.getString("com.mixpanel.android.MPConfig.GroupsEndpoint");
        if (groupsEndpoint != null) {
            this.setGroupsEndpoint(groupsEndpoint);
        } else {
            this.setMixpanelGroupsEndpoint();
        }
        String decideEndpoint = metaData.getString("com.mixpanel.android.MPConfig.DecideEndpoint");
        if (decideEndpoint != null) {
            this.setDecideEndpoint(decideEndpoint);
        } else {
            this.setMixpanelDecideEndpoint();
        }
        String editorUrl = metaData.getString("com.mixpanel.android.MPConfig.EditorUrl");
        if (null == editorUrl) {
            editorUrl = "wss://switchboard.mixpanel.com/connect/";
        }
        this.mEditorUrl = editorUrl;
        int resourceId = metaData.getInt("com.mixpanel.android.MPConfig.DisableViewCrawlerForProjects", -1);
        this.mDisableViewCrawlerForProjects = resourceId != -1 ? context.getResources().getStringArray(resourceId) : new String[0];
        MPLog.v(LOGTAG, this.toString());
    }

    public int getBulkUploadLimit() {
        return this.mBulkUploadLimit;
    }

    public int getFlushInterval() {
        return this.mFlushInterval;
    }

    public boolean getFlushOnBackground() {
        return this.mFlushOnBackground;
    }

    public long getDataExpiration() {
        return this.mDataExpiration;
    }

    public int getMinimumDatabaseLimit() {
        return this.mMinimumDatabaseLimit;
    }

    public boolean getDisableGestureBindingUI() {
        return this.mDisableGestureBindingUI;
    }

    public boolean getDisableEmulatorBindingUI() {
        return this.mDisableEmulatorBindingUI;
    }

    public boolean getDisableAppOpenEvent() {
        return this.mDisableAppOpenEvent;
    }

    public boolean getDisableViewCrawler() {
        return this.mDisableViewCrawler;
    }

    public String[] getDisableViewCrawlerForProjects() {
        return this.mDisableViewCrawlerForProjects;
    }

    public boolean getTestMode() {
        return this.mTestMode;
    }

    public String getEventsEndpoint() {
        return this.mEventsEndpoint;
    }

    public void setMixpanelEventsEndpoint() {
        this.setEventsEndpoint("https://api.mixpanel.com/track?ip=" + (this.getUseIpAddressForGeolocation() ? "1" : "0"));
    }

    public void setEventsEndpoint(String eventsEndpoint) {
        this.mEventsEndpoint = eventsEndpoint;
    }

    public String getPeopleEndpoint() {
        return this.mPeopleEndpoint;
    }

    public void setMixpanelPeopleEndpoint() {
        this.setPeopleEndpoint("https://api.mixpanel.com/engage?ip=" + (this.getUseIpAddressForGeolocation() ? "1" : "0"));
    }

    public void setPeopleEndpoint(String peopleEndpoint) {
        this.mPeopleEndpoint = peopleEndpoint;
    }

    public String getGroupsEndpoint() {
        return this.mGroupsEndpoint;
    }

    public void setMixpanelGroupsEndpoint() {
        this.setGroupsEndpoint("https://api.mixpanel.com/groups");
    }

    public void setGroupsEndpoint(String groupsEndpoint) {
        this.mGroupsEndpoint = groupsEndpoint;
    }

    public String getDecideEndpoint() {
        return this.mDecideEndpoint;
    }

    public void setMixpanelDecideEndpoint() {
        this.setDecideEndpoint("https://decide.mixpanel.com/decide");
    }

    public void setDecideEndpoint(String decideEndpoint) {
        this.mDecideEndpoint = decideEndpoint;
    }

    public boolean getAutoShowMixpanelUpdates() {
        return this.mAutoShowMixpanelUpdates;
    }

    public String getEditorUrl() {
        return this.mEditorUrl;
    }

    public boolean getDisableDecideChecker() {
        return this.mDisableDecideChecker;
    }

    public boolean getIgnoreInvisibleViewsEditor() {
        return this.mIgnoreInvisibleViewsEditor;
    }

    public int getNotificationDefaults() {
        return this.mNotificationDefaults;
    }

    public int getMinimumSessionDuration() {
        return this.mMinSessionDuration;
    }

    public int getSessionTimeoutDuration() {
        return this.mSessionTimeoutDuration;
    }

    public boolean getDisableExceptionHandler() {
        return this.mDisableExceptionHandler;
    }

    public String getNotificationChannelId() {
        return this.mNotificationChannelId;
    }

    public String getNotificationChannelName() {
        return this.mNotificationChannelName;
    }

    public int getNotificationChannelImportance() {
        return this.mNotificationChannelImportance;
    }

    public boolean getUseIpAddressForGeolocation() {
        return this.mUseIpAddressForGeolocation;
    }

    public String getResourcePackageName() {
        return this.mResourcePackageName;
    }

    public synchronized SSLSocketFactory getSSLSocketFactory() {
        return this.mSSLSocketFactory;
    }

    public synchronized OfflineMode getOfflineMode() {
        return this.mOfflineMode;
    }

    public int getImageCacheMaxMemoryFactor() {
        return this.mImageCacheMaxMemoryFactor;
    }

    static MPConfig readConfig(Context appContext) {
        String packageName = appContext.getPackageName();
        try {
            ApplicationInfo appInfo = appContext.getPackageManager().getApplicationInfo(packageName, 128);
            Bundle configBundle = appInfo.metaData;
            if (null == configBundle) {
                configBundle = new Bundle();
            }
            return new MPConfig(configBundle, appContext);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Can't configure Mixpanel with package name " + packageName, e);
        }
    }

    public String toString() {
        return "Mixpanel (5.8.5) configured with:\n    AutoShowMixpanelUpdates " + this.getAutoShowMixpanelUpdates() + "\n    BulkUploadLimit " + this.getBulkUploadLimit() + "\n    FlushInterval " + this.getFlushInterval() + "\n    DataExpiration " + this.getDataExpiration() + "\n    MinimumDatabaseLimit " + this.getMinimumDatabaseLimit() + "\n    DisableAppOpenEvent " + this.getDisableAppOpenEvent() + "\n    DisableViewCrawler " + this.getDisableViewCrawler() + "\n    DisableGestureBindingUI " + this.getDisableGestureBindingUI() + "\n    DisableEmulatorBindingUI " + this.getDisableEmulatorBindingUI() + "\n    EnableDebugLogging " + DEBUG + "\n    TestMode " + this.getTestMode() + "\n    EventsEndpoint " + this.getEventsEndpoint() + "\n    PeopleEndpoint " + this.getPeopleEndpoint() + "\n    DecideEndpoint " + this.getDecideEndpoint() + "\n    EditorUrl " + this.getEditorUrl() + "\n    ImageCacheMaxMemoryFactor " + this.getImageCacheMaxMemoryFactor() + "\n    DisableDecideChecker " + this.getDisableDecideChecker() + "\n    IgnoreInvisibleViewsEditor " + this.getIgnoreInvisibleViewsEditor() + "\n    NotificationDefaults " + this.getNotificationDefaults() + "\n    MinimumSessionDuration: " + this.getMinimumSessionDuration() + "\n    SessionTimeoutDuration: " + this.getSessionTimeoutDuration() + "\n    DisableExceptionHandler: " + this.getDisableExceptionHandler() + "\n    NotificationChannelId: " + this.getNotificationChannelId() + "\n    NotificationChannelName: " + this.getNotificationChannelName() + "\n    NotificationChannelImportance: " + this.getNotificationChannelImportance() + "\n    FlushOnBackground: " + this.getFlushOnBackground();
    }

    static {
        sInstanceLock = new Object();
    }
}

