/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.content.Context;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.android.installreferrer.api.ReferrerDetails;
import com.mixpanel.android.mpmetrics.PersistentIdentity;
import com.mixpanel.android.util.MPLog;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class InstallReferrerPlay
implements InstallReferrerStateListener {
    private static String TAG = "MixpanelAPI.InstallReferrerPlay";
    private static final int MAX_INSTALL_REFERRER_RETRIES = 5;
    private static final int TIME_MS_BETWEEN_RETRIES = 2500;
    protected static final Pattern UTM_SOURCE_PATTERN = Pattern.compile("(^|&)utm_source=([^&#=]*)([#&]|$)");
    private final Pattern UTM_MEDIUM_PATTERN = Pattern.compile("(^|&)utm_medium=([^&#=]*)([#&]|$)");
    private final Pattern UTM_CAMPAIGN_PATTERN = Pattern.compile("(^|&)utm_campaign=([^&#=]*)([#&]|$)");
    private final Pattern UTM_CONTENT_PATTERN = Pattern.compile("(^|&)utm_content=([^&#=]*)([#&]|$)");
    private final Pattern UTM_TERM_PATTERN = Pattern.compile("(^|&)utm_term=([^&#=]*)([#&]|$)");
    private static boolean sHasStartedConnection = false;
    private Context mContext;
    private ReferrerCallback mCallBack;
    private InstallReferrerClient mReferrerClient;
    private int mRetryCount;
    private Timer mTimer;

    public InstallReferrerPlay(Context appContext, ReferrerCallback callback) {
        this.mContext = appContext;
        this.mCallBack = callback;
        this.mRetryCount = 0;
        this.mTimer = new Timer();
    }

    public void onInstallReferrerSetupFinished(int responseCode) {
        boolean shouldRetry = false;
        switch (responseCode) {
            case 0: {
                try {
                    ReferrerDetails details = this.mReferrerClient.getInstallReferrer();
                    String referrer = details.getInstallReferrer();
                    this.saveReferrerDetails(referrer);
                }
                catch (Exception e) {
                    MPLog.d(TAG, "There was an error fetching your referrer details.", e);
                    shouldRetry = true;
                }
                break;
            }
            case 1: {
                shouldRetry = true;
                MPLog.d(TAG, "Service is currently unavailable.");
                break;
            }
            case -1: {
                shouldRetry = true;
                MPLog.d(TAG, "Service was disconnected unexpectedly.");
                break;
            }
            case 2: {
                MPLog.d(TAG, "API not available on the current Play Store app.");
                break;
            }
            case 3: {
                MPLog.d(TAG, "Unexpected error.");
                break;
            }
        }
        if (shouldRetry) {
            this.retryConnection();
        } else {
            this.disconnect();
        }
    }

    public void onInstallReferrerServiceDisconnected() {
        MPLog.d(TAG, "Install Referrer Service Disconnected.");
        this.retryConnection();
    }

    public void connect() {
        this.mReferrerClient = InstallReferrerClient.newBuilder((Context)this.mContext).build();
        this.mReferrerClient.startConnection((InstallReferrerStateListener)this);
        sHasStartedConnection = true;
    }

    private void retryConnection() {
        if (this.mRetryCount > 5) {
            MPLog.d(TAG, "Already retried 5 times. Disconnecting...");
            this.disconnect();
            return;
        }
        this.mTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                InstallReferrerPlay.this.connect();
            }
        }, 2500L);
        ++this.mRetryCount;
    }

    public void disconnect() {
        if (this.mReferrerClient != null) {
            this.mReferrerClient.endConnection();
        }
    }

    public static boolean hasStartedConnection() {
        return sHasStartedConnection;
    }

    void saveReferrerDetails(String referrer) {
        Matcher termMatcher;
        String term;
        Matcher contentMatcher;
        String content;
        Matcher campaignMatcher;
        String campaign;
        Matcher mediumMatcher;
        String medium;
        if (referrer == null) {
            return;
        }
        HashMap<String, String> newPrefs = new HashMap<String, String>();
        newPrefs.put("referrer", referrer);
        Matcher sourceMatcher = UTM_SOURCE_PATTERN.matcher(referrer);
        String source = this.find(sourceMatcher);
        if (null != source) {
            newPrefs.put("utm_source", source);
        }
        if (null != (medium = this.find(mediumMatcher = this.UTM_MEDIUM_PATTERN.matcher(referrer)))) {
            newPrefs.put("utm_medium", medium);
        }
        if (null != (campaign = this.find(campaignMatcher = this.UTM_CAMPAIGN_PATTERN.matcher(referrer)))) {
            newPrefs.put("utm_campaign", campaign);
        }
        if (null != (content = this.find(contentMatcher = this.UTM_CONTENT_PATTERN.matcher(referrer)))) {
            newPrefs.put("utm_content", content);
        }
        if (null != (term = this.find(termMatcher = this.UTM_TERM_PATTERN.matcher(referrer)))) {
            newPrefs.put("utm_term", term);
        }
        PersistentIdentity.writeReferrerPrefs(this.mContext, "com.mixpanel.android.mpmetrics.ReferralInfo", newPrefs);
        if (this.mCallBack != null) {
            this.mCallBack.onReferrerReadSuccess();
        }
    }

    private String find(Matcher matcher) {
        String encoded;
        if (matcher.find() && null != (encoded = matcher.group(2))) {
            try {
                return URLDecoder.decode(encoded, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                MPLog.e(TAG, "Could not decode a parameter into UTF-8");
            }
        }
        return null;
    }

    static interface ReferrerCallback {
        public void onReferrerReadSuccess();
    }
}

