/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class SelectorEvaluator {
    private static final String ENGAGE_DATE_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String OPERATOR_KEY = "operator";
    private static final String CHILDREN_KEY = "children";
    private static final String PROPERTY_KEY = "property";
    private static final String VALUE_KEY = "value";
    private static final String EVENT_KEY = "event";
    private static final String LITERAL_KEY = "literal";
    private static final String WINDOW_KEY = "window";
    private static final String UNIT_KEY = "unit";
    private static final String HOUR_KEY = "hour";
    private static final String DAY_KEY = "day";
    private static final String WEEK_KEY = "week";
    private static final String MONTH_KEY = "month";
    private static final String BOOLEAN_OPERATOR = "boolean";
    private static final String DATETIME_OPERATOR = "datetime";
    private static final String LIST_OPERATOR = "list";
    private static final String NUMBER_OPERATOR = "number";
    private static final String STRING_OPERATOR = "string";
    private static final String AND_OPERATOR = "and";
    private static final String OR_OPERATOR = "or";
    private static final String IN_OPERATOR = "in";
    private static final String NOT_IN_OPERATOR = "not in";
    private static final String PLUS_OPERATOR = "+";
    private static final String MINUS_OPERATOR = "-";
    private static final String MUL_OPERATOR = "*";
    private static final String DIV_OPERATOR = "/";
    private static final String MOD_OPERATOR = "%";
    private static final String EQUALS_OPERATOR = "==";
    private static final String NOT_EQUALS_OPERATOR = "!=";
    private static final String GREATER_THAN_OPERATOR = ">";
    private static final String GREATER_THAN_EQUAL_OPERATOR = ">=";
    private static final String LESS_THAN_OPERATOR = "<";
    private static final String LESS_THAN_EQUAL_OPERATOR = "<=";
    private static final String NOT_OPERATOR = "not";
    private static final String DEFINED_OPERATOR = "defined";
    private static final String NOT_DEFINED_OPERATOR = "not defined";
    private static final String NOW_LITERAL = "now";
    private final JSONObject mSelector;
    private static Calendar sCalendar;

    SelectorEvaluator(JSONObject selector) throws IllegalArgumentException {
        if (!selector.has(OPERATOR_KEY) || !selector.has(CHILDREN_KEY)) {
            throw new IllegalArgumentException("Missing required keys: operator children");
        }
        this.mSelector = selector;
    }

    static PropertyType getType(Object value) {
        if (value == null || value.equals(JSONObject.NULL)) {
            return PropertyType.Null;
        }
        if (value instanceof String) {
            return PropertyType.String;
        }
        if (value instanceof JSONArray) {
            return PropertyType.Array;
        }
        if (value instanceof JSONObject) {
            return PropertyType.Object;
        }
        if (value instanceof Double || value instanceof Integer || value instanceof Number) {
            return PropertyType.Number;
        }
        if (value instanceof Boolean) {
            return PropertyType.Boolean;
        }
        if (value instanceof Date) {
            return PropertyType.Datetime;
        }
        return PropertyType.Unknown;
    }

    static Double toNumber(Object value) {
        switch (SelectorEvaluator.getType(value)) {
            case Null: {
                return null;
            }
            case Datetime: {
                Date dt = (Date)value;
                return dt.getTime() > 0L ? new Double(dt.getTime()) : null;
            }
            case Boolean: {
                Boolean b = (Boolean)value;
                return b != false ? 1.0 : 0.0;
            }
            case Number: {
                if (value instanceof Double) {
                    return (Double)value;
                }
                if (value instanceof Integer) {
                    return ((Integer)value).doubleValue();
                }
                if (value instanceof Number) {
                    return ((Number)value).doubleValue();
                }
            }
            case String: {
                try {
                    return Double.parseDouble((String)value);
                }
                catch (NumberFormatException e) {
                    return 0.0;
                }
            }
        }
        return null;
    }

    static Boolean toBoolean(Object value) {
        switch (SelectorEvaluator.getType(value)) {
            case Null: {
                return false;
            }
            case Boolean: {
                return (Boolean)value;
            }
            case Number: {
                return SelectorEvaluator.toNumber(value) != 0.0;
            }
            case String: {
                return ((String)value).length() > 0;
            }
            case Array: {
                return ((JSONArray)value).length() > 0;
            }
            case Datetime: {
                return ((Date)value).getTime() > 0L;
            }
            case Object: {
                return ((JSONObject)value).length() > 0;
            }
        }
        return false;
    }

    static Double evaluateNumber(JSONObject node, JSONObject properties) throws JSONException {
        if (!node.has(OPERATOR_KEY) || !node.getString(OPERATOR_KEY).equals(NUMBER_OPERATOR) || node.optJSONArray(CHILDREN_KEY) == null || node.getJSONArray(CHILDREN_KEY).length() != 1) {
            throw new IllegalArgumentException("Invalid node for cast operator: number");
        }
        return SelectorEvaluator.toNumber(SelectorEvaluator.evaluateNode(node.getJSONArray(CHILDREN_KEY).getJSONObject(0), properties));
    }

    static Boolean evaluateBoolean(JSONObject node, JSONObject properties) throws JSONException {
        if (!node.has(OPERATOR_KEY) || !node.getString(OPERATOR_KEY).equals(BOOLEAN_OPERATOR) || node.optJSONArray(CHILDREN_KEY) == null || node.getJSONArray(CHILDREN_KEY).length() != 1) {
            throw new IllegalArgumentException("Invalid node for cast operator: boolean");
        }
        return SelectorEvaluator.toBoolean(SelectorEvaluator.evaluateNode(node.getJSONArray(CHILDREN_KEY).getJSONObject(0), properties));
    }

    static Date evaluateDateTime(JSONObject node, JSONObject properties) throws JSONException {
        if (!node.has(OPERATOR_KEY) || !node.getString(OPERATOR_KEY).equals(DATETIME_OPERATOR) || node.optJSONArray(CHILDREN_KEY) == null || node.getJSONArray(CHILDREN_KEY).length() != 1) {
            throw new IllegalArgumentException("Invalid node for cast operator: datetime");
        }
        Object value = SelectorEvaluator.evaluateNode(node.getJSONArray(CHILDREN_KEY).getJSONObject(0), properties);
        switch (SelectorEvaluator.getType(value)) {
            case Number: {
                return new Date(SelectorEvaluator.toNumber(value).longValue());
            }
            case String: {
                try {
                    return new SimpleDateFormat(ENGAGE_DATE_FORMAT_STRING, Locale.US).parse((String)value);
                }
                catch (ParseException e) {
                    return null;
                }
            }
            case Datetime: {
                return (Date)value;
            }
        }
        return null;
    }

    static JSONArray evaluateList(JSONObject node, JSONObject properties) throws JSONException {
        if (!node.has(OPERATOR_KEY) || !node.getString(OPERATOR_KEY).equals(LIST_OPERATOR) || node.optJSONArray(CHILDREN_KEY) == null || node.getJSONArray(CHILDREN_KEY).length() != 1) {
            throw new IllegalArgumentException("Invalid node for cast operator: list");
        }
        Object value = SelectorEvaluator.evaluateNode(node.getJSONArray(CHILDREN_KEY).getJSONObject(0), properties);
        if (SelectorEvaluator.getType(value) == PropertyType.Array) {
            return (JSONArray)value;
        }
        return null;
    }

    static String evaluateString(JSONObject node, JSONObject properties) throws JSONException {
        if (!node.has(OPERATOR_KEY) || !node.getString(OPERATOR_KEY).equals(STRING_OPERATOR) || node.optJSONArray(CHILDREN_KEY) == null || node.getJSONArray(CHILDREN_KEY).length() != 1) {
            throw new IllegalArgumentException("Invalid node for cast operator: string");
        }
        Object value = SelectorEvaluator.evaluateNode(node.getJSONArray(CHILDREN_KEY).getJSONObject(0), properties);
        if (SelectorEvaluator.getType(value) == PropertyType.Datetime) {
            return new SimpleDateFormat(ENGAGE_DATE_FORMAT_STRING, Locale.US).format((Date)value);
        }
        return value != null ? value.toString() : null;
    }

    static Boolean evaluateAnd(JSONObject node, JSONObject properties) throws JSONException {
        if (!node.has(OPERATOR_KEY) || !node.getString(OPERATOR_KEY).equals(AND_OPERATOR) || node.optJSONArray(CHILDREN_KEY) == null || node.getJSONArray(CHILDREN_KEY).length() != 2) {
            throw new IllegalArgumentException("Invalid node for operator: and");
        }
        JSONArray children = node.getJSONArray(CHILDREN_KEY);
        return SelectorEvaluator.toBoolean(SelectorEvaluator.evaluateNode(children.getJSONObject(0), properties)) != false && SelectorEvaluator.toBoolean(SelectorEvaluator.evaluateNode(children.getJSONObject(1), properties)) != false;
    }

    static Boolean evaluateOr(JSONObject node, JSONObject properties) throws JSONException {
        if (!node.has(OPERATOR_KEY) || !node.getString(OPERATOR_KEY).equals(OR_OPERATOR) || node.optJSONArray(CHILDREN_KEY) == null || node.getJSONArray(CHILDREN_KEY).length() != 2) {
            throw new IllegalArgumentException("Invalid node for operator: or");
        }
        JSONArray children = node.getJSONArray(CHILDREN_KEY);
        return SelectorEvaluator.toBoolean(SelectorEvaluator.evaluateNode(children.getJSONObject(0), properties)) != false || SelectorEvaluator.toBoolean(SelectorEvaluator.evaluateNode(children.getJSONObject(1), properties)) != false;
    }

    static Boolean evaluateIn(JSONObject node, JSONObject properties) throws JSONException {
        if (!node.has(OPERATOR_KEY) || !node.getString(OPERATOR_KEY).equals(IN_OPERATOR) && !node.getString(OPERATOR_KEY).equals(NOT_IN_OPERATOR) || node.optJSONArray(CHILDREN_KEY) == null || node.getJSONArray(CHILDREN_KEY).length() != 2) {
            throw new IllegalArgumentException("Invalid node for operator: (not) in");
        }
        JSONArray children = node.getJSONArray(CHILDREN_KEY);
        Object l = SelectorEvaluator.evaluateNode(children.getJSONObject(0), properties);
        Object r = SelectorEvaluator.evaluateNode(children.getJSONObject(1), properties);
        Boolean v = false;
        String ls = l.toString();
        block0 : switch (SelectorEvaluator.getType(r)) {
            case Array: {
                JSONArray arr = (JSONArray)r;
                for (int i = 0; i < arr.length(); ++i) {
                    if (!ls.equals(arr.getString(i))) continue;
                    v = true;
                    break block0;
                }
                break;
            }
            case String: {
                v = ((String)r).contains(ls);
            }
        }
        return node.getString(OPERATOR_KEY).equals(IN_OPERATOR) ? v : v == false;
    }

    static Object evaluatePlus(JSONObject node, JSONObject properties) throws JSONException {
        if (!node.has(OPERATOR_KEY) || !node.getString(OPERATOR_KEY).equals(PLUS_OPERATOR) || node.optJSONArray(CHILDREN_KEY) == null || node.getJSONArray(CHILDREN_KEY).length() != 2) {
            throw new IllegalArgumentException("Invalid node for operator: +");
        }
        JSONArray children = node.getJSONArray(CHILDREN_KEY);
        Object l = SelectorEvaluator.evaluateNode(children.getJSONObject(0), properties);
        Object r = SelectorEvaluator.evaluateNode(children.getJSONObject(1), properties);
        if (SelectorEvaluator.getType(l) == PropertyType.Number && SelectorEvaluator.getType(r) == PropertyType.Number) {
            return SelectorEvaluator.toNumber(l) + SelectorEvaluator.toNumber(r);
        }
        if (SelectorEvaluator.getType(l) == PropertyType.String && SelectorEvaluator.getType(r) == PropertyType.String) {
            return l + (String)r;
        }
        return null;
    }

    static Double evaluateArithmetic(JSONObject node, JSONObject properties) throws JSONException {
        if (!(node.has(OPERATOR_KEY) && (node.getString(OPERATOR_KEY).equals(MINUS_OPERATOR) || node.getString(OPERATOR_KEY).equals(MUL_OPERATOR) || node.getString(OPERATOR_KEY).equals(DIV_OPERATOR) || node.getString(OPERATOR_KEY).equals(MOD_OPERATOR)) && node.optJSONArray(CHILDREN_KEY) != null && node.getJSONArray(CHILDREN_KEY).length() == 2)) {
            throw new IllegalArgumentException("Invalid node for arithmetic operator");
        }
        JSONArray children = node.getJSONArray(CHILDREN_KEY);
        Object l = SelectorEvaluator.evaluateNode(children.getJSONObject(0), properties);
        Object r = SelectorEvaluator.evaluateNode(children.getJSONObject(1), properties);
        if (SelectorEvaluator.getType(l) == PropertyType.Number && SelectorEvaluator.getType(r) == PropertyType.Number) {
            double ld = SelectorEvaluator.toNumber(l);
            double rd = SelectorEvaluator.toNumber(r);
            switch (node.getString(OPERATOR_KEY)) {
                case "-": {
                    return ld - rd;
                }
                case "*": {
                    return ld * rd;
                }
                case "/": {
                    if (rd != 0.0) {
                        return ld / rd;
                    }
                    return null;
                }
                case "%": {
                    if (rd == 0.0) {
                        return null;
                    }
                    if (ld == 0.0) {
                        return 0.0;
                    }
                    if (ld < 0.0 && rd > 0.0 || ld > 0.0 && rd < 0.0) {
                        return -(Math.floor(ld / rd) * rd - ld);
                    }
                    return ld % rd;
                }
            }
        }
        return null;
    }

    private static boolean equals(Object l, Object r) {
        if (SelectorEvaluator.getType(l) == SelectorEvaluator.getType(r)) {
            switch (SelectorEvaluator.getType(l)) {
                case Null: {
                    return true;
                }
                case Number: {
                    return SelectorEvaluator.toNumber(l).equals(SelectorEvaluator.toNumber(r));
                }
                case Boolean: {
                    return SelectorEvaluator.toBoolean(l).equals(SelectorEvaluator.toBoolean(r));
                }
                case Datetime: 
                case String: 
                case Array: {
                    return l.equals(r);
                }
            }
        }
        return false;
    }

    static Boolean evaluateEquality(JSONObject node, JSONObject properties) throws JSONException {
        if (!node.has(OPERATOR_KEY) || !node.getString(OPERATOR_KEY).equals(EQUALS_OPERATOR) && !node.getString(OPERATOR_KEY).equals(NOT_EQUALS_OPERATOR) || node.optJSONArray(CHILDREN_KEY) == null || node.getJSONArray(CHILDREN_KEY).length() != 2) {
            throw new IllegalArgumentException("Invalid node for equality operator");
        }
        JSONArray children = node.getJSONArray(CHILDREN_KEY);
        Object l = SelectorEvaluator.evaluateNode(children.getJSONObject(0), properties);
        Object r = SelectorEvaluator.evaluateNode(children.getJSONObject(1), properties);
        Boolean v = false;
        if (SelectorEvaluator.getType(l) == SelectorEvaluator.getType(r)) {
            block0 : switch (SelectorEvaluator.getType(l)) {
                case Object: {
                    JSONObject lo = (JSONObject)l;
                    JSONObject ro = (JSONObject)r;
                    if (lo.length() != ro.length()) break;
                    v = true;
                    Iterator keys = lo.keys();
                    while (keys.hasNext()) {
                        String k = (String)keys.next();
                        if (SelectorEvaluator.equals(lo.get(k), ro.opt(k))) continue;
                        v = false;
                        break block0;
                    }
                    break;
                }
                default: {
                    v = SelectorEvaluator.equals(l, r);
                }
            }
        }
        return node.getString(OPERATOR_KEY).equals(NOT_EQUALS_OPERATOR) ? !v.booleanValue() : v;
    }

    static Boolean evaluateComparison(JSONObject node, JSONObject properties) throws JSONException {
        if (!(node.has(OPERATOR_KEY) && (node.getString(OPERATOR_KEY).equals(GREATER_THAN_OPERATOR) || node.getString(OPERATOR_KEY).equals(GREATER_THAN_EQUAL_OPERATOR) || node.getString(OPERATOR_KEY).equals(LESS_THAN_OPERATOR) || node.getString(OPERATOR_KEY).equals(LESS_THAN_EQUAL_OPERATOR)) && node.optJSONArray(CHILDREN_KEY) != null && node.getJSONArray(CHILDREN_KEY).length() == 2)) {
            throw new IllegalArgumentException("Invalid node for comparison operator");
        }
        JSONArray children = node.getJSONArray(CHILDREN_KEY);
        Object l = SelectorEvaluator.evaluateNode(children.getJSONObject(0), properties);
        Object r = SelectorEvaluator.evaluateNode(children.getJSONObject(1), properties);
        if (SelectorEvaluator.getType(l) == SelectorEvaluator.getType(r)) {
            if (SelectorEvaluator.getType(l) == PropertyType.Number || SelectorEvaluator.getType(l) == PropertyType.Datetime) {
                Double ld = SelectorEvaluator.toNumber(l);
                Double rd = SelectorEvaluator.toNumber(r);
                switch (node.getString(OPERATOR_KEY)) {
                    case ">": {
                        return ld > rd;
                    }
                    case ">=": {
                        return ld >= rd;
                    }
                    case "<": {
                        return ld < rd;
                    }
                    case "<=": {
                        return ld <= rd;
                    }
                }
            } else if (SelectorEvaluator.getType(l) == PropertyType.String) {
                String ls = (String)l;
                String rs = (String)r;
                int compare = ls.compareTo(rs);
                switch (node.getString(OPERATOR_KEY)) {
                    case ">": {
                        return compare > 0;
                    }
                    case ">=": {
                        return compare >= 0;
                    }
                    case "<": {
                        return compare < 0;
                    }
                    case "<=": {
                        return compare <= 0;
                    }
                }
            }
        }
        return null;
    }

    static Boolean evaluateDefined(JSONObject node, JSONObject properties) throws JSONException {
        boolean v;
        if (!node.has(OPERATOR_KEY) || !node.getString(OPERATOR_KEY).equals(DEFINED_OPERATOR) && !node.getString(OPERATOR_KEY).equals(NOT_DEFINED_OPERATOR) || node.optJSONArray(CHILDREN_KEY) == null || node.getJSONArray(CHILDREN_KEY).length() != 1) {
            throw new IllegalArgumentException("Invalid node for (not) defined operator");
        }
        boolean bl = v = SelectorEvaluator.evaluateNode(node.getJSONArray(CHILDREN_KEY).getJSONObject(0), properties) != null;
        return node.getString(OPERATOR_KEY).equals(DEFINED_OPERATOR) ? v : !v;
    }

    static Boolean evaluateNot(JSONObject node, JSONObject properties) throws JSONException {
        if (!node.has(OPERATOR_KEY) || !node.getString(OPERATOR_KEY).equals(NOT_OPERATOR) || node.optJSONArray(CHILDREN_KEY) == null || node.getJSONArray(CHILDREN_KEY).length() != 1) {
            throw new IllegalArgumentException("Invalid node for operator: not");
        }
        Object v = SelectorEvaluator.evaluateNode(node.getJSONArray(CHILDREN_KEY).getJSONObject(0), properties);
        switch (SelectorEvaluator.getType(v)) {
            case Boolean: {
                return SelectorEvaluator.toBoolean(v) == false;
            }
            case Null: {
                return true;
            }
        }
        return null;
    }

    static Date evaluateWindow(JSONObject node) throws JSONException {
        Calendar calendar;
        JSONObject window = node.optJSONObject(WINDOW_KEY);
        if (window == null || !window.has(VALUE_KEY) || !window.has(UNIT_KEY)) {
            throw new IllegalArgumentException("Invalid window specification for value key " + node.toString());
        }
        if (sCalendar == null) {
            calendar = Calendar.getInstance();
            calendar.setTime(new Date());
        } else {
            calendar = (Calendar)sCalendar.clone();
        }
        Integer value = -1 * window.getInt(VALUE_KEY);
        switch (window.getString(UNIT_KEY)) {
            case "hour": {
                calendar.add(10, value);
                break;
            }
            case "day": {
                calendar.add(6, value);
                break;
            }
            case "week": {
                calendar.add(6, 7 * value);
                break;
            }
            case "month": {
                calendar.add(6, 30 * value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid unit specification for window " + window.getString(UNIT_KEY));
            }
        }
        return calendar.getTime();
    }

    static Object evaluateOperand(JSONObject node, JSONObject properties) throws JSONException {
        if (!node.has(PROPERTY_KEY) || !node.has(VALUE_KEY)) {
            throw new IllegalArgumentException("Missing required keys: property/value");
        }
        switch (node.getString(PROPERTY_KEY)) {
            case "event": {
                return properties.opt(node.getString(VALUE_KEY));
            }
            case "literal": {
                if (SelectorEvaluator.getType(node.get(VALUE_KEY)) == PropertyType.String && node.getString(VALUE_KEY).equalsIgnoreCase(NOW_LITERAL)) {
                    return new Date();
                }
                Object value = node.get(VALUE_KEY);
                switch (SelectorEvaluator.getType(value)) {
                    case Object: {
                        return SelectorEvaluator.evaluateWindow((JSONObject)value);
                    }
                }
                return value;
            }
        }
        throw new IllegalArgumentException("Invalid operand: Invalid property type: " + node.getString(PROPERTY_KEY));
    }

    static Object evaluateOperator(JSONObject node, JSONObject properties) throws JSONException {
        if (!node.has(OPERATOR_KEY)) {
            throw new IllegalArgumentException("Missing required keys: operator");
        }
        switch (node.getString(OPERATOR_KEY)) {
            case "and": {
                return SelectorEvaluator.evaluateAnd(node, properties);
            }
            case "or": {
                return SelectorEvaluator.evaluateOr(node, properties);
            }
            case "in": 
            case "not in": {
                return SelectorEvaluator.evaluateIn(node, properties);
            }
            case "+": {
                return SelectorEvaluator.evaluatePlus(node, properties);
            }
            case "-": 
            case "*": 
            case "/": 
            case "%": {
                return SelectorEvaluator.evaluateArithmetic(node, properties);
            }
            case "==": 
            case "!=": {
                return SelectorEvaluator.evaluateEquality(node, properties);
            }
            case ">": 
            case ">=": 
            case "<": 
            case "<=": {
                return SelectorEvaluator.evaluateComparison(node, properties);
            }
            case "boolean": {
                return SelectorEvaluator.evaluateBoolean(node, properties);
            }
            case "datetime": {
                return SelectorEvaluator.evaluateDateTime(node, properties);
            }
            case "list": {
                return SelectorEvaluator.evaluateList(node, properties);
            }
            case "number": {
                return SelectorEvaluator.evaluateNumber(node, properties);
            }
            case "string": {
                return SelectorEvaluator.evaluateString(node, properties);
            }
            case "defined": 
            case "not defined": {
                return SelectorEvaluator.evaluateDefined(node, properties);
            }
            case "not": {
                return SelectorEvaluator.evaluateNot(node, properties);
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + node.getString(OPERATOR_KEY));
    }

    private static Object evaluateNode(JSONObject node, JSONObject properties) throws JSONException {
        if (node.has(PROPERTY_KEY)) {
            return SelectorEvaluator.evaluateOperand(node, properties);
        }
        return SelectorEvaluator.evaluateOperator(node, properties);
    }

    public boolean evaluate(JSONObject properties) throws JSONException {
        return SelectorEvaluator.toBoolean(SelectorEvaluator.evaluateOperator(this.mSelector, properties));
    }

    static void setCalendar(Calendar calendar, boolean isTestMode) {
        if (isTestMode) {
            sCalendar = calendar;
        }
    }

    static enum PropertyType {
        Array,
        Boolean,
        Datetime,
        Null,
        Number,
        Object,
        String,
        Unknown;

    }
}

