/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.os.Parcel;
import android.os.Parcelable;
import com.mixpanel.android.mpmetrics.AnalyticsMessages;
import com.mixpanel.android.mpmetrics.BadDecideObjectException;
import com.mixpanel.android.mpmetrics.SelectorEvaluator;
import com.mixpanel.android.util.MPLog;
import org.json.JSONException;
import org.json.JSONObject;

class DisplayTrigger
implements Parcelable {
    private static final String LOGTAG = "MixpanelAPI.DisplayTrigger";
    private static final String ANY_EVENT = "$any_event";
    private static final String EVENT_KEY = "event";
    private static final String SELECTOR_KEY = "selector";
    private final String mEventName;
    private final JSONObject mJSONSelector;
    private final SelectorEvaluator mEvaluator;
    public static final Parcelable.Creator<DisplayTrigger> CREATOR = new Parcelable.Creator<DisplayTrigger>(){

        public DisplayTrigger createFromParcel(Parcel source) {
            return new DisplayTrigger(source);
        }

        public DisplayTrigger[] newArray(int size) {
            return new DisplayTrigger[size];
        }
    };

    public DisplayTrigger(JSONObject displayTrigger) throws BadDecideObjectException {
        SelectorEvaluator evaluator = null;
        try {
            this.mEventName = displayTrigger.getString(EVENT_KEY);
            this.mJSONSelector = displayTrigger.optJSONObject(SELECTOR_KEY);
            if (this.mJSONSelector != null) {
                evaluator = new SelectorEvaluator(this.mJSONSelector);
            }
        }
        catch (JSONException e) {
            throw new BadDecideObjectException("Event triggered notification JSON was unexpected or bad", e);
        }
        this.mEvaluator = evaluator;
    }

    public DisplayTrigger(Parcel in) {
        this.mEventName = in.readString();
        JSONObject tempSelector = null;
        SelectorEvaluator evaluator = null;
        try {
            tempSelector = new JSONObject(in.readString());
        }
        catch (JSONException e) {
            MPLog.e(LOGTAG, "Error parsing selector from display_trigger", e);
        }
        this.mJSONSelector = tempSelector;
        if (this.mJSONSelector != null) {
            evaluator = new SelectorEvaluator(this.mJSONSelector);
        }
        this.mEvaluator = evaluator;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mEventName);
        dest.writeString(this.mJSONSelector.toString());
    }

    public boolean matchesEventDescription(AnalyticsMessages.EventDescription eventDescription) {
        if (null != eventDescription && (this.mEventName.equals(ANY_EVENT) || eventDescription.getEventName().equals(this.mEventName))) {
            if (this.mEvaluator != null) {
                try {
                    return this.mEvaluator.evaluate(eventDescription.getProperties());
                }
                catch (Exception e) {
                    MPLog.e(LOGTAG, "Error evaluating selector", e);
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public int describeContents() {
        return 0;
    }
}

