/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.util.MPLog;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class MPDbAdapter {
    private static final String LOGTAG = "MixpanelAPI.Database";
    private static final Map<Context, MPDbAdapter> sInstances = new HashMap<Context, MPDbAdapter>();
    public static final String KEY_DATA = "data";
    public static final String KEY_CREATED_AT = "created_at";
    public static final String KEY_AUTOMATIC_DATA = "automatic_data";
    public static final String KEY_TOKEN = "token";
    public static final int DB_UPDATE_ERROR = -1;
    public static final int DB_OUT_OF_MEMORY_ERROR = -2;
    public static final int DB_UNDEFINED_CODE = -3;
    private static final String DATABASE_NAME = "mixpanel";
    private static final int DATABASE_VERSION = 5;
    private static final String CREATE_EVENTS_TABLE = "CREATE TABLE " + Table.EVENTS.getName() + " (_id INTEGER PRIMARY KEY AUTOINCREMENT, " + "data" + " STRING NOT NULL, " + "created_at" + " INTEGER NOT NULL, " + "automatic_data" + " INTEGER DEFAULT 0, " + "token" + " STRING NOT NULL DEFAULT '')";
    private static final String CREATE_PEOPLE_TABLE = "CREATE TABLE " + Table.PEOPLE.getName() + " (_id INTEGER PRIMARY KEY AUTOINCREMENT, " + "data" + " STRING NOT NULL, " + "created_at" + " INTEGER NOT NULL, " + "automatic_data" + " INTEGER DEFAULT 0, " + "token" + " STRING NOT NULL DEFAULT '')";
    private static final String EVENTS_TIME_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON " + Table.EVENTS.getName() + " (" + "created_at" + ");";
    private static final String PEOPLE_TIME_INDEX = "CREATE INDEX IF NOT EXISTS time_idx ON " + Table.PEOPLE.getName() + " (" + "created_at" + ");";
    private final MPDatabaseHelper mDb;

    public MPDbAdapter(Context context) {
        this(context, DATABASE_NAME);
    }

    public MPDbAdapter(Context context, String dbName) {
        this.mDb = new MPDatabaseHelper(context, dbName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MPDbAdapter getInstance(Context context) {
        Map<Context, MPDbAdapter> map = sInstances;
        synchronized (map) {
            MPDbAdapter ret;
            Context appContext = context.getApplicationContext();
            if (!sInstances.containsKey(appContext)) {
                ret = new MPDbAdapter(appContext);
                sInstances.put(appContext, ret);
            } else {
                ret = sInstances.get(appContext);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addJSON(JSONObject j, String token, Table table, boolean isAutomaticRecord) {
        if (!this.belowMemThreshold()) {
            MPLog.e(LOGTAG, "There is not enough space left on the device to store Mixpanel data, so data was discarded");
            return -2;
        }
        String tableName = table.getName();
        Cursor c = null;
        int count = -1;
        try {
            SQLiteDatabase db = this.mDb.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put(KEY_DATA, j.toString());
            cv.put(KEY_CREATED_AT, Long.valueOf(System.currentTimeMillis()));
            cv.put(KEY_AUTOMATIC_DATA, Boolean.valueOf(isAutomaticRecord));
            cv.put(KEY_TOKEN, token);
            db.insert(tableName, null, cv);
            c = db.rawQuery("SELECT COUNT(*) FROM " + tableName + " WHERE token='" + token + "'", null);
            c.moveToFirst();
            count = c.getInt(0);
        }
        catch (SQLiteException e) {
            MPLog.e(LOGTAG, "Could not add Mixpanel data to table " + tableName + ". Re-initializing database.", e);
            if (c != null) {
                c.close();
                c = null;
            }
            this.mDb.deleteDatabase();
        }
        finally {
            if (c != null) {
                c.close();
            }
            this.mDb.close();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupEvents(String last_id, Table table, String token, boolean includeAutomaticEvents) {
        String tableName = table.getName();
        try {
            SQLiteDatabase db = this.mDb.getWritableDatabase();
            StringBuffer deleteQuery = new StringBuffer("_id <= " + last_id + " AND " + KEY_TOKEN + " = '" + token + "'");
            if (!includeAutomaticEvents) {
                deleteQuery.append(" AND automatic_data=0");
            }
            db.delete(tableName, deleteQuery.toString(), null);
        }
        catch (SQLiteException e) {
            MPLog.e(LOGTAG, "Could not clean sent Mixpanel records from " + tableName + ". Re-initializing database.", e);
            this.mDb.deleteDatabase();
        }
        finally {
            this.mDb.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupEvents(long time, Table table) {
        String tableName = table.getName();
        try {
            SQLiteDatabase db = this.mDb.getWritableDatabase();
            db.delete(tableName, "created_at <= " + time, null);
        }
        catch (SQLiteException e) {
            MPLog.e(LOGTAG, "Could not clean timed-out Mixpanel records from " + tableName + ". Re-initializing database.", e);
            this.mDb.deleteDatabase();
        }
        finally {
            this.mDb.close();
        }
    }

    public synchronized void cleanupAutomaticEvents(String token) {
        this.cleanupAutomaticEvents(Table.EVENTS, token);
        this.cleanupAutomaticEvents(Table.PEOPLE, token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupAutomaticEvents(Table table, String token) {
        String tableName = table.getName();
        try {
            SQLiteDatabase db = this.mDb.getWritableDatabase();
            db.delete(tableName, "automatic_data = 1 AND token = '" + token + "'", null);
        }
        catch (SQLiteException e) {
            MPLog.e(LOGTAG, "Could not clean automatic Mixpanel records from " + tableName + ". Re-initializing database.", e);
            this.mDb.deleteDatabase();
        }
        finally {
            this.mDb.close();
        }
    }

    public void deleteDB() {
        this.mDb.deleteDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] generateDataString(Table table, String token, boolean includeAutomaticEvents) {
        Cursor c = null;
        Cursor queueCountCursor = null;
        String data = null;
        String last_id = null;
        String queueCount = null;
        String tableName = table.getName();
        SQLiteDatabase db = this.mDb.getReadableDatabase();
        try {
            StringBuffer rawDataQuery = new StringBuffer("SELECT * FROM " + tableName + " WHERE " + KEY_TOKEN + " = '" + token + "' ");
            StringBuffer queueCountQuery = new StringBuffer("SELECT COUNT(*) FROM " + tableName + " WHERE " + KEY_TOKEN + " = '" + token + "' ");
            if (!includeAutomaticEvents) {
                rawDataQuery.append("AND automatic_data = 0 ");
                queueCountQuery.append(" AND automatic_data = 0");
            }
            rawDataQuery.append("ORDER BY created_at ASC LIMIT 50");
            c = db.rawQuery(rawDataQuery.toString(), null);
            queueCountCursor = db.rawQuery(queueCountQuery.toString(), null);
            queueCountCursor.moveToFirst();
            queueCount = String.valueOf(queueCountCursor.getInt(0));
            JSONArray arr = new JSONArray();
            while (c.moveToNext()) {
                if (c.isLast()) {
                    last_id = c.getString(c.getColumnIndex("_id"));
                }
                try {
                    JSONObject j = new JSONObject(c.getString(c.getColumnIndex(KEY_DATA)));
                    arr.put((Object)j);
                }
                catch (JSONException e) {}
            }
            if (arr.length() > 0) {
                data = arr.toString();
            }
        }
        catch (SQLiteException e) {
            MPLog.e(LOGTAG, "Could not pull records for Mixpanel out of database " + tableName + ". Waiting to send.", e);
            last_id = null;
            data = null;
        }
        finally {
            this.mDb.close();
            if (c != null) {
                c.close();
            }
            if (queueCountCursor != null) {
                queueCountCursor.close();
            }
        }
        if (last_id != null && data != null) {
            String[] ret = new String[]{last_id, data, queueCount};
            return ret;
        }
        return null;
    }

    public File getDatabaseFile() {
        return this.mDb.mDatabaseFile;
    }

    protected boolean belowMemThreshold() {
        return this.mDb.belowMemThreshold();
    }

    private static class MPDatabaseHelper
    extends SQLiteOpenHelper {
        private final File mDatabaseFile;
        private final MPConfig mConfig;

        MPDatabaseHelper(Context context, String dbName) {
            super(context, dbName, null, 5);
            this.mDatabaseFile = context.getDatabasePath(dbName);
            this.mConfig = MPConfig.getInstance(context);
        }

        public void deleteDatabase() {
            this.close();
            this.mDatabaseFile.delete();
        }

        public void onCreate(SQLiteDatabase db) {
            MPLog.v(MPDbAdapter.LOGTAG, "Creating a new Mixpanel events DB");
            db.execSQL(CREATE_EVENTS_TABLE);
            db.execSQL(CREATE_PEOPLE_TABLE);
            db.execSQL(EVENTS_TIME_INDEX);
            db.execSQL(PEOPLE_TIME_INDEX);
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            MPLog.v(MPDbAdapter.LOGTAG, "Upgrading app, replacing Mixpanel events DB");
            if (newVersion == 5) {
                this.migrateTableFrom4To5(db);
            } else {
                db.execSQL("DROP TABLE IF EXISTS " + Table.EVENTS.getName());
                db.execSQL("DROP TABLE IF EXISTS " + Table.PEOPLE.getName());
                db.execSQL(CREATE_EVENTS_TABLE);
                db.execSQL(CREATE_PEOPLE_TABLE);
                db.execSQL(EVENTS_TIME_INDEX);
                db.execSQL(PEOPLE_TIME_INDEX);
            }
        }

        public boolean belowMemThreshold() {
            if (this.mDatabaseFile.exists()) {
                return Math.max(this.mDatabaseFile.getUsableSpace(), (long)this.mConfig.getMinimumDatabaseLimit()) >= this.mDatabaseFile.length();
            }
            return true;
        }

        private void migrateTableFrom4To5(SQLiteDatabase db) {
            db.execSQL("ALTER TABLE " + Table.EVENTS.getName() + " ADD COLUMN " + MPDbAdapter.KEY_AUTOMATIC_DATA + " INTEGER DEFAULT 0");
            db.execSQL("ALTER TABLE " + Table.PEOPLE.getName() + " ADD COLUMN " + MPDbAdapter.KEY_AUTOMATIC_DATA + " INTEGER DEFAULT 0");
            db.execSQL("ALTER TABLE " + Table.EVENTS.getName() + " ADD COLUMN " + MPDbAdapter.KEY_TOKEN + " STRING NOT NULL DEFAULT ''");
            db.execSQL("ALTER TABLE " + Table.PEOPLE.getName() + " ADD COLUMN " + MPDbAdapter.KEY_TOKEN + " STRING NOT NULL DEFAULT ''");
            Cursor eventsCursor = db.rawQuery("SELECT * FROM " + Table.EVENTS.getName(), null);
            while (eventsCursor.moveToNext()) {
                int rowId = 0;
                try {
                    JSONObject j = new JSONObject(eventsCursor.getString(eventsCursor.getColumnIndex(MPDbAdapter.KEY_DATA)));
                    String token = j.getJSONObject("properties").getString(MPDbAdapter.KEY_TOKEN);
                    rowId = eventsCursor.getInt(eventsCursor.getColumnIndex("_id"));
                    db.execSQL("UPDATE " + Table.EVENTS.getName() + " SET " + MPDbAdapter.KEY_TOKEN + " = '" + token + "' WHERE _id = " + rowId);
                }
                catch (JSONException e) {
                    db.delete(Table.EVENTS.getName(), "_id = " + rowId, null);
                }
            }
            Cursor peopleCursor = db.rawQuery("SELECT * FROM " + Table.PEOPLE.getName(), null);
            while (peopleCursor.moveToNext()) {
                int rowId = 0;
                try {
                    JSONObject j = new JSONObject(peopleCursor.getString(peopleCursor.getColumnIndex(MPDbAdapter.KEY_DATA)));
                    String token = j.getString("$token");
                    rowId = peopleCursor.getInt(peopleCursor.getColumnIndex("_id"));
                    db.execSQL("UPDATE " + Table.PEOPLE.getName() + " SET " + MPDbAdapter.KEY_TOKEN + " = '" + token + "' WHERE _id = " + rowId);
                }
                catch (JSONException e) {
                    db.delete(Table.PEOPLE.getName(), "_id = " + rowId, null);
                }
            }
        }
    }

    public static enum Table {
        EVENTS("events"),
        PEOPLE("people");

        private final String mTableName;

        private Table(String name) {
            this.mTableName = name;
        }

        public String getName() {
            return this.mTableName;
        }
    }
}

