/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.util;

import android.util.Log;
import com.mixpanel.android.mpmetrics.MPConfig;

public class MPLog {
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int NONE = Integer.MAX_VALUE;
    private static int sMinLevel = MPConfig.DEBUG ? 2 : 5;

    public static void setLevel(int minLevel) {
        sMinLevel = minLevel;
    }

    public static void v(String tag, String message) {
        if (MPLog.shouldLog(2)) {
            Log.v((String)tag, (String)message);
        }
    }

    public static void v(String tag, String message, Throwable throwable) {
        if (MPLog.shouldLog(2)) {
            Log.v((String)tag, (String)message, (Throwable)throwable);
        }
    }

    public static void d(String tag, String message) {
        if (MPLog.shouldLog(3)) {
            Log.d((String)tag, (String)message);
        }
    }

    public static void d(String tag, String message, Throwable throwable) {
        if (MPLog.shouldLog(3)) {
            Log.d((String)tag, (String)message, (Throwable)throwable);
        }
    }

    public static void i(String tag, String message) {
        if (MPLog.shouldLog(4)) {
            Log.i((String)tag, (String)message);
        }
    }

    public static void i(String tag, String message, Throwable throwable) {
        if (MPLog.shouldLog(4)) {
            Log.i((String)tag, (String)message, (Throwable)throwable);
        }
    }

    public static void w(String tag, String message) {
        if (MPLog.shouldLog(5)) {
            Log.w((String)tag, (String)message);
        }
    }

    public static void w(String tag, String message, Throwable throwable) {
        if (MPLog.shouldLog(5)) {
            Log.w((String)tag, (String)message, (Throwable)throwable);
        }
    }

    public static void e(String tag, String message) {
        if (MPLog.shouldLog(6)) {
            Log.e((String)tag, (String)message);
        }
    }

    public static void e(String tag, String message, Throwable throwable) {
        if (MPLog.shouldLog(6)) {
            Log.e((String)tag, (String)message, (Throwable)throwable);
        }
    }

    public static void wtf(String tag, String message) {
        if (MPLog.shouldLog(6)) {
            Log.wtf((String)tag, (String)message);
        }
    }

    public static void wtf(String tag, String message, Throwable throwable) {
        if (MPLog.shouldLog(6)) {
            Log.wtf((String)tag, (String)message, (Throwable)throwable);
        }
    }

    private static boolean shouldLog(int level) {
        return sMinLevel <= level;
    }
}

