/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.os.Build;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import com.mixpanel.android.mpmetrics.BadDecideObjectException;
import com.mixpanel.android.mpmetrics.DecideMessages;
import com.mixpanel.android.mpmetrics.InAppNotification;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.Survey;
import com.mixpanel.android.mpmetrics.SystemInformation;
import com.mixpanel.android.util.ImageStore;
import com.mixpanel.android.util.RemoteService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class DecideChecker {
    private final MPConfig mConfig;
    private final Context mContext;
    private final List<DecideMessages> mChecks;
    private final ImageStore mImageStore;
    private final SystemInformation mSystemInformation;
    private static final JSONArray EMPTY_JSON_ARRAY = new JSONArray();
    private static final String LOGTAG = "MixpanelAPI.DChecker";

    public DecideChecker(Context context, MPConfig config, SystemInformation systemInformation) {
        this.mContext = context;
        this.mConfig = config;
        this.mChecks = new LinkedList<DecideMessages>();
        this.mImageStore = this.createImageStore(context);
        this.mSystemInformation = systemInformation;
    }

    protected ImageStore createImageStore(Context context) {
        return new ImageStore(context, "DecideChecker");
    }

    public void addDecideCheck(DecideMessages check) {
        this.mChecks.add(check);
    }

    public void runDecideChecks(RemoteService poster) throws RemoteService.ServiceUnavailableException {
        for (DecideMessages updates : this.mChecks) {
            String distinctId = updates.getDistinctId();
            try {
                Result result = this.runDecideCheck(updates.getToken(), distinctId, poster);
                updates.reportResults(result.surveys, result.notifications, result.eventBindings, result.variants);
            }
            catch (UnintelligibleMessageException e) {
                Log.e((String)LOGTAG, (String)e.getMessage(), (Throwable)e);
            }
        }
    }

    private Result runDecideCheck(String token, String distinctId, RemoteService poster) throws RemoteService.ServiceUnavailableException, UnintelligibleMessageException {
        String responseString = this.getDecideResponseFromServer(token, distinctId, poster);
        if (MPConfig.DEBUG) {
            Log.v((String)LOGTAG, (String)("Mixpanel decide server response was:\n" + responseString));
        }
        Result parsed = new Result();
        if (null != responseString) {
            parsed = DecideChecker.parseDecideResponse(responseString);
        }
        Iterator<InAppNotification> notificationIterator = parsed.notifications.iterator();
        while (notificationIterator.hasNext()) {
            InAppNotification notification = notificationIterator.next();
            Bitmap image = this.getNotificationImage(notification, this.mContext, poster);
            if (null == image) {
                Log.i((String)LOGTAG, (String)("Could not retrieve image for notification " + notification.getId() + ", will not show the notification."));
                notificationIterator.remove();
                continue;
            }
            notification.setImage(image);
        }
        return parsed;
    }

    static Result parseDecideResponse(String responseString) throws UnintelligibleMessageException {
        JSONObject response;
        Result ret = new Result();
        try {
            response = new JSONObject(responseString);
        }
        catch (JSONException e) {
            String message = "Mixpanel endpoint returned unparsable result:\n" + responseString;
            throw new UnintelligibleMessageException(message, e);
        }
        JSONArray surveys = null;
        if (response.has("surveys")) {
            try {
                surveys = response.getJSONArray("surveys");
            }
            catch (JSONException e) {
                Log.e((String)LOGTAG, (String)("Mixpanel endpoint returned non-array JSON for surveys: " + response));
            }
        }
        if (null != surveys) {
            for (int i = 0; i < surveys.length(); ++i) {
                try {
                    JSONObject surveyJson = surveys.getJSONObject(i);
                    Survey survey = new Survey(surveyJson);
                    ret.surveys.add(survey);
                    continue;
                }
                catch (JSONException e) {
                    Log.e((String)LOGTAG, (String)("Received a strange response from surveys service: " + surveys.toString()));
                    continue;
                }
                catch (BadDecideObjectException e) {
                    Log.e((String)LOGTAG, (String)("Received a strange response from surveys service: " + surveys.toString()));
                }
            }
        }
        JSONArray notifications = null;
        if (response.has("notifications")) {
            try {
                notifications = response.getJSONArray("notifications");
            }
            catch (JSONException e) {
                Log.e((String)LOGTAG, (String)("Mixpanel endpoint returned non-array JSON for notifications: " + response));
            }
        }
        if (null != notifications) {
            int notificationsToRead = Math.min(notifications.length(), 2);
            for (int i = 0; i < notificationsToRead; ++i) {
                try {
                    JSONObject notificationJson = notifications.getJSONObject(i);
                    InAppNotification notification = new InAppNotification(notificationJson);
                    ret.notifications.add(notification);
                    continue;
                }
                catch (JSONException e) {
                    Log.e((String)LOGTAG, (String)("Received a strange response from notifications service: " + notifications.toString()), (Throwable)e);
                    continue;
                }
                catch (BadDecideObjectException e) {
                    Log.e((String)LOGTAG, (String)("Received a strange response from notifications service: " + notifications.toString()), (Throwable)e);
                    continue;
                }
                catch (OutOfMemoryError e) {
                    Log.e((String)LOGTAG, (String)("Not enough memory to show load notification from package: " + notifications.toString()), (Throwable)e);
                }
            }
        }
        if (response.has("event_bindings")) {
            try {
                ret.eventBindings = response.getJSONArray("event_bindings");
            }
            catch (JSONException e) {
                Log.e((String)LOGTAG, (String)("Mixpanel endpoint returned non-array JSON for event bindings: " + response));
            }
        }
        if (response.has("variants")) {
            try {
                ret.variants = response.getJSONArray("variants");
            }
            catch (JSONException e) {
                Log.e((String)LOGTAG, (String)("Mixpanel endpoint returned non-array JSON for variants: " + response));
            }
        }
        return ret;
    }

    private String getDecideResponseFromServer(String unescapedToken, String unescapedDistinctId, RemoteService poster) throws RemoteService.ServiceUnavailableException {
        byte[] response;
        String escapedId;
        String escapedToken;
        try {
            escapedToken = URLEncoder.encode(unescapedToken, "utf-8");
            escapedId = null != unescapedDistinctId ? URLEncoder.encode(unescapedDistinctId, "utf-8") : null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Mixpanel library requires utf-8 string encoding to be available", e);
        }
        StringBuilder queryBuilder = new StringBuilder().append("?version=1&lib=android&token=").append(escapedToken);
        if (null != escapedId) {
            queryBuilder.append("&distinct_id=").append(escapedId);
        }
        queryBuilder.append("&properties=");
        JSONObject properties = new JSONObject();
        try {
            properties.putOpt("$android_lib_version", (Object)"4.9.2");
            properties.putOpt("$android_app_version", (Object)this.mSystemInformation.getAppVersionName());
            properties.putOpt("$android_version", (Object)Build.VERSION.RELEASE);
            properties.putOpt("$android_app_release", (Object)this.mSystemInformation.getAppVersionCode());
            properties.putOpt("$android_device_model", (Object)Build.MODEL);
            queryBuilder.append(URLEncoder.encode(properties.toString(), "utf-8"));
        }
        catch (Exception e) {
            Log.e((String)LOGTAG, (String)"Exception constructing properties JSON", (Throwable)e.getCause());
        }
        String checkQuery = queryBuilder.toString();
        String[] urls = this.mConfig.getDisableFallback() ? new String[]{this.mConfig.getDecideEndpoint() + checkQuery} : new String[]{this.mConfig.getDecideEndpoint() + checkQuery, this.mConfig.getDecideFallbackEndpoint() + checkQuery};
        if (MPConfig.DEBUG) {
            Log.v((String)LOGTAG, (String)"Querying decide server, urls:");
            for (int i = 0; i < urls.length; ++i) {
                Log.v((String)LOGTAG, (String)("    >> " + urls[i]));
            }
        }
        if (null == (response = DecideChecker.getUrls(poster, this.mContext, urls))) {
            return null;
        }
        try {
            return new String(response, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF not supported on this platform?", e);
        }
    }

    private Bitmap getNotificationImage(InAppNotification notification, Context context, RemoteService poster) throws RemoteService.ServiceUnavailableException {
        String[] urls = new String[]{notification.getImage2xUrl(), notification.getImageUrl()};
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        int displayWidth = DecideChecker.getDisplayWidth(display);
        if (notification.getType() == InAppNotification.Type.TAKEOVER && displayWidth >= 720) {
            urls = new String[]{notification.getImage4xUrl(), notification.getImage2xUrl(), notification.getImageUrl()};
        }
        for (String url : urls) {
            try {
                return this.mImageStore.getImage(url);
            }
            catch (ImageStore.CantGetImageException e) {
                Log.v((String)LOGTAG, (String)("Can't load image " + url + " for a notification"), (Throwable)e);
            }
        }
        return null;
    }

    @SuppressLint(value={"NewApi"})
    private static int getDisplayWidth(Display display) {
        if (Build.VERSION.SDK_INT < 13) {
            return display.getWidth();
        }
        Point displaySize = new Point();
        display.getSize(displaySize);
        return displaySize.x;
    }

    private static byte[] getUrls(RemoteService poster, Context context, String[] urls) throws RemoteService.ServiceUnavailableException {
        MPConfig config = MPConfig.getInstance(context);
        if (!poster.isOnline(context, config.getOfflineMode())) {
            return null;
        }
        byte[] response = null;
        for (String url : urls) {
            try {
                SSLSocketFactory socketFactory = config.getSSLSocketFactory();
                response = poster.performRequest(url, null, socketFactory);
                break;
            }
            catch (MalformedURLException e) {
                Log.e((String)LOGTAG, (String)("Cannot interpret " + url + " as a URL."), (Throwable)e);
            }
            catch (FileNotFoundException e) {
                if (!MPConfig.DEBUG) continue;
                Log.v((String)LOGTAG, (String)("Cannot get " + url + ", file not found."), (Throwable)e);
            }
            catch (IOException e) {
                if (!MPConfig.DEBUG) continue;
                Log.v((String)LOGTAG, (String)("Cannot get " + url + "."), (Throwable)e);
            }
            catch (OutOfMemoryError e) {
                Log.e((String)LOGTAG, (String)("Out of memory when getting to " + url + "."), (Throwable)e);
                break;
            }
        }
        return response;
    }

    static /* synthetic */ JSONArray access$000() {
        return EMPTY_JSON_ARRAY;
    }

    static class UnintelligibleMessageException
    extends Exception {
        private static final long serialVersionUID = -6501269367559104957L;

        public UnintelligibleMessageException(String message, JSONException cause) {
            super(message, cause);
        }
    }

    static class Result {
        public final List<Survey> surveys = new ArrayList<Survey>();
        public final List<InAppNotification> notifications = new ArrayList<InAppNotification>();
        public JSONArray eventBindings = DecideChecker.access$000();
        public JSONArray variants = DecideChecker.access$000();
    }
}

