/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.mixpanel.android.mpmetrics.BadDecideObjectException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class InAppNotification
implements Parcelable {
    public static final Parcelable.Creator<InAppNotification> CREATOR = new Parcelable.Creator<InAppNotification>(){

        public InAppNotification createFromParcel(Parcel source) {
            return new InAppNotification(source);
        }

        public InAppNotification[] newArray(int size) {
            return new InAppNotification[size];
        }
    };
    private Bitmap mImage;
    private final JSONObject mDescription;
    private final int mId;
    private final int mMessageId;
    private final String mType;
    private final String mStyle;
    private final String mTitle;
    private final String mBody;
    private final String mImageUrl;
    private final String mCallToAction;
    private final String mCallToActionUrl;
    private static final String LOGTAG = "MixpanelAPI.InAppNotif";
    private static final Pattern FILE_EXTENSION_PATTERN = Pattern.compile("(\\.[^./]+$)");

    public InAppNotification(Parcel in) {
        JSONObject temp = new JSONObject();
        try {
            temp = new JSONObject(in.readString());
        }
        catch (JSONException e) {
            Log.e((String)LOGTAG, (String)"Error reading JSON when creating InAppNotification from Parcel");
        }
        this.mDescription = temp;
        this.mId = in.readInt();
        this.mMessageId = in.readInt();
        this.mType = in.readString();
        this.mStyle = in.readString();
        this.mTitle = in.readString();
        this.mBody = in.readString();
        this.mImageUrl = in.readString();
        this.mCallToAction = in.readString();
        this.mCallToActionUrl = in.readString();
        this.mImage = (Bitmap)in.readParcelable(Bitmap.class.getClassLoader());
    }

    InAppNotification(JSONObject description) throws BadDecideObjectException {
        try {
            this.mDescription = description;
            this.mId = description.getInt("id");
            this.mMessageId = description.getInt("message_id");
            this.mType = description.getString("type");
            this.mStyle = description.getString("style");
            this.mTitle = description.getString("title");
            this.mBody = description.getString("body");
            this.mImageUrl = description.getString("image_url");
            this.mImage = Bitmap.createBitmap((int)500, (int)500, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.mCallToAction = description.getString("cta");
            this.mCallToActionUrl = description.getString("cta_url");
        }
        catch (JSONException e) {
            throw new BadDecideObjectException("Notification JSON was unexpected or bad", e);
        }
    }

    String toJSON() {
        return this.mDescription.toString();
    }

    JSONObject getCampaignProperties() {
        JSONObject ret = new JSONObject();
        try {
            ret.put("campaign_id", this.getId());
            ret.put("message_id", this.getMessageId());
            ret.put("message_type", (Object)"inapp");
            ret.put("message_subtype", (Object)this.mType);
        }
        catch (JSONException e) {
            Log.e((String)LOGTAG, (String)"Impossible JSON Exception", (Throwable)e);
        }
        return ret;
    }

    public int getId() {
        return this.mId;
    }

    public int getMessageId() {
        return this.mMessageId;
    }

    public Type getType() {
        if (Type.MINI.toString().equals(this.mType)) {
            return Type.MINI;
        }
        if (Type.TAKEOVER.toString().equals(this.mType)) {
            return Type.TAKEOVER;
        }
        return Type.UNKNOWN;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public String getBody() {
        return this.mBody;
    }

    public String getImageUrl() {
        return this.mImageUrl;
    }

    public String getImage2xUrl() {
        return InAppNotification.sizeSuffixUrl(this.mImageUrl, "@2x");
    }

    public String getImage4xUrl() {
        return InAppNotification.sizeSuffixUrl(this.mImageUrl, "@4x");
    }

    public String getCallToAction() {
        return this.mCallToAction;
    }

    public String getCallToActionUrl() {
        return this.mCallToActionUrl;
    }

    public String getStyle() {
        return this.mStyle;
    }

    void setImage(Bitmap image) {
        this.mImage = image;
    }

    public Bitmap getImage() {
        return this.mImage;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mDescription.toString());
        dest.writeInt(this.mId);
        dest.writeInt(this.mMessageId);
        dest.writeString(this.mType);
        dest.writeString(this.mStyle);
        dest.writeString(this.mTitle);
        dest.writeString(this.mBody);
        dest.writeString(this.mImageUrl);
        dest.writeString(this.mCallToAction);
        dest.writeString(this.mCallToActionUrl);
        dest.writeParcelable((Parcelable)this.mImage, flags);
    }

    static String sizeSuffixUrl(String url, String sizeSuffix) {
        Matcher matcher = FILE_EXTENSION_PATTERN.matcher(url);
        if (matcher.find()) {
            return matcher.replaceFirst(sizeSuffix + "$1");
        }
        return url;
    }

    public static enum Style {
        LIGHT("light"),
        DARK("dark");

        private final String style;

        private Style(String s) {
            this.style = s;
        }

        public boolean equalsName(String otherName) {
            return otherName != null && this.style.equals(otherName);
        }

        public String toString() {
            return this.style;
        }
    }

    public static enum Type {
        UNKNOWN{

            public String toString() {
                return "*unknown_type*";
            }
        }
        ,
        MINI{

            public String toString() {
                return "mini";
            }
        }
        ,
        TAKEOVER{

            public String toString() {
                return "takeover";
            }
        };

    }
}

