/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.util.Log;
import com.mixpanel.android.mpmetrics.Tweak;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Tweaks {
    public static final int BOOLEAN_TYPE = 1;
    public static final int DOUBLE_TYPE = 2;
    public static final int LONG_TYPE = 3;
    public static final int STRING_TYPE = 4;
    private final Map<String, TweakValue> mTweakValues = new HashMap<String, TweakValue>();
    private final Map<String, TweakValue> mTweakDefaultValues = new HashMap<String, TweakValue>();
    private final List<OnTweakDeclaredListener> mTweakDeclaredListeners = new ArrayList<OnTweakDeclaredListener>();
    private static final String LOGTAG = "MixpanelAPI.Tweaks";

    public synchronized void addOnTweakDeclaredListener(OnTweakDeclaredListener listener) {
        if (null == listener) {
            throw new NullPointerException("listener cannot be null");
        }
        this.mTweakDeclaredListeners.add(listener);
    }

    public synchronized void set(String tweakName, Object value) {
        if (!this.mTweakValues.containsKey(tweakName)) {
            Log.w((String)LOGTAG, (String)("Attempt to set a tweak \"" + tweakName + "\" which has never been defined."));
            return;
        }
        TweakValue container = this.mTweakValues.get(tweakName);
        TweakValue updated = container.updateValue(value);
        this.mTweakValues.put(tweakName, updated);
    }

    public synchronized Map<String, TweakValue> getAllValues() {
        return new HashMap<String, TweakValue>(this.mTweakValues);
    }

    public synchronized Map<String, TweakValue> getDefaultValues() {
        return new HashMap<String, TweakValue>(this.mTweakDefaultValues);
    }

    Tweaks() {
    }

    Tweak<String> stringTweak(final String tweakName, String defaultValue) {
        this.declareTweak(tweakName, defaultValue, 4);
        return new Tweak<String>(){

            @Override
            public String get() {
                TweakValue tweakValue = Tweaks.this.getValue(tweakName);
                return tweakValue.getStringValue();
            }
        };
    }

    Tweak<Double> doubleTweak(final String tweakName, double defaultValue) {
        this.declareTweak(tweakName, defaultValue, 2);
        return new Tweak<Double>(){

            @Override
            public Double get() {
                TweakValue tweakValue = Tweaks.this.getValue(tweakName);
                Number result = tweakValue.getNumberValue();
                return result.doubleValue();
            }
        };
    }

    Tweak<Float> floatTweak(final String tweakName, float defaultValue) {
        this.declareTweak(tweakName, Float.valueOf(defaultValue), 2);
        return new Tweak<Float>(){

            @Override
            public Float get() {
                TweakValue tweakValue = Tweaks.this.getValue(tweakName);
                Number result = tweakValue.getNumberValue();
                return Float.valueOf(result.floatValue());
            }
        };
    }

    Tweak<Long> longTweak(final String tweakName, long defaultValue) {
        this.declareTweak(tweakName, defaultValue, 3);
        return new Tweak<Long>(){

            @Override
            public Long get() {
                TweakValue tweakValue = Tweaks.this.getValue(tweakName);
                Number result = tweakValue.getNumberValue();
                return result.longValue();
            }
        };
    }

    Tweak<Integer> intTweak(final String tweakName, int defaultValue) {
        this.declareTweak(tweakName, defaultValue, 3);
        return new Tweak<Integer>(){

            @Override
            public Integer get() {
                TweakValue tweakValue = Tweaks.this.getValue(tweakName);
                Number result = tweakValue.getNumberValue();
                return result.intValue();
            }
        };
    }

    Tweak<Byte> byteTweak(final String tweakName, byte defaultValue) {
        this.declareTweak(tweakName, defaultValue, 3);
        return new Tweak<Byte>(){

            @Override
            public Byte get() {
                TweakValue tweakValue = Tweaks.this.getValue(tweakName);
                Number result = tweakValue.getNumberValue();
                return result.byteValue();
            }
        };
    }

    Tweak<Short> shortTweak(final String tweakName, short defaultValue) {
        this.declareTweak(tweakName, defaultValue, 3);
        return new Tweak<Short>(){

            @Override
            public Short get() {
                TweakValue tweakValue = Tweaks.this.getValue(tweakName);
                Number result = tweakValue.getNumberValue();
                return result.shortValue();
            }
        };
    }

    Tweak<Boolean> booleanTweak(final String tweakName, boolean defaultValue) {
        this.declareTweak(tweakName, defaultValue, 1);
        return new Tweak<Boolean>(){

            @Override
            public Boolean get() {
                TweakValue tweakValue = Tweaks.this.getValue(tweakName);
                return tweakValue.getBooleanValue();
            }
        };
    }

    private synchronized TweakValue getValue(String tweakName) {
        return this.mTweakValues.get(tweakName);
    }

    private void declareTweak(String tweakName, Object defaultValue, int tweakType) {
        if (this.mTweakValues.containsKey(tweakName)) {
            Log.w((String)LOGTAG, (String)("Attempt to define a tweak \"" + tweakName + "\" twice with the same name"));
            return;
        }
        TweakValue value = new TweakValue(tweakType, defaultValue, null, null, defaultValue);
        this.mTweakValues.put(tweakName, value);
        this.mTweakDefaultValues.put(tweakName, value);
        int listenerSize = this.mTweakDeclaredListeners.size();
        for (int i = 0; i < listenerSize; ++i) {
            this.mTweakDeclaredListeners.get(i).onTweakDeclared();
        }
    }

    public static interface OnTweakDeclaredListener {
        public void onTweakDeclared();
    }

    public static class TweakValue {
        public final int type;
        private final Object value;
        private final Object defaultValue;
        private final Number minimum;
        private final Number maximum;

        private TweakValue(int aType, Object aDefaultValue, Number aMin, Number aMax, Object value) {
            this.type = aType;
            this.defaultValue = aDefaultValue;
            this.minimum = aMin;
            this.maximum = aMax;
            this.value = value;
        }

        public TweakValue updateValue(Object newValue) {
            return new TweakValue(this.type, this.defaultValue, this.minimum, this.maximum, newValue);
        }

        public String getStringValue() {
            String ret = null;
            try {
                ret = (String)this.defaultValue;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            try {
                ret = (String)this.value;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return ret;
        }

        public Number getNumberValue() {
            Number ret = 0;
            if (null != this.defaultValue) {
                try {
                    ret = (Number)this.defaultValue;
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
            }
            if (null != this.value) {
                try {
                    ret = (Number)this.value;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return ret;
        }

        public Boolean getBooleanValue() {
            Boolean ret = false;
            if (null != this.defaultValue) {
                try {
                    ret = (Boolean)this.defaultValue;
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
            }
            if (null != this.value) {
                try {
                    ret = (Boolean)this.value;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return ret;
        }
    }
}

