/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.surveys;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.mixpanel.android.R;

public class FadingImageView
extends ImageView {
    private Matrix mGradientMatrix;
    private Paint mAlphaGradientPaint;
    private Shader mAlphaGradientShader;
    private Paint mDarkenGradientPaint;
    private Shader mDarkenGradientShader;
    private int mHeight;
    private int mWidth;

    public FadingImageView(Context context) {
        super(context);
        this.initFadingImageView();
    }

    public FadingImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initFadingImageView();
    }

    public FadingImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initFadingImageView();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mHeight = this.getHeight();
        this.mWidth = this.getWidth();
        int parentHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        LinearLayout container = (LinearLayout)this.getParent();
        if (this.getResources().getConfiguration().orientation == 1) {
            View root = this.getRootView();
            View bottomWrapperView = root.findViewById(R.id.com_mixpanel_android_notification_bottom_wrapper);
            int bottomWrapperHeight = 0;
            if (null != bottomWrapperView && bottomWrapperView.getHeight() != 0) {
                bottomWrapperHeight = bottomWrapperView.getHeight();
            }
            Resources r = this.getResources();
            float extraPx = TypedValue.applyDimension((int)1, (float)15.0f, (DisplayMetrics)r.getDisplayMetrics());
            this.mGradientMatrix.setScale(1.0f, (float)(parentHeight + container.getPaddingBottom() - bottomWrapperHeight) + extraPx);
        } else {
            this.mGradientMatrix.setScale(1.0f, (float)parentHeight);
        }
        this.mAlphaGradientShader.setLocalMatrix(this.mGradientMatrix);
        this.mDarkenGradientShader.setLocalMatrix(this.mGradientMatrix);
    }

    public void draw(Canvas canvas) {
        Rect clip = canvas.getClipBounds();
        int restoreTo = canvas.saveLayer(0.0f, 0.0f, (float)clip.width(), (float)clip.height(), null, 31);
        super.draw(canvas);
        if (this.getResources().getConfiguration().orientation == 1) {
            canvas.drawRect(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight, this.mAlphaGradientPaint);
        }
        canvas.restoreToCount(restoreTo);
    }

    private void initFadingImageView() {
        this.mGradientMatrix = new Matrix();
        this.mAlphaGradientPaint = new Paint();
        this.mAlphaGradientShader = new LinearGradient(0.0f, 0.0f, 0.0f, 1.0f, new int[]{-16777216, -16777216, -452984832, 0}, new float[]{0.0f, 0.7f, 0.8f, 1.0f}, Shader.TileMode.CLAMP);
        this.mAlphaGradientPaint.setShader(this.mAlphaGradientShader);
        this.mAlphaGradientPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        this.mDarkenGradientPaint = new Paint();
        this.mDarkenGradientShader = new LinearGradient(0.0f, 0.0f, 0.0f, 1.0f, new int[]{0, 0, -16777216, -16777216}, new float[]{0.0f, 0.85f, 0.98f, 1.0f}, Shader.TileMode.CLAMP);
        this.mDarkenGradientPaint.setShader(this.mDarkenGradientShader);
        this.mAlphaGradientPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
    }
}

