/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.viewcrawler;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Base64;
import android.util.Log;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.util.HttpService;
import com.mixpanel.android.util.RemoteService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLSocketFactory;

class ImageStore {
    private final File mDirectory;
    private final RemoteService mPoster;
    private final MessageDigest mDigest;
    private final MPConfig mConfig;
    private static final String DEFAULT_DIRECTORY_NAME = "MixpanelAPI.Images";
    private static final int MAX_BITMAP_SIZE = 10000000;
    private static final String FILE_PREFIX = "MP_IMG_";
    private static final String LOGTAG = "MixpanelAPI.ImageStore";

    public ImageStore(Context context) {
        this(context, DEFAULT_DIRECTORY_NAME, new HttpService());
    }

    public ImageStore(Context context, String directoryName, RemoteService poster) {
        MessageDigest useDigest;
        this.mDirectory = context.getDir(directoryName, 0);
        this.mPoster = poster;
        this.mConfig = MPConfig.getInstance(context);
        try {
            useDigest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            Log.w((String)LOGTAG, (String)"Images won't be stored because this platform doesn't supply a SHA1 hash function");
            useDigest = null;
        }
        this.mDigest = useDigest;
    }

    public Bitmap getImage(String url) throws CantGetImageException {
        Bitmap bitmap;
        File file = this.storedFile(url);
        byte[] bytes = null;
        if (null == file || !file.exists()) {
            try {
                SSLSocketFactory factory = this.mConfig.getSSLSocketFactory();
                bytes = this.mPoster.performRequest(url, null, factory);
            }
            catch (IOException e) {
                throw new CantGetImageException("Can't download bitmap", e);
            }
            catch (RemoteService.ServiceUnavailableException e) {
                throw new CantGetImageException("Couldn't download image due to service availability", e);
            }
        }
        if (null != bytes) {
            if (null != file && bytes.length < 10000000) {
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(file);
                    ((OutputStream)out).write(bytes);
                }
                catch (FileNotFoundException e) {
                    throw new CantGetImageException("It appears that ImageStore is misconfigured, or disk storage is unavailable- can't write to bitmap directory", e);
                }
                catch (IOException e) {
                    throw new CantGetImageException("Can't store bitmap", e);
                }
                finally {
                    if (null != out) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (IOException e) {
                            Log.w((String)LOGTAG, (String)"Problem closing output file", (Throwable)e);
                        }
                    }
                }
            }
            if (null == (bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length))) {
                throw new CantGetImageException("Downloaded data could not be interpreted as a bitmap");
            }
        } else {
            bitmap = BitmapFactory.decodeFile((String)file.getAbsolutePath());
            if (null == bitmap) {
                boolean ignored = file.delete();
                throw new CantGetImageException("Bitmap on disk can't be opened or was corrupt");
            }
        }
        return bitmap;
    }

    public void clearStorage() {
        for (File file : this.mDirectory.listFiles()) {
            String filename = file.getName();
            if (!filename.startsWith(FILE_PREFIX)) continue;
            boolean ignored = file.delete();
        }
    }

    public void deleteStorage(String url) {
        File file = this.storedFile(url);
        if (null != file) {
            boolean bl = file.delete();
        }
    }

    private File storedFile(String url) {
        if (null == this.mDigest) {
            return null;
        }
        byte[] hashed = this.mDigest.digest(url.getBytes());
        String safeName = FILE_PREFIX + Base64.encodeToString((byte[])hashed, (int)10);
        return new File(this.mDirectory, safeName);
    }

    public static class CantGetImageException
    extends Exception {
        public CantGetImageException(String message) {
            super(message);
        }

        public CantGetImageException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

