/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.MixpanelAPI;

public class GCMReceiver
extends BroadcastReceiver {
    private static final String LOGTAG = "MixpanelAPI.GCMReceiver";

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if ("com.google.android.c2dm.intent.REGISTRATION".equals(action)) {
            this.handleRegistrationIntent(intent);
        } else if ("com.google.android.c2dm.intent.RECEIVE".equals(action)) {
            this.handleNotificationIntent(context, intent);
        }
    }

    private void handleRegistrationIntent(Intent intent) {
        final String registration = intent.getStringExtra("registration_id");
        if (intent.getStringExtra("error") != null) {
            Log.e((String)LOGTAG, (String)("Error when registering for GCM: " + intent.getStringExtra("error")));
        } else if (registration != null) {
            if (MPConfig.DEBUG) {
                Log.d((String)LOGTAG, (String)("Registering GCM ID: " + registration));
            }
            MixpanelAPI.allInstances(new MixpanelAPI.InstanceProcessor(){

                @Override
                public void process(MixpanelAPI api) {
                    api.getPeople().setPushRegistrationId(registration);
                }
            });
        } else if (intent.getStringExtra("unregistered") != null) {
            if (MPConfig.DEBUG) {
                Log.d((String)LOGTAG, (String)"Unregistering from GCM");
            }
            MixpanelAPI.allInstances(new MixpanelAPI.InstanceProcessor(){

                @Override
                public void process(MixpanelAPI api) {
                    api.getPeople().clearPushRegistrationId();
                }
            });
        }
    }

    private void handleNotificationIntent(Context context, Intent intent) {
        String message = intent.getStringExtra("mp_message");
        if (message == null) {
            return;
        }
        if (MPConfig.DEBUG) {
            Log.d((String)LOGTAG, (String)("MP GCM notification received: " + message));
        }
        PackageManager manager = context.getPackageManager();
        Intent appIntent = manager.getLaunchIntentForPackage(context.getPackageName());
        CharSequence notificationTitle = "";
        int notificationIcon = 17301651;
        try {
            ApplicationInfo appInfo = manager.getApplicationInfo(context.getPackageName(), 0);
            notificationTitle = manager.getApplicationLabel(appInfo);
            notificationIcon = appInfo.icon;
        }
        catch (PackageManager.NameNotFoundException e) {
            // empty catch block
        }
        PendingIntent contentIntent = PendingIntent.getActivity((Context)context.getApplicationContext(), (int)0, (Intent)appIntent, (int)0x8000000);
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        Notification notification = Build.VERSION.SDK_INT >= 16 ? this.makeNotificationSDK16OrHigher(context, contentIntent, notificationIcon, notificationTitle, message) : (Build.VERSION.SDK_INT >= 11 ? this.makeNotificationSDK11OrHigher(context, contentIntent, notificationIcon, notificationTitle, message) : this.makeNotificationSDKLessThan11(context, contentIntent, notificationIcon, notificationTitle, message));
        notificationManager.notify(0, notification);
    }

    @TargetApi(value=8)
    private Notification makeNotificationSDKLessThan11(Context context, PendingIntent intent, int notificationIcon, CharSequence title, CharSequence message) {
        Notification n = new Notification(notificationIcon, message, System.currentTimeMillis());
        n.flags |= 0x10;
        n.setLatestEventInfo(context, title, message, intent);
        return n;
    }

    @TargetApi(value=11)
    private Notification makeNotificationSDK11OrHigher(Context context, PendingIntent intent, int notificationIcon, CharSequence title, CharSequence message) {
        Notification.Builder builder = new Notification.Builder(context).setSmallIcon(notificationIcon).setTicker(message).setWhen(System.currentTimeMillis()).setContentTitle(title).setContentText(message).setContentIntent(intent);
        Notification n = builder.getNotification();
        n.flags |= 0x10;
        return n;
    }

    @SuppressLint(value={"NewApi"})
    @TargetApi(value=16)
    private Notification makeNotificationSDK16OrHigher(Context context, PendingIntent intent, int notificationIcon, CharSequence title, CharSequence message) {
        Notification.Builder builder = new Notification.Builder(context).setSmallIcon(notificationIcon).setTicker(message).setWhen(System.currentTimeMillis()).setContentTitle(title).setContentText(message).setContentIntent(intent).setStyle((Notification.Style)new Notification.BigTextStyle().bigText(message));
        Notification n = builder.build();
        n.flags |= 0x10;
        return n;
    }
}

