/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.viewcrawler;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.hardware.Sensor;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.JsonWriter;
import android.util.Log;
import android.util.Pair;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import com.mixpanel.android.util.JSONUtils;
import com.mixpanel.android.viewcrawler.DynamicEventTracker;
import com.mixpanel.android.viewcrawler.EditProtocol;
import com.mixpanel.android.viewcrawler.EditState;
import com.mixpanel.android.viewcrawler.EditorConnection;
import com.mixpanel.android.viewcrawler.FlipGesture;
import com.mixpanel.android.viewcrawler.TrackingDebug;
import com.mixpanel.android.viewcrawler.Tweaks;
import com.mixpanel.android.viewcrawler.UpdatesFromMixpanel;
import com.mixpanel.android.viewcrawler.ViewSnapshot;
import com.mixpanel.android.viewcrawler.ViewVisitor;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@TargetApi(value=16)
public class ViewCrawler
implements UpdatesFromMixpanel,
TrackingDebug {
    private final List<Pair<String, JSONObject>> mPersistentChanges;
    private final List<Pair<String, JSONObject>> mEditorChanges;
    private final List<Pair<String, JSONObject>> mPersistentEventBindings;
    private final List<Pair<String, JSONObject>> mEditorEventBindings;
    private final MPConfig mConfig;
    private final DynamicEventTracker mTracker;
    private final SSLSocketFactory mSSLSocketFactory;
    private final EditProtocol mProtocol;
    private final EditState mEditState;
    private final Tweaks mTweaks;
    private final Map<String, String> mDeviceInfo;
    private final ViewCrawlerHandler mMessageThreadHandler;
    private static final String SHARED_PREF_EDITS_FILE = "mixpanel.viewcrawler.changes";
    private static final String SHARED_PREF_CHANGES_KEY = "mixpanel.viewcrawler.changes";
    private static final String SHARED_PREF_BINDINGS_KEY = "mixpanel.viewcrawler.bindings";
    private static final int MESSAGE_INITIALIZE_CHANGES = 0;
    private static final int MESSAGE_CONNECT_TO_EDITOR = 1;
    private static final int MESSAGE_SEND_STATE_FOR_EDITING = 2;
    private static final int MESSAGE_HANDLE_EDITOR_CHANGES_RECEIVED = 3;
    private static final int MESSAGE_SEND_DEVICE_INFO = 4;
    private static final int MESSAGE_EVENT_BINDINGS_RECEIVED = 6;
    private static final int MESSAGE_HANDLE_EDITOR_BINDINGS_RECEIVED = 8;
    private static final int MESSAGE_SEND_EVENT_TRACKED = 9;
    private static final int MESSAGE_HANDLE_EDITOR_CLOSED = 10;
    private static final int EMULATOR_CONNECT_ATTEMPT_INTERVAL_MILLIS = 30000;
    private static final String LOGTAG = "MixpanelAPI.ViewCrawler";

    public ViewCrawler(Context context, String token, MixpanelAPI mixpanel) {
        SSLSocketFactory foundSSLFactory;
        this.mConfig = MPConfig.getInstance(context);
        this.mPersistentChanges = new ArrayList<Pair<String, JSONObject>>();
        this.mEditorChanges = new ArrayList<Pair<String, JSONObject>>();
        this.mPersistentEventBindings = new ArrayList<Pair<String, JSONObject>>();
        this.mEditorEventBindings = new ArrayList<Pair<String, JSONObject>>();
        this.mProtocol = new EditProtocol(context);
        this.mEditState = new EditState();
        this.mTweaks = new Tweaks();
        this.mDeviceInfo = mixpanel.getDeviceInfo();
        Application app = (Application)context.getApplicationContext();
        app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new LifecycleCallbacks());
        HandlerThread thread = new HandlerThread(ViewCrawler.class.getCanonicalName());
        thread.setPriority(10);
        thread.start();
        this.mMessageThreadHandler = new ViewCrawlerHandler(context, token, thread.getLooper());
        this.mMessageThreadHandler.sendMessage(this.mMessageThreadHandler.obtainMessage(0));
        this.mTracker = new DynamicEventTracker(mixpanel, this.mMessageThreadHandler);
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, null, null);
            foundSSLFactory = sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            Log.i((String)LOGTAG, (String)"System has no SSL support. Built-in events editor will not be available", (Throwable)e);
            foundSSLFactory = null;
        }
        this.mSSLSocketFactory = foundSSLFactory;
    }

    @Override
    public Tweaks getTweaks() {
        return this.mTweaks;
    }

    @Override
    public void setEventBindings(JSONArray bindings) {
        Message msg = this.mMessageThreadHandler.obtainMessage(6);
        msg.obj = bindings;
        this.mMessageThreadHandler.sendMessage(msg);
    }

    @Override
    public void reportTrack(String eventName) {
        Message m = this.mMessageThreadHandler.obtainMessage();
        m.what = 9;
        m.obj = eventName;
        this.mMessageThreadHandler.sendMessage(m);
    }

    private class Editor
    implements EditorConnection.Editor {
        private Editor() {
        }

        @Override
        public void sendSnapshot(JSONObject message) {
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(2);
            msg.obj = message;
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }

        @Override
        public void performEdit(JSONObject message) {
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(3);
            msg.obj = message;
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }

        @Override
        public void bindEvents(JSONObject message) {
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(8);
            msg.obj = message;
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }

        @Override
        public void sendDeviceInfo() {
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(4);
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }

        @Override
        public void cleanup() {
            Message msg = ViewCrawler.this.mMessageThreadHandler.obtainMessage(10);
            ViewCrawler.this.mMessageThreadHandler.sendMessage(msg);
        }
    }

    private class ViewCrawlerHandler
    extends Handler {
        private EditorConnection mEditorConnection;
        private ViewSnapshot mSnapshot;
        private final Context mContext;
        private final String mToken;

        public ViewCrawlerHandler(Context context, String token, Looper looper) {
            super(looper);
            this.mContext = context;
            this.mToken = token;
            this.mSnapshot = null;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    this.initializeChanges();
                    break;
                }
                case 1: {
                    this.connectToEditor();
                    break;
                }
                case 4: {
                    this.sendDeviceInfo();
                    break;
                }
                case 2: {
                    this.sendSnapshot((JSONObject)msg.obj);
                    break;
                }
                case 9: {
                    this.sendReportTrackToEditor((String)msg.obj);
                    break;
                }
                case 3: {
                    this.handleEditorChangeReceived((JSONObject)msg.obj);
                    break;
                }
                case 6: {
                    this.handleEventBindingsReceived((JSONArray)msg.obj);
                    break;
                }
                case 8: {
                    this.handleEditorBindingsReceived((JSONObject)msg.obj);
                    break;
                }
                case 10: {
                    this.handleEditorClosed();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initializeChanges() {
            block11: {
                SharedPreferences preferences = this.getSharedPreferences();
                String storedChanges = preferences.getString("mixpanel.viewcrawler.changes", null);
                String storedBindings = preferences.getString(ViewCrawler.SHARED_PREF_BINDINGS_KEY, null);
                try {
                    String targetActivity;
                    int i;
                    List list;
                    if (null != storedChanges) {
                        JSONArray changes = new JSONArray(storedChanges);
                        list = ViewCrawler.this.mPersistentChanges;
                        synchronized (list) {
                            ViewCrawler.this.mPersistentChanges.clear();
                            for (i = 0; i < changes.length(); ++i) {
                                JSONObject changeMessage = changes.getJSONObject(i);
                                targetActivity = JSONUtils.optionalStringKey(changeMessage, "target");
                                JSONObject change = changeMessage.getJSONObject("change");
                                ViewCrawler.this.mPersistentChanges.add(new Pair((Object)targetActivity, (Object)change));
                            }
                        }
                    }
                    if (null == storedBindings) break block11;
                    JSONArray bindings = new JSONArray(storedBindings);
                    list = ViewCrawler.this.mPersistentEventBindings;
                    synchronized (list) {
                        ViewCrawler.this.mPersistentEventBindings.clear();
                        for (i = 0; i < bindings.length(); ++i) {
                            JSONObject event = bindings.getJSONObject(i);
                            targetActivity = JSONUtils.optionalStringKey(event, "target_activity");
                            ViewCrawler.this.mPersistentEventBindings.add(new Pair((Object)targetActivity, (Object)event));
                        }
                    }
                }
                catch (JSONException e) {
                    Log.i((String)ViewCrawler.LOGTAG, (String)"JSON error when initializing saved changes, clearing persistent memory", (Throwable)e);
                    SharedPreferences.Editor editor = preferences.edit();
                    editor.remove("mixpanel.viewcrawler.changes");
                    editor.remove(ViewCrawler.SHARED_PREF_BINDINGS_KEY);
                    editor.apply();
                }
            }
            this.updateEditState();
        }

        private void connectToEditor() {
            if (MPConfig.DEBUG) {
                Log.v((String)ViewCrawler.LOGTAG, (String)"connecting to editor");
            }
            if (this.mEditorConnection != null && this.mEditorConnection.isValid()) {
                if (MPConfig.DEBUG) {
                    Log.v((String)ViewCrawler.LOGTAG, (String)"There is already a valid connection to an events editor.");
                }
                return;
            }
            if (null == ViewCrawler.this.mSSLSocketFactory) {
                if (MPConfig.DEBUG) {
                    Log.v((String)ViewCrawler.LOGTAG, (String)"SSL is not available on this device, no connection will be attempted to the events editor.");
                }
                return;
            }
            String url = MPConfig.getInstance(this.mContext).getEditorUrl() + this.mToken;
            try {
                Socket sslSocket = ViewCrawler.this.mSSLSocketFactory.createSocket();
                this.mEditorConnection = new EditorConnection(new URI(url), new Editor(), sslSocket);
            }
            catch (URISyntaxException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)("Error parsing URI " + url + " for editor websocket"), (Throwable)e);
            }
            catch (EditorConnection.EditorConnectionException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)("Error connecting to URI " + url), (Throwable)e);
            }
            catch (IOException e) {
                Log.i((String)ViewCrawler.LOGTAG, (String)"Can't create SSL Socket to connect to editor service", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendError(String errorMessage) {
            JSONObject errorObject = new JSONObject();
            try {
                errorObject.put("error_message", (Object)errorMessage);
            }
            catch (JSONException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Apparently impossible JSONException", (Throwable)e);
            }
            OutputStreamWriter writer = new OutputStreamWriter(this.mEditorConnection.getBufferedOutputStream());
            try {
                writer.write("{\"type\": \"error\", ");
                writer.write("\"payload\": ");
                writer.write(errorObject.toString());
                writer.write("}");
            }
            catch (IOException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Can't write error message to editor", (Throwable)e);
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Could not close output writer to editor", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendDeviceInfo() {
            BufferedOutputStream out = this.mEditorConnection.getBufferedOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(out);
            try {
                writer.write("{\"type\": \"device_info_response\",");
                writer.write("\"payload\": {");
                writer.write("\"device_type\": \"Android\",");
                writer.write("\"device_name\":");
                writer.write(JSONObject.quote((String)(Build.BRAND + "/" + Build.MODEL)));
                writer.write(",");
                writer.write("\"tweaks\":");
                writer.write(new JSONObject(ViewCrawler.this.mTweaks.getAll()).toString());
                for (Map.Entry entry : ViewCrawler.this.mDeviceInfo.entrySet()) {
                    writer.write(",");
                    writer.write(JSONObject.quote((String)((String)entry.getKey())));
                    writer.write(":");
                    writer.write(JSONObject.quote((String)((String)entry.getValue())));
                }
                writer.write("}");
                writer.write("}");
            }
            catch (IOException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Can't write device_info to server", (Throwable)e);
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Can't close websocket writer", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendSnapshot(JSONObject message) {
            try {
                JSONObject payload = message.getJSONObject("payload");
                if (payload.has("config")) {
                    this.mSnapshot = ViewCrawler.this.mProtocol.readSnapshotConfig(payload);
                }
            }
            catch (JSONException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Payload with snapshot config required with snapshot request", (Throwable)e);
                this.sendError("Payload with snapshot config required with snapshot request");
                return;
            }
            catch (EditProtocol.BadInstructionsException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Editor sent malformed message with snapshot request", (Throwable)e);
                this.sendError(e.getMessage());
                return;
            }
            if (null == this.mSnapshot) {
                this.sendError("No snapshot configuration was sent.");
                Log.w((String)ViewCrawler.LOGTAG, (String)"Mixpanel editor is misconfigured, sent a snapshot request without configuration.");
            }
            BufferedOutputStream out = this.mEditorConnection.getBufferedOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(out);
            try {
                writer.write("{");
                writer.write("\"type\": \"snapshot_response\",");
                writer.write("\"payload\": {");
                writer.write("\"activities\":");
                writer.flush();
                this.mSnapshot.snapshots(ViewCrawler.this.mEditState, out);
                writer.write("}");
                writer.write("}");
            }
            catch (IOException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Can't write snapshot request to server", (Throwable)e);
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Can't close writer.", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendReportTrackToEditor(String eventName) {
            if (this.mEditorConnection == null || !this.mEditorConnection.isValid()) {
                return;
            }
            BufferedOutputStream out = this.mEditorConnection.getBufferedOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(out);
            JsonWriter j = new JsonWriter((Writer)writer);
            try {
                j.beginObject();
                j.name("type").value("track_message");
                j.name("payload");
                j.beginObject();
                j.name("event_name").value(eventName);
                j.endObject();
                j.endObject();
                j.flush();
            }
            catch (IOException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Can't write track_message to server", (Throwable)e);
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    Log.e((String)ViewCrawler.LOGTAG, (String)"Can't close writer.", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleEditorChangeReceived(JSONObject changeMessage) {
            try {
                String targetActivity = JSONUtils.optionalStringKey(changeMessage, "target");
                JSONObject change = changeMessage.getJSONObject("change");
                List list = ViewCrawler.this.mEditorChanges;
                synchronized (list) {
                    ViewCrawler.this.mEditorChanges.add(new Pair((Object)targetActivity, (Object)change));
                }
                this.updateEditState();
            }
            catch (JSONException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Bad change request received", (Throwable)e);
            }
        }

        private void handleEventBindingsReceived(JSONArray eventBindings) {
            SharedPreferences preferences = this.getSharedPreferences();
            SharedPreferences.Editor editor = preferences.edit();
            editor.putString(ViewCrawler.SHARED_PREF_BINDINGS_KEY, eventBindings.toString());
            editor.apply();
            this.initializeChanges();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleEditorBindingsReceived(JSONObject message) {
            JSONArray eventBindings;
            try {
                JSONObject payload = message.getJSONObject("payload");
                eventBindings = payload.getJSONArray("events");
            }
            catch (JSONException e) {
                Log.e((String)ViewCrawler.LOGTAG, (String)"Bad event bindings received", (Throwable)e);
                return;
            }
            int eventCount = eventBindings.length();
            List list = ViewCrawler.this.mEditorEventBindings;
            synchronized (list) {
                ViewCrawler.this.mEditorEventBindings.clear();
                for (int i = 0; i < eventCount; ++i) {
                    try {
                        JSONObject event = eventBindings.getJSONObject(i);
                        String targetActivity = JSONUtils.optionalStringKey(event, "target_activity");
                        ViewCrawler.this.mEditorEventBindings.add(new Pair((Object)targetActivity, (Object)event));
                        continue;
                    }
                    catch (JSONException e) {
                        Log.e((String)ViewCrawler.LOGTAG, (String)("Bad event binding received from editor in " + eventBindings.toString()), (Throwable)e);
                    }
                }
            }
            this.updateEditState();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleEditorClosed() {
            List list = ViewCrawler.this.mEditorChanges;
            synchronized (list) {
                ViewCrawler.this.mEditorChanges.clear();
            }
            list = ViewCrawler.this.mEditorEventBindings;
            synchronized (list) {
                ViewCrawler.this.mEditorEventBindings.clear();
            }
            this.updateEditState();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateEditState() {
            ViewVisitor visitor;
            Pair changeInfo;
            int i;
            int size;
            ArrayList<Pair> newEdits = new ArrayList<Pair>();
            List list = ViewCrawler.this.mPersistentChanges;
            synchronized (list) {
                size = ViewCrawler.this.mPersistentChanges.size();
                for (i = 0; i < size; ++i) {
                    changeInfo = (Pair)ViewCrawler.this.mPersistentChanges.get(i);
                    try {
                        visitor = ViewCrawler.this.mProtocol.readEdit((JSONObject)changeInfo.second);
                        newEdits.add(new Pair(changeInfo.first, (Object)visitor));
                        continue;
                    }
                    catch (EditProtocol.InapplicableInstructionsException e) {
                        Log.i((String)ViewCrawler.LOGTAG, (String)e.getMessage());
                        continue;
                    }
                    catch (EditProtocol.BadInstructionsException e) {
                        Log.e((String)ViewCrawler.LOGTAG, (String)"Bad persistent change request cannot be applied.", (Throwable)e);
                    }
                }
            }
            list = ViewCrawler.this.mEditorChanges;
            synchronized (list) {
                size = ViewCrawler.this.mEditorChanges.size();
                for (i = 0; i < size; ++i) {
                    changeInfo = (Pair)ViewCrawler.this.mEditorChanges.get(i);
                    try {
                        visitor = ViewCrawler.this.mProtocol.readEdit((JSONObject)changeInfo.second);
                        newEdits.add(new Pair(changeInfo.first, (Object)visitor));
                        continue;
                    }
                    catch (EditProtocol.InapplicableInstructionsException e) {
                        Log.i((String)ViewCrawler.LOGTAG, (String)e.getMessage());
                        continue;
                    }
                    catch (EditProtocol.BadInstructionsException e) {
                        Log.e((String)ViewCrawler.LOGTAG, (String)"Bad editor change request cannot be applied.", (Throwable)e);
                    }
                }
            }
            list = ViewCrawler.this.mPersistentEventBindings;
            synchronized (list) {
                size = ViewCrawler.this.mPersistentEventBindings.size();
                for (i = 0; i < size; ++i) {
                    changeInfo = (Pair)ViewCrawler.this.mPersistentEventBindings.get(i);
                    try {
                        visitor = ViewCrawler.this.mProtocol.readEventBinding((JSONObject)changeInfo.second, ViewCrawler.this.mTracker);
                        newEdits.add(new Pair(changeInfo.first, (Object)visitor));
                        continue;
                    }
                    catch (EditProtocol.InapplicableInstructionsException e) {
                        Log.i((String)ViewCrawler.LOGTAG, (String)e.getMessage());
                        continue;
                    }
                    catch (EditProtocol.BadInstructionsException e) {
                        Log.e((String)ViewCrawler.LOGTAG, (String)"Bad persistent event binding cannot be applied.", (Throwable)e);
                    }
                }
            }
            list = ViewCrawler.this.mEditorEventBindings;
            synchronized (list) {
                size = ViewCrawler.this.mEditorEventBindings.size();
                for (i = 0; i < size; ++i) {
                    changeInfo = (Pair)ViewCrawler.this.mEditorEventBindings.get(i);
                    try {
                        visitor = ViewCrawler.this.mProtocol.readEventBinding((JSONObject)changeInfo.second, ViewCrawler.this.mTracker);
                        newEdits.add(new Pair(changeInfo.first, (Object)visitor));
                        continue;
                    }
                    catch (EditProtocol.InapplicableInstructionsException e) {
                        Log.i((String)ViewCrawler.LOGTAG, (String)e.getMessage());
                        continue;
                    }
                    catch (EditProtocol.BadInstructionsException e) {
                        Log.e((String)ViewCrawler.LOGTAG, (String)"Bad editor event binding cannot be applied.", (Throwable)e);
                    }
                }
            }
            HashMap<String, List<ViewVisitor>> editMap = new HashMap<String, List<ViewVisitor>>();
            int totalEdits = newEdits.size();
            for (i = 0; i < totalEdits; ++i) {
                List<Object> mapElement;
                Pair next = (Pair)newEdits.get(i);
                if (editMap.containsKey(next.first)) {
                    mapElement = (List)editMap.get(next.first);
                } else {
                    mapElement = new ArrayList();
                    editMap.put((String)next.first, mapElement);
                }
                mapElement.add(next.second);
            }
            ViewCrawler.this.mEditState.setEdits(editMap);
        }

        private SharedPreferences getSharedPreferences() {
            String sharedPrefsName = "mixpanel.viewcrawler.changes" + this.mToken;
            return this.mContext.getSharedPreferences(sharedPrefsName, 0);
        }
    }

    private class LifecycleCallbacks
    implements Application.ActivityLifecycleCallbacks,
    FlipGesture.OnFlipGestureListener {
        private final FlipGesture mFlipGesture = new FlipGesture(this);
        private final EmulatorConnector mEmulatorConnector;

        public LifecycleCallbacks() {
            this.mEmulatorConnector = new EmulatorConnector();
        }

        @Override
        public void onFlipGesture() {
            Message message = ViewCrawler.this.mMessageThreadHandler.obtainMessage(1);
            ViewCrawler.this.mMessageThreadHandler.sendMessage(message);
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
            this.installConnectionSensor(activity);
            ViewCrawler.this.mEditState.add(activity);
        }

        public void onActivityPaused(Activity activity) {
            ViewCrawler.this.mEditState.remove(activity);
            if (ViewCrawler.this.mEditState.isEmpty()) {
                this.uninstallConnectionSensor(activity);
            }
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
        }

        private void installConnectionSensor(Activity activity) {
            if (this.isInEmulator() && !ViewCrawler.this.mConfig.getDisableEmulatorBindingUI()) {
                this.mEmulatorConnector.start();
            } else if (!ViewCrawler.this.mConfig.getDisableGestureBindingUI()) {
                SensorManager sensorManager = (SensorManager)activity.getSystemService("sensor");
                Sensor accelerometer = sensorManager.getDefaultSensor(1);
                sensorManager.registerListener((SensorEventListener)this.mFlipGesture, accelerometer, 3);
            }
        }

        private void uninstallConnectionSensor(Activity activity) {
            if (this.isInEmulator() && !ViewCrawler.this.mConfig.getDisableEmulatorBindingUI()) {
                this.mEmulatorConnector.stop();
            } else if (!ViewCrawler.this.mConfig.getDisableGestureBindingUI()) {
                SensorManager sensorManager = (SensorManager)activity.getSystemService("sensor");
                sensorManager.unregisterListener((SensorEventListener)this.mFlipGesture);
            }
        }

        private boolean isInEmulator() {
            if (!Build.HARDWARE.equals("goldfish")) {
                return false;
            }
            if (!Build.BRAND.startsWith("generic")) {
                return false;
            }
            if (!Build.DEVICE.startsWith("generic")) {
                return false;
            }
            if (!Build.PRODUCT.contains("sdk")) {
                return false;
            }
            return Build.MODEL.toLowerCase().contains("sdk");
        }
    }

    private class EmulatorConnector
    implements Runnable {
        private volatile boolean mStopped = true;

        @Override
        public void run() {
            if (!this.mStopped) {
                Message message = ViewCrawler.this.mMessageThreadHandler.obtainMessage(1);
                ViewCrawler.this.mMessageThreadHandler.sendMessage(message);
            }
            ViewCrawler.this.mMessageThreadHandler.postDelayed(this, 30000L);
        }

        public void start() {
            this.mStopped = false;
            ViewCrawler.this.mMessageThreadHandler.post(this);
        }

        public void stop() {
            this.mStopped = true;
            ViewCrawler.this.mMessageThreadHandler.removeCallbacks(this);
        }
    }
}

