/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.viewcrawler;

import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import com.mixpanel.android.viewcrawler.ViewVisitor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class DynamicEventTracker
implements ViewVisitor.OnEventListener {
    private final MixpanelAPI mMixpanel;
    private final Handler mHandler;
    private final Runnable mTask;
    private final Map<Signature, UnsentEvent> mDebouncedEvents;
    private static final int MAX_PROPERTY_LENGTH = 128;
    private static final int DEBOUNCE_TIME_MILLIS = 1000;
    private static String LOGTAG = "MixpanelAPI.DynamicEventTracker";

    public DynamicEventTracker(MixpanelAPI mixpanel, Handler homeHandler) {
        this.mMixpanel = mixpanel;
        this.mDebouncedEvents = new HashMap<Signature, UnsentEvent>();
        this.mTask = new SendDebouncedTask();
        this.mHandler = homeHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void OnEvent(View v, String eventName, boolean debounce) {
        long moment = System.currentTimeMillis();
        JSONObject properties = new JSONObject();
        try {
            String text = DynamicEventTracker.textPropertyFromView(v);
            properties.put("$text", (Object)text);
            properties.put("$from_binding", true);
            properties.put("time", moment / 1000L);
        }
        catch (JSONException e) {
            Log.e((String)LOGTAG, (String)"Can't format properties from view due to JSON issue", (Throwable)e);
        }
        if (debounce) {
            Signature eventSignature = new Signature(v, eventName);
            UnsentEvent event = new UnsentEvent(eventName, properties, moment);
            Map<Signature, UnsentEvent> map = this.mDebouncedEvents;
            synchronized (map) {
                boolean needsRestart = this.mDebouncedEvents.isEmpty();
                this.mDebouncedEvents.put(eventSignature, event);
                if (needsRestart) {
                    this.mHandler.postDelayed(this.mTask, 1000L);
                }
            }
        } else {
            this.mMixpanel.track(eventName, properties);
        }
    }

    private static String textPropertyFromView(View v) {
        String ret = null;
        if (v instanceof TextView) {
            TextView textV = (TextView)v;
            CharSequence retSequence = textV.getText();
            if (null != retSequence) {
                ret = retSequence.toString();
            }
        } else if (v instanceof ViewGroup) {
            StringBuilder builder = new StringBuilder();
            ViewGroup vGroup = (ViewGroup)v;
            int childCount = vGroup.getChildCount();
            boolean textSeen = false;
            for (int i = 0; i < childCount && builder.length() < 128; ++i) {
                View child = vGroup.getChildAt(i);
                String childText = DynamicEventTracker.textPropertyFromView(child);
                if (null == childText || childText.length() <= 0) continue;
                if (textSeen) {
                    builder.append(", ");
                }
                builder.append(childText);
                textSeen = true;
            }
            if (builder.length() > 128) {
                ret = builder.substring(0, 128);
            } else if (textSeen) {
                ret = builder.toString();
            }
        }
        return ret;
    }

    private static class UnsentEvent {
        public final long timeSentMillis;
        public final String eventName;
        public final JSONObject properties;

        public UnsentEvent(String name, JSONObject props, long timeSent) {
            this.eventName = name;
            this.properties = props;
            this.timeSentMillis = timeSent;
        }
    }

    private static class Signature {
        private final int mHashCode;

        public Signature(View view, String eventName) {
            this.mHashCode = view.hashCode() ^ eventName.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof Signature) {
                return this.mHashCode == o.hashCode();
            }
            return false;
        }

        public int hashCode() {
            return this.mHashCode;
        }
    }

    private final class SendDebouncedTask
    implements Runnable {
        private SendDebouncedTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long now = System.currentTimeMillis();
            Map map = DynamicEventTracker.this.mDebouncedEvents;
            synchronized (map) {
                Iterator iter = DynamicEventTracker.this.mDebouncedEvents.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    UnsentEvent val = (UnsentEvent)entry.getValue();
                    if (now - val.timeSentMillis <= 1000L) continue;
                    DynamicEventTracker.this.mMixpanel.track(val.eventName, val.properties);
                    iter.remove();
                }
                if (!DynamicEventTracker.this.mDebouncedEvents.isEmpty()) {
                    DynamicEventTracker.this.mHandler.postDelayed((Runnable)this, 500L);
                }
            }
        }
    }
}

