/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.surveys;

import android.content.Context;
import android.database.DataSetObserver;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Interpolator;
import android.view.animation.RotateAnimation;
import android.view.animation.ScaleAnimation;
import android.view.animation.TranslateAnimation;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.mixpanel.android.R;
import com.mixpanel.android.mpmetrics.Survey;
import java.util.ArrayList;
import java.util.List;

public class CardCarouselLayout
extends ViewGroup {
    private static int EXIT_ANGLE = 45;
    private static float EXIT_SIZE = 0.8f;
    private static float EXIT_ROTATION_CENTER_X = 0.5f;
    private static float EXIT_ROTATION_CENTER_Y = 0.5f;
    private final List<View> mMatchParentChildren = new ArrayList<View>(1);
    private QuestionCard mVisibleCard;
    private QuestionCard mBackupCard;
    private OnQuestionAnsweredListener mListener = null;
    private static final long ANIMATION_DURATION_MILLIS = 330L;
    private static final long ANIMATION_ROTATION_MILLIS = 198L;

    public CardCarouselLayout(Context context) {
        super(context);
        this.initCards(context);
    }

    public CardCarouselLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initCards(context);
    }

    public CardCarouselLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initCards(context);
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    public void setOnQuestionAnsweredListener(OnQuestionAnsweredListener listener) {
        this.mListener = listener;
    }

    public void moveTo(Survey.Question question, String answerOrNull, Direction direction) throws UnrecognizedAnswerTypeException {
        QuestionCard tmp = this.mBackupCard;
        this.mBackupCard = this.mVisibleCard;
        this.mVisibleCard = tmp;
        this.mVisibleCard.showQuestionOnCard(question, answerOrNull);
        final View viewShowing = this.mBackupCard.getView();
        View viewToShow = this.mVisibleCard.getView();
        viewShowing.setVisibility(0);
        viewToShow.setVisibility(0);
        Animation exit = null;
        Animation entrance = null;
        switch (direction) {
            case FORWARD: {
                exit = this.exitLeft();
                entrance = this.enterRight();
                break;
            }
            case BACKWARD: {
                exit = this.exitRight();
                entrance = this.enterLeft();
            }
        }
        exit.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationEnd(Animation animation) {
                viewShowing.setVisibility(8);
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationStart(Animation animation) {
            }
        });
        viewShowing.startAnimation(exit);
        viewToShow.startAnimation(entrance);
        this.invalidate();
    }

    public void replaceTo(Survey.Question question, String answerOrNull) throws UnrecognizedAnswerTypeException {
        this.mVisibleCard.showQuestionOnCard(question, answerOrNull);
        this.removeAllViews();
        this.addView(this.mVisibleCard.getView());
        this.addView(this.mBackupCard.getView());
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int childHeightMeasureSpec;
        int childWidthMeasureSpec;
        ViewGroup.LayoutParams lp;
        int count = this.getChildCount();
        boolean measureMatchParentChildren = View.MeasureSpec.getMode((int)widthMeasureSpec) != 0x40000000 || View.MeasureSpec.getMode((int)heightMeasureSpec) != 0x40000000;
        this.mMatchParentChildren.clear();
        int maxHeight = 0;
        int maxWidth = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            lp = child.getLayoutParams();
            childWidthMeasureSpec = CardCarouselLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)lp.width);
            childHeightMeasureSpec = CardCarouselLayout.getChildMeasureSpec((int)heightMeasureSpec, (int)0, (int)lp.height);
            child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            maxWidth = Math.max(maxWidth, child.getMeasuredWidth());
            maxHeight = Math.max(maxHeight, child.getMeasuredHeight());
            if (!measureMatchParentChildren || lp.width != -1 && lp.height != -1) continue;
            this.mMatchParentChildren.add(child);
        }
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(CardCarouselLayout.resolveSize((int)maxWidth, (int)widthMeasureSpec), CardCarouselLayout.resolveSize((int)maxHeight, (int)heightMeasureSpec));
        for (View child : this.mMatchParentChildren) {
            lp = child.getLayoutParams();
            childWidthMeasureSpec = lp.width == -1 ? View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredWidth(), (int)0x40000000) : CardCarouselLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)lp.width);
            childHeightMeasureSpec = lp.height == -1 ? View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredHeight(), (int)0x40000000) : CardCarouselLayout.getChildMeasureSpec((int)heightMeasureSpec, (int)0, (int)lp.height);
            child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        View backup;
        View visible = this.mVisibleCard.getView();
        int visibleWidth = 0;
        if (visible.getVisibility() != 8) {
            visibleWidth = visible.getMeasuredWidth();
            int visibleHeight = visible.getMeasuredHeight();
            visible.layout(0, 0, visibleWidth, visibleHeight);
        }
        if ((backup = this.mBackupCard.getView()).getVisibility() != 8) {
            int backupWidth = backup.getMeasuredWidth();
            int backupHeight = backup.getMeasuredHeight();
            backup.layout(visibleWidth, 0, visibleWidth + backupWidth, backupHeight);
        }
    }

    private void initCards(Context context) {
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        View v1 = inflater.inflate(R.layout.com_mixpanel_android_question_card, (ViewGroup)this, false);
        this.mVisibleCard = new QuestionCard(v1);
        View v2 = inflater.inflate(R.layout.com_mixpanel_android_question_card, (ViewGroup)this, false);
        this.mBackupCard = new QuestionCard(v2);
        this.addView(v1);
        this.addView(v2);
    }

    private Animation enterRight() {
        AnimationSet set = new AnimationSet(false);
        RotateAnimation rotateIn = new RotateAnimation((float)EXIT_ANGLE, 0.0f, 1, EXIT_ROTATION_CENTER_X, 1, EXIT_ROTATION_CENTER_Y);
        rotateIn.setDuration(198L);
        set.addAnimation((Animation)rotateIn);
        ScaleAnimation scaleUp = new ScaleAnimation(EXIT_SIZE, 1.0f, EXIT_SIZE, 1.0f, 1, EXIT_ROTATION_CENTER_X, 1, EXIT_ROTATION_CENTER_Y);
        scaleUp.setDuration(198L);
        set.addAnimation((Animation)scaleUp);
        TranslateAnimation slideX = new TranslateAnimation(2, 1.3f, 2, 0.0f, 2, 0.0f, 2, 0.0f);
        slideX.setDuration(330L);
        set.addAnimation((Animation)slideX);
        return set;
    }

    private Animation exitRight() {
        AnimationSet set = new AnimationSet(false);
        RotateAnimation rotateOut = new RotateAnimation(0.0f, (float)EXIT_ANGLE, 1, EXIT_ROTATION_CENTER_X, 1, EXIT_ROTATION_CENTER_Y);
        rotateOut.setDuration(198L);
        rotateOut.setStartOffset(132L);
        set.addAnimation((Animation)rotateOut);
        ScaleAnimation scaleDown = new ScaleAnimation(1.0f, EXIT_SIZE, 1.0f, EXIT_SIZE, 1, EXIT_ROTATION_CENTER_X, 1, EXIT_ROTATION_CENTER_Y);
        scaleDown.setDuration(198L);
        scaleDown.setStartOffset(132L);
        set.addAnimation((Animation)scaleDown);
        TranslateAnimation slideX = new TranslateAnimation(2, -1.0f, 2, 0.3f, 2, 0.0f, 2, 0.0f);
        slideX.setInterpolator((Interpolator)new AccelerateInterpolator());
        slideX.setDuration(330L);
        set.addAnimation((Animation)slideX);
        return set;
    }

    private Animation enterLeft() {
        AnimationSet set = new AnimationSet(false);
        RotateAnimation rotateIn = new RotateAnimation((float)(-EXIT_ANGLE), 0.0f, 1, EXIT_ROTATION_CENTER_X, 1, EXIT_ROTATION_CENTER_Y);
        rotateIn.setDuration(198L);
        set.addAnimation((Animation)rotateIn);
        ScaleAnimation scaleUp = new ScaleAnimation(EXIT_SIZE, 1.0f, EXIT_SIZE, 1.0f, 1, EXIT_ROTATION_CENTER_X, 1, EXIT_ROTATION_CENTER_Y);
        scaleUp.setDuration(198L);
        set.addAnimation((Animation)scaleUp);
        TranslateAnimation slideX = new TranslateAnimation(2, -1.3f, 2, 0.0f, 2, 0.0f, 2, 0.0f);
        slideX.setDuration(330L);
        set.addAnimation((Animation)slideX);
        return set;
    }

    private Animation exitLeft() {
        AnimationSet set = new AnimationSet(false);
        RotateAnimation rotateOut = new RotateAnimation(0.0f, (float)(-EXIT_ANGLE), 1, EXIT_ROTATION_CENTER_X, 1, EXIT_ROTATION_CENTER_Y);
        rotateOut.setDuration(330L);
        rotateOut.setStartOffset(132L);
        set.addAnimation((Animation)rotateOut);
        ScaleAnimation scaleDown = new ScaleAnimation(1.0f, EXIT_SIZE, 1.0f, EXIT_SIZE, 1, EXIT_ROTATION_CENTER_X, 1, EXIT_ROTATION_CENTER_Y);
        scaleDown.setDuration(330L);
        scaleDown.setStartOffset(132L);
        set.addAnimation((Animation)scaleDown);
        TranslateAnimation slideX = new TranslateAnimation(2, -1.0f, 2, -2.3f, 2, 0.0f, 2, 0.0f);
        slideX.setInterpolator((Interpolator)new AccelerateInterpolator());
        slideX.setDuration(330L);
        set.addAnimation((Animation)slideX);
        return set;
    }

    private class QuestionCard {
        private Survey.Question mQuestion;
        private final View mCardView;
        private final TextView mPromptView;
        private final TextView mEditAnswerView;
        private final ListView mChoiceView;

        public QuestionCard(View cardView) {
            this.mCardView = cardView;
            this.mPromptView = (TextView)cardView.findViewWithTag((Object)"com_mixpanel_android_TAG_prompt_text");
            this.mEditAnswerView = (EditText)cardView.findViewWithTag((Object)"com_mixpanel_android_TAG_text_answer");
            this.mChoiceView = (ListView)cardView.findViewWithTag((Object)"com_mixpanel_android_TAG_choice_list");
            this.mEditAnswerView.setText((CharSequence)"");
            this.mEditAnswerView.setOnEditorActionListener(new TextView.OnEditorActionListener(){

                public boolean onEditorAction(TextView view, int actionId, KeyEvent event) {
                    boolean enterKeyDown;
                    boolean bl = enterKeyDown = event != null && event.getKeyCode() == 66 && event.getAction() == 0 && 0 == (event.getFlags() & 0x20);
                    if (enterKeyDown || actionId == 6) {
                        view.clearComposingText();
                        if (null != CardCarouselLayout.this.mListener) {
                            String answer = ((Object)view.getText()).toString();
                            CardCarouselLayout.this.mListener.onQuestionAnswered(QuestionCard.this.mQuestion, answer);
                        }
                        return true;
                    }
                    return false;
                }
            });
            this.mChoiceView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View v, int position, long id2) {
                    if (null != CardCarouselLayout.this.mListener) {
                        final String answer = parent.getItemAtPosition(position).toString();
                        CardCarouselLayout.this.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                CardCarouselLayout.this.mListener.onQuestionAnswered(QuestionCard.this.mQuestion, answer);
                            }
                        }, 165L);
                    }
                }
            });
        }

        public View getView() {
            return this.mCardView;
        }

        public void showQuestionOnCard(Survey.Question question, String answerOrNull) throws UnrecognizedAnswerTypeException {
            this.mQuestion = question;
            this.mPromptView.setText((CharSequence)this.mQuestion.getPrompt());
            InputMethodManager inputMethodManager = (InputMethodManager)this.mCardView.getContext().getSystemService("input_method");
            Survey.QuestionType questionType = question.getType();
            if (Survey.QuestionType.TEXT == questionType) {
                this.mChoiceView.setVisibility(8);
                this.mEditAnswerView.setVisibility(0);
                if (null != answerOrNull) {
                    this.mEditAnswerView.setText((CharSequence)answerOrNull);
                }
                if (CardCarouselLayout.this.getResources().getConfiguration().orientation == 1) {
                    this.mEditAnswerView.requestFocus();
                    inputMethodManager.showSoftInput((View)this.mEditAnswerView, 0);
                } else {
                    inputMethodManager.hideSoftInputFromWindow(this.mCardView.getWindowToken(), 0);
                }
            } else if (Survey.QuestionType.MULTIPLE_CHOICE == questionType) {
                inputMethodManager.hideSoftInputFromWindow(this.mCardView.getWindowToken(), 0);
                this.mChoiceView.setVisibility(0);
                this.mEditAnswerView.setVisibility(8);
                ChoiceAdapter answerAdapter = new ChoiceAdapter(question.getChoices(), LayoutInflater.from((Context)CardCarouselLayout.this.getContext()));
                this.mChoiceView.setAdapter((ListAdapter)answerAdapter);
                this.mChoiceView.clearChoices();
                if (null != answerOrNull) {
                    for (int i = 0; i < answerAdapter.getCount(); ++i) {
                        String item = answerAdapter.getItem(i);
                        if (!item.equals(answerOrNull)) continue;
                        this.mChoiceView.setItemChecked(i, true);
                    }
                }
            } else {
                throw new UnrecognizedAnswerTypeException("No way to display question type " + (Object)((Object)questionType));
            }
            this.mCardView.invalidate();
        }
    }

    private static class ChoiceAdapter
    implements ListAdapter {
        private final List<String> mChoices;
        private final LayoutInflater mInflater;
        private static final int VIEW_TYPE_FIRST = 0;
        private static final int VIEW_TYPE_LAST = 1;
        private static final int VIEW_TYPE_MIDDLE = 2;
        private static final int VIEW_TYPE_MAX = 3;

        public ChoiceAdapter(List<String> choices, LayoutInflater inflater) {
            this.mChoices = choices;
            this.mInflater = inflater;
        }

        public int getCount() {
            return this.mChoices.size();
        }

        public String getItem(int position) {
            return this.mChoices.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public int getItemViewType(int position) {
            if (0 == position) {
                return 0;
            }
            if (position == this.mChoices.size() - 1) {
                return 1;
            }
            return 2;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            int viewId = -1;
            if (null == convertView) {
                switch (this.getItemViewType(position)) {
                    case 0: {
                        viewId = R.layout.com_mixpanel_android_first_choice_answer;
                        break;
                    }
                    case 1: {
                        viewId = R.layout.com_mixpanel_android_last_choice_answer;
                        break;
                    }
                    case 2: {
                        viewId = R.layout.com_mixpanel_android_middle_choice_answer;
                    }
                }
                convertView = this.mInflater.inflate(viewId, parent, false);
            }
            TextView choiceText = (TextView)convertView.findViewById(R.id.com_mixpanel_android_multiple_choice_answer_text);
            String choice = this.mChoices.get(position);
            choiceText.setText((CharSequence)choice);
            return convertView;
        }

        public int getViewTypeCount() {
            return 3;
        }

        public boolean hasStableIds() {
            return true;
        }

        public boolean isEmpty() {
            return this.mChoices.isEmpty();
        }

        public void registerDataSetObserver(DataSetObserver observer) {
        }

        public void unregisterDataSetObserver(DataSetObserver observer) {
        }

        public boolean areAllItemsEnabled() {
            return true;
        }

        public boolean isEnabled(int arg0) {
            return true;
        }
    }

    public static enum Direction {
        FORWARD,
        BACKWARD;

    }

    public static interface OnQuestionAnsweredListener {
        public void onQuestionAnswered(Survey.Question var1, String var2);
    }

    public static class UnrecognizedAnswerTypeException
    extends Exception {
        private static final long serialVersionUID = -6040399928243560328L;

        private UnrecognizedAnswerTypeException(String string) {
            super(string);
        }
    }
}

