/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.ImageView;

class MiniCircleImageView
extends ImageView {
    private Paint mWhitePaint;
    private int mCanvasWidth;
    private int mCanvasHeight;

    public MiniCircleImageView(Context context) {
        super(context);
        this.init();
    }

    public MiniCircleImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public MiniCircleImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.mWhitePaint = new Paint(1);
        this.mWhitePaint.setColor(this.getResources().getColor(17170443));
        this.mWhitePaint.setStyle(Paint.Style.STROKE);
        Resources r = this.getResources();
        float strokePx = TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)r.getDisplayMetrics());
        this.mWhitePaint.setStrokeWidth(strokePx);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float centerX = this.mCanvasWidth / 2;
        float centerY = this.mCanvasHeight / 2;
        float radius = 0.7f * Math.min(centerX, centerY);
        canvas.drawCircle(centerX, centerY, radius, this.mWhitePaint);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mCanvasWidth = w;
        this.mCanvasHeight = h;
    }
}

