/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.util;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.view.View;

public class ActivityImageUtils {
    public static Bitmap getScaledScreenshot(Activity activity, int scaleWidth, int scaleHeight, boolean relativeScaleIfTrue) {
        View someView = activity.findViewById(0x1020002);
        View rootView = someView.getRootView();
        boolean originalCacheState = rootView.isDrawingCacheEnabled();
        rootView.setDrawingCacheEnabled(true);
        rootView.buildDrawingCache(true);
        Bitmap original = rootView.getDrawingCache();
        Bitmap scaled = null;
        if (null != original && original.getWidth() > 0 && original.getHeight() > 0) {
            if (relativeScaleIfTrue) {
                scaleWidth = original.getWidth() / scaleWidth;
                scaleHeight = original.getHeight() / scaleHeight;
            }
            if (scaleWidth > 0 && scaleHeight > 0) {
                scaled = Bitmap.createScaledBitmap((Bitmap)original, (int)scaleWidth, (int)scaleHeight, (boolean)false);
            }
        }
        if (!originalCacheState) {
            rootView.setDrawingCacheEnabled(false);
        }
        return scaled;
    }

    public static int getHighlightColorFromBackground(Activity activity) {
        int incolor = -16777216;
        Bitmap screenshot1px = ActivityImageUtils.getScaledScreenshot(activity, 1, 1, false);
        if (null != screenshot1px) {
            incolor = screenshot1px.getPixel(0, 0);
        }
        return ActivityImageUtils.getHighlightColor(incolor);
    }

    public static int getHighlightColorFromBitmap(Bitmap bitmap) {
        int incolor = -16777216;
        if (null != bitmap) {
            Bitmap bitmap1px = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)1, (int)1, (boolean)false);
            incolor = bitmap1px.getPixel(0, 0);
        }
        return ActivityImageUtils.getHighlightColor(incolor);
    }

    public static int getHighlightColor(int sampleColor) {
        float[] hsvBackground = new float[3];
        Color.colorToHSV((int)sampleColor, (float[])hsvBackground);
        hsvBackground[2] = 0.3f;
        return Color.HSVToColor((int)204, (float[])hsvBackground);
    }
}

