/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.mixpanel.android.mpmetrics.InAppNotification;
import com.mixpanel.android.mpmetrics.Survey;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

@TargetApi(value=14)
public class UpdateDisplayState
implements Parcelable {
    public static final Parcelable.Creator<UpdateDisplayState> CREATOR = new Parcelable.Creator<UpdateDisplayState>(){

        public UpdateDisplayState createFromParcel(Parcel in) {
            Bundle read = new Bundle(UpdateDisplayState.class.getClassLoader());
            read.readFromParcel(in);
            return new UpdateDisplayState(read);
        }

        public UpdateDisplayState[] newArray(int size) {
            return new UpdateDisplayState[size];
        }
    };
    private final String mDistinctId;
    private final String mToken;
    private final DisplayState mDisplayState;
    private static final Object sUpdateDisplayLock = new Object();
    private static long sUpdateDisplayLockMillis = -1L;
    private static UpdateDisplayState sUpdateDisplayState = null;
    private static int sNextIntentId = 0;
    private static int sShowingIntentId = -1;
    private static final String LOGTAG = "MixpanelAPI UpdateDisplayState";
    private static final long MAX_LOCK_TIME_MILLIS = 43200000L;
    private static final String DISTINCT_ID_BUNDLE_KEY = "com.mixpanel.android.mpmetrics.UpdateDisplayState.DISTINCT_ID_BUNDLE_KEY";
    private static final String TOKEN_BUNDLE_KEY = "com.mixpanel.android.mpmetrics.UpdateDisplayState.TOKEN_BUNDLE_KEY";
    private static final String DISPLAYSTATE_BUNDLE_KEY = "com.mixpanel.android.mpmetrics.UpdateDisplayState.DISPLAYSTATE_BUNDLE_KEY";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int proposeDisplay(DisplayState state, String distinctId, String token) {
        int ret = -1;
        Object object = sUpdateDisplayLock;
        synchronized (object) {
            long currentTime = System.currentTimeMillis();
            long deltaTime = currentTime - sUpdateDisplayLockMillis;
            if (sNextIntentId > 0 && deltaTime > 43200000L) {
                Log.i((String)LOGTAG, (String)"UpdateDisplayState set long, long ago, without showing.");
                sUpdateDisplayState = null;
            }
            if (null == sUpdateDisplayState) {
                sUpdateDisplayLockMillis = currentTime;
                sUpdateDisplayState = new UpdateDisplayState(state, distinctId, token);
                ret = ++sNextIntentId;
            } else {
                Log.d((String)LOGTAG, (String)"Already showing (or cooking) a Mixpanel update, declining to show another.");
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseDisplayState(int intentId) {
        Object object = sUpdateDisplayLock;
        synchronized (object) {
            if (intentId == sShowingIntentId) {
                sShowingIntentId = -1;
                sUpdateDisplayState = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UpdateDisplayState claimDisplayState(int intentId) {
        Object object = sUpdateDisplayLock;
        synchronized (object) {
            if (sShowingIntentId > 0 && sShowingIntentId != intentId) {
                return null;
            }
            if (sUpdateDisplayState == null) {
                return null;
            }
            sUpdateDisplayLockMillis = System.currentTimeMillis();
            sShowingIntentId = intentId;
            return sUpdateDisplayState;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle();
        bundle.putString(DISTINCT_ID_BUNDLE_KEY, this.mDistinctId);
        bundle.putString(TOKEN_BUNDLE_KEY, this.mToken);
        bundle.putParcelable(DISPLAYSTATE_BUNDLE_KEY, (Parcelable)this.mDisplayState);
        dest.writeBundle(bundle);
    }

    public DisplayState getDisplayState() {
        return this.mDisplayState;
    }

    public String getDistinctId() {
        return this.mDistinctId;
    }

    public String getToken() {
        return this.mToken;
    }

    UpdateDisplayState(DisplayState displayState, String distinctId, String token) {
        this.mDistinctId = distinctId;
        this.mToken = token;
        this.mDisplayState = displayState;
    }

    private UpdateDisplayState(Bundle read) {
        this.mDistinctId = read.getString(DISTINCT_ID_BUNDLE_KEY);
        this.mToken = read.getString(TOKEN_BUNDLE_KEY);
        this.mDisplayState = (DisplayState)read.getParcelable(DISPLAYSTATE_BUNDLE_KEY);
    }

    public static class AnswerMap
    implements Parcelable {
        public static final Parcelable.Creator<AnswerMap> CREATOR = new Parcelable.Creator<AnswerMap>(){

            public AnswerMap createFromParcel(Parcel in) {
                Bundle read = new Bundle(AnswerMap.class.getClassLoader());
                AnswerMap ret = new AnswerMap();
                read.readFromParcel(in);
                for (String kString : read.keySet()) {
                    Integer kInt = Integer.valueOf(kString);
                    ret.put(kInt, read.getString(kString));
                }
                return ret;
            }

            public AnswerMap[] newArray(int size) {
                return new AnswerMap[size];
            }
        };
        private final HashMap<Integer, String> mMap = new HashMap();

        @SuppressLint(value={"UseSparseArrays"})
        public AnswerMap() {
        }

        public void put(Integer i, String s) {
            this.mMap.put(i, s);
        }

        public String get(Integer i) {
            return this.mMap.get(i);
        }

        public boolean contentEquals(AnswerMap other) {
            return this.mMap.equals(other.mMap);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            Bundle out = new Bundle();
            for (Map.Entry<Integer, String> entry : this.mMap.entrySet()) {
                String keyString = Integer.toString(entry.getKey());
                out.putString(keyString, entry.getValue());
            }
            dest.writeBundle(out);
        }
    }

    public static abstract class DisplayState
    implements Parcelable {
        public static final Parcelable.Creator<DisplayState> CREATOR = new Parcelable.Creator<DisplayState>(){

            public DisplayState createFromParcel(Parcel source) {
                Bundle read = new Bundle(DisplayState.class.getClassLoader());
                read.readFromParcel(source);
                String type = read.getString(DisplayState.STATE_TYPE_KEY);
                Bundle implementation = read.getBundle(DisplayState.STATE_IMPL_KEY);
                if ("InAppNotificationState".equals(type)) {
                    return new InAppNotificationState(implementation);
                }
                if ("SurveyState".equals(type)) {
                    return new SurveyState(implementation);
                }
                throw new RuntimeException("Unrecognized display state type " + type);
            }

            public DisplayState[] newArray(int size) {
                return new DisplayState[size];
            }
        };
        public static final String STATE_TYPE_KEY = "com.mixpanel.android.mpmetrics.UpdateDisplayState.DisplayState.STATE_TYPE_KEY";
        public static final String STATE_IMPL_KEY = "com.mixpanel.android.mpmetrics.UpdateDisplayState.DisplayState.STATE_IMPL_KEY";

        private DisplayState() {
        }

        public abstract String getType();

        public static final class SurveyState
        extends DisplayState {
            public static final String TYPE = "SurveyState";
            public static final Parcelable.Creator<SurveyState> CREATOR = new Parcelable.Creator<SurveyState>(){

                public SurveyState createFromParcel(Parcel source) {
                    Bundle read = new Bundle(SurveyState.class.getClassLoader());
                    read.readFromParcel(source);
                    return new SurveyState(read);
                }

                public SurveyState[] newArray(int size) {
                    return new SurveyState[size];
                }
            };
            private final boolean mShowAskDialog;
            private final Survey mSurvey;
            private final int mHighlightColor;
            private final AnswerMap mAnswers;
            private final Bitmap mBackground;
            private static final String SHOW_ASK_BUNDLE_KEY = "com.mixpanel.android.mpmetrics.UpdateDisplayState.SHOW_ASK_BUNDLE_KEY";
            private static final String SURVEY_BUNDLE_KEY = "com.mixpanel.android.mpmetrics.UpdateDisplayState.SURVEY_BUNDLE_KEY";
            private static final String HIGHLIGHT_COLOR_BUNDLE_KEY = "com.mixpanel.android.mpmetrics.UpdateDisplayState.HIGHLIGHT_COLOR_BUNDLE_KEY";
            private static final String ANSWERS_BUNDLE_KEY = "com.mixpanel.android.mpmetrics.UpdateDisplayState.ANSWERS_BUNDLE_KEY";
            private static final String BACKGROUND_COMPRESSED_BUNDLE_KEY = "com.mixpanel.android.mpmetrics.UpdateDisplayState.BACKGROUND_COMPRESSED_BUNDLE_KEY";

            public SurveyState(Survey survey, int highlightColor, Bitmap background, boolean showAskDialog) {
                this.mShowAskDialog = showAskDialog;
                this.mSurvey = survey;
                this.mHighlightColor = highlightColor;
                this.mBackground = background;
                this.mAnswers = new AnswerMap();
            }

            public Bitmap getBackground() {
                return this.mBackground;
            }

            public AnswerMap getAnswers() {
                return this.mAnswers;
            }

            public int getHighlightColor() {
                return this.mHighlightColor;
            }

            public Survey getSurvey() {
                return this.mSurvey;
            }

            @Override
            public String getType() {
                return TYPE;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel dest, int flags) {
                Bundle out = new Bundle();
                out.putBoolean(SHOW_ASK_BUNDLE_KEY, this.mShowAskDialog);
                out.putInt(HIGHLIGHT_COLOR_BUNDLE_KEY, this.mHighlightColor);
                out.putParcelable(ANSWERS_BUNDLE_KEY, (Parcelable)this.mAnswers);
                byte[] backgroundCompressed = null;
                if (this.mBackground != null) {
                    ByteArrayOutputStream bs = new ByteArrayOutputStream();
                    this.mBackground.compress(Bitmap.CompressFormat.PNG, 20, (OutputStream)bs);
                    backgroundCompressed = bs.toByteArray();
                }
                out.putByteArray(BACKGROUND_COMPRESSED_BUNDLE_KEY, backgroundCompressed);
                out.putParcelable(SURVEY_BUNDLE_KEY, (Parcelable)this.mSurvey);
                dest.writeBundle(out);
            }

            private SurveyState(Bundle in) {
                this.mShowAskDialog = in.getBoolean(SHOW_ASK_BUNDLE_KEY);
                this.mHighlightColor = in.getInt(HIGHLIGHT_COLOR_BUNDLE_KEY);
                this.mAnswers = (AnswerMap)in.getParcelable(ANSWERS_BUNDLE_KEY);
                byte[] backgroundCompressed = in.getByteArray(BACKGROUND_COMPRESSED_BUNDLE_KEY);
                this.mBackground = null != backgroundCompressed ? BitmapFactory.decodeByteArray((byte[])backgroundCompressed, (int)0, (int)backgroundCompressed.length) : null;
                this.mSurvey = (Survey)in.getParcelable(SURVEY_BUNDLE_KEY);
            }
        }

        public static final class InAppNotificationState
        extends DisplayState {
            public static final String TYPE = "InAppNotificationState";
            public static final Parcelable.Creator<InAppNotificationState> CREATOR = new Parcelable.Creator<InAppNotificationState>(){

                public InAppNotificationState createFromParcel(Parcel source) {
                    Bundle read = new Bundle(InAppNotificationState.class.getClassLoader());
                    read.readFromParcel(source);
                    return new InAppNotificationState(read);
                }

                public InAppNotificationState[] newArray(int size) {
                    return new InAppNotificationState[size];
                }
            };
            private final InAppNotification mInAppNotification;
            private final int mHighlightColor;
            private static String INAPP_KEY = "com.com.mixpanel.android.mpmetrics.UpdateDisplayState.InAppNotificationState.INAPP_KEY";
            private static String HIGHLIGHT_KEY = "com.com.mixpanel.android.mpmetrics.UpdateDisplayState.InAppNotificationState.HIGHLIGHT_KEY";

            public InAppNotificationState(InAppNotification notification, int highlightColor) {
                this.mInAppNotification = notification;
                this.mHighlightColor = highlightColor;
            }

            public int getHighlightColor() {
                return this.mHighlightColor;
            }

            public InAppNotification getInAppNotification() {
                return this.mInAppNotification;
            }

            @Override
            public String getType() {
                return TYPE;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel dest, int flags) {
                Bundle write = new Bundle();
                write.putParcelable(INAPP_KEY, (Parcelable)this.mInAppNotification);
                write.putInt(HIGHLIGHT_KEY, this.mHighlightColor);
                dest.writeBundle(write);
            }

            private InAppNotificationState(Bundle in) {
                this.mInAppNotification = (InAppNotification)in.getParcelable(INAPP_KEY);
                this.mHighlightColor = in.getInt(HIGHLIGHT_KEY);
            }
        }
    }
}

