/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.util.Log;
import com.mixpanel.android.util.Base64Coder;
import com.mixpanel.android.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;

class ServerMessage {
    private static final String LOGTAG = "MixpanelAPI";

    ServerMessage() {
    }

    public Result postData(String rawMessage, String endpointUrl, String fallbackUrl) {
        Status status = Status.FAILED_UNRECOVERABLE;
        String encodedData = Base64Coder.encodeString(rawMessage);
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>(1);
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("data", encodedData));
        Result baseResult = this.performRequest(endpointUrl, nameValuePairs);
        Status baseStatus = baseResult.getStatus();
        String response = baseResult.getResponse();
        if (baseStatus == Status.SUCCEEDED && response.equals("1\n")) {
            status = Status.SUCCEEDED;
        }
        if (baseStatus == Status.FAILED_RECOVERABLE && fallbackUrl != null) {
            Result retryResult = this.postData(rawMessage, fallbackUrl, null);
            Status retryStatus = retryResult.getStatus();
            response = retryResult.getResponse();
            if (retryStatus != Status.SUCCEEDED) {
                Log.e((String)LOGTAG, (String)"Could not post data to Mixpanel");
            } else {
                status = Status.SUCCEEDED;
            }
        }
        return new Result(status, response);
    }

    public Result get(String endpointUrl, String fallbackUrl) {
        Result ret = this.performRequest(endpointUrl, null);
        if (ret.getStatus() == Status.FAILED_RECOVERABLE && fallbackUrl != null) {
            ret = this.get(fallbackUrl, null);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result performRequest(String endpointUrl, List<NameValuePair> nameValuePairs) {
        Status status = Status.FAILED_UNRECOVERABLE;
        String response = null;
        try {
            int retries = 0;
            boolean succeeded = false;
            while (retries < 3 && !succeeded) {
                InputStream in = null;
                BufferedInputStream bin = null;
                OutputStream out = null;
                FilterOutputStream bout = null;
                HttpURLConnection connection = null;
                try {
                    URL url = new URL(endpointUrl);
                    connection = (HttpURLConnection)url.openConnection();
                    if (null != nameValuePairs) {
                        connection.setDoOutput(true);
                        UrlEncodedFormEntity form = new UrlEncodedFormEntity(nameValuePairs, "UTF-8");
                        connection.setRequestMethod("POST");
                        connection.setFixedLengthStreamingMode((int)form.getContentLength());
                        out = connection.getOutputStream();
                        bout = new BufferedOutputStream(out);
                        form.writeTo((OutputStream)bout);
                        bout.close();
                        bout = null;
                        out.close();
                        out = null;
                    }
                    in = connection.getInputStream();
                    bin = new BufferedInputStream(in);
                    response = StringUtils.inputStreamToString(in);
                    bin.close();
                    bin = null;
                    in.close();
                    in = null;
                    succeeded = true;
                }
                catch (EOFException e) {
                    ++retries;
                }
                finally {
                    if (null != bout) {
                        try {
                            bout.close();
                        }
                        catch (IOException e) {}
                    }
                    if (null != out) {
                        try {
                            out.close();
                        }
                        catch (IOException e) {}
                    }
                    if (null != bin) {
                        try {
                            bin.close();
                        }
                        catch (IOException e) {}
                    }
                    if (null != in) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {}
                    }
                    if (null == connection) continue;
                    connection.disconnect();
                }
            }
        }
        catch (MalformedURLException e) {
            Log.e((String)LOGTAG, (String)("Cannot iterpret " + endpointUrl + " as a URL"), (Throwable)e);
            status = Status.FAILED_UNRECOVERABLE;
        }
        catch (IOException e) {
            status = Status.FAILED_RECOVERABLE;
        }
        catch (OutOfMemoryError e) {
            Log.e((String)LOGTAG, (String)"Cannot post message to Mixpanel Servers, will not retry.", (Throwable)e);
            status = Status.FAILED_UNRECOVERABLE;
        }
        if (null != response) {
            status = Status.SUCCEEDED;
        }
        return new Result(status, response);
    }

    public static class Result {
        private final String mResponse;
        private final Status mStatus;

        Result(Status status, String response) {
            this.mStatus = status;
            this.mResponse = response;
        }

        public Status getStatus() {
            return this.mStatus;
        }

        public String getResponse() {
            return this.mResponse;
        }
    }

    public static enum Status {
        SUCCEEDED,
        FAILED_RECOVERABLE,
        FAILED_UNRECOVERABLE;

    }
}

