/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class PersistentProperties {
    private final Future<SharedPreferences> mLoadStoredPreferences;
    private final Future<SharedPreferences> mLoadReferrerPreferences;
    private final SharedPreferences.OnSharedPreferenceChangeListener mReferrerChangeListener;
    private JSONObject mSuperPropertiesCache;
    private Map<String, String> mReferrerPropertiesCache;
    private boolean mIdentitiesLoaded;
    private String mEventsDistinctId;
    private String mPeopleDistinctId;
    private JSONArray mWaitingPeopleRecords;
    private static boolean sReferrerPrefsDirty = true;
    private static final Object sReferrerPrefsLock = new Object();
    private static final String LOGTAG = "MixpanelAPI PersistentProperties";

    public static JSONArray waitingPeopleRecordsForSending(SharedPreferences storedPreferences) {
        JSONArray ret = null;
        String peopleDistinctId = storedPreferences.getString("people_distinct_id", null);
        String waitingPeopleRecords = storedPreferences.getString("waiting_array", null);
        if (null != waitingPeopleRecords && null != peopleDistinctId) {
            JSONArray waitingObjects = null;
            try {
                waitingObjects = new JSONArray(waitingPeopleRecords);
            }
            catch (JSONException e) {
                Log.e((String)LOGTAG, (String)"Waiting people records were unreadable.");
                return null;
            }
            ret = new JSONArray();
            for (int i = 0; i < waitingObjects.length(); ++i) {
                try {
                    JSONObject ob = waitingObjects.getJSONObject(i);
                    ob.put("$distinct_id", (Object)peopleDistinctId);
                    ret.put((Object)ob);
                    continue;
                }
                catch (JSONException e) {
                    Log.e((String)LOGTAG, (String)"Unparsable object found in waiting people records", (Throwable)e);
                }
            }
            SharedPreferences.Editor editor = storedPreferences.edit();
            editor.remove("waiting_array");
            editor.commit();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeReferrerPrefs(Context context, String preferencesName, Map<String, String> properties) {
        Object object = sReferrerPrefsLock;
        synchronized (object) {
            SharedPreferences referralInfo = context.getSharedPreferences(preferencesName, 0);
            SharedPreferences.Editor editor = referralInfo.edit();
            editor.clear();
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                editor.putString(entry.getKey(), entry.getValue());
            }
            editor.commit();
            sReferrerPrefsDirty = true;
        }
    }

    public PersistentProperties(Future<SharedPreferences> referrerPreferences, Future<SharedPreferences> storedPreferences) {
        this.mLoadReferrerPreferences = referrerPreferences;
        this.mLoadStoredPreferences = storedPreferences;
        this.mSuperPropertiesCache = null;
        this.mReferrerPropertiesCache = null;
        this.mIdentitiesLoaded = false;
        this.mReferrerChangeListener = new SharedPreferences.OnSharedPreferenceChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
                Object object = sReferrerPrefsLock;
                synchronized (object) {
                    PersistentProperties.this.readReferrerProperties();
                    sReferrerPrefsDirty = false;
                }
            }
        };
    }

    public JSONObject getSuperProperties() {
        if (null == this.mSuperPropertiesCache) {
            this.readSuperProperties();
        }
        return this.mSuperPropertiesCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getReferrerProperties() {
        Object object = sReferrerPrefsLock;
        synchronized (object) {
            if (sReferrerPrefsDirty || null == this.mReferrerPropertiesCache) {
                this.readReferrerProperties();
                sReferrerPrefsDirty = false;
            }
        }
        return this.mReferrerPropertiesCache;
    }

    public String getEventsDistinctId() {
        if (!this.mIdentitiesLoaded) {
            this.readIdentities();
        }
        return this.mEventsDistinctId;
    }

    public void setEventsDistinctId(String eventsDistinctId) {
        if (!this.mIdentitiesLoaded) {
            this.readIdentities();
        }
        this.mEventsDistinctId = eventsDistinctId;
        this.writeIdentities();
    }

    public String getPeopleDistinctId() {
        if (!this.mIdentitiesLoaded) {
            this.readIdentities();
        }
        return this.mPeopleDistinctId;
    }

    public void setPeopleDistinctId(String peopleDistinctId) {
        if (!this.mIdentitiesLoaded) {
            this.readIdentities();
        }
        this.mPeopleDistinctId = peopleDistinctId;
        this.writeIdentities();
    }

    public void storeWaitingPeopleRecord(JSONObject record) {
        if (!this.mIdentitiesLoaded) {
            this.readIdentities();
        }
        if (null == this.mWaitingPeopleRecords) {
            this.mWaitingPeopleRecords = new JSONArray();
        }
        this.mWaitingPeopleRecords.put((Object)record);
        this.writeIdentities();
    }

    public JSONArray waitingPeopleRecordsForSending() {
        JSONArray ret = null;
        try {
            SharedPreferences prefs = this.mLoadStoredPreferences.get();
            ret = PersistentProperties.waitingPeopleRecordsForSending(prefs);
            this.readIdentities();
        }
        catch (ExecutionException e) {
            Log.e((String)LOGTAG, (String)"Couldn't read waiting people records from shared preferences.", (Throwable)e.getCause());
        }
        catch (InterruptedException e) {
            Log.e((String)LOGTAG, (String)"Couldn't read waiting people records from shared preferences.", (Throwable)e);
        }
        return ret;
    }

    public void clearPreferences() {
        try {
            SharedPreferences prefs = this.mLoadStoredPreferences.get();
            SharedPreferences.Editor prefsEdit = prefs.edit();
            prefsEdit.clear().commit();
            this.readSuperProperties();
            this.readIdentities();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public void registerSuperProperties(JSONObject superProperties) {
        Log.d((String)LOGTAG, (String)"registerSuperProperties");
        JSONObject propCache = this.getSuperProperties();
        Iterator iter = superProperties.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            try {
                propCache.put(key, superProperties.get(key));
            }
            catch (JSONException e) {
                Log.e((String)LOGTAG, (String)"Exception registering super property.", (Throwable)e);
            }
        }
        this.storeSuperProperties();
    }

    public void storePushId(String registrationId) {
        try {
            SharedPreferences prefs = this.mLoadStoredPreferences.get();
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString("push_id", registrationId);
            editor.commit();
        }
        catch (ExecutionException e) {
            Log.e((String)LOGTAG, (String)"Can't write push id to shared preferences", (Throwable)e.getCause());
        }
        catch (InterruptedException e) {
            Log.e((String)LOGTAG, (String)"Can't write push id to shared preferences", (Throwable)e);
        }
    }

    public void clearPushId() {
        try {
            SharedPreferences prefs = this.mLoadStoredPreferences.get();
            SharedPreferences.Editor editor = prefs.edit();
            editor.remove("push_id");
            editor.commit();
        }
        catch (ExecutionException e) {
            Log.e((String)LOGTAG, (String)"Can't write push id to shared preferences", (Throwable)e.getCause());
        }
        catch (InterruptedException e) {
            Log.e((String)LOGTAG, (String)"Can't write push id to shared preferences", (Throwable)e);
        }
    }

    public String getPushId() {
        String ret = null;
        try {
            SharedPreferences prefs = this.mLoadStoredPreferences.get();
            ret = prefs.getString("push_id", null);
        }
        catch (ExecutionException e) {
            Log.e((String)LOGTAG, (String)"Can't write push id to shared preferences", (Throwable)e.getCause());
        }
        catch (InterruptedException e) {
            Log.e((String)LOGTAG, (String)"Can't write push id to shared preferences", (Throwable)e);
        }
        return ret;
    }

    public void unregisterSuperProperty(String superPropertyName) {
        JSONObject propCache = this.getSuperProperties();
        propCache.remove(superPropertyName);
        this.storeSuperProperties();
    }

    public void registerSuperPropertiesOnce(JSONObject superProperties) {
        Log.d((String)LOGTAG, (String)"registerSuperPropertiesOnce");
        JSONObject propCache = this.getSuperProperties();
        Iterator iter = superProperties.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (propCache.has(key)) continue;
            try {
                propCache.put(key, superProperties.get(key));
            }
            catch (JSONException e) {
                Log.e((String)LOGTAG, (String)"Exception registering super property.", (Throwable)e);
            }
        }
        this.storeSuperProperties();
    }

    public void clearSuperProperties() {
        Log.d((String)LOGTAG, (String)"clearSuperProperties");
        this.mSuperPropertiesCache = new JSONObject();
        this.storeSuperProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSuperProperties() {
        try {
            SharedPreferences prefs = this.mLoadStoredPreferences.get();
            String props = prefs.getString("super_properties", "{}");
            Log.d((String)LOGTAG, (String)("Loading Super Properties " + props));
            this.mSuperPropertiesCache = new JSONObject(props);
        }
        catch (ExecutionException e) {
            Log.e((String)LOGTAG, (String)"Cannot load superProperties from SharedPreferences.", (Throwable)e.getCause());
        }
        catch (InterruptedException e) {
            Log.e((String)LOGTAG, (String)"Cannot load superProperties from SharedPreferences.", (Throwable)e);
        }
        catch (JSONException e) {
            Log.e((String)LOGTAG, (String)"Cannot parse stored superProperties");
            this.storeSuperProperties();
        }
        finally {
            if (null == this.mSuperPropertiesCache) {
                this.mSuperPropertiesCache = new JSONObject();
            }
        }
    }

    private void readReferrerProperties() {
        this.mReferrerPropertiesCache = new HashMap<String, String>();
        try {
            SharedPreferences referrerPrefs = this.mLoadReferrerPreferences.get();
            referrerPrefs.unregisterOnSharedPreferenceChangeListener(this.mReferrerChangeListener);
            referrerPrefs.registerOnSharedPreferenceChangeListener(this.mReferrerChangeListener);
            Map prefsMap = referrerPrefs.getAll();
            for (Map.Entry entry : prefsMap.entrySet()) {
                String prefsName = (String)entry.getKey();
                Object prefsVal = entry.getValue();
                this.mReferrerPropertiesCache.put(prefsName, prefsVal.toString());
            }
        }
        catch (ExecutionException e) {
            Log.e((String)LOGTAG, (String)"Cannot load referrer properties from shared preferences.", (Throwable)e.getCause());
        }
        catch (InterruptedException e) {
            Log.e((String)LOGTAG, (String)"Cannot load referrer properties from shared preferences.", (Throwable)e);
        }
    }

    private void storeSuperProperties() {
        if (null == this.mSuperPropertiesCache) {
            Log.e((String)LOGTAG, (String)"storeSuperProperties should not be called with uninitialized superPropertiesCache.");
            return;
        }
        String props = this.mSuperPropertiesCache.toString();
        Log.d((String)LOGTAG, (String)("Storing Super Properties " + props));
        try {
            SharedPreferences prefs = this.mLoadStoredPreferences.get();
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString("super_properties", props);
            editor.commit();
        }
        catch (ExecutionException e) {
            Log.e((String)LOGTAG, (String)"Cannot store superProperties in shared preferences.", (Throwable)e.getCause());
        }
        catch (InterruptedException e) {
            Log.e((String)LOGTAG, (String)"Cannot store superProperties in shared preferences.", (Throwable)e);
        }
    }

    private void readIdentities() {
        SharedPreferences prefs = null;
        try {
            prefs = this.mLoadStoredPreferences.get();
        }
        catch (ExecutionException e) {
            Log.e((String)LOGTAG, (String)"Cannot read distinct ids from sharedPreferences.", (Throwable)e.getCause());
        }
        catch (InterruptedException e) {
            Log.e((String)LOGTAG, (String)"Cannot read distinct ids from sharedPreferences.", (Throwable)e);
        }
        if (null == prefs) {
            return;
        }
        this.mEventsDistinctId = prefs.getString("events_distinct_id", null);
        this.mPeopleDistinctId = prefs.getString("people_distinct_id", null);
        this.mWaitingPeopleRecords = null;
        String storedWaitingRecord = prefs.getString("waiting_array", null);
        if (storedWaitingRecord != null) {
            try {
                this.mWaitingPeopleRecords = new JSONArray(storedWaitingRecord);
            }
            catch (JSONException e) {
                Log.e((String)LOGTAG, (String)("Could not interpret waiting people JSON record " + storedWaitingRecord));
            }
        }
        if (null == this.mEventsDistinctId) {
            this.mEventsDistinctId = UUID.randomUUID().toString();
            this.writeIdentities();
        }
        this.mIdentitiesLoaded = true;
    }

    private void writeIdentities() {
        try {
            SharedPreferences prefs = this.mLoadStoredPreferences.get();
            SharedPreferences.Editor prefsEditor = prefs.edit();
            prefsEditor.putString("events_distinct_id", this.mEventsDistinctId);
            prefsEditor.putString("people_distinct_id", this.mPeopleDistinctId);
            if (this.mWaitingPeopleRecords == null) {
                prefsEditor.remove("waiting_array");
            } else {
                prefsEditor.putString("waiting_array", this.mWaitingPeopleRecords.toString());
            }
            prefsEditor.commit();
        }
        catch (ExecutionException e) {
            Log.e((String)LOGTAG, (String)"Can't write distinct ids to shared preferences.", (Throwable)e.getCause());
        }
        catch (InterruptedException e) {
            Log.e((String)LOGTAG, (String)"Can't write distinct ids to shared preferences.", (Throwable)e);
        }
    }
}

