/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.mixpanel.android.mpmetrics.Survey;
import com.mixpanel.android.surveys.SurveyActivity;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class SurveyState
implements Parcelable {
    public static final Parcelable.Creator<SurveyState> CREATOR = new Parcelable.Creator<SurveyState>(){

        public SurveyState createFromParcel(Parcel in) {
            Bundle read = new Bundle(SurveyState.class.getClassLoader());
            read.readFromParcel(in);
            return new SurveyState(read);
        }

        public SurveyState[] newArray(int size) {
            return new SurveyState[size];
        }
    };
    private final Survey mSurvey;
    private final String mDistinctId;
    private final String mToken;
    private final AnswerMap mAnswers;
    private final Bitmap mBackground;
    private final int mHighlightColor;
    private static final Object sSurveyStateLock = new Object();
    private static long sSurveyStateLockMillis = -1L;
    private static SurveyState sSurveyState = null;
    private static int sNextIntentId = 0;
    private static long sIntentIdLockMillis = -1L;
    private static int sShowingIntentId = -1;
    private static final String LOGTAG = "MixpanelAPI SurveyState";
    private static final long MAX_LOCK_TIME_MILLIS = 43200000L;
    private static final String SURVEY_BUNDLE_KEY = "com.mixpanel.android.mpmetrics.SurveyState.SURVEY_BUNDLE_KEY";
    private static final String DISTINCT_ID_BUNDLE_KEY = "com.mixpanel.android.mpmetrics.SurveyState.DISTINCT_ID_BUNDLE_KEY";
    private static final String TOKEN_BUNDLE_KEY = "com.mixpanel.android.mpmetrics.SurveyState.TOKEN_BUNDLE_KEY";
    private static final String HIGHLIGHT_COLOR_BUNDLE_KEY = "com.mixpanel.android.mpmetrics.SurveyState.HIGHLIGHT_COLOR_BUNDLE_KEY";
    private static final String ANSWERS_BUNDLE_KEY = "com.mixpanel.android.mpmetrics.SurveyState.ANSWERS_BUNDLE_KEY";
    private static final String BACKGROUND_COMPRESSED_BUNDLE_KEY = "com.mixpanel.android.mpmetrics.SurveyState.BACKGROUND_COMPRESSED_BUNDLE_KEY";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void proposeSurvey(Survey s, Activity parentActivity, String distinctId, String token, Bitmap background, int highlightColor) {
        long currentTime = System.currentTimeMillis();
        long deltaTime = currentTime - sSurveyStateLockMillis;
        Object object = sSurveyStateLock;
        synchronized (object) {
            if (sShowingIntentId > 0 && deltaTime > 43200000L) {
                Log.i((String)LOGTAG, (String)"SurveyState set long, long ago, without showing.");
                sSurveyState = null;
            }
            if (null == sSurveyState) {
                sSurveyState = new SurveyState(s, distinctId, token, background, highlightColor);
                sSurveyState.initializeAndLaunch(parentActivity);
            } else {
                Log.d((String)LOGTAG, (String)"Already showing (or cooking) a survey, declining to show another.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseSurvey(int intentId) {
        Object object = sSurveyStateLock;
        synchronized (object) {
            if (intentId == sShowingIntentId) {
                sShowingIntentId = -1;
                sSurveyState = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SurveyState claimSurveyState(SurveyState proposed, int intentId) {
        assert (null == proposed);
        long currentTime = System.currentTimeMillis();
        long deltaTime = currentTime - sIntentIdLockMillis;
        Object object = sSurveyStateLock;
        synchronized (object) {
            if (sShowingIntentId > 0 && deltaTime > 43200000L) {
                Log.i((String)LOGTAG, (String)"Survey activity claimed but never released lock, possible force quit.");
                sShowingIntentId = -1;
            }
            if (sShowingIntentId > 0 && sShowingIntentId != intentId) {
                return null;
            }
            if (null != proposed) {
                sShowingIntentId = intentId;
                sSurveyState = proposed;
                return proposed;
            }
            if (sSurveyState == null) {
                return null;
            }
            sShowingIntentId = intentId;
            return sSurveyState;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle out = new Bundle();
        out.putString(DISTINCT_ID_BUNDLE_KEY, this.mDistinctId);
        out.putString(TOKEN_BUNDLE_KEY, this.mToken);
        out.putInt(HIGHLIGHT_COLOR_BUNDLE_KEY, this.mHighlightColor);
        out.putParcelable(ANSWERS_BUNDLE_KEY, (Parcelable)this.mAnswers);
        byte[] backgroundCompressed = null;
        if (this.mBackground != null) {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            this.mBackground.compress(Bitmap.CompressFormat.PNG, 20, (OutputStream)bs);
            backgroundCompressed = bs.toByteArray();
        }
        out.putByteArray(BACKGROUND_COMPRESSED_BUNDLE_KEY, backgroundCompressed);
        String surveyJson = this.mSurvey.toJSON();
        out.putString(SURVEY_BUNDLE_KEY, surveyJson);
        dest.writeBundle(out);
    }

    public Survey getSurvey() {
        return this.mSurvey;
    }

    public String getDistinctId() {
        return this.mDistinctId;
    }

    public String getToken() {
        return this.mToken;
    }

    public Bitmap getBackground() {
        return this.mBackground;
    }

    public AnswerMap getAnswers() {
        return this.mAnswers;
    }

    public int getHighlightColor() {
        return this.mHighlightColor;
    }

    SurveyState(Survey s, String distinctId, String token, Bitmap background, int highlightColor) {
        this.mSurvey = s;
        this.mDistinctId = distinctId;
        this.mToken = token;
        this.mAnswers = new AnswerMap();
        this.mBackground = background;
        this.mHighlightColor = highlightColor;
    }

    private SurveyState(Bundle read) {
        this.mDistinctId = read.getString(DISTINCT_ID_BUNDLE_KEY);
        this.mToken = read.getString(TOKEN_BUNDLE_KEY);
        this.mHighlightColor = read.getInt(HIGHLIGHT_COLOR_BUNDLE_KEY);
        this.mAnswers = (AnswerMap)read.getParcelable(ANSWERS_BUNDLE_KEY);
        byte[] backgroundCompressed = read.getByteArray(BACKGROUND_COMPRESSED_BUNDLE_KEY);
        this.mBackground = null != backgroundCompressed ? BitmapFactory.decodeByteArray((byte[])backgroundCompressed, (int)0, (int)backgroundCompressed.length) : null;
        String surveyJsonString = read.getString(SURVEY_BUNDLE_KEY);
        try {
            JSONObject surveyJson = new JSONObject(surveyJsonString);
            this.mSurvey = new Survey(surveyJson);
        }
        catch (JSONException e) {
            throw new RuntimeException("Survey serialization resulted in a corrupted parcel");
        }
        catch (Survey.BadSurveyException e) {
            throw new RuntimeException("Survey serialization resulted in a corrupted parcel");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeAndLaunch(Activity parentActivity) {
        Intent surveyIntent = new Intent(parentActivity.getApplicationContext(), SurveyActivity.class);
        surveyIntent.addFlags(0x10000000);
        surveyIntent.addFlags(131072);
        Object object = sSurveyStateLock;
        synchronized (object) {
            surveyIntent.putExtra("intentID", ++sNextIntentId);
        }
        parentActivity.startActivity(surveyIntent);
    }

    public static class AnswerMap
    implements Parcelable {
        public static final Parcelable.Creator<AnswerMap> CREATOR = new Parcelable.Creator<AnswerMap>(){

            public AnswerMap createFromParcel(Parcel in) {
                Bundle read = new Bundle();
                AnswerMap ret = new AnswerMap();
                read.readFromParcel(in);
                for (String kString : read.keySet()) {
                    Integer kInt = Integer.valueOf(kString);
                    ret.put(kInt, read.getString(kString));
                }
                return ret;
            }

            public AnswerMap[] newArray(int size) {
                return new AnswerMap[size];
            }
        };
        private final HashMap<Integer, String> mMap = new HashMap();

        @SuppressLint(value={"UseSparseArrays"})
        public AnswerMap() {
        }

        public void put(Integer i, String s) {
            this.mMap.put(i, s);
        }

        public String get(Integer i) {
            return this.mMap.get(i);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            Bundle out = new Bundle();
            for (Map.Entry<Integer, String> entry : this.mMap.entrySet()) {
                String keyString = Integer.toString(entry.getKey());
                out.putString(keyString, entry.getValue());
            }
            dest.writeBundle(out);
        }
    }
}

