/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.DisplayMetrics;
import android.util.Log;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.MPDbAdapter;
import com.mixpanel.android.mpmetrics.ServerMessage;
import com.mixpanel.android.mpmetrics.Survey;
import com.mixpanel.android.mpmetrics.SurveyCallbacks;
import com.mixpanel.android.mpmetrics.SystemInformation;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class AnalyticsMessages {
    private final AtomicBoolean mLogMixpanelMessages;
    private final Worker mWorker;
    private final Context mContext;
    private final MPConfig mConfig;
    private static int ENQUEUE_PEOPLE = 0;
    private static int ENQUEUE_EVENTS = 1;
    private static int FLUSH_QUEUE = 2;
    private static int KILL_WORKER = 5;
    private static int CHECK_FOR_SURVEYS = 11;
    private static int SET_FLUSH_INTERVAL = 4;
    private static int SET_DISABLE_FALLBACK = 10;
    private static final String LOGTAG = "MixpanelAPI";
    private static final Map<Context, AnalyticsMessages> sInstances = new HashMap<Context, AnalyticsMessages>();

    AnalyticsMessages(Context context) {
        this.mContext = context;
        this.mConfig = this.getConfig(context);
        this.mLogMixpanelMessages = new AtomicBoolean(false);
        this.mWorker = new Worker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnalyticsMessages getInstance(Context messageContext) {
        Map<Context, AnalyticsMessages> map = sInstances;
        synchronized (map) {
            AnalyticsMessages ret;
            Context appContext = messageContext.getApplicationContext();
            if (!sInstances.containsKey(appContext)) {
                Log.d((String)LOGTAG, (String)("Constructing new AnalyticsMessages for Context " + appContext));
                ret = new AnalyticsMessages(appContext);
                sInstances.put(appContext, ret);
            } else {
                Log.d((String)LOGTAG, (String)("AnalyticsMessages for Context " + appContext + " already exists- returning"));
                ret = sInstances.get(appContext);
            }
            return ret;
        }
    }

    public void logPosts() {
        this.mLogMixpanelMessages.set(true);
    }

    public void eventsMessage(EventDTO eventDTO) {
        Message m = Message.obtain();
        m.what = ENQUEUE_EVENTS;
        m.obj = eventDTO;
        this.mWorker.runMessage(m);
    }

    public void peopleMessage(JSONObject peopleJson) {
        Message m = Message.obtain();
        m.what = ENQUEUE_PEOPLE;
        m.obj = peopleJson;
        this.mWorker.runMessage(m);
    }

    public void postToServer() {
        Message m = Message.obtain();
        m.what = FLUSH_QUEUE;
        this.mWorker.runMessage(m);
    }

    public void setFlushInterval(long milliseconds) {
        Message m = Message.obtain();
        m.what = SET_FLUSH_INTERVAL;
        m.obj = new Long(milliseconds);
        this.mWorker.runMessage(m);
    }

    public void setDisableFallback(boolean disableIfTrue) {
        Message m = Message.obtain();
        m.what = SET_DISABLE_FALLBACK;
        m.obj = new Boolean(disableIfTrue);
        this.mWorker.runMessage(m);
    }

    public void checkForSurveys(SurveyCheck check) {
        Message m = Message.obtain();
        m.what = CHECK_FOR_SURVEYS;
        m.obj = check;
        this.mWorker.runMessage(m);
    }

    public void hardKill() {
        Message m = Message.obtain();
        m.what = KILL_WORKER;
        this.mWorker.runMessage(m);
    }

    boolean isDead() {
        return this.mWorker.isDead();
    }

    protected MPDbAdapter makeDbAdapter(Context context) {
        return new MPDbAdapter(context);
    }

    protected MPConfig getConfig(Context context) {
        return MPConfig.readConfig(context);
    }

    protected ServerMessage getPoster() {
        return new ServerMessage();
    }

    private void logAboutMessageToMixpanel(String message) {
        if (!this.mLogMixpanelMessages.get()) {
            // empty if block
        }
        Log.i((String)LOGTAG, (String)(message + " (Thread " + Thread.currentThread().getId() + ")"));
    }

    private class Worker {
        private final Object mHandlerLock = new Object();
        private Handler mHandler = this.restartWorkerThread();
        private long mFlushCount = 0L;
        private long mAveFlushFrequency = 0L;
        private long mLastFlushTime = -1L;
        private SystemInformation mSystemInformation;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDead() {
            Object object = this.mHandlerLock;
            synchronized (object) {
                return this.mHandler == null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runMessage(Message msg) {
            if (this.isDead()) {
                AnalyticsMessages.this.logAboutMessageToMixpanel("Dead mixpanel worker dropping a message: " + msg);
            } else {
                Object object = this.mHandlerLock;
                synchronized (object) {
                    if (this.mHandler != null) {
                        this.mHandler.sendMessage(msg);
                    }
                }
            }
        }

        private Handler restartWorkerThread() {
            Handler ret = null;
            final SynchronousQueue handlerQueue = new SynchronousQueue();
            Thread thread = new Thread(){

                @Override
                public void run() {
                    Log.i((String)AnalyticsMessages.LOGTAG, (String)("Starting worker thread " + this.getId()));
                    Looper.prepare();
                    try {
                        handlerQueue.put(new AnalyticsMessageHandler());
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("Couldn't build worker thread for Analytics Messages", e);
                    }
                    try {
                        Looper.loop();
                    }
                    catch (RuntimeException e) {
                        Log.e((String)AnalyticsMessages.LOGTAG, (String)"Mixpanel Thread dying from RuntimeException", (Throwable)e);
                    }
                }
            };
            thread.setPriority(1);
            thread.start();
            try {
                ret = (Handler)handlerQueue.take();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Couldn't retrieve handler from worker thread");
            }
            return ret;
        }

        private void updateFlushFrequency() {
            long now = System.currentTimeMillis();
            long newFlushCount = this.mFlushCount + 1L;
            if (this.mLastFlushTime > 0L) {
                long flushInterval = now - this.mLastFlushTime;
                long totalFlushTime = flushInterval + this.mAveFlushFrequency * this.mFlushCount;
                this.mAveFlushFrequency = totalFlushTime / newFlushCount;
                long seconds = this.mAveFlushFrequency / 1000L;
                AnalyticsMessages.this.logAboutMessageToMixpanel("Average send frequency approximately " + seconds + " seconds.");
            }
            this.mLastFlushTime = now;
            this.mFlushCount = newFlushCount;
        }

        private class AnalyticsMessageHandler
        extends Handler {
            private MPDbAdapter mDbAdapter = null;
            private final Set<Integer> mSeenSurveys = Collections.synchronizedSet(new HashSet());
            private long mFlushInterval;
            private boolean mDisableFallback;

            public AnalyticsMessageHandler() {
                this.mDisableFallback = AnalyticsMessages.this.mConfig.getDisableFallback();
                this.mFlushInterval = AnalyticsMessages.this.mConfig.getFlushInterval();
                Worker.this.mSystemInformation = new SystemInformation(AnalyticsMessages.this.mContext);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(Message msg) {
                if (this.mDbAdapter == null) {
                    this.mDbAdapter = AnalyticsMessages.this.makeDbAdapter(AnalyticsMessages.this.mContext);
                    this.mDbAdapter.cleanupEvents(System.currentTimeMillis() - (long)AnalyticsMessages.this.mConfig.getDataExpiration(), MPDbAdapter.Table.EVENTS);
                    this.mDbAdapter.cleanupEvents(System.currentTimeMillis() - (long)AnalyticsMessages.this.mConfig.getDataExpiration(), MPDbAdapter.Table.PEOPLE);
                }
                try {
                    int queueDepth = -1;
                    if (msg.what == SET_FLUSH_INTERVAL) {
                        Long newIntervalObj = (Long)msg.obj;
                        AnalyticsMessages.this.logAboutMessageToMixpanel("Changing flush interval to " + newIntervalObj);
                        this.mFlushInterval = newIntervalObj;
                        this.removeMessages(FLUSH_QUEUE);
                    } else if (msg.what == SET_DISABLE_FALLBACK) {
                        Boolean disableState = (Boolean)msg.obj;
                        AnalyticsMessages.this.logAboutMessageToMixpanel("Setting fallback to " + disableState);
                        this.mDisableFallback = disableState;
                    } else if (msg.what == ENQUEUE_PEOPLE) {
                        JSONObject message = (JSONObject)msg.obj;
                        AnalyticsMessages.this.logAboutMessageToMixpanel("Queuing people record for sending later");
                        AnalyticsMessages.this.logAboutMessageToMixpanel("    " + message.toString());
                        queueDepth = this.mDbAdapter.addJSON(message, MPDbAdapter.Table.PEOPLE);
                    } else if (msg.what == ENQUEUE_EVENTS) {
                        EventDTO eventDTO = (EventDTO)msg.obj;
                        try {
                            JSONObject message = this.prepareEventObject(eventDTO);
                            AnalyticsMessages.this.logAboutMessageToMixpanel("Queuing event for sending later");
                            AnalyticsMessages.this.logAboutMessageToMixpanel("    " + message.toString());
                            queueDepth = this.mDbAdapter.addJSON(message, MPDbAdapter.Table.EVENTS);
                        }
                        catch (JSONException e) {
                            Log.e((String)AnalyticsMessages.LOGTAG, (String)("Exception tracking event " + eventDTO.getEventName()), (Throwable)e);
                        }
                    } else if (msg.what == FLUSH_QUEUE) {
                        AnalyticsMessages.this.logAboutMessageToMixpanel("Flushing queue due to scheduled or forced flush");
                        Worker.this.updateFlushFrequency();
                        this.sendAllData(this.mDbAdapter);
                    } else if (msg.what == CHECK_FOR_SURVEYS) {
                        AnalyticsMessages.this.logAboutMessageToMixpanel("Flushing before checking surveys");
                        Worker.this.updateFlushFrequency();
                        this.sendAllData(this.mDbAdapter);
                        AnalyticsMessages.this.logAboutMessageToMixpanel("Checking Mixpanel for available surveys");
                        SurveyCheck check = (SurveyCheck)msg.obj;
                        this.runSurveyCheck(check);
                    } else if (msg.what == KILL_WORKER) {
                        Log.w((String)AnalyticsMessages.LOGTAG, (String)("Worker recieved a hard kill. Dumping all events and force-killing. Thread id " + Thread.currentThread().getId()));
                        Object object = Worker.this.mHandlerLock;
                        synchronized (object) {
                            this.mDbAdapter.deleteDB();
                            Worker.this.mHandler = null;
                            Looper.myLooper().quit();
                        }
                    } else {
                        Log.e((String)AnalyticsMessages.LOGTAG, (String)("Unexpected message recieved by Mixpanel worker: " + msg));
                    }
                    if (queueDepth >= AnalyticsMessages.this.mConfig.getBulkUploadLimit()) {
                        AnalyticsMessages.this.logAboutMessageToMixpanel("Flushing queue due to bulk upload limit");
                        Worker.this.updateFlushFrequency();
                        this.sendAllData(this.mDbAdapter);
                    } else if (queueDepth > 0 && !this.hasMessages(FLUSH_QUEUE)) {
                        AnalyticsMessages.this.logAboutMessageToMixpanel("Queue depth " + queueDepth + " - Adding flush in " + this.mFlushInterval);
                        if (this.mFlushInterval >= 0L) {
                            this.sendEmptyMessageDelayed(FLUSH_QUEUE, this.mFlushInterval);
                        }
                    }
                }
                catch (RuntimeException e) {
                    Log.e((String)AnalyticsMessages.LOGTAG, (String)"Worker threw an unhandled exception- will not send any more mixpanel messages", (Throwable)e);
                    Object object = Worker.this.mHandlerLock;
                    synchronized (object) {
                        Worker.this.mHandler = null;
                        try {
                            Looper.myLooper().quit();
                        }
                        catch (Exception tooLate) {
                            Log.e((String)AnalyticsMessages.LOGTAG, (String)"Could not halt looper", (Throwable)tooLate);
                        }
                    }
                    throw e;
                }
            }

            private void runSurveyCheck(SurveyCheck check) {
                String escapedId;
                String escapedToken;
                final SurveyCallbacks callbacks = check.getCallbacks();
                try {
                    escapedToken = URLEncoder.encode(check.getToken(), "utf-8");
                    escapedId = URLEncoder.encode(check.getDistinctId(), "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Mixpanel library requires utf-8 string encoding to be available", e);
                }
                String checkQuery = "?version=1&lib=android&token=" + escapedToken + "&distinct_id=" + escapedId;
                String endpointUrl = AnalyticsMessages.this.mConfig.getDecideEndpoint() + checkQuery;
                String fallbackUrl = AnalyticsMessages.this.mConfig.getDecideFallbackEndpoint() + checkQuery;
                ServerMessage poster = AnalyticsMessages.this.getPoster();
                ServerMessage.Result result = poster.get(endpointUrl, fallbackUrl);
                if (result.getStatus() != ServerMessage.Status.SUCCEEDED) {
                    Log.e((String)AnalyticsMessages.LOGTAG, (String)"Couldn't reach Mixpanel to check for Surveys.");
                    return;
                }
                String response = result.getResponse();
                JSONArray surveys = null;
                try {
                    JSONObject parsed = new JSONObject(response);
                    surveys = parsed.getJSONArray("surveys");
                }
                catch (JSONException e) {
                    Log.e((String)AnalyticsMessages.LOGTAG, (String)("Mixpanel endpoint returned invalid JSON " + response));
                    return;
                }
                Survey found = null;
                for (int i = 0; found == null && i < surveys.length(); ++i) {
                    try {
                        JSONObject candidateJson = surveys.getJSONObject(i);
                        Survey candidate = new Survey(candidateJson);
                        if (this.mSeenSurveys.contains(candidate.getId())) {
                            Log.i((String)AnalyticsMessages.LOGTAG, (String)"Recieved a duplicate survey from Mixpanel, ignoring.");
                            continue;
                        }
                        found = candidate;
                        continue;
                    }
                    catch (JSONException e) {
                        found = null;
                    }
                }
                final Survey toReport = found;
                Looper mainLooper = Looper.getMainLooper();
                if (mainLooper != null) {
                    new Handler(mainLooper).post(new Runnable(){

                        @Override
                        public void run() {
                            callbacks.foundSurvey(toReport);
                        }
                    });
                } else {
                    callbacks.foundSurvey(toReport);
                }
            }

            public boolean isOnline() {
                boolean isOnline;
                try {
                    ConnectivityManager cm = (ConnectivityManager)AnalyticsMessages.this.mContext.getSystemService("connectivity");
                    NetworkInfo netInfo = cm.getActiveNetworkInfo();
                    isOnline = netInfo != null && netInfo.isConnectedOrConnecting();
                    Log.d((String)AnalyticsMessages.LOGTAG, (String)("ConnectivityManager says we " + (isOnline ? "are" : "are not") + " online"));
                }
                catch (SecurityException e) {
                    isOnline = true;
                    Log.d((String)AnalyticsMessages.LOGTAG, (String)"Don't have permission to check connectivity so returning true");
                }
                return isOnline;
            }

            private void sendAllData(MPDbAdapter dbAdapter) {
                if (this.isOnline()) {
                    AnalyticsMessages.this.logAboutMessageToMixpanel("Sending records to Mixpanel");
                    if (this.mDisableFallback) {
                        this.sendData(dbAdapter, MPDbAdapter.Table.EVENTS, AnalyticsMessages.this.mConfig.getEventsEndpoint(), null);
                        this.sendData(dbAdapter, MPDbAdapter.Table.PEOPLE, AnalyticsMessages.this.mConfig.getPeopleEndpoint(), null);
                    } else {
                        this.sendData(dbAdapter, MPDbAdapter.Table.EVENTS, AnalyticsMessages.this.mConfig.getEventsEndpoint(), AnalyticsMessages.this.mConfig.getEventsFallbackEndpoint());
                        this.sendData(dbAdapter, MPDbAdapter.Table.PEOPLE, AnalyticsMessages.this.mConfig.getPeopleEndpoint(), AnalyticsMessages.this.mConfig.getPeopleFallbackEndpoint());
                    }
                } else {
                    AnalyticsMessages.this.logAboutMessageToMixpanel("Can't send data to mixpanel, because the device is not connected to the internet");
                }
            }

            private void sendData(MPDbAdapter dbAdapter, MPDbAdapter.Table table, String endpointUrl, String fallbackUrl) {
                String[] eventsData = dbAdapter.generateDataString(table);
                if (eventsData != null) {
                    String lastId = eventsData[0];
                    String rawMessage = eventsData[1];
                    ServerMessage poster = AnalyticsMessages.this.getPoster();
                    ServerMessage.Result eventsPosted = poster.postData(rawMessage, endpointUrl, fallbackUrl);
                    ServerMessage.Status postStatus = eventsPosted.getStatus();
                    if (postStatus == ServerMessage.Status.SUCCEEDED) {
                        AnalyticsMessages.this.logAboutMessageToMixpanel("Posted to " + endpointUrl);
                        AnalyticsMessages.this.logAboutMessageToMixpanel("Sent Message\n" + rawMessage);
                        dbAdapter.cleanupEvents(lastId, table);
                    } else if (postStatus == ServerMessage.Status.FAILED_RECOVERABLE) {
                        if (!this.hasMessages(FLUSH_QUEUE)) {
                            this.sendEmptyMessageDelayed(FLUSH_QUEUE, this.mFlushInterval);
                        }
                    } else {
                        dbAdapter.cleanupEvents(lastId, table);
                    }
                }
            }

            private JSONObject getDefaultEventProperties() throws JSONException {
                String bluetoothVersion;
                Boolean isBluetoothEnabled;
                Boolean isWifi;
                String carrier;
                Boolean hasTelephony;
                Boolean hasNFC;
                JSONObject ret = new JSONObject();
                ret.put("mp_lib", (Object)"android");
                ret.put("$lib_version", (Object)"4.0.0-RC1");
                ret.put("$os", (Object)"Android");
                ret.put("$os_version", (Object)(Build.VERSION.RELEASE == null ? "UNKNOWN" : Build.VERSION.RELEASE));
                ret.put("$manufacturer", (Object)(Build.MANUFACTURER == null ? "UNKNOWN" : Build.MANUFACTURER));
                ret.put("$brand", (Object)(Build.BRAND == null ? "UNKNOWN" : Build.BRAND));
                ret.put("$model", (Object)(Build.MODEL == null ? "UNKNOWN" : Build.MODEL));
                DisplayMetrics displayMetrics = Worker.this.mSystemInformation.getDisplayMetrics();
                ret.put("$screen_dpi", displayMetrics.densityDpi);
                ret.put("$screen_height", displayMetrics.heightPixels);
                ret.put("$screen_width", displayMetrics.widthPixels);
                String applicationVersionName = Worker.this.mSystemInformation.getAppVersionName();
                if (null != applicationVersionName) {
                    ret.put("$app_version", (Object)applicationVersionName);
                }
                if (null != (hasNFC = Boolean.valueOf(Worker.this.mSystemInformation.hasNFC()))) {
                    ret.put("$has_nfc", hasNFC.booleanValue());
                }
                if (null != (hasTelephony = Boolean.valueOf(Worker.this.mSystemInformation.hasTelephony()))) {
                    ret.put("$has_telephone", hasTelephony.booleanValue());
                }
                if (null != (carrier = Worker.this.mSystemInformation.getCurrentNetworkOperator())) {
                    ret.put("$carrier", (Object)carrier);
                }
                if (null != (isWifi = Worker.this.mSystemInformation.isWifiConnected())) {
                    ret.put("$wifi", isWifi.booleanValue());
                }
                if ((isBluetoothEnabled = Worker.this.mSystemInformation.isBluetoothEnabled()) != null) {
                    ret.put("$bluetooth_enabled", (Object)isBluetoothEnabled);
                }
                if ((bluetoothVersion = Worker.this.mSystemInformation.getBluetoothVersion()) != null) {
                    ret.put("$bluetooth_version", (Object)bluetoothVersion);
                }
                return ret;
            }

            private JSONObject prepareEventObject(EventDTO eventDTO) throws JSONException {
                JSONObject eventObj = new JSONObject();
                JSONObject properties = eventDTO.getProperties();
                JSONObject propertiesObj = this.getDefaultEventProperties();
                propertiesObj.put("token", (Object)eventDTO.getToken());
                if (properties != null) {
                    Iterator iter = properties.keys();
                    while (iter.hasNext()) {
                        String key = (String)iter.next();
                        propertiesObj.put(key, properties.get(key));
                    }
                }
                eventObj.put("event", (Object)eventDTO.getEventName());
                eventObj.put("properties", (Object)propertiesObj);
                return eventObj;
            }
        }
    }

    static class EventDTO {
        private String eventName;
        private JSONObject properties;
        private String token;

        public EventDTO(String eventName, JSONObject properties, String token) {
            this.eventName = eventName;
            this.properties = properties;
            this.token = token;
        }

        public String getEventName() {
            return this.eventName;
        }

        public JSONObject getProperties() {
            return this.properties;
        }

        public String getToken() {
            return this.token;
        }
    }

    public static interface SurveyCheck {
        public SurveyCallbacks getCallbacks();

        public String getDistinctId();

        public String getToken();
    }
}

