/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.utils;

import android.support.annotation.NonNull;
import com.mikepenz.fastadapter.IIdentifyable;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class IdDistributor {
    private static final AtomicLong idDistributor = new AtomicLong(9000000000000000000L);

    public static <T extends IIdentifyable> List<T> checkIds(@NonNull List<T> items) {
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            IdDistributor.checkId((IIdentifyable)items.get(i));
        }
        return items;
    }

    public static <T extends IIdentifyable> T[] checkIds(T ... items) {
        for (T item : items) {
            IdDistributor.checkId(item);
        }
        return items;
    }

    public static <T extends IIdentifyable> T checkId(@NonNull T item) {
        if (item.getIdentifier() == -1L) {
            item.withIdentifier(idDistributor.incrementAndGet());
        }
        return item;
    }
}

