/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries.plugin.api;

import com.mikepenz.aboutlibraries.plugin.api.IApi;
import com.mikepenz.aboutlibraries.plugin.mapping.Funding;
import com.mikepenz.aboutlibraries.plugin.mapping.License;
import com.mikepenz.aboutlibraries.plugin.mapping.Scm;
import com.mikepenz.aboutlibraries.plugin.util.LicenseUtil;
import groovy.json.JsonSlurper;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0006H\u0002J\u001e\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0003H\u0002J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J2\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0016\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u0015j\b\u0012\u0004\u0012\u00020\u0016`\u0017H\u0016J0\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0016\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u0015j\b\u0012\u0004\u0012\u00020\u0016`\u0017H\u0002J\b\u0010\u001a\u001a\u00020\fH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/mikepenz/aboutlibraries/plugin/api/GitHubApi;", "Lcom/mikepenz/aboutlibraries/plugin/api/IApi;", "gitHubToken", "", "(Ljava/lang/String;)V", "rateLimit", "", "availableGitHubRateLimit", "discoverBase", "Lkotlin/Pair;", "url", "fetchFunding", "", "uniqueId", "repositoryLink", "Lcom/mikepenz/aboutlibraries/plugin/mapping/Scm;", "funding", "", "Lcom/mikepenz/aboutlibraries/plugin/mapping/Funding;", "fetchRemoteLicense", "licenses", "Ljava/util/HashSet;", "Lcom/mikepenz/aboutlibraries/plugin/mapping/License;", "Lkotlin/collections/HashSet;", "getLicenseFromGitHubAPI", "", "updateAndCheckRateLimit", "Companion", "plugin"})
@SourceDebugExtension(value={"SMAP\nGitHubApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitHubApi.kt\ncom/mikepenz/aboutlibraries/plugin/api/GitHubApi\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,213:1\n1855#2,2:214\n1855#2,2:217\n1855#2,2:219\n766#2:221\n857#2,2:222\n1#3:216\n*S KotlinDebug\n*F\n+ 1 GitHubApi.kt\ncom/mikepenz/aboutlibraries/plugin/api/GitHubApi\n*L\n55#1:214,2\n130#1:217,2\n159#1:219,2\n186#1:221\n186#1:222,2\n*E\n"})
public final class GitHubApi
implements IApi {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private final String gitHubToken;
    private int rateLimit;
    @NotNull
    private static final String GITHUB_API = "https://api.github.com/";
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static final HashMap<String, Set<Funding>> remoteFundingCache;

    public GitHubApi(@Nullable String gitHubToken) {
        this.gitHubToken = gitHubToken;
        this.rateLimit = this.availableGitHubRateLimit();
    }

    public /* synthetic */ GitHubApi(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string);
    }

    /*
     * WARNING - void declaration
     */
    private final int availableGitHubRateLimit() {
        int n;
        try {
            void var3_5;
            URLConnection connection = new URL("https://api.github.com/rate_limit").openConnection();
            String string = this.gitHubToken;
            boolean bl = string != null ? !StringsKt.isBlank((CharSequence)string) : false;
            if (bl) {
                connection.setRequestProperty("Authorization", "token " + this.gitHubToken);
            }
            JsonSlurper jsonSlurper = new JsonSlurper();
            InputStream inputStream = connection.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            Object object = jsonSlurper.parse(ByteStreamsKt.readBytes((InputStream)inputStream));
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, *>");
            Map rateLimit = (Map)object;
            Object v = rateLimit.get("rate");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, *>");
            Object v2 = ((Map)v).get("remaining");
            Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.Int");
            int limit = (Integer)v2;
            if (limit == 0) {
                LOGGER.warn("GitHub `rate_limit` exhausted. Won't be able to use the GitHub API. Please check if the token is provided, or enable `offlineMode`.");
            }
            n = var3_5;
        }
        catch (Throwable t) {
            LOGGER.error("Could not retrieve `rate_limit`. Please check if the token is provided.");
            n = 0;
        }
        return n;
    }

    @Override
    public void fetchRemoteLicense(@NotNull String uniqueId, @Nullable Scm repositoryLink, @NotNull HashSet<License> licenses2) {
        String url;
        Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
        Intrinsics.checkNotNullParameter(licenses2, (String)"licenses");
        Scm scm2 = repositoryLink;
        String string = url = scm2 != null ? scm2.getUrl() : null;
        if (this.rateLimit > 0) {
            String string2 = url;
            boolean bl = string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"github", (boolean)false, (int)2, null) : false;
            if (bl) {
                LOGGER.debug("Remaining GitHub rate limit: " + this.rateLimit);
                boolean calledGitHub = this.getLicenseFromGitHubAPI(uniqueId, url, licenses2);
                if (!((Collection)licenses2).isEmpty()) {
                    Iterable $this$forEach$iv = licenses2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        License it = (License)element$iv;
                        boolean bl2 = false;
                        if (it.getSpdxId() == null || it.getContent() != null) continue;
                        LicenseUtil.INSTANCE.loadSpdxLicense(it);
                    }
                } else {
                    License license = (License)CollectionsKt.firstOrNull((Iterable)licenses2);
                    LOGGER.info("Retrieved license (" + (license != null ? license.getName() : null) + ") via GitHub license API");
                }
                if (calledGitHub) {
                    this.updateAndCheckRateLimit();
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean getLicenseFromGitHubAPI(String uniqueId, String url, HashSet<License> licenses2) {
        boolean calledGitHub;
        block7: {
            calledGitHub = false;
            Pair<String, String> pair = this.discoverBase(url);
            if (pair == null) break block7;
            Pair<String, String> pair2 = pair;
            boolean bl = false;
            String user = (String)pair2.component1();
            String project = (String)pair2.component2();
            String licenseApi = "https://api.github.com/repos/" + user + "/" + project + "/license";
            try {
                String content;
                Map map;
                URLConnection connection = new URL(licenseApi).openConnection();
                CharSequence charSequence = this.gitHubToken;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                    connection.setRequestProperty("Authorization", "token " + this.gitHubToken);
                }
                try {
                    JsonSlurper jsonSlurper = new JsonSlurper();
                    InputStream inputStream = connection.getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                    Object object = jsonSlurper.parse(ByteStreamsKt.readBytes((InputStream)inputStream));
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, *>");
                    map = (Map)object;
                }
                catch (Throwable t) {
                    return calledGitHub;
                }
                Map licensesApiResult = map;
                calledGitHub = true;
                Object v = licensesApiResult.get("download_url");
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
                String rawLicense = (String)v;
                Object v2 = licensesApiResult.get("license");
                Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
                Map licenseInformation = (Map)v2;
                String string = content = LicenseUtil.INSTANCE.loadLicenseCached$plugin(rawLicense);
                boolean bl2 = string != null ? !StringsKt.isBlank((CharSequence)string) : false;
                if (bl2) {
                    void it;
                    License hasSame;
                    String spdxId = (String)licenseInformation.get("spdx_id");
                    Object object = spdxId;
                    if (!(object == null || StringsKt.isBlank((CharSequence)object)) && (hasSame = LicenseUtil.INSTANCE.findSameSpdx(licenses2, spdxId)) != null) {
                        licenses2.remove(hasSame);
                        LOGGER.debug("Replace POM license with REPO library");
                    }
                    Object v3 = licenseInformation.get("name");
                    Intrinsics.checkNotNull(v3);
                    Object object2 = object = new License((String)v3, rawLicense, null, content);
                    HashSet<License> hashSet = licenses2;
                    boolean bl3 = false;
                    it.setSpdxId(spdxId);
                    hashSet.add((License)object);
                }
            }
            catch (Throwable t) {
                LOGGER.warn("Could not fetch license for " + user + "/" + project + " - (" + uniqueId + ")", t);
            }
        }
        return calledGitHub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetchFunding(@NotNull String uniqueId, @Nullable Scm repositoryLink, @NotNull Set<Funding> funding) {
        block16: {
            String project;
            Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
            Intrinsics.checkNotNullParameter(funding, (String)"funding");
            Object object = repositoryLink;
            if (object == null || (object = ((Scm)object).getUrl()) == null) {
                return;
            }
            Object url = object;
            Pair<String, String> pair = this.discoverBase((String)url);
            if (pair == null) break block16;
            Pair<String, String> pair2 = pair;
            boolean bl = false;
            String user = (String)pair2.component1();
            String cacheKey = user + "/" + (project = (String)pair2.component2());
            if (remoteFundingCache.containsKey(cacheKey)) {
                Set<Funding> set;
                Set<Funding> set2 = set = remoteFundingCache.get(cacheKey);
                if (set2 != null) {
                    Intrinsics.checkNotNull(set2);
                    Iterable $this$forEach$iv = set;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Funding it = (Funding)element$iv;
                        boolean bl2 = false;
                        funding.add(it);
                    }
                }
                return;
            }
            if (this.rateLimit <= 0) {
                return;
            }
            try {
                URLConnection connection = new URL("https://api.github.com/graphql").openConnection();
                Object $this$forEach$iv = this.gitHubToken;
                if (!($this$forEach$iv == null || StringsKt.isBlank((CharSequence)$this$forEach$iv))) {
                    connection.setRequestProperty("Authorization", "token " + this.gitHubToken);
                }
                connection.setDoOutput(true);
                $this$forEach$iv = new OutputStreamWriter(connection.getOutputStream());
                Throwable $i$f$forEach = null;
                try {
                    OutputStreamWriter it = (OutputStreamWriter)$this$forEach$iv;
                    boolean bl3 = false;
                    it.write(StringsKt.trimIndent((String)("\n                    {\"query\": \"query { repository(name: \\\"" + project + "\\\", owner: \\\"" + user + "\\\") { fundingLinks { platform url } } }\" }\n                    ")));
                    it.flush();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    $i$f$forEach = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)$this$forEach$iv, (Throwable)$i$f$forEach);
                }
                Set localFunding = new LinkedHashSet();
                JsonSlurper jsonSlurper = new JsonSlurper();
                InputStream inputStream = connection.getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                Object object2 = jsonSlurper.parse(ByteStreamsKt.readBytes((InputStream)inputStream));
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.collections.Map<kotlin.String, kotlin.collections.Map<kotlin.String, java.util.ArrayList<kotlin.collections.Map<kotlin.String, kotlin.String>>{ kotlin.collections.TypeAliasesKt.ArrayList<kotlin.collections.Map<kotlin.String, kotlin.String>> }>>>");
                Map fundingResult = (Map)object2;
                Object object3 = (Map)fundingResult.get("data");
                if (object3 != null && (object3 = (Map)object3.get("repository")) != null && (object3 = (ArrayList)object3.get("fundingLinks")) != null) {
                    Iterable $this$forEach$iv2 = (Iterable)object3;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv2) {
                        Map it = (Map)element$iv;
                        boolean bl4 = false;
                        String platform = (String)it.get("platform");
                        String fundingUrl = (String)it.get("url");
                        if (platform == null || fundingUrl == null) continue;
                        localFunding.add(new Funding(platform, fundingUrl));
                    }
                }
                ((Map)remoteFundingCache).put(cacheKey, localFunding);
                funding.addAll(localFunding);
                this.updateAndCheckRateLimit();
            }
            catch (Throwable t) {
                LOGGER.warn("Could not fetch funding for " + user + "/" + project + " - (" + uniqueId + ")", t);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<String, String> discoverBase(String url) {
        void $this$filterTo$iv$iv;
        String[] stringArray = new String[]{"/"};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)url, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List parts = (List)destination$iv$iv;
        if (parts.size() > 3 && StringsKt.contains$default((CharSequence)((CharSequence)parts.get(parts.size() - 3)), (CharSequence)"github", (boolean)false, (int)2, null)) {
            return TuplesKt.to(parts.get(parts.size() - 2), parts.get(parts.size() - 1));
        }
        return null;
    }

    private final void updateAndCheckRateLimit() {
        --this.rateLimit;
        if (this.rateLimit <= 0) {
            LOGGER.warn("GitHub `rate_limit` exhausted. The plugin be able to use the GitHub API.");
        }
    }

    public GitHubApi() {
        this(null, 1, null);
    }

    static {
        Logger logger = LoggerFactory.getLogger(GitHubApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
        remoteFundingCache = new HashMap();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0007\u001a*\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bj\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/mikepenz/aboutlibraries/plugin/api/GitHubApi$Companion;", "", "()V", "GITHUB_API", "", "LOGGER", "Lorg/slf4j/Logger;", "remoteFundingCache", "Ljava/util/HashMap;", "", "Lcom/mikepenz/aboutlibraries/plugin/mapping/Funding;", "Lkotlin/collections/HashMap;", "plugin"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

