/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries.plugin;

import com.mikepenz.aboutlibraries.plugin.BaseAboutLibrariesTask;
import com.mikepenz.aboutlibraries.plugin.StrictMode;
import com.mikepenz.aboutlibraries.plugin.mapping.Library;
import com.mikepenz.aboutlibraries.plugin.mapping.License;
import com.mikepenz.aboutlibraries.plugin.model.ResultContainer;
import com.mikepenz.aboutlibraries.plugin.model.ResultContainerKt;
import com.mikepenz.aboutlibraries.plugin.util.ExtensionsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CacheableTask
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0007R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR&\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00048\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0006\"\u0004\b\u0010\u0010\bR\u0016\u0010\u0011\u001a\u00020\u00128\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lcom/mikepenz/aboutlibraries/plugin/AboutLibrariesTask;", "Lcom/mikepenz/aboutlibraries/plugin/BaseAboutLibrariesTask;", "()V", "combinedLibrariesOutputFile", "Ljava/io/File;", "getCombinedLibrariesOutputFile", "()Ljava/io/File;", "setCombinedLibrariesOutputFile", "(Ljava/io/File;)V", "outputFileName", "", "getOutputFileName", "()Ljava/lang/String;", "value", "resultDirectory", "getResultDirectory", "setResultDirectory", "strictMode", "Lcom/mikepenz/aboutlibraries/plugin/StrictMode;", "getStrictMode", "()Lcom/mikepenz/aboutlibraries/plugin/StrictMode;", "action", "", "Companion", "plugin"})
@SourceDebugExtension(value={"SMAP\nAboutLibrariesTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AboutLibrariesTask.kt\ncom/mikepenz/aboutlibraries/plugin/AboutLibrariesTask\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n11065#2:87\n11400#2,3:88\n1855#3,2:91\n1855#3:93\n1855#3,2:94\n1856#3:96\n*S KotlinDebug\n*F\n+ 1 AboutLibrariesTask.kt\ncom/mikepenz/aboutlibraries/plugin/AboutLibrariesTask\n*L\n38#1:87\n38#1:88,3\n42#1:91,2\n62#1:93\n64#1:94,2\n62#1:96\n*E\n"})
public abstract class AboutLibrariesTask
extends BaseAboutLibrariesTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Input
    @NotNull
    private final StrictMode strictMode = this.getExtension().getStrictMode();
    @Input
    @NotNull
    private final String outputFileName = this.getExtension().getOutputFileName();
    @Internal
    @NotNull
    private File resultDirectory;
    @OutputFile
    @NotNull
    private File combinedLibrariesOutputFile;
    private static final Logger LOGGER = LoggerFactory.getLogger(AboutLibrariesTask.class);

    public AboutLibrariesTask() {
        File file = this.getProject().file((Object)(this.getProject().getBuildDir() + "/generated/aboutLibraries/res/"));
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file(...)");
        this.resultDirectory = file;
        this.combinedLibrariesOutputFile = new File(this.resultDirectory, this.outputFileName);
    }

    @NotNull
    public final StrictMode getStrictMode() {
        return this.strictMode;
    }

    @NotNull
    public final String getOutputFileName() {
        return this.outputFileName;
    }

    @NotNull
    public final File getResultDirectory() {
        return this.resultDirectory;
    }

    public final void setResultDirectory(@NotNull File value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.resultDirectory = value;
        this.combinedLibrariesOutputFile = new File(this.resultDirectory, this.outputFileName);
    }

    @NotNull
    public final File getCombinedLibrariesOutputFile() {
        return this.combinedLibrariesOutputFile;
    }

    public final void setCombinedLibrariesOutputFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.combinedLibrariesOutputFile = file;
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        ResultContainer result;
        block16: {
            CharSequence id;
            void $this$mapTo$iv$iv;
            if (!this.resultDirectory.exists()) {
                this.resultDirectory.mkdirs();
            }
            result = BaseAboutLibrariesTask.createLibraryProcessor$default(this, null, 1, null).gatherDependencies();
            String[] $this$map$iv = this.getAllowedLicenses();
            boolean $i$f$map = false;
            String[] stringArray = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (String item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                void var11_22 = item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                Iterator iterator = it;
                Locale locale = Locale.ENGLISH;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
                String string = ((String)((Object)iterator)).toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                collection.add(string);
            }
            List allowedLicenses = (List)destination$iv$iv2;
            if (!(!((Collection)allowedLicenses).isEmpty()) || this.strictMode == StrictMode.IGNORE) break block16;
            List missing = new ArrayList();
            Iterable $this$forEach$iv = result.getLicenses().values();
            int $i$f$forEach = 0;
            for (Object element$iv : $this$forEach$iv) {
                String name;
                String url;
                String string;
                String string2;
                License it;
                block18: {
                    String item$iv$iv;
                    block17: {
                        it = (License)element$iv;
                        boolean bl = false;
                        string2 = it.getSpdxId();
                        if (string2 == null) break block17;
                        item$iv$iv = string2;
                        Locale locale = Locale.ENGLISH;
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
                        String string3 = item$iv$iv.toLowerCase(locale);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                        string2 = string3;
                        if (string3 != null) break block18;
                    }
                    item$iv$iv = it.getHash();
                    Locale locale = Locale.ENGLISH;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
                    String string4 = item$iv$iv.toLowerCase(locale);
                    string2 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                }
                id = string2;
                String bl = it.getName();
                Locale locale = Locale.ENGLISH;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
                Intrinsics.checkNotNullExpressionValue((Object)bl.toLowerCase(locale), (String)"toLowerCase(...)");
                if (it.getUrl() != null) {
                    String string5;
                    Locale locale2 = Locale.ENGLISH;
                    Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"ENGLISH");
                    String string6 = string5.toLowerCase(locale2);
                    string = string6;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
                } else {
                    string = url = null;
                }
                if (allowedLicenses.contains(id) || allowedLicenses.contains(name)) continue;
                String string7 = url;
                if ((string7 != null ? ((CharSequence)string7).length() > 0 : false) && allowedLicenses.contains(url)) continue;
                missing.add(it);
            }
            if (missing.isEmpty()) {
                LOGGER.info("No libraries detected using a license not allowed.");
            } else {
                StringBuilder message = new StringBuilder();
                $i$f$forEach = 2;
                int destination$iv$iv2 = 0;
                while (destination$iv$iv2 < $i$f$forEach) {
                    int it = destination$iv$iv2++;
                    boolean bl = false;
                    StringBuilder stringBuilder = message.append("=======================================");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
                }
                StringBuilder stringBuilder = message.append("Detected usage of not allowed licenses!");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
                Iterable $this$forEach$iv2 = missing;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    License it = (License)element$iv;
                    boolean bl = false;
                    id = message;
                    String string = it.getName();
                    String string8 = it.getSpdxId();
                    if (string8 == null) {
                        string8 = "-";
                    }
                    StringBuilder stringBuilder2 = ((StringBuilder)id).append("-> License: " + string + " | " + string8 + " (" + it.getUrl() + "), used by:");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
                    Iterable $this$forEach$iv3 = ExtensionsKt.forLicense(result.getLibraries(), it);
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv2 : $this$forEach$iv3) {
                        Library lib = (Library)element$iv2;
                        boolean bl2 = false;
                        StringBuilder stringBuilder3 = message.append("    " + lib.getUniqueId());
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
                    }
                }
                int n = 2;
                int n2 = 0;
                while (n2 < n) {
                    int it = n2++;
                    boolean bl = false;
                    StringBuilder stringBuilder4 = message.append("=======================================");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
                }
                if (this.strictMode == StrictMode.FAIL) {
                    throw new IllegalStateException(message.toString());
                }
                LOGGER.warn(message.toString());
            }
        }
        ResultContainerKt.writeToDisk(result, this.combinedLibrariesOutputFile, this.getExcludeFields(), this.getExtension().getPrettyPrint());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/mikepenz/aboutlibraries/plugin/AboutLibrariesTask$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

