/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries.plugin;

import com.mikepenz.aboutlibraries.plugin.AboutLibrariesCollectorTask;
import com.mikepenz.aboutlibraries.plugin.AboutLibrariesExportTask;
import com.mikepenz.aboutlibraries.plugin.AboutLibrariesExtension;
import com.mikepenz.aboutlibraries.plugin.AboutLibrariesFundingTask;
import com.mikepenz.aboutlibraries.plugin.AboutLibrariesIdTask;
import com.mikepenz.aboutlibraries.plugin.AboutLibrariesPlugin;
import com.mikepenz.aboutlibraries.plugin.AboutLibrariesPluginAndroidExtension;
import com.mikepenz.aboutlibraries.plugin.AboutLibrariesTask;
import com.mikepenz.aboutlibraries.plugin.util.ExtensionsKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/mikepenz/aboutlibraries/plugin/AboutLibrariesPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "experimentalCache", "", "getExperimentalCache", "(Lorg/gradle/api/Project;)Z", "apply", "", "project", "Companion", "plugin"})
public final class AboutLibrariesPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger LOGGER = LoggerFactory.getLogger(AboutLibrariesPlugin.class);

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"5.0")) < 0) {
            project.getLogger().error("Gradle 5.0 or greater is required to apply this plugin.");
            return;
        }
        project.getExtensions().create("aboutLibraries", AboutLibrariesExtension.class, new Object[0]);
        project.afterEvaluate(arg_0 -> AboutLibrariesPlugin.apply$lambda$0((Function1)new Function1<Project, Unit>(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ AboutLibrariesPlugin this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Project it) {
                TaskProvider collectTask2 = this.$project.getTasks().register("collectDependencies", AboutLibrariesCollectorTask.class, arg_0 -> apply.1.invoke$lambda$0((Function1)new Function1<AboutLibrariesCollectorTask, Unit>(this.this$0, this.$project){
                    final /* synthetic */ AboutLibrariesPlugin this$0;
                    final /* synthetic */ Project $project;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        super(1);
                    }

                    public final void invoke(AboutLibrariesCollectorTask it) {
                        it.setDescription("Collects dependencies to be used by the different AboutLibraries tasks");
                        if (AboutLibrariesPlugin.access$getExperimentalCache(this.this$0, this.$project)) {
                            it.configure();
                        }
                    }
                }, arg_0));
                this.$project.getTasks().register("fundLibraries", AboutLibrariesFundingTask.class, arg_0 -> apply.1.invoke$lambda$1((Function1)new Function1<AboutLibrariesFundingTask, Unit>((TaskProvider<AboutLibrariesCollectorTask>)collectTask2){
                    final /* synthetic */ TaskProvider<AboutLibrariesCollectorTask> $collectTask;
                    {
                        this.$collectTask = $collectTask;
                        super(1);
                    }

                    public final void invoke(AboutLibrariesFundingTask it) {
                        it.setDescription("Outputs the funding options for used dependencies");
                        it.setGroup("Help");
                        Object[] objectArray = new Object[]{this.$collectTask};
                        it.dependsOn(objectArray);
                    }
                }, arg_0));
                this.$project.getTasks().register("findLibraries", AboutLibrariesIdTask.class, arg_0 -> apply.1.invoke$lambda$2((Function1)new Function1<AboutLibrariesIdTask, Unit>((TaskProvider<AboutLibrariesCollectorTask>)collectTask2){
                    final /* synthetic */ TaskProvider<AboutLibrariesCollectorTask> $collectTask;
                    {
                        this.$collectTask = $collectTask;
                        super(1);
                    }

                    public final void invoke(AboutLibrariesIdTask it) {
                        it.setDescription("Writes the relevant meta data for the AboutLibraries plugin to display dependencies");
                        it.setGroup("Help");
                        Object[] objectArray = new Object[]{this.$collectTask};
                        it.dependsOn(objectArray);
                    }
                }, arg_0));
                this.$project.getTasks().register("exportLibraries", AboutLibrariesExportTask.class, arg_0 -> apply.1.invoke$lambda$3((Function1)new Function1<AboutLibrariesExportTask, Unit>((TaskProvider<AboutLibrariesCollectorTask>)collectTask2){
                    final /* synthetic */ TaskProvider<AboutLibrariesCollectorTask> $collectTask;
                    {
                        this.$collectTask = $collectTask;
                        super(1);
                    }

                    public final void invoke(AboutLibrariesExportTask it) {
                        it.setDescription("Writes all libraries and their license in CSV format to the CLI");
                        it.setGroup("Help");
                        Object[] objectArray = new Object[]{this.$collectTask};
                        it.dependsOn(objectArray);
                    }
                }, arg_0));
                this.$project.getTasks().register("exportLibraryDefinitions", AboutLibrariesTask.class, arg_0 -> apply.1.invoke$lambda$4((Function1)new Function1<AboutLibrariesTask, Unit>(this.$project, (TaskProvider<AboutLibrariesCollectorTask>)collectTask2){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ TaskProvider<AboutLibrariesCollectorTask> $collectTask;
                    {
                        this.$project = $project;
                        this.$collectTask = $collectTask;
                        super(1);
                    }

                    public final void invoke(AboutLibrariesTask it) {
                        it.setDescription("Writes the relevant meta data for the AboutLibraries plugin to display dependencies");
                        it.setGroup("Build");
                        String string = ExtensionsKt.safeProp(this.$project, "aboutLibraries.exportVariant");
                        if (string == null) {
                            string = ExtensionsKt.safeProp(this.$project, "exportVariant");
                        }
                        it.setVariant(string);
                        Object object = ExtensionsKt.safeProp(this.$project, "aboutLibraries.exportPath");
                        if (object == null && (object = ExtensionsKt.safeProp(this.$project, "exportPath")) == null) {
                            object = this.$project.getBuildDir() + "/generated/aboutLibraries/";
                        }
                        File file = this.$project.file(object);
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file(...)");
                        it.setResultDirectory(file);
                        Object[] objectArray = new Object[]{this.$collectTask};
                        it.dependsOn(objectArray);
                    }
                }, arg_0));
                Object object = this.$project.getExtensions().getByName("aboutLibraries");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.mikepenz.aboutlibraries.plugin.AboutLibrariesExtension");
                AboutLibrariesExtension extension = (AboutLibrariesExtension)object;
                if (extension.getRegisterAndroidTasks()) {
                    Intrinsics.checkNotNull((Object)collectTask2);
                    AboutLibrariesPluginAndroidExtension.INSTANCE.apply(this.$project, (TaskProvider<AboutLibrariesCollectorTask>)collectTask2);
                }
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void invoke$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void invoke$lambda$2(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void invoke$lambda$3(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void invoke$lambda$4(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0));
    }

    private final boolean getExperimentalCache(Project $this$experimentalCache) {
        return $this$experimentalCache.hasProperty("org.gradle.unsafe.configuration-cache") && Intrinsics.areEqual((Object)$this$experimentalCache.property("org.gradle.unsafe.configuration-cache"), (Object)"true") || $this$experimentalCache.hasProperty("org.gradle.configuration-cache") && Intrinsics.areEqual((Object)$this$experimentalCache.property("org.gradle.configuration-cache"), (Object)"true");
    }

    private static final void apply$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$getExperimentalCache(AboutLibrariesPlugin $this, Project $receiver) {
        return $this.getExperimentalCache($receiver);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/mikepenz/aboutlibraries/plugin/AboutLibrariesPlugin$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

