/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries.plugin;

import com.mikepenz.aboutlibraries.plugin.AboutLibrariesExportComplianceTask;
import com.mikepenz.aboutlibraries.plugin.BaseAboutLibrariesTask;
import com.mikepenz.aboutlibraries.plugin.mapping.Library;
import com.mikepenz.aboutlibraries.plugin.mapping.License;
import com.mikepenz.aboutlibraries.plugin.mapping.SpdxLicense;
import com.mikepenz.aboutlibraries.plugin.model.ResultContainer;
import com.mikepenz.aboutlibraries.plugin.util.ExtensionsKt;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0007R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0018\u0010\t\u001a\u0004\u0018\u00010\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R.\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u00040\fj\b\u0012\u0004\u0012\u00020\u0004`\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R.\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00130\fj\b\u0012\u0004\u0012\u00020\u0013`\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000f\"\u0004\b\u0015\u0010\u0011RJ\u0010\u0016\u001a>\u0012\u0004\u0012\u00020\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00040\fj\b\u0012\u0004\u0012\u00020\u0004`\r0\u0017j\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00040\fj\b\u0012\u0004\u0012\u00020\u0004`\r`\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/mikepenz/aboutlibraries/plugin/AboutLibrariesExportComplianceTask;", "Lcom/mikepenz/aboutlibraries/plugin/BaseAboutLibrariesTask;", "()V", "artifactGroups", "", "getArtifactGroups", "()Ljava/lang/String;", "exportPath", "getExportPath", "inputExportPath", "getInputExportPath", "librariesWithoutLicenses", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getLibrariesWithoutLicenses", "()Ljava/util/HashSet;", "setLibrariesWithoutLicenses", "(Ljava/util/HashSet;)V", "neededLicenses", "Lcom/mikepenz/aboutlibraries/plugin/mapping/SpdxLicense;", "getNeededLicenses", "setNeededLicenses", "unknownLicenses", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "action", "", "plugin"})
@SourceDebugExtension(value={"SMAP\nAboutLibrariesExportComplianceTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AboutLibrariesExportComplianceTask.kt\ncom/mikepenz/aboutlibraries/plugin/AboutLibrariesExportComplianceTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n1477#2:134\n1502#2,3:135\n1505#2,3:145\n1603#2,9:148\n1855#2:157\n1856#2:159\n1612#2:160\n1549#2:161\n1620#2,3:162\n1855#2,2:165\n372#3,7:138\n1#4:158\n*S KotlinDebug\n*F\n+ 1 AboutLibrariesExportComplianceTask.kt\ncom/mikepenz/aboutlibraries/plugin/AboutLibrariesExportComplianceTask\n*L\n52#1:134\n52#1:135,3\n52#1:145,3\n71#1:148,9\n71#1:157\n71#1:159\n71#1:160\n72#1:161\n72#1:162,3\n72#1:165,2\n52#1:138,7\n71#1:158\n*E\n"})
public abstract class AboutLibrariesExportComplianceTask
extends BaseAboutLibrariesTask {
    @Input
    @Optional
    @Nullable
    private final String inputExportPath;
    @OutputDirectory
    @NotNull
    private final String exportPath;
    @Input
    @NotNull
    private final String artifactGroups;
    @Internal
    @NotNull
    private HashSet<SpdxLicense> neededLicenses;
    @Internal
    @NotNull
    private HashSet<String> librariesWithoutLicenses;
    @NotNull
    private HashMap<String, HashSet<String>> unknownLicenses;

    public AboutLibrariesExportComplianceTask() {
        String string;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String string2 = ExtensionsKt.safeProp(project, "aboutLibraries.exportPath");
        if (string2 == null) {
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            string2 = ExtensionsKt.safeProp(project2, "exportPath");
        }
        if ((string = (this.inputExportPath = string2)) == null) {
            String string3 = this.getProject().getRootDir().getAbsolutePath();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAbsolutePath(...)");
        }
        this.exportPath = string;
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        String string4 = ExtensionsKt.safeProp(project3, "aboutLibraries.artifactGroups");
        if (string4 == null) {
            Project project4 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
            string4 = ExtensionsKt.safeProp(project4, "artifactGroups");
            if (string4 == null) {
                string4 = "";
            }
        }
        this.artifactGroups = string4;
        this.neededLicenses = new HashSet();
        this.librariesWithoutLicenses = new HashSet();
        this.unknownLicenses = new HashMap();
    }

    @Nullable
    public final String getInputExportPath() {
        return this.inputExportPath;
    }

    @NotNull
    public final String getExportPath() {
        return this.exportPath;
    }

    @NotNull
    public final String getArtifactGroups() {
        return this.artifactGroups;
    }

    @NotNull
    public final HashSet<SpdxLicense> getNeededLicenses() {
        return this.neededLicenses;
    }

    public final void setNeededLicenses(@NotNull HashSet<SpdxLicense> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, (String)"<set-?>");
        this.neededLicenses = hashSet;
    }

    @NotNull
    public final HashSet<String> getLibrariesWithoutLicenses() {
        return this.librariesWithoutLicenses;
    }

    public final void setLibrariesWithoutLicenses(@NotNull HashSet<String> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, (String)"<set-?>");
        this.librariesWithoutLicenses = hashSet;
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void action() {
        Object value$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        ResultContainer result = BaseAboutLibrariesTask.createLibraryProcessor$default(this, null, 1, null).gatherDependencies();
        if (this.getVariant() != null) {
            System.out.println((Object)"");
            System.out.println((Object)"");
            System.out.println((Object)("Variant: " + this.getVariant()));
        }
        String[] stringArray = new String[]{";"};
        List groups = StringsKt.split$default((CharSequence)this.artifactGroups, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        File exportTargetFolder = new File(this.exportPath);
        exportTargetFolder.mkdirs();
        File exportCsv = new File(exportTargetFolder, "export.csv");
        exportCsv.delete();
        File exportTxt = new File(exportTargetFolder, "export.txt");
        exportTxt.delete();
        File dependenciesFolder = new File(exportTargetFolder, "dependencies");
        FilesKt.deleteRecursively((File)dependenciesFolder);
        String ungroupedKey = "zzzzz_ungrouped";
        Iterable $this$groupBy$iv = result.getLibraries();
        boolean bl = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            String string;
            block20: {
                Library it = (Library)element$iv$iv;
                boolean bl2 = false;
                for (String group : groups) {
                    if (!StringsKt.startsWith$default((String)it.getArtifactId(), (String)group, (boolean)false, (int)2, null)) continue;
                    string = group;
                    break block20;
                }
                string = ungroupedKey;
            }
            String key$iv$iv = string;
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map groupSorted = destination$iv$iv;
        FilesKt.appendText$default((File)exportTxt, (String)"LIBRARIES:\n", null, (int)2, null);
        for (Map.Entry entry : groupSorted.entrySet()) {
            boolean ungrouped = Intrinsics.areEqual(entry.getKey(), (Object)ungroupedKey);
            String group = ungrouped ? "ungrouped" : (String)entry.getKey();
            FilesKt.appendText$default((File)exportCsv, (String)(group + ";;;\n"), null, (int)2, null);
            FilesKt.appendText$default((File)exportTxt, (String)(group + "\n"), null, (int)2, null);
            for (Library library : (List)entry.getValue()) {
                void $this$forEach$iv;
                Iterator $this$mapTo$iv$iv;
                Iterable $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = library.getLicenses();
                boolean $i$f$mapNotNull = false;
                Iterable iterable2 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                value$iv$iv$iv = $this$forEach$iv$iv$iv.iterator();
                while (value$iv$iv$iv.hasNext()) {
                    License it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = value$iv$iv$iv.next();
                    boolean bl4 = false;
                    String it = (String)element$iv$iv;
                    boolean bl2 = false;
                    if (result.getLicenses().get(it) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                List fullLicenses = (List)destination$iv$iv2;
                Iterable $this$map$iv = fullLicenses;
                boolean $i$f$map = false;
                $this$mapNotNullTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                $this$forEach$iv$iv$iv = $this$mapTo$iv$iv.iterator();
                while ($this$forEach$iv$iv$iv.hasNext()) {
                    void it;
                    Object item$iv$iv = $this$forEach$iv$iv$iv.next();
                    value$iv$iv$iv = (License)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl5 = false;
                    String string = it.getSpdxId();
                    if (string == null) {
                        string = it.getName();
                    }
                    collection.add(string);
                }
                $this$map$iv = (List)destination$iv$iv3;
                boolean $i$f$forEach2 = false;
                $this$mapTo$iv$iv = $this$forEach$iv.iterator();
                while ($this$mapTo$iv$iv.hasNext()) {
                    Object element$iv = $this$mapTo$iv$iv.next();
                    String licenseId = (String)element$iv;
                    boolean bl6 = false;
                    try {
                        this.neededLicenses.add(SpdxLicense.Companion.getById$plugin(licenseId));
                    }
                    catch (Throwable ex) {
                        if (!Intrinsics.areEqual((Object)licenseId, (Object)"")) {
                            HashSet<String> libsWithMissing;
                            Intrinsics.checkNotNullExpressionValue(this.unknownLicenses.getOrDefault(licenseId, new HashSet()), (String)"getOrDefault(...)");
                            libsWithMissing.add(library.getArtifactId());
                            ((Map)this.unknownLicenses).put(licenseId, libsWithMissing);
                            continue;
                        }
                        this.librariesWithoutLicenses.add(library.getArtifactId());
                    }
                }
                FilesKt.appendText$default((File)exportCsv, (String)(library.getName() + ";" + library.getArtifactId() + ";" + CollectionsKt.joinToString$default((Iterable)fullLicenses, (CharSequence)",", null, null, (int)0, null, (Function1)action.3.INSTANCE, (int)30, null) + ";" + library.getWebsite() + "\n"), null, (int)2, null);
                FilesKt.appendText$default((File)exportTxt, (String)(library.getName() + ";" + library.getArtifactId() + ";" + CollectionsKt.joinToString$default((Iterable)fullLicenses, (CharSequence)",", null, null, (int)0, null, (Function1)action.4.INSTANCE, (int)30, null) + "\n"), null, (int)2, null);
                Object targetFolder = String.valueOf(library.getArtifactId());
                if (!ungrouped) {
                    targetFolder = group + "/" + library.getArtifactId();
                }
                File libraryTargetFolder = new File(dependenciesFolder, (String)targetFolder);
                libraryTargetFolder.mkdirs();
                try {
                    File file = library.getArtifactFolder();
                    Path source = file != null ? file.toPath() : null;
                    if (source == null) continue;
                    Files.walk(source, new FileVisitOption[0]).forEach(arg_0 -> AboutLibrariesExportComplianceTask.action$lambda$4((Function1)new Function1<Path, Unit>(libraryTargetFolder){
                        final /* synthetic */ File $libraryTargetFolder;
                        {
                            this.$libraryTargetFolder = $libraryTargetFolder;
                            super(1);
                        }

                        public final void invoke(Path s) {
                            Path targetPath = this.$libraryTargetFolder.toPath();
                            String fn = ((Object)s.getFileName()).toString();
                            if (!Files.isDirectory(s, new LinkOption[0]) && (StringsKt.endsWith$default((String)fn, (String)".aar", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fn, (String)".jar", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fn, (String)".pom", (boolean)false, (int)2, null)) && !StringsKt.endsWith$default((String)fn, (String)"-javadoc.jar", (boolean)false, (int)2, null)) {
                                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                                Files.copy(s, targetPath.resolve(fn), copyOptionArray);
                            }
                        }
                    }, arg_0));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        FilesKt.appendText$default((File)exportTxt, (String)"\n\nLICENSES:\n", null, (int)2, null);
        for (SpdxLicense spdxLicense : this.neededLicenses) {
            FilesKt.appendText$default((File)exportTxt, (String)(spdxLicense.getId() + ";" + spdxLicense.getFullName() + ";" + spdxLicense.getUrl() + "\n"), null, (int)2, null);
        }
        FilesKt.appendText$default((File)exportTxt, (String)"\n\nARTIFACTS WITHOUT LICENSE:\n", null, (int)2, null);
        for (String string : this.librariesWithoutLicenses) {
            FilesKt.appendText$default((File)exportTxt, (String)(string + "\n"), null, (int)2, null);
        }
        FilesKt.appendText$default((File)exportTxt, (String)"\n\nUNKNOWN LICENSES:\n", null, (int)2, null);
        for (Map.Entry entry : ((Map)this.unknownLicenses).entrySet()) {
            FilesKt.appendText$default((File)exportTxt, (String)(entry.getKey() + "\n"), null, (int)2, null);
            FilesKt.appendText$default((File)exportTxt, (String)("-- " + entry.getValue() + "\n"), null, (int)2, null);
        }
    }

    private static final void action$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

