/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries.ui;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.LayoutAnimationController;
import com.mikepenz.aboutlibraries.Libs;
import com.mikepenz.aboutlibraries.LibsBuilder;
import com.mikepenz.aboutlibraries.LibsConfiguration;
import com.mikepenz.aboutlibraries.R;
import com.mikepenz.aboutlibraries.entity.Library;
import com.mikepenz.aboutlibraries.ui.adapter.LibsRecyclerViewAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class LibsFragment
extends Fragment {
    private RecyclerView mRecyclerView;
    private LibsRecyclerViewAdapter mAdapter;
    private LibsBuilder builder = null;
    private static ArrayList<Library> libraries;
    private Comparator<Library> comparator;
    private AsyncTask mLibTask;

    public void setLibraryComparator(Comparator<Library> comparator) {
        this.comparator = comparator;
    }

    public void onAttach(Context context) {
        Bundle bundle = this.getArguments();
        if (bundle == null) {
            Log.e((String)"AboutLibraries", (String)"The AboutLibraries fragment can't be build without the bundle containing the LibsBuilder");
            return;
        }
        this.builder = (LibsBuilder)bundle.getSerializable("data");
        super.onAttach(context);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_opensource, container, false);
        if (LibsConfiguration.getInstance().getUiListener() != null) {
            view = LibsConfiguration.getInstance().getUiListener().preOnCreateView(view);
        }
        this.mRecyclerView = view.getId() == R.id.cardListView ? (RecyclerView)view : (RecyclerView)view.findViewById(R.id.cardListView);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mRecyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        this.mAdapter = new LibsRecyclerViewAdapter(this.builder);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        if (LibsConfiguration.getInstance().getUiListener() != null) {
            view = LibsConfiguration.getInstance().getUiListener().postOnCreateView(view);
        }
        return view;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (this.getContext() != null) {
            this.mLibTask = new LibraryTask(this.getContext()).execute(new String[0]);
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.mLibTask != null) {
            this.mLibTask.cancel(true);
            this.mLibTask = null;
        }
    }

    private Boolean extractBooleanBundleOrResource(Libs libs, Boolean value, String resName) {
        Boolean result = null;
        if (value != null) {
            result = value;
        } else {
            String descriptionShowVersion = libs.getStringResourceByName(this.getContext(), resName);
            if (!TextUtils.isEmpty((CharSequence)descriptionShowVersion)) {
                try {
                    result = Boolean.parseBoolean(descriptionShowVersion);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private String extractStringBundleOrResource(Libs libs, String value, String resName) {
        String result = null;
        if (value != null) {
            result = value;
        } else {
            String descriptionShowVersion = libs.getStringResourceByName(this.getContext(), resName);
            if (!TextUtils.isEmpty((CharSequence)descriptionShowVersion)) {
                result = descriptionShowVersion;
            }
        }
        return result;
    }

    private class LibraryTask
    extends AsyncTask<String, String, String> {
        Context ctx;
        String versionName;
        Integer versionCode;
        Drawable icon = null;

        public LibraryTask(Context ctx) {
            this.ctx = ctx;
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected String doInBackground(String ... strings) {
            Libs libs = null;
            libs = LibsFragment.this.builder == null || ((LibsFragment)LibsFragment.this).builder.fields == null ? new Libs(this.ctx) : new Libs(this.ctx, ((LibsFragment)LibsFragment.this).builder.fields);
            ((LibsFragment)LibsFragment.this).builder.aboutShowIcon = LibsFragment.this.extractBooleanBundleOrResource(libs, ((LibsFragment)LibsFragment.this).builder.aboutShowIcon, "aboutLibraries_description_showIcon");
            ((LibsFragment)LibsFragment.this).builder.aboutShowVersion = LibsFragment.this.extractBooleanBundleOrResource(libs, ((LibsFragment)LibsFragment.this).builder.aboutShowVersion, "aboutLibraries_description_showVersion");
            ((LibsFragment)LibsFragment.this).builder.aboutShowVersionName = LibsFragment.this.extractBooleanBundleOrResource(libs, ((LibsFragment)LibsFragment.this).builder.aboutShowVersionName, "aboutLibraries_description_showVersionName");
            ((LibsFragment)LibsFragment.this).builder.aboutShowVersionCode = LibsFragment.this.extractBooleanBundleOrResource(libs, ((LibsFragment)LibsFragment.this).builder.aboutShowVersionCode, "aboutLibraries_description_showVersionCode");
            ((LibsFragment)LibsFragment.this).builder.aboutAppName = LibsFragment.this.extractStringBundleOrResource(libs, ((LibsFragment)LibsFragment.this).builder.aboutAppName, "aboutLibraries_description_name");
            ((LibsFragment)LibsFragment.this).builder.aboutDescription = LibsFragment.this.extractStringBundleOrResource(libs, ((LibsFragment)LibsFragment.this).builder.aboutDescription, "aboutLibraries_description_text");
            ((LibsFragment)LibsFragment.this).builder.aboutAppSpecial1 = LibsFragment.this.extractStringBundleOrResource(libs, ((LibsFragment)LibsFragment.this).builder.aboutAppSpecial1, "aboutLibraries_description_special1_name");
            ((LibsFragment)LibsFragment.this).builder.aboutAppSpecial1Description = LibsFragment.this.extractStringBundleOrResource(libs, ((LibsFragment)LibsFragment.this).builder.aboutAppSpecial1Description, "aboutLibraries_description_special1_text");
            ((LibsFragment)LibsFragment.this).builder.aboutAppSpecial2 = LibsFragment.this.extractStringBundleOrResource(libs, ((LibsFragment)LibsFragment.this).builder.aboutAppSpecial2, "aboutLibraries_description_special2_name");
            ((LibsFragment)LibsFragment.this).builder.aboutAppSpecial2Description = LibsFragment.this.extractStringBundleOrResource(libs, ((LibsFragment)LibsFragment.this).builder.aboutAppSpecial2Description, "aboutLibraries_description_special2_text");
            ((LibsFragment)LibsFragment.this).builder.aboutAppSpecial3 = LibsFragment.this.extractStringBundleOrResource(libs, ((LibsFragment)LibsFragment.this).builder.aboutAppSpecial3, "aboutLibraries_description_special3_name");
            ((LibsFragment)LibsFragment.this).builder.aboutAppSpecial3Description = LibsFragment.this.extractStringBundleOrResource(libs, ((LibsFragment)LibsFragment.this).builder.aboutAppSpecial3Description, "aboutLibraries_description_special3_text");
            if (libraries == null) {
                libs.modifyLibraries(((LibsFragment)LibsFragment.this).builder.libraryModification);
                boolean doDefaultSort = ((LibsFragment)LibsFragment.this).builder.sort != false && null == ((LibsFragment)LibsFragment.this).builder.libraryComparator && null == LibsFragment.this.comparator;
                libraries = libs.prepareLibraries(this.ctx, ((LibsFragment)LibsFragment.this).builder.internalLibraries, ((LibsFragment)LibsFragment.this).builder.excludeLibraries, ((LibsFragment)LibsFragment.this).builder.autoDetect, doDefaultSort);
                if (LibsFragment.this.comparator != null) {
                    Collections.sort(libraries, LibsFragment.this.comparator);
                } else if (((LibsFragment)LibsFragment.this).builder.libraryComparator != null) {
                    Collections.sort(libraries, ((LibsFragment)LibsFragment.this).builder.libraryComparator);
                }
            }
            if (((LibsFragment)LibsFragment.this).builder.aboutShowIcon != null && (((LibsFragment)LibsFragment.this).builder.aboutShowVersion != null || ((LibsFragment)LibsFragment.this).builder.aboutShowVersionName != null || ((LibsFragment)LibsFragment.this).builder.aboutShowVersionCode.booleanValue())) {
                PackageManager pm = this.ctx.getPackageManager();
                String packageName = this.ctx.getPackageName();
                ApplicationInfo appInfo = null;
                PackageInfo packageInfo = null;
                try {
                    appInfo = pm.getApplicationInfo(packageName, 0);
                    packageInfo = pm.getPackageInfo(packageName, 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (((LibsFragment)LibsFragment.this).builder.aboutShowIcon.booleanValue() && appInfo != null) {
                    this.icon = appInfo.loadIcon(pm);
                }
                this.versionName = null;
                this.versionCode = null;
                if (packageInfo != null) {
                    this.versionName = packageInfo.versionName;
                    this.versionCode = packageInfo.versionCode;
                }
            }
            return null;
        }

        protected void onPostExecute(String s) {
            if (((LibsFragment)LibsFragment.this).builder.aboutShowIcon != null && (((LibsFragment)LibsFragment.this).builder.aboutShowVersion != null || ((LibsFragment)LibsFragment.this).builder.aboutShowVersionName != null || ((LibsFragment)LibsFragment.this).builder.aboutShowVersionCode.booleanValue())) {
                LibsFragment.this.mAdapter.setHeader(this.versionName, this.versionCode, this.icon);
            }
            LibsFragment.this.mAdapter.addLibs(libraries);
            if (((LibsFragment)LibsFragment.this).builder.animate.booleanValue()) {
                LayoutAnimationController layoutAnimationController;
                if (LibsConfiguration.getInstance().getLayoutAnimationController() == null) {
                    Animation fadeIn = AnimationUtils.loadAnimation((Context)this.ctx, (int)17432578);
                    fadeIn.setDuration(500L);
                    layoutAnimationController = new LayoutAnimationController(fadeIn);
                } else {
                    layoutAnimationController = LibsConfiguration.getInstance().getLayoutAnimationController();
                }
                LibsFragment.this.mRecyclerView.setLayoutAnimation(layoutAnimationController);
                LibsFragment.this.mRecyclerView.startLayoutAnimation();
            }
            super.onPostExecute((Object)s);
            this.ctx = null;
        }
    }
}

