/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.text.TextUtils;
import android.util.Log;
import com.mikepenz.aboutlibraries.R;
import com.mikepenz.aboutlibraries.detector.Detect;
import com.mikepenz.aboutlibraries.entity.Library;
import com.mikepenz.aboutlibraries.entity.License;
import com.mikepenz.aboutlibraries.util.Util;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Libs {
    public static final String BUNDLE_THEME = "ABOUT_LIBRARIES_THEME";
    public static final String BUNDLE_TITLE = "ABOUT_LIBRARIES_TITLE";
    public static final String BUNDLE_STYLE = "ABOUT_LIBRARIES_STYLE";
    public static final String BUNDLE_COLORS = "ABOUT_COLOR";
    private static final String DEFINE_LICENSE = "define_license_";
    private static final String DEFINE_INT = "define_int_";
    private static final String DEFINE_EXT = "define_";
    private Context ctx;
    private ArrayList<Library> internLibraries = new ArrayList();
    private ArrayList<Library> externLibraries = new ArrayList();
    private ArrayList<License> licenses = new ArrayList();

    public Libs(Context context) {
        this.ctx = context;
        String[] fields = Libs.toStringArray(R.string.class.getFields());
        this.init(fields);
    }

    public Libs(Context context, String[] fields) {
        this.ctx = context;
        this.init(fields);
    }

    private void init(String[] fields) {
        Library library;
        ArrayList<String> foundLicenseIdentifiers = new ArrayList<String>();
        ArrayList<String> foundInternalLibraryIdentifiers = new ArrayList<String>();
        ArrayList<String> foundExternalLibraryIdentifiers = new ArrayList<String>();
        if (fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i].startsWith(DEFINE_LICENSE)) {
                    foundLicenseIdentifiers.add(fields[i].replace(DEFINE_LICENSE, ""));
                    continue;
                }
                if (fields[i].startsWith(DEFINE_INT)) {
                    foundInternalLibraryIdentifiers.add(fields[i].replace(DEFINE_INT, ""));
                    continue;
                }
                if (!fields[i].startsWith(DEFINE_EXT)) continue;
                foundExternalLibraryIdentifiers.add(fields[i].replace(DEFINE_EXT, ""));
            }
        }
        for (String licenseIdentifier : foundLicenseIdentifiers) {
            License license = this.genLicense(licenseIdentifier);
            if (license == null) continue;
            this.licenses.add(license);
        }
        for (String internalIdentifier : foundInternalLibraryIdentifiers) {
            library = this.genLibrary(internalIdentifier);
            if (library == null) continue;
            library.setInternal(true);
            this.internLibraries.add(library);
        }
        for (String externalIdentifier : foundExternalLibraryIdentifiers) {
            library = this.genLibrary(externalIdentifier);
            if (library == null) continue;
            library.setInternal(false);
            this.externLibraries.add(library);
        }
    }

    public static String[] toStringArray(Field[] fields) {
        ArrayList<String> fieldArray = new ArrayList<String>();
        for (Field field : fields) {
            if (!field.getName().contains(DEFINE_EXT)) continue;
            fieldArray.add(field.getName());
        }
        return fieldArray.toArray(new String[fieldArray.size()]);
    }

    public ArrayList<Library> prepareLibraries(String[] internalLibraries, String[] excludeLibraries, boolean autoDetect, boolean sort) {
        HashMap<String, Library> libraries = new HashMap<String, Library>();
        if (autoDetect) {
            for (Library lib : this.getAutoDetectedLibraries()) {
                libraries.put(lib.getDefinedName(), lib);
            }
        }
        for (Library lib : this.getExternLibraries()) {
            libraries.put(lib.getDefinedName(), lib);
        }
        if (internalLibraries != null) {
            for (String internalLibrary : internalLibraries) {
                Library lib = this.getLibrary(internalLibrary);
                if (lib == null) continue;
                libraries.put(lib.getDefinedName(), lib);
            }
        }
        ArrayList<Library> resultLibraries = new ArrayList<Library>(libraries.values());
        if (excludeLibraries != null) {
            ArrayList<Library> libsToRemove = new ArrayList<Library>();
            block3: for (String excludeLibrary : excludeLibraries) {
                for (Library library : resultLibraries) {
                    if (!library.getDefinedName().equals(excludeLibrary)) continue;
                    libsToRemove.add(library);
                    continue block3;
                }
            }
            for (Library libToRemove : libsToRemove) {
                resultLibraries.remove(libToRemove);
            }
        }
        if (sort) {
            Collections.sort(resultLibraries);
        }
        return resultLibraries;
    }

    public ArrayList<Library> getAutoDetectedLibraries() {
        String[] autoDetectedLibraries;
        ArrayList<Library> libraries = new ArrayList<Library>();
        PackageInfo pi = Util.getPackageInfo(this.ctx);
        if (pi != null && (autoDetectedLibraries = this.ctx.getSharedPreferences("aboutLibraries_" + pi.versionCode, 0).getString("autoDetectedLibraries", "").split(";")).length > 0) {
            for (String autoDetectedLibrary : autoDetectedLibraries) {
                Library lib = this.getLibrary(autoDetectedLibrary);
                if (lib == null) continue;
                libraries.add(lib);
            }
        }
        if (libraries.size() == 0) {
            String delimiter = "";
            String autoDetectedLibrariesPref = "";
            for (Library lib : Detect.detect(this.ctx, this.getLibraries())) {
                libraries.add(lib);
                autoDetectedLibrariesPref = autoDetectedLibrariesPref + delimiter + lib.getDefinedName();
                delimiter = ";";
            }
            if (pi != null) {
                this.ctx.getSharedPreferences("aboutLibraries_" + pi.versionCode, 0).edit().putString("autoDetectedLibraries", autoDetectedLibrariesPref).commit();
            }
        }
        return libraries;
    }

    public ArrayList<Library> getInternLibraries() {
        return new ArrayList<Library>(this.internLibraries);
    }

    public ArrayList<Library> getExternLibraries() {
        return new ArrayList<Library>(this.externLibraries);
    }

    public ArrayList<License> getLicenses() {
        return new ArrayList<License>(this.licenses);
    }

    public ArrayList<Library> getLibraries() {
        ArrayList<Library> libs = new ArrayList<Library>();
        libs.addAll(this.getInternLibraries());
        libs.addAll(this.getExternLibraries());
        return libs;
    }

    public Library getLibrary(String libraryName) {
        for (Library library : this.getLibraries()) {
            if (library.getLibraryName().toLowerCase().equals(libraryName.toLowerCase())) {
                return library;
            }
            if (!library.getDefinedName().toLowerCase().equals(libraryName.toLowerCase())) continue;
            return library;
        }
        return null;
    }

    public ArrayList<Library> findLibrary(String searchTerm, int limit) {
        return this.find(this.getLibraries(), searchTerm, false, limit);
    }

    public ArrayList<Library> findInInternalLibrary(String searchTerm, boolean idOnly, int limit) {
        return this.find(this.getInternLibraries(), searchTerm, idOnly, limit);
    }

    public ArrayList<Library> findInExternalLibrary(String searchTerm, boolean idOnly, int limit) {
        return this.find(this.getExternLibraries(), searchTerm, idOnly, limit);
    }

    private ArrayList<Library> find(ArrayList<Library> libraries, String searchTerm, boolean idOnly, int limit) {
        ArrayList<Library> localLibs = new ArrayList<Library>();
        int count = 0;
        for (Library library : libraries) {
            if (idOnly) {
                if (!library.getDefinedName().toLowerCase().contains(searchTerm.toLowerCase())) continue;
                localLibs.add(library);
                if (limit == -1 || limit >= ++count) continue;
                break;
            }
            if (!library.getLibraryName().toLowerCase().contains(searchTerm.toLowerCase()) && !library.getDefinedName().toLowerCase().contains(searchTerm.toLowerCase())) continue;
            localLibs.add(library);
            if (limit == -1 || limit >= ++count) continue;
            break;
        }
        return localLibs;
    }

    public License getLicense(String licenseName) {
        for (License license : this.getLicenses()) {
            if (license.getLicenseName().toLowerCase().equals(licenseName.toLowerCase())) {
                return license;
            }
            if (!license.getDefinedName().toLowerCase().equals(licenseName.toLowerCase())) continue;
            return license;
        }
        return null;
    }

    private License genLicense(String licenseName) {
        licenseName = licenseName.replace("-", "_");
        try {
            License lic = new License();
            lic.setDefinedName(licenseName);
            lic.setLicenseName(this.getStringResourceByName("license_" + licenseName + "_licenseName"));
            lic.setLicenseWebsite(this.getStringResourceByName("license_" + licenseName + "_licenseWebsite"));
            lic.setLicenseShortDescription(this.getStringResourceByName("license_" + licenseName + "_licenseShortDescription"));
            lic.setLicenseDescription(this.getStringResourceByName("license_" + licenseName + "_licenseDescription"));
            return lic;
        }
        catch (Exception ex) {
            Log.e((String)"aboutlibraries", (String)("Failed to generateLicense from file: " + ex.toString()));
            return null;
        }
    }

    private Library genLibrary(String libraryName) {
        libraryName = libraryName.replace("-", "_");
        try {
            Library lib = new Library();
            HashMap<String, String> customVariables = this.getCustomVariables(libraryName);
            lib.setDefinedName(libraryName);
            lib.setAuthor(this.getStringResourceByName("library_" + libraryName + "_author"));
            lib.setAuthorWebsite(this.getStringResourceByName("library_" + libraryName + "_authorWebsite"));
            lib.setLibraryName(this.getStringResourceByName("library_" + libraryName + "_libraryName"));
            lib.setLibraryDescription(this.insertVariables(this.getStringResourceByName("library_" + libraryName + "_libraryDescription"), customVariables));
            lib.setLibraryVersion(this.getStringResourceByName("library_" + libraryName + "_libraryVersion"));
            lib.setLibraryWebsite(this.getStringResourceByName("library_" + libraryName + "_libraryWebsite"));
            String licenseId = this.getStringResourceByName("library_" + libraryName + "_licenseId");
            if (TextUtils.isEmpty((CharSequence)licenseId)) {
                License license = new License();
                license.setLicenseName(this.getStringResourceByName("library_" + libraryName + "_licenseVersion"));
                license.setLicenseWebsite(this.getStringResourceByName("library_" + libraryName + "_licenseLink"));
                license.setLicenseShortDescription(this.insertVariables(this.getStringResourceByName("library_" + libraryName + "_licenseContent"), customVariables));
                lib.setLicense(license);
            } else {
                License license = this.getLicense(licenseId);
                if (license != null) {
                    license = license.copy();
                    license.setLicenseShortDescription(this.insertVariables(license.getLicenseShortDescription(), customVariables));
                    license.setLicenseDescription(this.insertVariables(license.getLicenseDescription(), customVariables));
                    lib.setLicense(license);
                }
            }
            lib.setOpenSource(Boolean.valueOf(this.getStringResourceByName("library_" + libraryName + "_isOpenSource")));
            lib.setRepositoryLink(this.getStringResourceByName("library_" + libraryName + "_repositoryLink"));
            lib.setClassPath(this.getStringResourceByName("library_" + libraryName + "_classPath"));
            if (TextUtils.isEmpty((CharSequence)lib.getLibraryName()) && TextUtils.isEmpty((CharSequence)lib.getLibraryDescription())) {
                return null;
            }
            return lib;
        }
        catch (Exception ex) {
            Log.e((String)"aboutlibraries", (String)("Failed to generateLibrary from file: " + ex.toString()));
            return null;
        }
    }

    public HashMap<String, String> getCustomVariables(String libraryName) {
        String[] customVariableArray;
        HashMap<String, String> customVariables = new HashMap<String, String>();
        String customVariablesString = this.getStringResourceByName(DEFINE_EXT + libraryName);
        if (TextUtils.isEmpty((CharSequence)customVariablesString)) {
            customVariablesString = this.getStringResourceByName(DEFINE_INT + libraryName);
        }
        if (!TextUtils.isEmpty((CharSequence)customVariablesString) && (customVariableArray = customVariablesString.split(";")).length > 0) {
            for (String customVariableKey : customVariableArray) {
                String customVariableContent = this.getStringResourceByName("library_" + libraryName + "_" + customVariableKey);
                if (TextUtils.isEmpty((CharSequence)customVariableContent)) continue;
                customVariables.put(customVariableKey, customVariableContent);
            }
        }
        return customVariables;
    }

    public String insertVariables(String insertInto, HashMap<String, String> variables) {
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            if (TextUtils.isEmpty((CharSequence)entry.getValue())) continue;
            insertInto = insertInto.replace("<<<" + entry.getKey().toUpperCase() + ">>>", entry.getValue());
        }
        insertInto = insertInto.replace("<<<", "");
        insertInto = insertInto.replace(">>>", "");
        return insertInto;
    }

    public String getStringResourceByName(String aString) {
        String packageName = this.ctx.getPackageName();
        int resId = this.ctx.getResources().getIdentifier(aString, "string", packageName);
        if (resId == 0) {
            return "";
        }
        return this.ctx.getString(resId);
    }

    public void modifyLibraries(HashMap<String, HashMap<String, String>> modifications) {
        if (modifications != null) {
            for (Map.Entry<String, HashMap<String, String>> entry : modifications.entrySet()) {
                ArrayList<Library> foundLibs = this.findInExternalLibrary(entry.getKey(), true, 1);
                if (foundLibs == null || foundLibs.size() == 0) {
                    foundLibs = this.findInInternalLibrary(entry.getKey(), true, 1);
                }
                if (foundLibs == null || foundLibs.size() != 1) continue;
                Library lib = foundLibs.get(0);
                for (Map.Entry<String, String> modification : entry.getValue().entrySet()) {
                    String key = modification.getKey().toUpperCase();
                    String value = modification.getValue();
                    if (key.equals(LibraryFields.AUTHOR_NAME.name())) {
                        lib.setAuthor(value);
                        continue;
                    }
                    if (key.equals(LibraryFields.AUTHOR_WEBSITE.name())) {
                        lib.setAuthorWebsite(value);
                        continue;
                    }
                    if (key.equals(LibraryFields.LIBRARY_NAME.name())) {
                        lib.setLibraryName(value);
                        continue;
                    }
                    if (key.equals(LibraryFields.LIBRARY_DESCRIPTION.name())) {
                        lib.setLibraryDescription(value);
                        continue;
                    }
                    if (key.equals(LibraryFields.LIBRARY_VERSION.name())) {
                        lib.setLibraryVersion(value);
                        continue;
                    }
                    if (key.equals(LibraryFields.LIBRARY_WEBSITE.name())) {
                        lib.setLibraryWebsite(value);
                        continue;
                    }
                    if (key.equals(LibraryFields.LIBRARY_OPEN_SOURCE.name())) {
                        lib.setOpenSource(Boolean.parseBoolean(value));
                        continue;
                    }
                    if (key.equals(LibraryFields.LIBRARY_REPOSITORY_LINK.name())) {
                        lib.setRepositoryLink(value);
                        continue;
                    }
                    if (key.equals(LibraryFields.LIBRARY_CLASSPATH.name())) {
                        lib.setClassPath(value);
                        continue;
                    }
                    if (key.equals(LibraryFields.LICENSE_NAME.name())) {
                        if (lib.getLicense() == null) {
                            lib.setLicense(new License());
                        }
                        lib.getLicense().setLicenseName(value);
                        continue;
                    }
                    if (key.equals(LibraryFields.LICENSE_SHORT_DESCRIPTION.name())) {
                        if (lib.getLicense() == null) {
                            lib.setLicense(new License());
                        }
                        lib.getLicense().setLicenseShortDescription(value);
                        continue;
                    }
                    if (key.equals(LibraryFields.LICENSE_DESCRIPTION.name())) {
                        if (lib.getLicense() == null) {
                            lib.setLicense(new License());
                        }
                        lib.getLicense().setLicenseDescription(value);
                        continue;
                    }
                    if (!key.equals(LibraryFields.LICENSE_WEBSITE.name())) continue;
                    if (lib.getLicense() == null) {
                        lib.setLicense(new License());
                    }
                    lib.getLicense().setLicenseWebsite(value);
                }
            }
        }
    }

    public static enum SpecialButton {
        SPECIAL1,
        SPECIAL2,
        SPECIAL3;

    }

    public static enum ActivityStyle {
        LIGHT,
        DARK,
        LIGHT_DARK_TOOLBAR;

    }

    public static enum LibraryFields {
        AUTHOR_NAME,
        AUTHOR_WEBSITE,
        LIBRARY_NAME,
        LIBRARY_DESCRIPTION,
        LIBRARY_VERSION,
        LIBRARY_WEBSITE,
        LIBRARY_OPEN_SOURCE,
        LIBRARY_REPOSITORY_LINK,
        LIBRARY_CLASSPATH,
        LICENSE_NAME,
        LICENSE_SHORT_DESCRIPTION,
        LICENSE_DESCRIPTION,
        LICENSE_WEBSITE;

    }
}

