/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries.ui.item;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.net.Uri;
import android.view.View;
import android.widget.TextView;
import androidx.core.text.HtmlCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.mikepenz.aboutlibraries.LibsBuilder;
import com.mikepenz.aboutlibraries.LibsConfiguration;
import com.mikepenz.aboutlibraries.R;
import com.mikepenz.aboutlibraries.entity.Library;
import com.mikepenz.aboutlibraries.entity.License;
import com.mikepenz.aboutlibraries.util.LibraryExtensionsKt;
import com.mikepenz.aboutlibraries.util.UIUtilsKt;
import com.mikepenz.fastadapter.items.AbstractItem;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001#B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00022\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J \u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Lcom/mikepenz/aboutlibraries/ui/item/SimpleLibraryItem;", "Lcom/mikepenz/fastadapter/items/AbstractItem;", "Lcom/mikepenz/aboutlibraries/ui/item/SimpleLibraryItem$ViewHolder;", "library", "Lcom/mikepenz/aboutlibraries/entity/Library;", "libsBuilder", "Lcom/mikepenz/aboutlibraries/LibsBuilder;", "<init>", "(Lcom/mikepenz/aboutlibraries/entity/Library;Lcom/mikepenz/aboutlibraries/LibsBuilder;)V", "getLibrary$aboutlibraries", "()Lcom/mikepenz/aboutlibraries/entity/Library;", "type", "", "getType", "()I", "layoutRes", "getLayoutRes", "value", "", "isSelectable", "()Z", "setSelectable", "(Z)V", "bindView", "", "holder", "payloads", "", "", "openLicense", "ctx", "Landroid/content/Context;", "getViewHolder", "v", "Landroid/view/View;", "ViewHolder", "aboutlibraries"})
public final class SimpleLibraryItem
extends AbstractItem<ViewHolder> {
    @NotNull
    private final Library library;
    @NotNull
    private final LibsBuilder libsBuilder;

    public SimpleLibraryItem(@NotNull Library library, @NotNull LibsBuilder libsBuilder) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)libsBuilder, (String)"libsBuilder");
        this.library = library;
        this.libsBuilder = libsBuilder;
    }

    @NotNull
    public final Library getLibrary$aboutlibraries() {
        return this.library;
    }

    public int getType() {
        return R.id.library_simple_item_id;
    }

    public int getLayoutRes() {
        return R.layout.listitem_minimal_opensource;
    }

    public boolean isSelectable() {
        return false;
    }

    public void setSelectable(boolean value) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void bindView(@NotNull ViewHolder holder, @NotNull List<? extends Object> payloads) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        Intrinsics.checkNotNullParameter(payloads, (String)"payloads");
        super.bindView((RecyclerView.ViewHolder)holder, payloads);
        Context ctx = holder.itemView.getContext();
        holder.getLibraryName$aboutlibraries().setText((CharSequence)this.library.getName());
        if (LibraryExtensionsKt.getLicense(this.library) != null) {
            Object object = LibraryExtensionsKt.getLicense(this.library);
            boolean bl = object != null && (object = object.getUrl()) != null ? ((CharSequence)object).length() > 0 : false;
            if (bl || this.libsBuilder.getShowLicenseDialog()) {
                holder.itemView.setOnClickListener(arg_0 -> SimpleLibraryItem.bindView$lambda$0(this, ctx, arg_0));
                return;
            }
        }
        holder.itemView.setOnClickListener(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void openLicense(Context ctx, LibsBuilder libsBuilder, Library library) {
        try {
            if (libsBuilder.getShowLicenseDialog()) {
                Object object = LibraryExtensionsKt.getLicense(library);
                boolean bl = object != null && (object = object.getLicenseContent()) != null ? ((CharSequence)object).length() > 0 : false;
                if (bl) {
                    MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(ctx);
                    Object object2 = LibraryExtensionsKt.getLicense(library);
                    if (object2 == null || (object2 = LibraryExtensionsKt.getHtmlReadyLicenseContent(object2)) == null) {
                        object2 = "";
                    }
                    builder.setMessage((CharSequence)HtmlCompat.fromHtml((String)object2, (int)0));
                    builder.create().show();
                    return;
                }
            }
            License license = LibraryExtensionsKt.getLicense(library);
            Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)(license != null ? license.getUrl() : null)));
            ctx.startActivity(browserIntent);
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public ViewHolder getViewHolder(@NotNull View v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new ViewHolder(v);
    }

    private static final void bindView$lambda$0(SimpleLibraryItem this$0, Context $ctx, View view) {
        boolean consumed;
        boolean bl;
        LibsConfiguration.LibsListener libsListener = LibsConfiguration.INSTANCE.getListener();
        if (libsListener != null) {
            Intrinsics.checkNotNull((Object)view);
            bl = libsListener.onLibraryBottomClicked(view, this$0.library);
        } else {
            bl = consumed = false;
        }
        if (!consumed) {
            Intrinsics.checkNotNull((Object)$ctx);
            this$0.openLicense($ctx, this$0.libsBuilder, this$0.library);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0006\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/mikepenz/aboutlibraries/ui/item/SimpleLibraryItem$ViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "<init>", "(Landroid/view/View;)V", "libraryName", "Landroid/widget/TextView;", "getLibraryName$aboutlibraries", "()Landroid/widget/TextView;", "setLibraryName$aboutlibraries", "(Landroid/widget/TextView;)V", "aboutlibraries"})
    public static final class ViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private TextView libraryName;

        public ViewHolder(@NotNull View itemView) {
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super(itemView);
            this.libraryName = (TextView)itemView;
            Context ctx = itemView.getContext();
            Intrinsics.checkNotNull((Object)ctx);
            UIUtilsKt.resolveStyledValue$default(ctx, null, 0, 0, arg_0 -> ViewHolder._init_$lambda$0(this, arg_0), 7, null);
        }

        @NotNull
        public final TextView getLibraryName$aboutlibraries() {
            return this.libraryName;
        }

        public final void setLibraryName$aboutlibraries(@NotNull TextView textView) {
            Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
            this.libraryName = textView;
        }

        private static final Unit _init_$lambda$0(ViewHolder this$0, TypedArray it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.libraryName.setTextColor(it.getColorStateList(R.styleable.AboutLibraries_aboutLibrariesOpenSourceTitle));
            return Unit.INSTANCE;
        }
    }
}

