/*
 * Decompiled with CFR 0.152.
 */
package com.mihaelisaev.metw;

import android.text.Editable;
import android.text.TextWatcher;
import android.widget.EditText;
import com.mihaelisaev.metw.MaskedEditTextWatcherDelegate;

public class MaskedEditTextWatcher
implements TextWatcher {
    private EditText mEditText;
    private String mMask = "";
    private String countryCode = "";
    private MaskedEditTextWatcherDelegate mDelegate;
    private boolean isUpdating;

    public MaskedEditTextWatcher(EditText editText, MaskedEditTextWatcherDelegate delegate) {
        this.mEditText = editText;
        this.mDelegate = delegate;
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        if (this.mEditText == null || this.mDelegate == null) {
            return;
        }
        if (!this.isUpdating && count == 0) {
            if (this.countryCode.length() > 0 && s.toString().equals("+") || s.toString().length() < this.countryCode.length()) {
                this.mMask = "";
                this.countryCode = "";
            }
            return;
        }
        String str = s.toString();
        if (!this.isUpdating && this.mMask.length() > 0 && this.countryCode.length() > 0 && (str.trim().equals(this.countryCode) || str.trim().length() < this.countryCode.length())) {
            this.mMask = "";
            this.countryCode = "";
            return;
        }
        if (!this.isUpdating && this.countryCode.equals("")) {
            String text = str.replace(" ", "").replace("+", "");
            String m = this.mDelegate.maskForCountryCode(text);
            if (m != null && m.length() > 0) {
                this.mMask = m;
                if (m.contains("+" + text)) {
                    str = "";
                    this.countryCode = "+" + text;
                } else {
                    this.countryCode = m.substring(0, m.indexOf(" "));
                    this.mEditText.setText((CharSequence)(this.countryCode + str));
                }
            }
            return;
        }
        if (this.isUpdating) {
            this.isUpdating = false;
            return;
        }
        String masked = this.mask(this.mMask, this.unmask(str, this.countryCode));
        this.isUpdating = true;
        this.mEditText.setText((CharSequence)masked);
        this.mEditText.setSelection(masked.length());
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void afterTextChanged(Editable s) {
    }

    private String unmask(String s, String countryCode) {
        s = s.replace("+", "");
        s = s.substring(countryCode.replace("+", "").length());
        s = s.replaceAll("\\D", "");
        return s;
    }

    private String mask(String format, String text) {
        String maskedText = "";
        int i = 0;
        for (char character : format.toCharArray()) {
            if (character != '#') {
                maskedText = maskedText + character;
                continue;
            }
            try {
                maskedText = maskedText + text.charAt(i);
            }
            catch (Exception e) {
                break;
            }
            ++i;
        }
        return maskedText;
    }
}

