/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.msa;

import android.app.Activity;
import android.util.Log;
import com.microsoft.services.msa.DeviceType;

enum ScreenSize {
    SMALL{

        @Override
        public DeviceType getDeviceType() {
            return DeviceType.PHONE;
        }
    }
    ,
    NORMAL{

        @Override
        public DeviceType getDeviceType() {
            return DeviceType.PHONE;
        }
    }
    ,
    LARGE{

        @Override
        public DeviceType getDeviceType() {
            return DeviceType.TABLET;
        }
    }
    ,
    XLARGE{

        @Override
        public DeviceType getDeviceType() {
            return DeviceType.TABLET;
        }
    };

    private static final int SCREENLAYOUT_SIZE_XLARGE = 4;

    public abstract DeviceType getDeviceType();

    public static ScreenSize determineScreenSize(Activity activity) {
        int screenLayout = activity.getResources().getConfiguration().screenLayout;
        int screenLayoutMasked = screenLayout & 0xF;
        switch (screenLayoutMasked) {
            case 1: {
                return SMALL;
            }
            case 2: {
                return NORMAL;
            }
            case 3: {
                return LARGE;
            }
            case 4: {
                return XLARGE;
            }
        }
        Log.d((String)"Live SDK ScreenSize", (String)"Unable to determine ScreenSize. A Normal ScreenSize will be returned.");
        return NORMAL;
    }
}

