/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.services.msa;

import com.microsoft.services.msa.LiveAuthClient;
import com.microsoft.services.msa.OAuthSuccessfulResponse;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class LiveConnectSession {
    private String accessToken;
    private String authenticationToken;
    private final PropertyChangeSupport changeSupport;
    private final LiveAuthClient creator;
    private Date expiresIn;
    private String refreshToken;
    private Set<String> scopes;
    private String tokenType;

    LiveConnectSession(LiveAuthClient creator) {
        if (creator == null) {
            throw new AssertionError();
        }
        this.creator = creator;
        this.changeSupport = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getAuthenticationToken() {
        return this.authenticationToken;
    }

    public Date getExpiresIn() {
        return new Date(this.expiresIn.getTime());
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.changeSupport.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.changeSupport.getPropertyChangeListeners(propertyName);
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public Iterable<String> getScopes() {
        return this.scopes;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public boolean isExpired() {
        if (this.expiresIn == null) {
            return true;
        }
        Date now = new Date();
        return now.after(this.expiresIn);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public String toString() {
        return String.format("LiveConnectSession [accessToken=%s, authenticationToken=%s, expiresIn=%s, refreshToken=%s, scopes=%s, tokenType=%s]", this.accessToken, this.authenticationToken, this.expiresIn, this.refreshToken, this.scopes, this.tokenType);
    }

    boolean contains(Iterable<String> scopes) {
        if (scopes == null) {
            return true;
        }
        if (this.scopes == null) {
            return false;
        }
        for (String scope : scopes) {
            if (this.scopes.contains(scope)) continue;
            return false;
        }
        return true;
    }

    void loadFromOAuthResponse(OAuthSuccessfulResponse response) {
        this.accessToken = response.getAccessToken();
        this.tokenType = response.getTokenType().toString().toLowerCase();
        if (response.hasAuthenticationToken()) {
            this.authenticationToken = response.getAuthenticationToken();
        }
        if (response.hasExpiresIn()) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(13, response.getExpiresIn());
            this.setExpiresIn(calendar.getTime());
        }
        if (response.hasRefreshToken()) {
            this.refreshToken = response.getRefreshToken();
        }
        if (response.hasScope()) {
            String scopeString = response.getScope();
            this.setScopes(Arrays.asList(scopeString.split(" ")));
        }
    }

    boolean refresh() {
        return this.creator.tryRefresh(this.getScopes());
    }

    void setAccessToken(String accessToken) {
        String oldValue = this.accessToken;
        this.accessToken = accessToken;
        this.changeSupport.firePropertyChange("accessToken", oldValue, this.accessToken);
    }

    void setAuthenticationToken(String authenticationToken) {
        String oldValue = this.authenticationToken;
        this.authenticationToken = authenticationToken;
        this.changeSupport.firePropertyChange("authenticationToken", oldValue, this.authenticationToken);
    }

    void setExpiresIn(Date expiresIn) {
        Date oldValue = this.expiresIn;
        this.expiresIn = new Date(expiresIn.getTime());
        this.changeSupport.firePropertyChange("expiresIn", oldValue, this.expiresIn);
    }

    void setRefreshToken(String refreshToken) {
        String oldValue = this.refreshToken;
        this.refreshToken = refreshToken;
        this.changeSupport.firePropertyChange("refreshToken", oldValue, this.refreshToken);
    }

    void setScopes(Iterable<String> scopes) {
        Set<String> oldValue = this.scopes;
        this.scopes = new HashSet<String>();
        if (scopes != null) {
            for (String scope : scopes) {
                this.scopes.add(scope);
            }
        }
        this.scopes = Collections.unmodifiableSet(this.scopes);
        this.changeSupport.firePropertyChange("scopes", oldValue, this.scopes);
    }

    void setTokenType(String tokenType) {
        String oldValue = this.tokenType;
        this.tokenType = tokenType;
        this.changeSupport.firePropertyChange("tokenType", oldValue, this.tokenType);
    }

    boolean willExpireInSecs(int secs) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, secs);
        Date future = calendar.getTime();
        return future.after(this.expiresIn);
    }
}

