/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2.http;

import com.microsoft.rest.v2.http.HttpHeaders;
import com.microsoft.rest.v2.http.HttpResponse;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public final class BufferedHttpResponse
extends HttpResponse {
    private final HttpResponse innerHttpResponse;
    private final Single<byte[]> cachedBody;

    public BufferedHttpResponse(HttpResponse innerHttpResponse) {
        this.innerHttpResponse = innerHttpResponse;
        this.cachedBody = innerHttpResponse.bodyAsByteArray().cache();
    }

    @Override
    public int statusCode() {
        return this.innerHttpResponse.statusCode();
    }

    @Override
    public String headerValue(String headerName) {
        return this.innerHttpResponse.headerValue(headerName);
    }

    @Override
    public HttpHeaders headers() {
        return this.innerHttpResponse.headers();
    }

    @Override
    public Single<byte[]> bodyAsByteArray() {
        return this.cachedBody;
    }

    @Override
    public Flowable<ByteBuffer> body() {
        return this.bodyAsByteArray().flatMapPublisher(bytes -> Flowable.just((Object)ByteBuffer.wrap(bytes)));
    }

    @Override
    public Single<String> bodyAsString() {
        return this.bodyAsByteArray().map(bytes -> bytes == null ? null : new String((byte[])bytes, StandardCharsets.UTF_8));
    }

    @Override
    public BufferedHttpResponse buffer() {
        return this;
    }

    @Override
    public boolean isDecoded() {
        return this.innerHttpResponse.isDecoded();
    }

    @Override
    public boolean withIsDecoded(boolean isDecoded) {
        return this.innerHttpResponse.withIsDecoded(isDecoded);
    }

    @Override
    public Object deserializedHeaders() {
        return this.innerHttpResponse.deserializedHeaders();
    }

    @Override
    public HttpResponse withDeserializedHeaders(Object deserializedHeaders) {
        this.innerHttpResponse.withDeserializedHeaders(deserializedHeaders);
        return this;
    }

    @Override
    public Object deserializedBody() {
        return this.innerHttpResponse.deserializedBody();
    }

    @Override
    public HttpResponse withDeserializedBody(Object deserializedBody) {
        this.innerHttpResponse.withDeserializedBody(deserializedBody);
        return this;
    }
}

