/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2.http;

import com.microsoft.rest.v2.http.UrlToken;
import com.microsoft.rest.v2.http.UrlTokenType;
import com.microsoft.rest.v2.http.UrlTokenizer;
import com.microsoft.rest.v2.http.UrlTokenizerState;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;

public final class UrlBuilder {
    private String scheme;
    private String host;
    private String port;
    private String path;
    private final Map<String, String> query = new LinkedHashMap<String, String>();

    public UrlBuilder withScheme(String scheme) {
        if (scheme == null || scheme.isEmpty()) {
            this.scheme = null;
        } else {
            this.with(scheme, UrlTokenizerState.SCHEME);
        }
        return this;
    }

    public String scheme() {
        return this.scheme;
    }

    public UrlBuilder withHost(String host) {
        if (host == null || host.isEmpty()) {
            this.host = null;
        } else {
            this.with(host, UrlTokenizerState.SCHEME_OR_HOST);
        }
        return this;
    }

    public String host() {
        return this.host;
    }

    public UrlBuilder withPort(String port) {
        if (port == null || port.isEmpty()) {
            this.port = null;
        } else {
            this.with(port, UrlTokenizerState.PORT);
        }
        return this;
    }

    public UrlBuilder withPort(int port) {
        return this.withPort(Integer.toString(port));
    }

    public Integer port() {
        return this.port == null ? null : Integer.valueOf(this.port);
    }

    public UrlBuilder withPath(String path) {
        if (path == null || path.isEmpty()) {
            this.path = null;
        } else {
            this.with(path, UrlTokenizerState.PATH);
        }
        return this;
    }

    public String path() {
        return this.path;
    }

    public UrlBuilder setQueryParameter(String queryParameterName, String queryParameterEncodedValue) {
        this.query.put(queryParameterName, queryParameterEncodedValue);
        return this;
    }

    public UrlBuilder withQuery(String query) {
        if (query == null || query.isEmpty()) {
            this.query.clear();
        } else {
            this.with(query, UrlTokenizerState.QUERY);
        }
        return this;
    }

    public Map<String, String> query() {
        return this.query;
    }

    private UrlBuilder with(String text, UrlTokenizerState startState) {
        UrlTokenizer tokenizer = new UrlTokenizer(text, startState);
        block7: while (tokenizer.next()) {
            UrlToken token = tokenizer.current();
            String tokenText = token.text();
            UrlTokenType tokenType = token.type();
            switch (tokenType) {
                case SCHEME: {
                    this.scheme = UrlBuilder.emptyToNull(tokenText);
                    break;
                }
                case HOST: {
                    this.host = UrlBuilder.emptyToNull(tokenText);
                    break;
                }
                case PORT: {
                    this.port = UrlBuilder.emptyToNull(tokenText);
                    break;
                }
                case PATH: {
                    String tokenPath = UrlBuilder.emptyToNull(tokenText);
                    if (this.path != null && !this.path.equals("/") && tokenPath.equals("/")) break;
                    this.path = tokenPath;
                    break;
                }
                case QUERY: {
                    String queryString = UrlBuilder.emptyToNull(tokenText);
                    if (queryString == null) break;
                    if (queryString.startsWith("?")) {
                        queryString = queryString.substring(1);
                    }
                    for (String entry : queryString.split("&")) {
                        String[] nameValue = entry.split("=");
                        if (nameValue.length != 2) {
                            throw new IllegalArgumentException("Malformed query entry: " + entry);
                        }
                        this.setQueryParameter(nameValue[0], nameValue[1]);
                    }
                    continue block7;
                }
            }
        }
        return this;
    }

    public URL toURL() throws MalformedURLException {
        return new URL(this.toString());
    }

    public String toString() {
        boolean isAbsolutePath;
        StringBuilder result = new StringBuilder();
        boolean bl = isAbsolutePath = this.path != null && (this.path.startsWith("http://") || this.path.startsWith("https://"));
        if (!isAbsolutePath) {
            if (this.scheme != null) {
                result.append(this.scheme);
                if (!this.scheme.endsWith("://")) {
                    result.append("://");
                }
            }
            if (this.host != null) {
                result.append(this.host);
            }
        }
        if (this.port != null) {
            result.append(":");
            result.append(this.port);
        }
        if (this.path != null) {
            if (result.length() != 0 && !this.path.startsWith("/")) {
                result.append('/');
            }
            result.append(this.path);
        }
        if (!this.query.isEmpty()) {
            StringBuilder queryBuilder = new StringBuilder("?");
            for (Map.Entry<String, String> entry : this.query.entrySet()) {
                if (queryBuilder.length() > 1) {
                    queryBuilder.append("&");
                }
                queryBuilder.append(entry.getKey());
                queryBuilder.append("=");
                queryBuilder.append(entry.getValue());
            }
            result.append(queryBuilder.toString());
        }
        return result.toString();
    }

    public static UrlBuilder parse(String url) {
        UrlBuilder result = new UrlBuilder();
        result.with(url, UrlTokenizerState.SCHEME_OR_HOST);
        return result;
    }

    public static UrlBuilder parse(URL url) {
        UrlBuilder result = new UrlBuilder();
        if (url != null) {
            String query;
            String path;
            int port;
            String host;
            String protocol = url.getProtocol();
            if (protocol != null && !protocol.isEmpty()) {
                result.withScheme(protocol);
            }
            if ((host = url.getHost()) != null && !host.isEmpty()) {
                result.withHost(host);
            }
            if ((port = url.getPort()) != -1) {
                result.withPort(port);
            }
            if ((path = url.getPath()) != null && !path.isEmpty()) {
                result.withPath(path);
            }
            if ((query = url.getQuery()) != null && !query.isEmpty()) {
                result.withQuery(query);
            }
        }
        return result;
    }

    private static String emptyToNull(String value) {
        return value == null || value.isEmpty() ? null : value;
    }
}

