/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2.http;

import com.microsoft.rest.v2.http.HttpClient;
import com.microsoft.rest.v2.http.HttpClientConfiguration;
import com.microsoft.rest.v2.http.HttpClientFactory;
import com.microsoft.rest.v2.http.HttpHeader;
import com.microsoft.rest.v2.http.HttpRequest;
import com.microsoft.rest.v2.http.HttpResponse;
import com.microsoft.rest.v2.http.NettyResponse;
import com.microsoft.rest.v2.http.SharedChannelPool;
import com.microsoft.rest.v2.http.SharedChannelPoolOptions;
import com.microsoft.rest.v2.util.FlowableUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.pool.AbstractChannelPoolHandler;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyClient
extends HttpClient {
    private final NettyAdapter adapter;
    private final HttpClientConfiguration configuration;
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyClient.class);

    private NettyClient(HttpClientConfiguration configuration, NettyAdapter adapter) {
        this.adapter = adapter;
        this.configuration = configuration != null ? configuration : new HttpClientConfiguration(null);
    }

    @Override
    public Single<HttpResponse> sendRequestAsync(HttpRequest request) {
        return this.adapter.sendRequestInternalAsync(request, this.configuration);
    }

    private static void addHeaders(HttpRequest request) {
        request.withHeader(HttpHeaderNames.HOST.toString(), request.url().getHost()).withHeader(HttpHeaderNames.CONNECTION.toString(), HttpHeaderValues.KEEP_ALIVE.toString());
    }

    private static DefaultHttpRequest createDefaultHttpRequest(HttpRequest request) {
        DefaultHttpRequest raw = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)request.httpMethod().toString()), request.url().toString());
        for (HttpHeader header : request.headers()) {
            raw.headers().add(header.name(), (Object)header.value());
        }
        return raw;
    }

    public void dumpChannelPool() {
        this.adapter.channelPool.dump();
    }

    public static class Factory
    implements HttpClientFactory {
        private final NettyAdapter adapter;

        public Factory() {
            this.adapter = new NettyAdapter();
        }

        public Factory(Bootstrap baseBootstrap, int eventLoopGroupSize, int channelPoolSize) {
            this(baseBootstrap.clone(), eventLoopGroupSize, channelPoolSize, null);
        }

        public Factory(Bootstrap baseBootstrap, int eventLoopGroupSize, int channelPoolSize, SslContext sslContext) {
            this.adapter = new NettyAdapter(baseBootstrap.clone(), eventLoopGroupSize, channelPoolSize, sslContext);
        }

        @Override
        public HttpClient create(HttpClientConfiguration configuration) {
            return new NettyClient(configuration, this.adapter);
        }

        @Override
        public void close() {
            this.adapter.shutdownGracefully().awaitUninterruptibly();
        }
    }

    private static final class HttpClientInboundHandler
    extends ChannelInboundHandlerAdapter {
        private SingleEmitter<HttpResponse> responseEmitter;
        private volatile ResponseContentFlowable contentEmitter;
        private AcquisitionListener acquisitionListener;
        private volatile Subscription requestContentSubscription;
        private AtomicReference<Channel> channel = new AtomicReference();

        HttpClientInboundHandler() {
        }

        void setFields(SingleEmitter<HttpResponse> responseEmitter, AcquisitionListener acquisitionListener) {
            this.responseEmitter = responseEmitter;
            this.acquisitionListener = acquisitionListener;
            this.contentEmitter = new ResponseContentFlowable(acquisitionListener, new ChannelSubscription(this.channel, acquisitionListener));
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.channel.set(ctx.channel());
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            this.acquisitionListener.emitError(cause);
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            if (this.contentEmitter != null) {
                this.contentEmitter.chunkCompleted();
            }
        }

        public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
            this.acquisitionListener.channelWritable(ctx.channel().isWritable());
            super.channelWritabilityChanged(ctx);
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof io.netty.handler.codec.http.HttpResponse) {
                io.netty.handler.codec.http.HttpResponse response = (io.netty.handler.codec.http.HttpResponse)msg;
                if (response.decoderResult().isFailure()) {
                    this.exceptionCaught(ctx, response.decoderResult().cause());
                    return;
                }
                this.responseEmitter.onSuccess((Object)new NettyResponse(response, this.contentEmitter));
            } else if (msg instanceof HttpContent) {
                HttpContent content = (HttpContent)msg;
                this.contentEmitter.onReceivedContent(content);
                if (msg instanceof LastHttpContent) {
                    this.acquisitionListener.contentDone(false);
                }
            } else {
                this.exceptionCaught(ctx, new IllegalStateException("Unexpected message type: " + msg.getClass().getName()));
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            if (this.contentEmitter != null) {
                this.contentEmitter.channelInactive();
            }
            super.channelInactive(ctx);
        }
    }

    private static final class ChannelSubscription
    implements Subscription {
        private final AtomicReference<Channel> channel;
        private final AcquisitionListener acquisitionListener;

        ChannelSubscription(AtomicReference<Channel> channel, AcquisitionListener acquisitionListener) {
            this.channel = channel;
            this.acquisitionListener = acquisitionListener;
        }

        public void request(long n) {
            assert (n == 1L) : "requests must be one at a time!";
            Channel c = this.channel.get();
            if (c != null) {
                c.read();
            }
        }

        public void cancel() {
            this.acquisitionListener.contentDone(true);
        }
    }

    private static final class ResponseContentFlowable
    extends Flowable<ByteBuf>
    implements Subscription {
        private final SimplePlainQueue<HttpContent> queue = new SpscLinkedArrayQueue(16);
        private final Subscription channelSubscription;
        private final AtomicBoolean chunkRequested = new AtomicBoolean(true);
        private final AtomicLong requested = new AtomicLong();
        private final AtomicInteger wip = new AtomicInteger(1);
        private final AtomicBoolean once = new AtomicBoolean();
        private Subscriber<? super ByteBuf> subscriber;
        private boolean done;
        private volatile boolean cancelled = false;
        private volatile Throwable err;
        private final AcquisitionListener acquisitionListener;

        ResponseContentFlowable(AcquisitionListener acquisitionListener, Subscription channelSubscription) {
            this.acquisitionListener = acquisitionListener;
            this.channelSubscription = channelSubscription;
        }

        protected void subscribeActual(Subscriber<? super ByteBuf> s) {
            if (this.once.compareAndSet(false, true)) {
                this.subscriber = s;
                s.onSubscribe((Subscription)this);
                this.acquisitionListener.contentSubscribed(this);
                this.wip.lazySet(0);
                this.drain();
            } else {
                s.onSubscribe((Subscription)SubscriptionHelper.CANCELLED);
                s.onError((Throwable)new IllegalStateException("Multiple subscriptions not allowed for response content"));
            }
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                this.drain();
            }
        }

        public void cancel() {
            this.cancelled = true;
            this.channelSubscription.cancel();
            this.drain();
        }

        void onReceivedContent(HttpContent data) {
            if (this.done) {
                RxJavaPlugins.onError((Throwable)new IllegalStateException("data arrived after LastHttpContent"));
                return;
            }
            if (data instanceof LastHttpContent) {
                this.done = true;
            }
            if (this.cancelled) {
                data.release();
            } else {
                this.queue.offer((Object)data);
                this.drain();
            }
        }

        void chunkCompleted() {
            if (this.done) {
                return;
            }
            this.chunkRequested.set(false);
            this.drain();
        }

        void onError(Throwable cause) {
            if (this.done) {
                RxJavaPlugins.onError((Throwable)cause);
            }
            this.done = true;
            this.err = cause;
            this.drain();
        }

        void channelInactive() {
            if (!this.done) {
                this.done = true;
                this.err = new IOException("channel inactive");
                this.drain();
            }
        }

        private void requestChunkOfByteBufsFromUpstream() {
            this.channelSubscription.request(1L);
        }

        private void drain() {
            if (this.wip.getAndIncrement() == 0) {
                if (this.cancelled) {
                    this.releaseQueue();
                    this.acquisitionListener.contentDone(true);
                    return;
                }
                int missed = 1;
                do {
                    long e;
                    long r = this.requested.get();
                    for (e = 0L; e != r; ++e) {
                        Throwable error = this.err;
                        if (error != null) {
                            this.releaseQueue();
                            this.channelSubscription.cancel();
                            this.subscriber.onError(error);
                            this.acquisitionListener.contentDone(true);
                            return;
                        }
                        HttpContent o = (HttpContent)this.queue.poll();
                        if (o != null) {
                            if (!this.emitContent(o)) continue;
                            return;
                        }
                        if (!this.chunkRequested.compareAndSet(false, true)) break;
                        this.requestChunkOfByteBufsFromUpstream();
                        break;
                    }
                    if (e <= 0L) continue;
                    BackpressureHelper.produced((AtomicLong)this.requested, (long)e);
                } while ((missed = this.wip.addAndGet(-missed)) != 0);
                return;
            }
        }

        private boolean emitContent(HttpContent data) {
            this.subscriber.onNext((Object)data.content());
            if (data instanceof LastHttpContent) {
                this.releaseQueue();
                this.subscriber.onComplete();
                this.acquisitionListener.contentDone(false);
                return true;
            }
            return false;
        }

        private void releaseQueue() {
            HttpContent c;
            while ((c = (HttpContent)this.queue.poll()) != null) {
                c.release();
            }
        }
    }

    private static final class AcquisitionListener
    implements GenericFutureListener<Future<? super Channel>>,
    Disposable {
        private final SharedChannelPool channelPool;
        private final HttpRequest request;
        private final SingleEmitter<HttpResponse> responseEmitter;
        private final AtomicInteger state = new AtomicInteger(0);
        private static final int MAX_SEND_BUF_SIZE = 65536;
        private static final int ACQUIRING_NOT_DISPOSED = 0;
        private static final int ACQUIRING_DISPOSED = 1;
        private static final int ACQUIRED_CONTENT_NOT_SUBSCRIBED = 2;
        private static final int ACQUIRED_CONTENT_SUBSCRIBED = 3;
        private static final int ACQUIRED_DISPOSED_CONTENT_SUBSCRIBED = 4;
        private static final int ACQUIRED_DISPOSED_CONTENT_NOT_SUBSCRIBED = 5;
        private static final int CHANNEL_RELEASED = 6;
        private Channel channel;
        private ResponseContentFlowable content;
        private volatile boolean finishedWritingRequestBody;
        private volatile RequestSubscriber requestSubscriber;

        AcquisitionListener(SharedChannelPool channelPool, HttpRequest request, SingleEmitter<HttpResponse> responseEmitter) {
            this.channelPool = channelPool;
            this.request = request;
            this.responseEmitter = responseEmitter;
        }

        public void operationComplete(Future<? super Channel> cf) {
            block9: {
                block10: {
                    block8: {
                        if (!cf.isSuccess()) {
                            this.emitError(cf.cause());
                            return;
                        }
                        this.channel = (Channel)cf.getNow();
                        while (true) {
                            int s;
                            if ((s = this.state.get()) == 1) {
                                if (!this.transition(1, 6)) continue;
                                LOGGER.debug("Channel disposed on acquisition");
                                this.channelPool.closeAndRelease(this.channel);
                                return;
                            }
                            if (s != 0) break block8;
                            if (this.transition(0, 2)) break;
                        }
                        break block10;
                    }
                    return;
                }
                HttpClientInboundHandler inboundHandler = (HttpClientInboundHandler)this.channel.pipeline().get(HttpClientInboundHandler.class);
                inboundHandler.setFields(this.responseEmitter, this);
                try {
                    DefaultHttpRequest raw = NettyClient.createDefaultHttpRequest(this.request);
                    this.writeRequest(raw);
                    if (this.request.body() == null) {
                        this.writeBodyEnd();
                        break block9;
                    }
                    this.requestSubscriber = new RequestSubscriber(inboundHandler);
                    String contentLengthHeader = this.request.headers().value("content-length");
                    try {
                        long contentLength = Long.parseLong(contentLengthHeader);
                        this.request.body().flatMap(bb -> bb.remaining() > 65536 ? FlowableUtil.split(bb, 65536) : Flowable.just((Object)bb)).compose(FlowableUtil.ensureLength(contentLength)).subscribe((FlowableSubscriber)this.requestSubscriber);
                    }
                    catch (NumberFormatException e) {
                        String message = String.format("Content-Length was expected to be a valid long but was \"%s\"", contentLengthHeader);
                        throw new IllegalArgumentException(message, e);
                    }
                }
                catch (Exception e) {
                    this.emitError(e);
                }
            }
        }

        private void writeRequest(DefaultHttpRequest raw) {
            this.channel.eventLoop().execute(() -> this.channel.write((Object)raw).addListener(future -> {
                if (!future.isSuccess()) {
                    this.emitError(future.cause());
                }
            }));
        }

        private void writeBodyEnd() {
            this.channel.eventLoop().execute(() -> this.channel.writeAndFlush((Object)DefaultLastHttpContent.EMPTY_LAST_CONTENT).addListener(future -> {
                if (future.isSuccess()) {
                    this.finishedWritingRequestBody = true;
                    this.channel.read();
                } else {
                    this.emitError(future.cause());
                }
            }));
        }

        private boolean transition(int from, int to) {
            return this.state.compareAndSet(from, to);
        }

        void emitError(Throwable throwable) {
            block5: {
                int s;
                block6: {
                    while (true) {
                        LOGGER.warn("Error emitted on channel {}. Message: {}", (Object)this.channel.id(), (Object)throwable.getMessage());
                        LOGGER.debug("Stack trace: ", (Throwable)new Exception());
                        this.channelPool.dump();
                        s = this.state.get();
                        if (s == 0) {
                            if (!this.transition(0, 1)) continue;
                            LOGGER.debug("Channel disposed before response is subscribed");
                            this.responseEmitter.onError(throwable);
                            break block5;
                        }
                        if (s == 3) {
                            if (!this.transition(3, 6)) continue;
                            LOGGER.debug("Channel disposed after content is subscribed");
                            this.closeAndReleaseChannel();
                            this.content.onError(throwable);
                            break block5;
                        }
                        if (s == 2) {
                            if (!this.transition(2, 6)) continue;
                            LOGGER.debug("Channel disposed before content is subscribed");
                            this.closeAndReleaseChannel();
                            this.responseEmitter.onError(throwable);
                            break block5;
                        }
                        if (s == 4) {
                            if (!this.transition(4, 6)) continue;
                            LOGGER.debug("Channel disposed after content is subscribed with response emitter disposed");
                            this.closeAndReleaseChannel();
                            this.content.onError(throwable);
                            break block5;
                        }
                        if (s != 5) break block6;
                        if (this.transition(5, 6)) break;
                    }
                    LOGGER.debug("Channel disposed before content is subscribed with response emitter disposed");
                    this.closeAndReleaseChannel();
                    throw Exceptions.propagate((Throwable)throwable);
                }
                LOGGER.debug("Channel disposed at state {}", (Object)s);
            }
        }

        boolean contentSubscribed(ResponseContentFlowable content) {
            block2: {
                while (true) {
                    int s;
                    if ((s = this.state.get()) == 2) {
                        if (!this.transition(2, 3)) continue;
                        this.content = content;
                        return true;
                    }
                    if (s != 5) break block2;
                    if (this.transition(5, 4)) break;
                }
                this.content = content;
                return true;
            }
            return false;
        }

        private void releaseChannel(boolean cancelled) {
            if (!cancelled && this.finishedWritingRequestBody) {
                Future<Void> release = this.channelPool.release(this.channel);
                if (!release.isSuccess()) {
                    this.emitError(release.cause());
                }
            } else {
                LOGGER.debug("Channel disposed on cancellation or request body reading interrupted");
                this.closeAndReleaseChannel();
            }
        }

        void contentDone(boolean cancelled) {
            block2: {
                while (true) {
                    int s;
                    if ((s = this.state.get()) == 3) {
                        if (!this.transition(3, 6)) continue;
                        this.releaseChannel(cancelled);
                        return;
                    }
                    if (s != 4) break block2;
                    if (this.transition(4, 6)) break;
                }
                this.releaseChannel(cancelled);
                return;
            }
        }

        public void dispose() {
            block4: {
                while (true) {
                    int s;
                    if ((s = this.state.get()) == 0) {
                        if (!this.transition(0, 1)) continue;
                        return;
                    }
                    if (s == 1) {
                        if (!this.transition(1, 6)) continue;
                        LOGGER.debug("Channel disposed on ACQUIRING_DISPOSED");
                        this.closeAndReleaseChannel();
                        return;
                    }
                    if (s == 2) {
                        if (!this.transition(2, 5)) continue;
                        return;
                    }
                    if (s != 3) break block4;
                    if (this.transition(3, 4)) break;
                }
                return;
            }
        }

        private void closeAndReleaseChannel() {
            if (this.channel != null) {
                this.channelPool.closeAndRelease(this.channel);
            }
        }

        public boolean isDisposed() {
            return this.state.get() >= 4;
        }

        public void channelWritable(boolean writable) {
            if (this.requestSubscriber != null) {
                this.requestSubscriber.channelWritable(writable);
            }
        }

        private final class RequestSubscriber
        implements FlowableSubscriber<ByteBuffer>,
        GenericFutureListener<Future<Void>> {
            Subscription subscription;
            private boolean done;
            private final HttpClientInboundHandler inboundHandler;

            RequestSubscriber(HttpClientInboundHandler inboundHandler) {
                this.inboundHandler = inboundHandler;
            }

            public void onSubscribe(Subscription s) {
                this.subscription = s;
                this.inboundHandler.requestContentSubscription = this.subscription;
                this.subscription.request(1L);
            }

            public void onNext(ByteBuffer buf) {
                if (this.done) {
                    return;
                }
                try {
                    AcquisitionListener.this.channel.eventLoop().execute(() -> {
                        try {
                            AcquisitionListener.this.channel.write((Object)Unpooled.wrappedBuffer((ByteBuffer)buf)).addListener((GenericFutureListener)this);
                            if (AcquisitionListener.this.channel.isWritable()) {
                                this.subscription.request(1L);
                            } else {
                                AcquisitionListener.this.channel.flush();
                            }
                        }
                        catch (Exception e) {
                            this.subscription.cancel();
                            this.onError(e);
                        }
                    });
                }
                catch (Exception e) {
                    this.subscription.cancel();
                    this.onError(e);
                }
            }

            public void onError(Throwable t) {
                if (this.done) {
                    RxJavaPlugins.onError((Throwable)t);
                    return;
                }
                this.done = true;
                AcquisitionListener.this.emitError(t);
            }

            public void onComplete() {
                if (this.done) {
                    return;
                }
                this.done = true;
                try {
                    AcquisitionListener.this.writeBodyEnd();
                }
                catch (Exception e) {
                    AcquisitionListener.this.emitError(e);
                }
            }

            public void operationComplete(Future<Void> future) throws Exception {
                if (!future.isSuccess()) {
                    this.subscription.cancel();
                    this.done = true;
                    AcquisitionListener.this.emitError(future.cause());
                }
            }

            void channelWritable(boolean writable) {
                if (writable) {
                    this.subscription.request(1L);
                }
            }
        }
    }

    private static final class NettyAdapter {
        private static final String EPOLL_GROUP_CLASS_NAME = "io.netty.channel.epoll.EpollEventLoopGroup";
        private static final String EPOLL_SOCKET_CLASS_NAME = "io.netty.channel.epoll.EpollSocketChannel";
        private static final String KQUEUE_GROUP_CLASS_NAME = "io.netty.channel.kqueue.KQueueEventLoopGroup";
        private static final String KQUEUE_SOCKET_CLASS_NAME = "io.netty.channel.kqueue.KQueueSocketChannel";
        private final MultithreadEventLoopGroup eventLoopGroup;
        private final SharedChannelPool channelPool;

        public Future<?> shutdownGracefully() {
            this.channelPool.close();
            return this.eventLoopGroup.shutdownGracefully();
        }

        private static MultithreadEventLoopGroup loadEventLoopGroup(String className, int size) throws ReflectiveOperationException {
            Class<?> cls = Class.forName(className);
            DefaultThreadFactory factory = new DefaultThreadFactory(cls, true);
            MultithreadEventLoopGroup result = (MultithreadEventLoopGroup)cls.getConstructor(Integer.TYPE, ThreadFactory.class).newInstance(size, factory);
            return result;
        }

        private static TransportConfig loadTransport(int groupSize) {
            TransportConfig result = null;
            try {
                String osName = System.getProperty("os.name");
                if (osName.contains("Linux")) {
                    result = new TransportConfig(NettyAdapter.loadEventLoopGroup(EPOLL_GROUP_CLASS_NAME, groupSize), Class.forName(EPOLL_SOCKET_CLASS_NAME));
                } else if (osName.contains("Mac")) {
                    result = new TransportConfig(NettyAdapter.loadEventLoopGroup(KQUEUE_GROUP_CLASS_NAME, groupSize), Class.forName(KQUEUE_SOCKET_CLASS_NAME));
                }
            }
            catch (Exception e) {
                Throwable cause;
                String message = e.getMessage();
                if (message == null && (cause = e.getCause()) != null) {
                    message = cause.getMessage();
                }
                LoggerFactory.getLogger(NettyAdapter.class).debug("Exception when obtaining native EventLoopGroup and SocketChannel: " + message);
            }
            if (result == null) {
                result = new TransportConfig((MultithreadEventLoopGroup)new NioEventLoopGroup(groupSize, (ThreadFactory)new DefaultThreadFactory(NioEventLoopGroup.class, true)), NioSocketChannel.class);
            }
            return result;
        }

        private static SharedChannelPool createChannelPool(Bootstrap bootstrap, TransportConfig config, int poolSize, SslContext sslContext) {
            bootstrap.group((EventLoopGroup)config.eventLoopGroup);
            bootstrap.channel(config.channelClass);
            bootstrap.option(ChannelOption.AUTO_READ, (Object)false);
            bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)TimeUnit.MINUTES.toMillis(3L)));
            return new SharedChannelPool(bootstrap, (ChannelPoolHandler)new AbstractChannelPoolHandler(){

                public synchronized void channelCreated(Channel ch) throws Exception {
                    ch.pipeline().addLast("HttpClientCodec", (ChannelHandler)new HttpClientCodec());
                    ch.pipeline().addLast("HttpClientInboundHandler", (ChannelHandler)new HttpClientInboundHandler());
                }
            }, poolSize, new SharedChannelPoolOptions(), sslContext);
        }

        private NettyAdapter() {
            TransportConfig config = NettyAdapter.loadTransport(0);
            this.eventLoopGroup = config.eventLoopGroup;
            this.channelPool = NettyAdapter.createChannelPool(new Bootstrap(), config, this.eventLoopGroup.executorCount() * 16, null);
        }

        private NettyAdapter(Bootstrap baseBootstrap, int eventLoopGroupSize, int channelPoolSize, SslContext sslContext) {
            TransportConfig config = NettyAdapter.loadTransport(eventLoopGroupSize);
            this.eventLoopGroup = config.eventLoopGroup;
            this.channelPool = NettyAdapter.createChannelPool(baseBootstrap, config, channelPoolSize, sslContext);
        }

        private Single<HttpResponse> sendRequestInternalAsync(HttpRequest request, HttpClientConfiguration configuration) {
            NettyClient.addHeaders(request);
            return Single.create(responseEmitter -> {
                AcquisitionListener listener = new AcquisitionListener(this.channelPool, request, (SingleEmitter<HttpResponse>)responseEmitter);
                responseEmitter.setDisposable((Disposable)listener);
                this.channelPool.acquire(request.url().toURI(), configuration.proxy()).addListener((GenericFutureListener)listener);
            });
        }

        private static final class TransportConfig {
            final MultithreadEventLoopGroup eventLoopGroup;
            final Class<? extends SocketChannel> channelClass;

            private TransportConfig(MultithreadEventLoopGroup eventLoopGroup, Class<? extends SocketChannel> channelClass) {
                this.eventLoopGroup = eventLoopGroup;
                this.channelClass = channelClass;
            }
        }
    }
}

