/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl.driver.jar;

import com.microsoft.playwright.impl.driver.Driver;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DriverJar
extends Driver {
    private static final String PLAYWRIGHT_SKIP_BROWSER_DOWNLOAD = "PLAYWRIGHT_SKIP_BROWSER_DOWNLOAD";
    private static final String SELENIUM_REMOTE_URL = "SELENIUM_REMOTE_URL";
    static final String PLAYWRIGHT_NODEJS_PATH = "PLAYWRIGHT_NODEJS_PATH";
    private final Path driverTempDir;
    private Path preinstalledNodePath;

    public DriverJar() throws IOException {
        String alternativeTmpdir = System.getProperty("playwright.driver.tmpdir");
        String prefix = "playwright-java-";
        this.driverTempDir = alternativeTmpdir == null ? Files.createTempDirectory(prefix, new FileAttribute[0]) : Files.createTempDirectory(Paths.get(alternativeTmpdir, new String[0]), prefix, new FileAttribute[0]);
        this.driverTempDir.toFile().deleteOnExit();
        String nodePath = System.getProperty("playwright.nodejs.path");
        if (nodePath != null) {
            this.preinstalledNodePath = Paths.get(nodePath, new String[0]);
            if (!Files.exists(this.preinstalledNodePath, new LinkOption[0])) {
                throw new RuntimeException("Invalid Node.js path specified: " + nodePath);
            }
        }
        DriverJar.logMessage((String)("created DriverJar: " + this.driverTempDir));
    }

    protected void initialize(Boolean installBrowsers) throws Exception {
        if (this.preinstalledNodePath == null && this.env.containsKey(PLAYWRIGHT_NODEJS_PATH)) {
            this.preinstalledNodePath = Paths.get((String)this.env.get(PLAYWRIGHT_NODEJS_PATH), new String[0]);
            if (!Files.exists(this.preinstalledNodePath, new LinkOption[0])) {
                throw new RuntimeException("Invalid Node.js path specified: " + this.preinstalledNodePath);
            }
        } else if (this.preinstalledNodePath != null) {
            this.env.put(PLAYWRIGHT_NODEJS_PATH, this.preinstalledNodePath.toString());
        }
        this.extractDriverToTempDir();
        DriverJar.logMessage((String)("extracted driver from jar to " + this.driverPath()));
        if (installBrowsers.booleanValue()) {
            this.installBrowsers(this.env);
        }
    }

    private void installBrowsers(Map<String, String> env) throws IOException, InterruptedException {
        String skip = env.get(PLAYWRIGHT_SKIP_BROWSER_DOWNLOAD);
        if (skip == null) {
            skip = System.getenv(PLAYWRIGHT_SKIP_BROWSER_DOWNLOAD);
        }
        if (skip != null && !"0".equals(skip) && !"false".equals(skip)) {
            System.out.println("Skipping browsers download because `PLAYWRIGHT_SKIP_BROWSER_DOWNLOAD` env variable is set");
            return;
        }
        if (env.get(SELENIUM_REMOTE_URL) != null || System.getenv(SELENIUM_REMOTE_URL) != null) {
            DriverJar.logMessage((String)"Skipping browsers download because `SELENIUM_REMOTE_URL` env variable is set");
            return;
        }
        Path driver = this.driverPath();
        if (!Files.exists(driver, new LinkOption[0])) {
            throw new RuntimeException("Failed to find driver: " + driver);
        }
        ProcessBuilder pb = this.createProcessBuilder();
        pb.command().add("install");
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        Process p = pb.start();
        boolean result = p.waitFor(10L, TimeUnit.MINUTES);
        if (!result) {
            p.destroy();
            throw new RuntimeException("Timed out waiting for browsers to install");
        }
        if (p.exitValue() != 0) {
            throw new RuntimeException("Failed to install browsers, exit code: " + p.exitValue());
        }
    }

    private static boolean isExecutable(Path filePath) {
        String name = filePath.getFileName().toString();
        return name.endsWith(".sh") || name.endsWith(".exe") || !name.contains(".");
    }

    private FileSystem initFileSystem(URI uri) throws IOException {
        try {
            return FileSystems.newFileSystem(uri, Collections.emptyMap());
        }
        catch (FileSystemAlreadyExistsException e) {
            return null;
        }
    }

    public static URI getDriverResourceURI() throws URISyntaxException {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        return classloader.getResource("driver/" + DriverJar.platformDir()).toURI();
    }

    void extractDriverToTempDir() throws URISyntaxException, IOException {
        URI originalUri = DriverJar.getDriverResourceURI();
        URI uri = this.maybeExtractNestedJar(originalUri);
        try (FileSystem fileSystem = "jar".equals(uri.getScheme()) ? this.initFileSystem(uri) : null;){
            Path srcRoot = Paths.get(uri);
            Path srcRootDefaultFs = Paths.get(srcRoot.toString(), new String[0]);
            Files.walk(srcRoot, new FileVisitOption[0]).forEach(fromPath -> {
                String fileName;
                if (this.preinstalledNodePath != null && ("node.exe".equals(fileName = fromPath.getFileName().toString()) || "node".equals(fileName))) {
                    return;
                }
                Path relative = srcRootDefaultFs.relativize(Paths.get(fromPath.toString(), new String[0]));
                Path toPath = this.driverTempDir.resolve(relative.toString());
                try {
                    if (Files.isDirectory(fromPath, new LinkOption[0])) {
                        Files.createDirectories(toPath, new FileAttribute[0]);
                    } else {
                        Files.copy(fromPath, toPath, new CopyOption[0]);
                        if (DriverJar.isExecutable(toPath)) {
                            toPath.toFile().setExecutable(true, true);
                        }
                    }
                    toPath.toFile().deleteOnExit();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to extract driver from " + uri + ", full uri: " + originalUri, e);
                }
            });
        }
    }

    private URI maybeExtractNestedJar(URI uri) throws URISyntaxException {
        URI uRI;
        block10: {
            if (!"jar".equals(uri.getScheme())) {
                return uri;
            }
            String JAR_URL_SEPARATOR = "!/";
            String[] parts = uri.toString().split("!/");
            if (parts.length != 3) {
                return uri;
            }
            String innerJar = String.join((CharSequence)"!/", parts[0], parts[1]);
            URI jarUri = new URI(innerJar);
            FileSystem fs = FileSystems.newFileSystem(jarUri, Collections.emptyMap());
            try {
                Path fromPath = Paths.get(jarUri);
                Path toPath = this.driverTempDir.resolve(fromPath.getFileName().toString());
                Files.copy(fromPath, toPath, new CopyOption[0]);
                toPath.toFile().deleteOnExit();
                uRI = new URI("jar:" + toPath.toUri() + "!/" + parts[2]);
                if (fs == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (fs != null) {
                        try {
                            fs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to extract driver's nested .jar from " + jarUri + "; full uri: " + uri, e);
                }
            }
            fs.close();
        }
        return uRI;
    }

    private static String platformDir() {
        String name = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        if (name.contains("windows")) {
            return "win32_x64";
        }
        if (name.contains("linux")) {
            if (arch.equals("aarch64")) {
                return "linux-arm64";
            }
            return "linux";
        }
        if (name.contains("mac os x")) {
            if (arch.equals("aarch64")) {
                return "mac-arm64";
            }
            return "mac";
        }
        throw new RuntimeException("Unexpected os.name value: " + name);
    }

    protected Path driverDir() {
        return this.driverTempDir;
    }
}

