"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ValidationError", {
  enumerable: true,
  get: function () {
    return _validatorPrimitives.ValidationError;
  }
});
exports.createScheme = createScheme;

var _validatorPrimitives = require("./validatorPrimitives");

/**
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// This file is generated by generate_channels.js, do not edit manually.
function createScheme(tChannel) {
  const scheme = {};

  const tType = name => {
    return (arg, path) => {
      const v = scheme[name];
      if (!v) throw new _validatorPrimitives.ValidationError(path + ': unknown type "' + name + '"');
      return v(arg, path);
    };
  };

  scheme.StackFrame = (0, _validatorPrimitives.tObject)({
    file: _validatorPrimitives.tString,
    line: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    column: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    function: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString)
  });
  scheme.Metadata = (0, _validatorPrimitives.tObject)({
    stack: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(tType('StackFrame'))),
    apiName: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    internal: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.Point = (0, _validatorPrimitives.tObject)({
    x: _validatorPrimitives.tNumber,
    y: _validatorPrimitives.tNumber
  });
  scheme.Rect = (0, _validatorPrimitives.tObject)({
    x: _validatorPrimitives.tNumber,
    y: _validatorPrimitives.tNumber,
    width: _validatorPrimitives.tNumber,
    height: _validatorPrimitives.tNumber
  });
  scheme.SerializedValue = (0, _validatorPrimitives.tObject)({
    n: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    b: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    s: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    v: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['null', 'undefined', 'NaN', 'Infinity', '-Infinity', '-0'])),
    d: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    r: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      p: _validatorPrimitives.tString,
      f: _validatorPrimitives.tString
    })),
    a: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(tType('SerializedValue'))),
    o: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)((0, _validatorPrimitives.tObject)({
      k: _validatorPrimitives.tString,
      v: tType('SerializedValue')
    }))),
    h: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    id: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    ref: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.SerializedArgument = (0, _validatorPrimitives.tObject)({
    value: tType('SerializedValue'),
    handles: (0, _validatorPrimitives.tArray)(tChannel('*'))
  });
  scheme.ExpectedTextValue = (0, _validatorPrimitives.tObject)({
    string: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    regexSource: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    regexFlags: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    matchSubstring: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    normalizeWhiteSpace: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.AXNode = (0, _validatorPrimitives.tObject)({
    role: _validatorPrimitives.tString,
    name: _validatorPrimitives.tString,
    valueString: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    valueNumber: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    description: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    keyshortcuts: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    roledescription: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    valuetext: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    disabled: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    expanded: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    focused: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    modal: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    multiline: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    multiselectable: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    readonly: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    required: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    selected: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    checked: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['checked', 'unchecked', 'mixed'])),
    pressed: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['pressed', 'released', 'mixed'])),
    level: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    valuemin: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    valuemax: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    autocomplete: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    haspopup: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    invalid: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    orientation: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    children: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(tType('AXNode')))
  });
  scheme.SetNetworkCookie = (0, _validatorPrimitives.tObject)({
    name: _validatorPrimitives.tString,
    value: _validatorPrimitives.tString,
    url: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    domain: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    path: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    expires: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    httpOnly: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    secure: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    sameSite: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['Strict', 'Lax', 'None']))
  });
  scheme.NetworkCookie = (0, _validatorPrimitives.tObject)({
    name: _validatorPrimitives.tString,
    value: _validatorPrimitives.tString,
    domain: _validatorPrimitives.tString,
    path: _validatorPrimitives.tString,
    expires: _validatorPrimitives.tNumber,
    httpOnly: _validatorPrimitives.tBoolean,
    secure: _validatorPrimitives.tBoolean,
    sameSite: (0, _validatorPrimitives.tEnum)(['Strict', 'Lax', 'None'])
  });
  scheme.NameValue = (0, _validatorPrimitives.tObject)({
    name: _validatorPrimitives.tString,
    value: _validatorPrimitives.tString
  });
  scheme.OriginStorage = (0, _validatorPrimitives.tObject)({
    origin: _validatorPrimitives.tString,
    localStorage: (0, _validatorPrimitives.tArray)(tType('NameValue'))
  });
  scheme.SerializedError = (0, _validatorPrimitives.tObject)({
    error: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      message: _validatorPrimitives.tString,
      name: _validatorPrimitives.tString,
      stack: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString)
    })),
    value: (0, _validatorPrimitives.tOptional)(tType('SerializedValue'))
  });
  scheme.FormField = (0, _validatorPrimitives.tObject)({
    name: _validatorPrimitives.tString,
    value: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    file: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      name: _validatorPrimitives.tString,
      mimeType: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
      buffer: _validatorPrimitives.tBinary
    }))
  });
  scheme.APIRequestContextFetchParams = (0, _validatorPrimitives.tObject)({
    url: _validatorPrimitives.tString,
    params: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(tType('NameValue'))),
    method: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    headers: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(tType('NameValue'))),
    postData: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBinary),
    jsonData: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tAny),
    formData: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(tType('NameValue'))),
    multipartData: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(tType('FormField'))),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    failOnStatusCode: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    ignoreHTTPSErrors: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.APIRequestContextFetchResponseBodyParams = (0, _validatorPrimitives.tObject)({
    fetchUid: _validatorPrimitives.tString
  });
  scheme.APIRequestContextFetchLogParams = (0, _validatorPrimitives.tObject)({
    fetchUid: _validatorPrimitives.tString
  });
  scheme.APIRequestContextStorageStateParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.APIRequestContextDisposeAPIResponseParams = (0, _validatorPrimitives.tObject)({
    fetchUid: _validatorPrimitives.tString
  });
  scheme.APIRequestContextDisposeParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.APIResponse = (0, _validatorPrimitives.tObject)({
    fetchUid: _validatorPrimitives.tString,
    url: _validatorPrimitives.tString,
    status: _validatorPrimitives.tNumber,
    statusText: _validatorPrimitives.tString,
    headers: (0, _validatorPrimitives.tArray)(tType('NameValue'))
  });
  scheme.LifecycleEvent = (0, _validatorPrimitives.tEnum)(['load', 'domcontentloaded', 'networkidle', 'commit']);
  scheme.LocalUtilsZipParams = (0, _validatorPrimitives.tObject)({
    zipFile: _validatorPrimitives.tString,
    entries: (0, _validatorPrimitives.tArray)(tType('NameValue'))
  });
  scheme.RootInitializeParams = (0, _validatorPrimitives.tObject)({
    sdkLanguage: _validatorPrimitives.tString
  });
  scheme.PlaywrightNewRequestParams = (0, _validatorPrimitives.tObject)({
    baseURL: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    userAgent: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    ignoreHTTPSErrors: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    extraHTTPHeaders: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(tType('NameValue'))),
    httpCredentials: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      username: _validatorPrimitives.tString,
      password: _validatorPrimitives.tString
    })),
    proxy: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      server: _validatorPrimitives.tString,
      bypass: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
      username: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
      password: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString)
    })),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    storageState: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      cookies: (0, _validatorPrimitives.tArray)(tType('NetworkCookie')),
      origins: (0, _validatorPrimitives.tArray)(tType('OriginStorage'))
    })),
    tracesDir: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString)
  });
  scheme.PlaywrightHideHighlightParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.SocksSupportSocksConnectedParams = (0, _validatorPrimitives.tObject)({
    uid: _validatorPrimitives.tString,
    host: _validatorPrimitives.tString,
    port: _validatorPrimitives.tNumber
  });
  scheme.SocksSupportSocksFailedParams = (0, _validatorPrimitives.tObject)({
    uid: _validatorPrimitives.tString,
    errorCode: _validatorPrimitives.tString
  });
  scheme.SocksSupportSocksDataParams = (0, _validatorPrimitives.tObject)({
    uid: _validatorPrimitives.tString,
    data: _validatorPrimitives.tBinary
  });
  scheme.SocksSupportSocksErrorParams = (0, _validatorPrimitives.tObject)({
    uid: _validatorPrimitives.tString,
    error: _validatorPrimitives.tString
  });
  scheme.SocksSupportSocksEndParams = (0, _validatorPrimitives.tObject)({
    uid: _validatorPrimitives.tString
  });
  scheme.SelectorsRegisterParams = (0, _validatorPrimitives.tObject)({
    name: _validatorPrimitives.tString,
    source: _validatorPrimitives.tString,
    contentScript: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.BrowserTypeConnectParams = (0, _validatorPrimitives.tObject)({
    wsEndpoint: _validatorPrimitives.tString,
    headers: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tAny),
    slowMo: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    socksProxyRedirectPortForTest: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.BrowserTypeLaunchParams = (0, _validatorPrimitives.tObject)({
    channel: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    executablePath: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    args: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(_validatorPrimitives.tString)),
    ignoreAllDefaultArgs: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    ignoreDefaultArgs: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(_validatorPrimitives.tString)),
    handleSIGINT: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    handleSIGTERM: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    handleSIGHUP: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    env: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(tType('NameValue'))),
    headless: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    devtools: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    proxy: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      server: _validatorPrimitives.tString,
      bypass: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
      username: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
      password: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString)
    })),
    downloadsPath: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    tracesDir: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    chromiumSandbox: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    firefoxUserPrefs: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tAny),
    slowMo: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.BrowserTypeLaunchPersistentContextParams = (0, _validatorPrimitives.tObject)({
    channel: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    executablePath: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    args: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(_validatorPrimitives.tString)),
    ignoreAllDefaultArgs: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    ignoreDefaultArgs: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(_validatorPrimitives.tString)),
    handleSIGINT: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    handleSIGTERM: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    handleSIGHUP: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    env: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(tType('NameValue'))),
    headless: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    devtools: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    proxy: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      server: _validatorPrimitives.tString,
      bypass: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
      username: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
      password: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString)
    })),
    downloadsPath: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    tracesDir: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    chromiumSandbox: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    noDefaultViewport: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    viewport: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      width: _validatorPrimitives.tNumber,
      height: _validatorPrimitives.tNumber
    })),
    screen: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      width: _validatorPrimitives.tNumber,
      height: _validatorPrimitives.tNumber
    })),
    ignoreHTTPSErrors: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    javaScriptEnabled: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    bypassCSP: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    userAgent: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    locale: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    timezoneId: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    geolocation: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      longitude: _validatorPrimitives.tNumber,
      latitude: _validatorPrimitives.tNumber,
      accuracy: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
    })),
    permissions: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(_validatorPrimitives.tString)),
    extraHTTPHeaders: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(tType('NameValue'))),
    offline: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    httpCredentials: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      username: _validatorPrimitives.tString,
      password: _validatorPrimitives.tString
    })),
    deviceScaleFactor: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    isMobile: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    hasTouch: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    colorScheme: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['dark', 'light', 'no-preference'])),
    reducedMotion: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['reduce', 'no-preference'])),
    forcedColors: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['active', 'none'])),
    acceptDownloads: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    baseURL: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    recordVideo: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      dir: _validatorPrimitives.tString,
      size: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
        width: _validatorPrimitives.tNumber,
        height: _validatorPrimitives.tNumber
      }))
    })),
    recordHar: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      omitContent: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
      path: _validatorPrimitives.tString
    })),
    strictSelectors: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    userDataDir: _validatorPrimitives.tString,
    slowMo: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.BrowserTypeConnectOverCDPParams = (0, _validatorPrimitives.tObject)({
    endpointURL: _validatorPrimitives.tString,
    headers: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(tType('NameValue'))),
    slowMo: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.BrowserCloseParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.BrowserKillForTestsParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.BrowserNewContextParams = (0, _validatorPrimitives.tObject)({
    noDefaultViewport: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    viewport: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      width: _validatorPrimitives.tNumber,
      height: _validatorPrimitives.tNumber
    })),
    screen: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      width: _validatorPrimitives.tNumber,
      height: _validatorPrimitives.tNumber
    })),
    ignoreHTTPSErrors: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    javaScriptEnabled: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    bypassCSP: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    userAgent: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    locale: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    timezoneId: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    geolocation: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      longitude: _validatorPrimitives.tNumber,
      latitude: _validatorPrimitives.tNumber,
      accuracy: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
    })),
    permissions: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(_validatorPrimitives.tString)),
    extraHTTPHeaders: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(tType('NameValue'))),
    offline: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    httpCredentials: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      username: _validatorPrimitives.tString,
      password: _validatorPrimitives.tString
    })),
    deviceScaleFactor: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    isMobile: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    hasTouch: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    colorScheme: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['dark', 'light', 'no-preference'])),
    reducedMotion: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['reduce', 'no-preference'])),
    forcedColors: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['active', 'none'])),
    acceptDownloads: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    baseURL: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    recordVideo: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      dir: _validatorPrimitives.tString,
      size: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
        width: _validatorPrimitives.tNumber,
        height: _validatorPrimitives.tNumber
      }))
    })),
    recordHar: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      omitContent: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
      path: _validatorPrimitives.tString
    })),
    strictSelectors: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    proxy: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      server: _validatorPrimitives.tString,
      bypass: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
      username: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
      password: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString)
    })),
    storageState: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      cookies: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(tType('SetNetworkCookie'))),
      origins: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(tType('OriginStorage')))
    }))
  });
  scheme.BrowserNewBrowserCDPSessionParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.BrowserStartTracingParams = (0, _validatorPrimitives.tObject)({
    page: (0, _validatorPrimitives.tOptional)(tChannel('Page')),
    path: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    screenshots: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    categories: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(_validatorPrimitives.tString))
  });
  scheme.BrowserStopTracingParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.EventTargetWaitForEventInfoParams = (0, _validatorPrimitives.tObject)({
    info: (0, _validatorPrimitives.tObject)({
      waitId: _validatorPrimitives.tString,
      phase: (0, _validatorPrimitives.tEnum)(['before', 'after', 'log']),
      event: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
      message: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
      error: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString)
    })
  });
  scheme.BrowserContextWaitForEventInfoParams = tType('EventTargetWaitForEventInfoParams');
  scheme.PageWaitForEventInfoParams = tType('EventTargetWaitForEventInfoParams');
  scheme.WebSocketWaitForEventInfoParams = tType('EventTargetWaitForEventInfoParams');
  scheme.ElectronApplicationWaitForEventInfoParams = tType('EventTargetWaitForEventInfoParams');
  scheme.AndroidDeviceWaitForEventInfoParams = tType('EventTargetWaitForEventInfoParams');
  scheme.BrowserContextAddCookiesParams = (0, _validatorPrimitives.tObject)({
    cookies: (0, _validatorPrimitives.tArray)(tType('SetNetworkCookie'))
  });
  scheme.BrowserContextAddInitScriptParams = (0, _validatorPrimitives.tObject)({
    source: _validatorPrimitives.tString
  });
  scheme.BrowserContextRemoveInitScriptsParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.BrowserContextClearCookiesParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.BrowserContextClearPermissionsParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.BrowserContextCloseParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.BrowserContextCookiesParams = (0, _validatorPrimitives.tObject)({
    urls: (0, _validatorPrimitives.tArray)(_validatorPrimitives.tString)
  });
  scheme.BrowserContextExposeBindingParams = (0, _validatorPrimitives.tObject)({
    name: _validatorPrimitives.tString,
    needsHandle: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.BrowserContextRemoveExposedBindingsParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.BrowserContextGrantPermissionsParams = (0, _validatorPrimitives.tObject)({
    permissions: (0, _validatorPrimitives.tArray)(_validatorPrimitives.tString),
    origin: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString)
  });
  scheme.BrowserContextNewPageParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.BrowserContextSetDefaultNavigationTimeoutNoReplyParams = (0, _validatorPrimitives.tObject)({
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.BrowserContextSetDefaultTimeoutNoReplyParams = (0, _validatorPrimitives.tObject)({
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.BrowserContextSetExtraHTTPHeadersParams = (0, _validatorPrimitives.tObject)({
    headers: (0, _validatorPrimitives.tArray)(tType('NameValue'))
  });
  scheme.BrowserContextSetGeolocationParams = (0, _validatorPrimitives.tObject)({
    geolocation: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      longitude: _validatorPrimitives.tNumber,
      latitude: _validatorPrimitives.tNumber,
      accuracy: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
    }))
  });
  scheme.BrowserContextSetHTTPCredentialsParams = (0, _validatorPrimitives.tObject)({
    httpCredentials: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      username: _validatorPrimitives.tString,
      password: _validatorPrimitives.tString
    }))
  });
  scheme.BrowserContextSetNetworkInterceptionEnabledParams = (0, _validatorPrimitives.tObject)({
    enabled: _validatorPrimitives.tBoolean
  });
  scheme.BrowserContextSetOfflineParams = (0, _validatorPrimitives.tObject)({
    offline: _validatorPrimitives.tBoolean
  });
  scheme.BrowserContextStorageStateParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.BrowserContextPauseParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.BrowserContextRecorderSupplementEnableParams = (0, _validatorPrimitives.tObject)({
    language: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    startRecording: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    pauseOnNextStatement: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    launchOptions: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tAny),
    contextOptions: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tAny),
    device: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    saveStorage: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    outputFile: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString)
  });
  scheme.BrowserContextNewCDPSessionParams = (0, _validatorPrimitives.tObject)({
    page: (0, _validatorPrimitives.tOptional)(tChannel('Page')),
    frame: (0, _validatorPrimitives.tOptional)(tChannel('Frame'))
  });
  scheme.BrowserContextHarExportParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.BrowserContextCreateTempFileParams = (0, _validatorPrimitives.tObject)({
    name: _validatorPrimitives.tString
  });
  scheme.PageSetDefaultNavigationTimeoutNoReplyParams = (0, _validatorPrimitives.tObject)({
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.PageSetDefaultTimeoutNoReplyParams = (0, _validatorPrimitives.tObject)({
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.PageSetFileChooserInterceptedNoReplyParams = (0, _validatorPrimitives.tObject)({
    intercepted: _validatorPrimitives.tBoolean
  });
  scheme.PageAddInitScriptParams = (0, _validatorPrimitives.tObject)({
    source: _validatorPrimitives.tString
  });
  scheme.PageRemoveInitScriptsParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.PageCloseParams = (0, _validatorPrimitives.tObject)({
    runBeforeUnload: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.PageEmulateMediaParams = (0, _validatorPrimitives.tObject)({
    media: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['screen', 'print', 'null'])),
    colorScheme: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['dark', 'light', 'no-preference', 'null'])),
    reducedMotion: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['reduce', 'no-preference', 'null'])),
    forcedColors: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['active', 'none', 'null']))
  });
  scheme.PageExposeBindingParams = (0, _validatorPrimitives.tObject)({
    name: _validatorPrimitives.tString,
    needsHandle: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.PageRemoveExposedBindingsParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.PageGoBackParams = (0, _validatorPrimitives.tObject)({
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    waitUntil: (0, _validatorPrimitives.tOptional)(tType('LifecycleEvent'))
  });
  scheme.PageGoForwardParams = (0, _validatorPrimitives.tObject)({
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    waitUntil: (0, _validatorPrimitives.tOptional)(tType('LifecycleEvent'))
  });
  scheme.PageReloadParams = (0, _validatorPrimitives.tObject)({
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    waitUntil: (0, _validatorPrimitives.tOptional)(tType('LifecycleEvent'))
  });
  scheme.PageExpectScreenshotParams = (0, _validatorPrimitives.tObject)({
    expected: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBinary),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    isNot: _validatorPrimitives.tBoolean,
    locator: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      frame: tChannel('Frame'),
      selector: _validatorPrimitives.tString
    })),
    comparatorOptions: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      maxDiffPixels: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
      maxDiffPixelRatio: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
      threshold: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
    })),
    screenshotOptions: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      fullPage: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
      clip: (0, _validatorPrimitives.tOptional)(tType('Rect')),
      omitBackground: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
      caret: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['hide', 'initial'])),
      animations: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['disabled', 'allow'])),
      scale: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['css', 'device'])),
      mask: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)((0, _validatorPrimitives.tObject)({
        frame: tChannel('Frame'),
        selector: _validatorPrimitives.tString
      })))
    }))
  });
  scheme.PageScreenshotParams = (0, _validatorPrimitives.tObject)({
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    type: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['png', 'jpeg'])),
    quality: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    fullPage: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    clip: (0, _validatorPrimitives.tOptional)(tType('Rect')),
    omitBackground: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    caret: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['hide', 'initial'])),
    animations: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['disabled', 'allow'])),
    scale: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['css', 'device'])),
    mask: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)((0, _validatorPrimitives.tObject)({
      frame: tChannel('Frame'),
      selector: _validatorPrimitives.tString
    })))
  });
  scheme.PageSetExtraHTTPHeadersParams = (0, _validatorPrimitives.tObject)({
    headers: (0, _validatorPrimitives.tArray)(tType('NameValue'))
  });
  scheme.PageSetNetworkInterceptionEnabledParams = (0, _validatorPrimitives.tObject)({
    enabled: _validatorPrimitives.tBoolean
  });
  scheme.PageSetViewportSizeParams = (0, _validatorPrimitives.tObject)({
    viewportSize: (0, _validatorPrimitives.tObject)({
      width: _validatorPrimitives.tNumber,
      height: _validatorPrimitives.tNumber
    })
  });
  scheme.PageKeyboardDownParams = (0, _validatorPrimitives.tObject)({
    key: _validatorPrimitives.tString
  });
  scheme.PageKeyboardUpParams = (0, _validatorPrimitives.tObject)({
    key: _validatorPrimitives.tString
  });
  scheme.PageKeyboardInsertTextParams = (0, _validatorPrimitives.tObject)({
    text: _validatorPrimitives.tString
  });
  scheme.PageKeyboardTypeParams = (0, _validatorPrimitives.tObject)({
    text: _validatorPrimitives.tString,
    delay: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.PageKeyboardPressParams = (0, _validatorPrimitives.tObject)({
    key: _validatorPrimitives.tString,
    delay: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.PageMouseMoveParams = (0, _validatorPrimitives.tObject)({
    x: _validatorPrimitives.tNumber,
    y: _validatorPrimitives.tNumber,
    steps: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.PageMouseDownParams = (0, _validatorPrimitives.tObject)({
    button: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['left', 'right', 'middle'])),
    clickCount: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.PageMouseUpParams = (0, _validatorPrimitives.tObject)({
    button: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['left', 'right', 'middle'])),
    clickCount: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.PageMouseClickParams = (0, _validatorPrimitives.tObject)({
    x: _validatorPrimitives.tNumber,
    y: _validatorPrimitives.tNumber,
    delay: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    button: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['left', 'right', 'middle'])),
    clickCount: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.PageMouseWheelParams = (0, _validatorPrimitives.tObject)({
    deltaX: _validatorPrimitives.tNumber,
    deltaY: _validatorPrimitives.tNumber
  });
  scheme.PageTouchscreenTapParams = (0, _validatorPrimitives.tObject)({
    x: _validatorPrimitives.tNumber,
    y: _validatorPrimitives.tNumber
  });
  scheme.PageAccessibilitySnapshotParams = (0, _validatorPrimitives.tObject)({
    interestingOnly: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    root: (0, _validatorPrimitives.tOptional)(tChannel('ElementHandle'))
  });
  scheme.PagePdfParams = (0, _validatorPrimitives.tObject)({
    scale: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    displayHeaderFooter: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    headerTemplate: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    footerTemplate: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    printBackground: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    landscape: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    pageRanges: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    format: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    width: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    height: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    preferCSSPageSize: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    margin: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      top: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
      bottom: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
      left: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
      right: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString)
    }))
  });
  scheme.PageStartJSCoverageParams = (0, _validatorPrimitives.tObject)({
    resetOnNavigation: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    reportAnonymousScripts: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.PageStopJSCoverageParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.PageStartCSSCoverageParams = (0, _validatorPrimitives.tObject)({
    resetOnNavigation: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.PageStopCSSCoverageParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.PageBringToFrontParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.FrameEvalOnSelectorParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    expression: _validatorPrimitives.tString,
    isFunction: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    arg: tType('SerializedArgument')
  });
  scheme.FrameEvalOnSelectorAllParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    expression: _validatorPrimitives.tString,
    isFunction: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    arg: tType('SerializedArgument')
  });
  scheme.FrameAddScriptTagParams = (0, _validatorPrimitives.tObject)({
    url: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    content: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    type: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString)
  });
  scheme.FrameAddStyleTagParams = (0, _validatorPrimitives.tObject)({
    url: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    content: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString)
  });
  scheme.FrameCheckParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    force: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    noWaitAfter: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    position: (0, _validatorPrimitives.tOptional)(tType('Point')),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    trial: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.FrameClickParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    force: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    noWaitAfter: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    modifiers: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)((0, _validatorPrimitives.tEnum)(['Alt', 'Control', 'Meta', 'Shift']))),
    position: (0, _validatorPrimitives.tOptional)(tType('Point')),
    delay: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    button: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['left', 'right', 'middle'])),
    clickCount: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    trial: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.FrameContentParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.FrameDragAndDropParams = (0, _validatorPrimitives.tObject)({
    source: _validatorPrimitives.tString,
    target: _validatorPrimitives.tString,
    force: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    noWaitAfter: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    trial: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    sourcePosition: (0, _validatorPrimitives.tOptional)(tType('Point')),
    targetPosition: (0, _validatorPrimitives.tOptional)(tType('Point')),
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.FrameDblclickParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    force: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    noWaitAfter: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    modifiers: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)((0, _validatorPrimitives.tEnum)(['Alt', 'Control', 'Meta', 'Shift']))),
    position: (0, _validatorPrimitives.tOptional)(tType('Point')),
    delay: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    button: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['left', 'right', 'middle'])),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    trial: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.FrameDispatchEventParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    type: _validatorPrimitives.tString,
    eventInit: tType('SerializedArgument'),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.FrameEvaluateExpressionParams = (0, _validatorPrimitives.tObject)({
    expression: _validatorPrimitives.tString,
    isFunction: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    arg: tType('SerializedArgument')
  });
  scheme.FrameEvaluateExpressionHandleParams = (0, _validatorPrimitives.tObject)({
    expression: _validatorPrimitives.tString,
    isFunction: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    arg: tType('SerializedArgument')
  });
  scheme.FrameFillParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    value: _validatorPrimitives.tString,
    force: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    noWaitAfter: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.FrameFocusParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.FrameFrameElementParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.FrameHighlightParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString
  });
  scheme.FrameGetAttributeParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    name: _validatorPrimitives.tString,
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.FrameGotoParams = (0, _validatorPrimitives.tObject)({
    url: _validatorPrimitives.tString,
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    waitUntil: (0, _validatorPrimitives.tOptional)(tType('LifecycleEvent')),
    referer: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString)
  });
  scheme.FrameHoverParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    force: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    modifiers: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)((0, _validatorPrimitives.tEnum)(['Alt', 'Control', 'Meta', 'Shift']))),
    position: (0, _validatorPrimitives.tOptional)(tType('Point')),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    trial: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.FrameInnerHTMLParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.FrameInnerTextParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.FrameInputValueParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.FrameIsCheckedParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.FrameIsDisabledParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.FrameIsEnabledParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.FrameIsHiddenParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.FrameIsVisibleParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.FrameIsEditableParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.FramePressParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    key: _validatorPrimitives.tString,
    delay: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    noWaitAfter: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.FrameQuerySelectorParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.FrameQuerySelectorAllParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString
  });
  scheme.FrameQueryCountParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString
  });
  scheme.FrameSelectOptionParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    elements: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(tChannel('ElementHandle'))),
    options: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)((0, _validatorPrimitives.tObject)({
      value: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
      label: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
      index: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
    }))),
    force: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    noWaitAfter: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.FrameSetContentParams = (0, _validatorPrimitives.tObject)({
    html: _validatorPrimitives.tString,
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    waitUntil: (0, _validatorPrimitives.tOptional)(tType('LifecycleEvent'))
  });
  scheme.FrameSetInputFilesParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    files: (0, _validatorPrimitives.tArray)((0, _validatorPrimitives.tObject)({
      name: _validatorPrimitives.tString,
      mimeType: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
      buffer: _validatorPrimitives.tBinary
    })),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    noWaitAfter: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.FrameSetInputFilePathsParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    localPaths: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(_validatorPrimitives.tString)),
    streams: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(tChannel('WritableStream'))),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    noWaitAfter: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.FrameTapParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    force: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    noWaitAfter: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    modifiers: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)((0, _validatorPrimitives.tEnum)(['Alt', 'Control', 'Meta', 'Shift']))),
    position: (0, _validatorPrimitives.tOptional)(tType('Point')),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    trial: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.FrameTextContentParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.FrameTitleParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.FrameTypeParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    text: _validatorPrimitives.tString,
    delay: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    noWaitAfter: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.FrameUncheckParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    force: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    noWaitAfter: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    position: (0, _validatorPrimitives.tOptional)(tType('Point')),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    trial: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.FrameWaitForTimeoutParams = (0, _validatorPrimitives.tObject)({
    timeout: _validatorPrimitives.tNumber
  });
  scheme.FrameWaitForFunctionParams = (0, _validatorPrimitives.tObject)({
    expression: _validatorPrimitives.tString,
    isFunction: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    arg: tType('SerializedArgument'),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    pollingInterval: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.FrameWaitForSelectorParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    state: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['attached', 'detached', 'visible', 'hidden'])),
    omitReturnValue: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.FrameExpectParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    expression: _validatorPrimitives.tString,
    expressionArg: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tAny),
    expectedText: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(tType('ExpectedTextValue'))),
    expectedNumber: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    expectedValue: (0, _validatorPrimitives.tOptional)(tType('SerializedArgument')),
    useInnerText: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    isNot: _validatorPrimitives.tBoolean,
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.WorkerEvaluateExpressionParams = (0, _validatorPrimitives.tObject)({
    expression: _validatorPrimitives.tString,
    isFunction: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    arg: tType('SerializedArgument')
  });
  scheme.WorkerEvaluateExpressionHandleParams = (0, _validatorPrimitives.tObject)({
    expression: _validatorPrimitives.tString,
    isFunction: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    arg: tType('SerializedArgument')
  });
  scheme.JSHandleDisposeParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.ElementHandleDisposeParams = tType('JSHandleDisposeParams');
  scheme.JSHandleEvaluateExpressionParams = (0, _validatorPrimitives.tObject)({
    expression: _validatorPrimitives.tString,
    isFunction: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    arg: tType('SerializedArgument')
  });
  scheme.ElementHandleEvaluateExpressionParams = tType('JSHandleEvaluateExpressionParams');
  scheme.JSHandleEvaluateExpressionHandleParams = (0, _validatorPrimitives.tObject)({
    expression: _validatorPrimitives.tString,
    isFunction: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    arg: tType('SerializedArgument')
  });
  scheme.ElementHandleEvaluateExpressionHandleParams = tType('JSHandleEvaluateExpressionHandleParams');
  scheme.JSHandleGetPropertyListParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.ElementHandleGetPropertyListParams = tType('JSHandleGetPropertyListParams');
  scheme.JSHandleGetPropertyParams = (0, _validatorPrimitives.tObject)({
    name: _validatorPrimitives.tString
  });
  scheme.ElementHandleGetPropertyParams = tType('JSHandleGetPropertyParams');
  scheme.JSHandleJsonValueParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.ElementHandleJsonValueParams = tType('JSHandleJsonValueParams');
  scheme.ElementHandleEvalOnSelectorParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    expression: _validatorPrimitives.tString,
    isFunction: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    arg: tType('SerializedArgument')
  });
  scheme.ElementHandleEvalOnSelectorAllParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    expression: _validatorPrimitives.tString,
    isFunction: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    arg: tType('SerializedArgument')
  });
  scheme.ElementHandleBoundingBoxParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.ElementHandleCheckParams = (0, _validatorPrimitives.tObject)({
    force: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    noWaitAfter: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    position: (0, _validatorPrimitives.tOptional)(tType('Point')),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    trial: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.ElementHandleClickParams = (0, _validatorPrimitives.tObject)({
    force: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    noWaitAfter: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    modifiers: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)((0, _validatorPrimitives.tEnum)(['Alt', 'Control', 'Meta', 'Shift']))),
    position: (0, _validatorPrimitives.tOptional)(tType('Point')),
    delay: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    button: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['left', 'right', 'middle'])),
    clickCount: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    trial: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.ElementHandleContentFrameParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.ElementHandleDblclickParams = (0, _validatorPrimitives.tObject)({
    force: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    noWaitAfter: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    modifiers: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)((0, _validatorPrimitives.tEnum)(['Alt', 'Control', 'Meta', 'Shift']))),
    position: (0, _validatorPrimitives.tOptional)(tType('Point')),
    delay: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    button: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['left', 'right', 'middle'])),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    trial: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.ElementHandleDispatchEventParams = (0, _validatorPrimitives.tObject)({
    type: _validatorPrimitives.tString,
    eventInit: tType('SerializedArgument')
  });
  scheme.ElementHandleFillParams = (0, _validatorPrimitives.tObject)({
    value: _validatorPrimitives.tString,
    force: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    noWaitAfter: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.ElementHandleFocusParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.ElementHandleGetAttributeParams = (0, _validatorPrimitives.tObject)({
    name: _validatorPrimitives.tString
  });
  scheme.ElementHandleHoverParams = (0, _validatorPrimitives.tObject)({
    force: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    modifiers: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)((0, _validatorPrimitives.tEnum)(['Alt', 'Control', 'Meta', 'Shift']))),
    position: (0, _validatorPrimitives.tOptional)(tType('Point')),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    trial: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.ElementHandleInnerHTMLParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.ElementHandleInnerTextParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.ElementHandleInputValueParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.ElementHandleIsCheckedParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.ElementHandleIsDisabledParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.ElementHandleIsEditableParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.ElementHandleIsEnabledParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.ElementHandleIsHiddenParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.ElementHandleIsVisibleParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.ElementHandleOwnerFrameParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.ElementHandlePressParams = (0, _validatorPrimitives.tObject)({
    key: _validatorPrimitives.tString,
    delay: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    noWaitAfter: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.ElementHandleQuerySelectorParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.ElementHandleQuerySelectorAllParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString
  });
  scheme.ElementHandleScreenshotParams = (0, _validatorPrimitives.tObject)({
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    type: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['png', 'jpeg'])),
    quality: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    omitBackground: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    caret: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['hide', 'initial'])),
    animations: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['disabled', 'allow'])),
    scale: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['css', 'device'])),
    mask: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)((0, _validatorPrimitives.tObject)({
      frame: tChannel('Frame'),
      selector: _validatorPrimitives.tString
    })))
  });
  scheme.ElementHandleScrollIntoViewIfNeededParams = (0, _validatorPrimitives.tObject)({
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.ElementHandleSelectOptionParams = (0, _validatorPrimitives.tObject)({
    elements: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(tChannel('ElementHandle'))),
    options: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)((0, _validatorPrimitives.tObject)({
      value: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
      label: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
      index: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
    }))),
    force: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    noWaitAfter: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.ElementHandleSelectTextParams = (0, _validatorPrimitives.tObject)({
    force: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.ElementHandleSetInputFilesParams = (0, _validatorPrimitives.tObject)({
    files: (0, _validatorPrimitives.tArray)((0, _validatorPrimitives.tObject)({
      name: _validatorPrimitives.tString,
      mimeType: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
      buffer: _validatorPrimitives.tBinary
    })),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    noWaitAfter: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.ElementHandleSetInputFilePathsParams = (0, _validatorPrimitives.tObject)({
    localPaths: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(_validatorPrimitives.tString)),
    streams: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(tChannel('WritableStream'))),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    noWaitAfter: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.ElementHandleTapParams = (0, _validatorPrimitives.tObject)({
    force: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    noWaitAfter: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    modifiers: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)((0, _validatorPrimitives.tEnum)(['Alt', 'Control', 'Meta', 'Shift']))),
    position: (0, _validatorPrimitives.tOptional)(tType('Point')),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    trial: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.ElementHandleTextContentParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.ElementHandleTypeParams = (0, _validatorPrimitives.tObject)({
    text: _validatorPrimitives.tString,
    delay: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    noWaitAfter: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.ElementHandleUncheckParams = (0, _validatorPrimitives.tObject)({
    force: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    noWaitAfter: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    position: (0, _validatorPrimitives.tOptional)(tType('Point')),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    trial: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.ElementHandleWaitForElementStateParams = (0, _validatorPrimitives.tObject)({
    state: (0, _validatorPrimitives.tEnum)(['visible', 'hidden', 'stable', 'enabled', 'disabled', 'editable']),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.ElementHandleWaitForSelectorParams = (0, _validatorPrimitives.tObject)({
    selector: _validatorPrimitives.tString,
    strict: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    state: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['attached', 'detached', 'visible', 'hidden']))
  });
  scheme.RequestResponseParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.RequestRawRequestHeadersParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.RouteAbortParams = (0, _validatorPrimitives.tObject)({
    errorCode: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString)
  });
  scheme.RouteContinueParams = (0, _validatorPrimitives.tObject)({
    url: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    method: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    headers: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(tType('NameValue'))),
    postData: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBinary)
  });
  scheme.RouteFulfillParams = (0, _validatorPrimitives.tObject)({
    status: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    headers: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(tType('NameValue'))),
    body: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    isBase64: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    fetchResponseUid: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString)
  });
  scheme.ResourceTiming = (0, _validatorPrimitives.tObject)({
    startTime: _validatorPrimitives.tNumber,
    domainLookupStart: _validatorPrimitives.tNumber,
    domainLookupEnd: _validatorPrimitives.tNumber,
    connectStart: _validatorPrimitives.tNumber,
    secureConnectionStart: _validatorPrimitives.tNumber,
    connectEnd: _validatorPrimitives.tNumber,
    requestStart: _validatorPrimitives.tNumber,
    responseStart: _validatorPrimitives.tNumber
  });
  scheme.ResponseBodyParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.ResponseSecurityDetailsParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.ResponseServerAddrParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.ResponseRawResponseHeadersParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.ResponseSizesParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.SecurityDetails = (0, _validatorPrimitives.tObject)({
    issuer: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    protocol: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    subjectName: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    validFrom: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    validTo: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.RequestSizes = (0, _validatorPrimitives.tObject)({
    requestBodySize: _validatorPrimitives.tNumber,
    requestHeadersSize: _validatorPrimitives.tNumber,
    responseBodySize: _validatorPrimitives.tNumber,
    responseHeadersSize: _validatorPrimitives.tNumber
  });
  scheme.RemoteAddr = (0, _validatorPrimitives.tObject)({
    ipAddress: _validatorPrimitives.tString,
    port: _validatorPrimitives.tNumber
  });
  scheme.BindingCallRejectParams = (0, _validatorPrimitives.tObject)({
    error: tType('SerializedError')
  });
  scheme.BindingCallResolveParams = (0, _validatorPrimitives.tObject)({
    result: tType('SerializedArgument')
  });
  scheme.DialogAcceptParams = (0, _validatorPrimitives.tObject)({
    promptText: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString)
  });
  scheme.DialogDismissParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.TracingTracingStartParams = (0, _validatorPrimitives.tObject)({
    name: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    snapshots: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    screenshots: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    sources: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.TracingTracingStartChunkParams = (0, _validatorPrimitives.tObject)({
    title: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString)
  });
  scheme.TracingTracingStopChunkParams = (0, _validatorPrimitives.tObject)({
    mode: (0, _validatorPrimitives.tEnum)(['doNotSave', 'compressTrace', 'compressTraceAndSources'])
  });
  scheme.TracingTracingStopParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.ArtifactPathAfterFinishedParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.ArtifactSaveAsParams = (0, _validatorPrimitives.tObject)({
    path: _validatorPrimitives.tString
  });
  scheme.ArtifactSaveAsStreamParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.ArtifactFailureParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.ArtifactStreamParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.ArtifactCancelParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.ArtifactDeleteParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.StreamReadParams = (0, _validatorPrimitives.tObject)({
    size: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.StreamCloseParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.WritableStreamWriteParams = (0, _validatorPrimitives.tObject)({
    binary: _validatorPrimitives.tBinary
  });
  scheme.WritableStreamCloseParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.CDPSessionSendParams = (0, _validatorPrimitives.tObject)({
    method: _validatorPrimitives.tString,
    params: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tAny)
  });
  scheme.CDPSessionDetachParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.ElectronLaunchParams = (0, _validatorPrimitives.tObject)({
    executablePath: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    args: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(_validatorPrimitives.tString)),
    cwd: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    env: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(tType('NameValue'))),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    acceptDownloads: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    bypassCSP: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    colorScheme: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['dark', 'light', 'no-preference'])),
    extraHTTPHeaders: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(tType('NameValue'))),
    geolocation: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      longitude: _validatorPrimitives.tNumber,
      latitude: _validatorPrimitives.tNumber,
      accuracy: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
    })),
    httpCredentials: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      username: _validatorPrimitives.tString,
      password: _validatorPrimitives.tString
    })),
    ignoreHTTPSErrors: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    locale: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    offline: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    recordHar: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      omitContent: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
      path: _validatorPrimitives.tString
    })),
    recordVideo: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      dir: _validatorPrimitives.tString,
      size: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
        width: _validatorPrimitives.tNumber,
        height: _validatorPrimitives.tNumber
      }))
    })),
    strictSelectors: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    timezoneId: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString)
  });
  scheme.ElectronApplicationBrowserWindowParams = (0, _validatorPrimitives.tObject)({
    page: tChannel('Page')
  });
  scheme.ElectronApplicationEvaluateExpressionParams = (0, _validatorPrimitives.tObject)({
    expression: _validatorPrimitives.tString,
    isFunction: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    arg: tType('SerializedArgument')
  });
  scheme.ElectronApplicationEvaluateExpressionHandleParams = (0, _validatorPrimitives.tObject)({
    expression: _validatorPrimitives.tString,
    isFunction: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    arg: tType('SerializedArgument')
  });
  scheme.ElectronApplicationCloseParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.AndroidDevicesParams = (0, _validatorPrimitives.tObject)({
    host: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    port: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    omitDriverInstall: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean)
  });
  scheme.AndroidSetDefaultTimeoutNoReplyParams = (0, _validatorPrimitives.tObject)({
    timeout: _validatorPrimitives.tNumber
  });
  scheme.AndroidSocketWriteParams = (0, _validatorPrimitives.tObject)({
    data: _validatorPrimitives.tBinary
  });
  scheme.AndroidSocketCloseParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.AndroidDeviceWaitParams = (0, _validatorPrimitives.tObject)({
    selector: tType('AndroidSelector'),
    state: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['gone'])),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.AndroidDeviceFillParams = (0, _validatorPrimitives.tObject)({
    selector: tType('AndroidSelector'),
    text: _validatorPrimitives.tString,
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.AndroidDeviceTapParams = (0, _validatorPrimitives.tObject)({
    selector: tType('AndroidSelector'),
    duration: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.AndroidDeviceDragParams = (0, _validatorPrimitives.tObject)({
    selector: tType('AndroidSelector'),
    dest: tType('Point'),
    speed: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.AndroidDeviceFlingParams = (0, _validatorPrimitives.tObject)({
    selector: tType('AndroidSelector'),
    direction: (0, _validatorPrimitives.tEnum)(['up', 'down', 'left', 'right']),
    speed: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.AndroidDeviceLongTapParams = (0, _validatorPrimitives.tObject)({
    selector: tType('AndroidSelector'),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.AndroidDevicePinchCloseParams = (0, _validatorPrimitives.tObject)({
    selector: tType('AndroidSelector'),
    percent: _validatorPrimitives.tNumber,
    speed: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.AndroidDevicePinchOpenParams = (0, _validatorPrimitives.tObject)({
    selector: tType('AndroidSelector'),
    percent: _validatorPrimitives.tNumber,
    speed: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.AndroidDeviceScrollParams = (0, _validatorPrimitives.tObject)({
    selector: tType('AndroidSelector'),
    direction: (0, _validatorPrimitives.tEnum)(['up', 'down', 'left', 'right']),
    percent: _validatorPrimitives.tNumber,
    speed: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.AndroidDeviceSwipeParams = (0, _validatorPrimitives.tObject)({
    selector: tType('AndroidSelector'),
    direction: (0, _validatorPrimitives.tEnum)(['up', 'down', 'left', 'right']),
    percent: _validatorPrimitives.tNumber,
    speed: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    timeout: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.AndroidDeviceInfoParams = (0, _validatorPrimitives.tObject)({
    selector: tType('AndroidSelector')
  });
  scheme.AndroidDeviceScreenshotParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.AndroidDeviceInputTypeParams = (0, _validatorPrimitives.tObject)({
    text: _validatorPrimitives.tString
  });
  scheme.AndroidDeviceInputPressParams = (0, _validatorPrimitives.tObject)({
    key: _validatorPrimitives.tString
  });
  scheme.AndroidDeviceInputTapParams = (0, _validatorPrimitives.tObject)({
    point: tType('Point')
  });
  scheme.AndroidDeviceInputSwipeParams = (0, _validatorPrimitives.tObject)({
    segments: (0, _validatorPrimitives.tArray)(tType('Point')),
    steps: _validatorPrimitives.tNumber
  });
  scheme.AndroidDeviceInputDragParams = (0, _validatorPrimitives.tObject)({
    from: tType('Point'),
    to: tType('Point'),
    steps: _validatorPrimitives.tNumber
  });
  scheme.AndroidDeviceLaunchBrowserParams = (0, _validatorPrimitives.tObject)({
    noDefaultViewport: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    viewport: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      width: _validatorPrimitives.tNumber,
      height: _validatorPrimitives.tNumber
    })),
    screen: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      width: _validatorPrimitives.tNumber,
      height: _validatorPrimitives.tNumber
    })),
    ignoreHTTPSErrors: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    javaScriptEnabled: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    bypassCSP: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    userAgent: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    locale: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    timezoneId: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    geolocation: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      longitude: _validatorPrimitives.tNumber,
      latitude: _validatorPrimitives.tNumber,
      accuracy: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
    })),
    permissions: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(_validatorPrimitives.tString)),
    extraHTTPHeaders: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(tType('NameValue'))),
    offline: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    httpCredentials: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      username: _validatorPrimitives.tString,
      password: _validatorPrimitives.tString
    })),
    deviceScaleFactor: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    isMobile: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    hasTouch: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    colorScheme: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['dark', 'light', 'no-preference'])),
    reducedMotion: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['reduce', 'no-preference'])),
    forcedColors: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tEnum)(['active', 'none'])),
    acceptDownloads: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    baseURL: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    recordVideo: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      dir: _validatorPrimitives.tString,
      size: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
        width: _validatorPrimitives.tNumber,
        height: _validatorPrimitives.tNumber
      }))
    })),
    recordHar: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      omitContent: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
      path: _validatorPrimitives.tString
    })),
    strictSelectors: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    pkg: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    proxy: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      server: _validatorPrimitives.tString,
      bypass: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
      username: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
      password: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString)
    }))
  });
  scheme.AndroidDeviceOpenParams = (0, _validatorPrimitives.tObject)({
    command: _validatorPrimitives.tString
  });
  scheme.AndroidDeviceShellParams = (0, _validatorPrimitives.tObject)({
    command: _validatorPrimitives.tString
  });
  scheme.AndroidDeviceInstallApkParams = (0, _validatorPrimitives.tObject)({
    file: _validatorPrimitives.tBinary,
    args: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(_validatorPrimitives.tString))
  });
  scheme.AndroidDevicePushParams = (0, _validatorPrimitives.tObject)({
    file: _validatorPrimitives.tBinary,
    path: _validatorPrimitives.tString,
    mode: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
  });
  scheme.AndroidDeviceSetDefaultTimeoutNoReplyParams = (0, _validatorPrimitives.tObject)({
    timeout: _validatorPrimitives.tNumber
  });
  scheme.AndroidDeviceConnectToWebViewParams = (0, _validatorPrimitives.tObject)({
    socketName: _validatorPrimitives.tString
  });
  scheme.AndroidDeviceCloseParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  scheme.AndroidWebView = (0, _validatorPrimitives.tObject)({
    pid: _validatorPrimitives.tNumber,
    pkg: _validatorPrimitives.tString,
    socketName: _validatorPrimitives.tString
  });
  scheme.AndroidSelector = (0, _validatorPrimitives.tObject)({
    checkable: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    checked: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    clazz: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    clickable: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    depth: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber),
    desc: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    enabled: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    focusable: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    focused: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    hasChild: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      selector: tType('AndroidSelector')
    })),
    hasDescendant: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({
      selector: tType('AndroidSelector'),
      maxDepth: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tNumber)
    })),
    longClickable: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    pkg: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    res: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString),
    scrollable: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    selected: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tBoolean),
    text: (0, _validatorPrimitives.tOptional)(_validatorPrimitives.tString)
  });
  scheme.AndroidElementInfo = (0, _validatorPrimitives.tObject)({
    children: (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tArray)(tType('AndroidElementInfo'))),
    clazz: _validatorPrimitives.tString,
    desc: _validatorPrimitives.tString,
    res: _validatorPrimitives.tString,
    pkg: _validatorPrimitives.tString,
    text: _validatorPrimitives.tString,
    bounds: tType('Rect'),
    checkable: _validatorPrimitives.tBoolean,
    checked: _validatorPrimitives.tBoolean,
    clickable: _validatorPrimitives.tBoolean,
    enabled: _validatorPrimitives.tBoolean,
    focusable: _validatorPrimitives.tBoolean,
    focused: _validatorPrimitives.tBoolean,
    longClickable: _validatorPrimitives.tBoolean,
    scrollable: _validatorPrimitives.tBoolean,
    selected: _validatorPrimitives.tBoolean
  });
  scheme.JsonPipeSendParams = (0, _validatorPrimitives.tObject)({
    message: _validatorPrimitives.tAny
  });
  scheme.JsonPipeCloseParams = (0, _validatorPrimitives.tOptional)((0, _validatorPrimitives.tObject)({}));
  return scheme;
}