"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toEqual = toEqual;

var _utils = require("expect/build/utils");

var _globals = require("../globals");

var _util = require("../util");

/**
 * Copyright Microsoft Corporation. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Omit colon and one or more spaces, so can call getLabelPrinter.
const EXPECTED_LABEL = 'Expected';
const RECEIVED_LABEL = 'Received'; // The optional property of matcher context is true if undefined.

const isExpand = expand => expand !== false;

function regExpTester(a, b) {
  if (typeof a === 'string' && b instanceof RegExp) {
    b.lastIndex = 0;
    return b.test(a);
  }
}

async function toEqual(matcherName, receiver, receiverType, query, expected, options = {}) {
  const testInfo = (0, _globals.currentTestInfo)();
  if (!testInfo) throw new Error(`${matcherName} must be called during the test`);
  (0, _util.expectType)(receiver, receiverType, matcherName);
  const matcherOptions = {
    comment: 'deep equality',
    isNot: this.isNot,
    promise: this.promise
  };
  let received = undefined;
  let pass = false;
  await (0, _util.pollUntilDeadline)(testInfo, async remainingTime => {
    received = await query(remainingTime);
    pass = this.equals(received, expected, [_utils.iterableEquality, regExpTester]);
    return pass === !matcherOptions.isNot;
  }, options.timeout, testInfo._testFinished);
  const message = pass ? () => this.utils.matcherHint(matcherName, undefined, undefined, matcherOptions) + '\n\n' + `Expected: not ${this.utils.printExpected(expected)}\n` + (this.utils.stringify(expected) !== this.utils.stringify(received) ? `Received:     ${this.utils.printReceived(received)}` : '') : () => this.utils.matcherHint(matcherName, undefined, undefined, matcherOptions) + '\n\n' + this.utils.printDiffOrStringify(expected, received, EXPECTED_LABEL, RECEIVED_LABEL, isExpand(this.expand)); // Passing the actual and expected objects so that a custom reporter
  // could access them, for example in order to display a custom visual diff,
  // or create a different error message

  return {
    actual: received,
    expected,
    message,
    name: matcherName,
    pass
  };
}