/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.microsoft.playwright.impl.Driver;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.concurrent.TimeUnit;

public class DriverJar
extends Driver {
    private final Path driverTempDir = Files.createTempDirectory("playwright-java-", new FileAttribute[0]);

    DriverJar() throws IOException, URISyntaxException, InterruptedException {
        this.driverTempDir.toFile().deleteOnExit();
        this.extractDriverToTempDir();
        this.installBrowsers();
    }

    private void installBrowsers() throws IOException, InterruptedException {
        String cliFileName = super.cliFileName();
        Path driver = this.driverTempDir.resolve(cliFileName);
        if (!Files.exists(driver, new LinkOption[0])) {
            throw new RuntimeException("Failed to find " + cliFileName + " at " + driver);
        }
        ProcessBuilder pb = new ProcessBuilder(driver.toString(), "install");
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        Process p = pb.start();
        boolean result = p.waitFor(10L, TimeUnit.MINUTES);
        if (!result) {
            p.destroy();
            throw new RuntimeException("Timed out waiting for browsers to install");
        }
        if (p.exitValue() != 0) {
            throw new RuntimeException("Failed to install browsers, exit code: " + p.exitValue());
        }
    }

    private static boolean isExecutable(Path filePath) {
        String name = filePath.getFileName().toString();
        return name.endsWith(".sh") || name.endsWith(".exe") || !name.contains(".");
    }

    private void extractDriverToTempDir() throws URISyntaxException, IOException {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        URI originalUri = classloader.getResource("driver/" + DriverJar.platformDir()).toURI();
        URI uri = this.maybeExtractNestedJar(originalUri);
        try (FileSystem fileSystem = "jar".equals(uri.getScheme()) ? FileSystems.newFileSystem(uri, Collections.emptyMap()) : null;){
            Path srcRoot = Paths.get(uri);
            Path srcRootDefaultFs = Paths.get(srcRoot.toString(), new String[0]);
            Files.walk(srcRoot, new FileVisitOption[0]).forEach(fromPath -> {
                Path relative = srcRootDefaultFs.relativize(Paths.get(fromPath.toString(), new String[0]));
                Path toPath = this.driverTempDir.resolve(relative.toString());
                try {
                    if (Files.isDirectory(fromPath, new LinkOption[0])) {
                        Files.createDirectories(toPath, new FileAttribute[0]);
                    } else {
                        Files.copy(fromPath, toPath, new CopyOption[0]);
                        if (DriverJar.isExecutable(toPath)) {
                            toPath.toFile().setExecutable(true, true);
                        }
                    }
                    toPath.toFile().deleteOnExit();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to extract driver from " + uri + ", full uri: " + originalUri, e);
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private URI maybeExtractNestedJar(URI uri) throws URISyntaxException {
        if (!"jar".equals(uri.getScheme())) {
            return uri;
        }
        String JAR_URL_SEPARATOR = "!/";
        String[] parts = uri.toString().split("!/");
        if (parts.length != 3) {
            return uri;
        }
        String innerJar = String.join((CharSequence)"!/", parts[0], parts[1]);
        URI jarUri = new URI(innerJar);
        try (FileSystem fs = FileSystems.newFileSystem(jarUri, Collections.emptyMap());){
            Path fromPath = Paths.get(jarUri);
            Path toPath = this.driverTempDir.resolve(fromPath.getFileName().toString());
            Files.copy(fromPath, toPath, new CopyOption[0]);
            toPath.toFile().deleteOnExit();
            URI uRI = new URI("jar:" + toPath.toUri() + "!/" + parts[2]);
            return uRI;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to extract driver's nested .jar from " + jarUri + "; full uri: " + uri, e);
        }
    }

    private static String platformDir() {
        String name = System.getProperty("os.name").toLowerCase();
        if (name.contains("windows")) {
            return System.getProperty("os.arch").equals("amd64") ? "win32_x64" : "win32";
        }
        if (name.contains("linux")) {
            return "linux";
        }
        if (name.contains("mac os x")) {
            return "mac";
        }
        throw new RuntimeException("Unexpected os.name value: " + name);
    }

    Path driverDir() {
        return this.driverTempDir;
    }
}

