/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.security.AuthorityTemplate;
import com.microsoft.graph.models.security.CategoryTemplate;
import com.microsoft.graph.models.security.CitationTemplate;
import com.microsoft.graph.models.security.DepartmentTemplate;
import com.microsoft.graph.models.security.FilePlanReferenceTemplate;
import com.microsoft.graph.models.security.SubcategoryTemplate;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class FilePlanDescriptorTemplate
extends Entity
implements Parsable {
    @Nonnull
    public static FilePlanDescriptorTemplate createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.security.authorityTemplate": {
                    return new AuthorityTemplate();
                }
                case "#microsoft.graph.security.categoryTemplate": {
                    return new CategoryTemplate();
                }
                case "#microsoft.graph.security.citationTemplate": {
                    return new CitationTemplate();
                }
                case "#microsoft.graph.security.departmentTemplate": {
                    return new DepartmentTemplate();
                }
                case "#microsoft.graph.security.filePlanReferenceTemplate": {
                    return new FilePlanReferenceTemplate();
                }
                case "#microsoft.graph.security.subcategoryTemplate": {
                    return new SubcategoryTemplate();
                }
            }
        }
        return new FilePlanDescriptorTemplate();
    }

    @Nullable
    public IdentitySet getCreatedBy() {
        return (IdentitySet)this.backingStore.get("createdBy");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("createdBy", n -> this.setCreatedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        return deserializerMap;
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("createdBy", (Parsable)this.getCreatedBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("displayName", this.getDisplayName());
    }

    public void setCreatedBy(@Nullable IdentitySet value) {
        this.backingStore.set("createdBy", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }
}

