/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.VirtualEventRegistrationQuestionBase;
import com.microsoft.graph.models.VirtualEventWebinarRegistrationConfiguration;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class VirtualEventRegistrationConfiguration
extends Entity
implements Parsable {
    @Nonnull
    public static VirtualEventRegistrationConfiguration createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.virtualEventWebinarRegistrationConfiguration": {
                    return new VirtualEventWebinarRegistrationConfiguration();
                }
            }
        }
        return new VirtualEventRegistrationConfiguration();
    }

    @Nullable
    public Integer getCapacity() {
        return (Integer)this.backingStore.get("capacity");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("capacity", n -> this.setCapacity(n.getIntegerValue()));
        deserializerMap.put("questions", n -> this.setQuestions(n.getCollectionOfObjectValues(VirtualEventRegistrationQuestionBase::createFromDiscriminatorValue)));
        deserializerMap.put("registrationWebUrl", n -> this.setRegistrationWebUrl(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public List<VirtualEventRegistrationQuestionBase> getQuestions() {
        return (List)this.backingStore.get("questions");
    }

    @Nullable
    public String getRegistrationWebUrl() {
        return (String)this.backingStore.get("registrationWebUrl");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeIntegerValue("capacity", this.getCapacity());
        writer.writeCollectionOfObjectValues("questions", this.getQuestions());
        writer.writeStringValue("registrationWebUrl", this.getRegistrationWebUrl());
    }

    public void setCapacity(@Nullable Integer value) {
        this.backingStore.set("capacity", (Object)value);
    }

    public void setQuestions(@Nullable List<VirtualEventRegistrationQuestionBase> value) {
        this.backingStore.set("questions", value);
    }

    public void setRegistrationWebUrl(@Nullable String value) {
        this.backingStore.set("registrationWebUrl", (Object)value);
    }
}

