/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ItemBody;
import com.microsoft.graph.models.TimeCardEvent;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class TimeCardBreak
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public TimeCardBreak() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static TimeCardBreak createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new TimeCardBreak();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getBreakId() {
        return (String)this.backingStore.get("breakId");
    }

    @Nullable
    public TimeCardEvent getEnd() {
        return (TimeCardEvent)this.backingStore.get("end");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("breakId", n -> this.setBreakId(n.getStringValue()));
        deserializerMap.put("end", n -> this.setEnd((TimeCardEvent)n.getObjectValue(TimeCardEvent::createFromDiscriminatorValue)));
        deserializerMap.put("notes", n -> this.setNotes((ItemBody)n.getObjectValue(ItemBody::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("start", n -> this.setStart((TimeCardEvent)n.getObjectValue(TimeCardEvent::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public ItemBody getNotes() {
        return (ItemBody)this.backingStore.get("notes");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public TimeCardEvent getStart() {
        return (TimeCardEvent)this.backingStore.get("start");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("breakId", this.getBreakId());
        writer.writeObjectValue("end", (Parsable)this.getEnd(), new Parsable[0]);
        writer.writeObjectValue("notes", (Parsable)this.getNotes(), new Parsable[0]);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeObjectValue("start", (Parsable)this.getStart(), new Parsable[0]);
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setBreakId(@Nullable String value) {
        this.backingStore.set("breakId", (Object)value);
    }

    public void setEnd(@Nullable TimeCardEvent value) {
        this.backingStore.set("end", (Object)value);
    }

    public void setNotes(@Nullable ItemBody value) {
        this.backingStore.set("notes", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setStart(@Nullable TimeCardEvent value) {
        this.backingStore.set("start", (Object)value);
    }
}

