/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DestinationType;
import com.microsoft.graph.models.DriveRestoreArtifactsBulkAdditionRequest;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.MailboxRestoreArtifactsBulkAdditionRequest;
import com.microsoft.graph.models.PublicError;
import com.microsoft.graph.models.RestoreArtifactsBulkRequestStatus;
import com.microsoft.graph.models.RestorePointPreference;
import com.microsoft.graph.models.RestorePointTags;
import com.microsoft.graph.models.SiteRestoreArtifactsBulkAdditionRequest;
import com.microsoft.graph.models.TimePeriod;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class RestoreArtifactsBulkRequestBase
extends Entity
implements Parsable {
    @Nonnull
    public static RestoreArtifactsBulkRequestBase createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.driveRestoreArtifactsBulkAdditionRequest": {
                    return new DriveRestoreArtifactsBulkAdditionRequest();
                }
                case "#microsoft.graph.mailboxRestoreArtifactsBulkAdditionRequest": {
                    return new MailboxRestoreArtifactsBulkAdditionRequest();
                }
                case "#microsoft.graph.siteRestoreArtifactsBulkAdditionRequest": {
                    return new SiteRestoreArtifactsBulkAdditionRequest();
                }
            }
        }
        return new RestoreArtifactsBulkRequestBase();
    }

    @Nullable
    public IdentitySet getCreatedBy() {
        return (IdentitySet)this.backingStore.get("createdBy");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public DestinationType getDestinationType() {
        return (DestinationType)((Object)this.backingStore.get("destinationType"));
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Nullable
    public PublicError getError() {
        return (PublicError)this.backingStore.get("error");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("createdBy", n -> this.setCreatedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("destinationType", n -> this.setDestinationType((DestinationType)n.getEnumValue(DestinationType::forValue)));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("error", n -> this.setError((PublicError)n.getObjectValue(PublicError::createFromDiscriminatorValue)));
        deserializerMap.put("lastModifiedBy", n -> this.setLastModifiedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("protectionTimePeriod", n -> this.setProtectionTimePeriod((TimePeriod)n.getObjectValue(TimePeriod::createFromDiscriminatorValue)));
        deserializerMap.put("protectionUnitIds", n -> this.setProtectionUnitIds(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("restorePointPreference", n -> this.setRestorePointPreference((RestorePointPreference)n.getEnumValue(RestorePointPreference::forValue)));
        deserializerMap.put("status", n -> this.setStatus((RestoreArtifactsBulkRequestStatus)n.getEnumValue(RestoreArtifactsBulkRequestStatus::forValue)));
        deserializerMap.put("tags", n -> this.setTags(n.getEnumSetValue(RestorePointTags::forValue)));
        return deserializerMap;
    }

    @Nullable
    public IdentitySet getLastModifiedBy() {
        return (IdentitySet)this.backingStore.get("lastModifiedBy");
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Nullable
    public TimePeriod getProtectionTimePeriod() {
        return (TimePeriod)this.backingStore.get("protectionTimePeriod");
    }

    @Nullable
    public List<String> getProtectionUnitIds() {
        return (List)this.backingStore.get("protectionUnitIds");
    }

    @Nullable
    public RestorePointPreference getRestorePointPreference() {
        return (RestorePointPreference)((Object)this.backingStore.get("restorePointPreference"));
    }

    @Nullable
    public RestoreArtifactsBulkRequestStatus getStatus() {
        return (RestoreArtifactsBulkRequestStatus)((Object)this.backingStore.get("status"));
    }

    @Nullable
    public EnumSet<RestorePointTags> getTags() {
        return (EnumSet)this.backingStore.get("tags");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("createdBy", (Parsable)this.getCreatedBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeEnumValue("destinationType", (Enum)this.getDestinationType());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeObjectValue("error", (Parsable)this.getError(), new Parsable[0]);
        writer.writeObjectValue("lastModifiedBy", (Parsable)this.getLastModifiedBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeObjectValue("protectionTimePeriod", (Parsable)this.getProtectionTimePeriod(), new Parsable[0]);
        writer.writeCollectionOfPrimitiveValues("protectionUnitIds", this.getProtectionUnitIds());
        writer.writeEnumValue("restorePointPreference", (Enum)this.getRestorePointPreference());
        writer.writeEnumValue("status", (Enum)this.getStatus());
        writer.writeEnumSetValue("tags", this.getTags());
    }

    public void setCreatedBy(@Nullable IdentitySet value) {
        this.backingStore.set("createdBy", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDestinationType(@Nullable DestinationType value) {
        this.backingStore.set("destinationType", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setError(@Nullable PublicError value) {
        this.backingStore.set("error", (Object)value);
    }

    public void setLastModifiedBy(@Nullable IdentitySet value) {
        this.backingStore.set("lastModifiedBy", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }

    public void setProtectionTimePeriod(@Nullable TimePeriod value) {
        this.backingStore.set("protectionTimePeriod", (Object)value);
    }

    public void setProtectionUnitIds(@Nullable List<String> value) {
        this.backingStore.set("protectionUnitIds", value);
    }

    public void setRestorePointPreference(@Nullable RestorePointPreference value) {
        this.backingStore.set("restorePointPreference", (Object)value);
    }

    public void setStatus(@Nullable RestoreArtifactsBulkRequestStatus value) {
        this.backingStore.set("status", (Object)value);
    }

    public void setTags(@Nullable EnumSet<RestorePointTags> value) {
        this.backingStore.set("tags", value);
    }
}

